/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.application.options.colors.ReaderModeStatsCollector;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.ui.AbstractFontCombo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FontComboBox;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.components.DslLabel;
import com.intellij.ui.dsl.builder.impl.UtilsKt;
import com.intellij.ui.render.RenderersKt;
import com.intellij.util.EventDispatcher;
import com.intellij.util.MathUtil;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFontOptionsPanel
extends JPanel
implements OptionsPanel {
    private static final ListCellRenderer<Object> DEFAULT_FONT_COMBO_RENDERER = RenderersKt.fontInfoRenderer(true);
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private final JLabel myPrimaryLabel = new JLabel(ApplicationBundle.message((String)"primary.font", (Object[])new Object[0]));
    private final AbstractFontCombo<?> myPrimaryCombo;
    private final JCheckBox myEnableLigaturesCheckbox = new JCheckBox(ApplicationBundle.message((String)"use.ligatures", (Object[])new Object[0]));
    private final JLabel enableLigaturesHintLabel = new JLabel(AllIcons.General.ContextHelp);
    private final AbstractFontCombo<?> mySecondaryCombo;
    @NotNull
    private final JBCheckBox myOnlyMonospacedCheckBox = new JBCheckBox(ApplicationBundle.message((String)"checkbox.show.only.monospaced.fonts", (Object[])new Object[0]));
    private boolean myIsInSchemeChange;
    private final JLabel mySizeLabel = new JLabel(ApplicationBundle.message((String)"editbox.font.size", (Object[])new Object[0]));
    private final JTextField myEditorFontSizeField = new JBTextField(4);
    protected static final int ADDITIONAL_VERTICAL_GAP = 12;
    protected static final int BASE_INSET = 5;
    private JLabel mySecondaryFontLabel;
    private final JLabel myLineSpacingLabel = new JLabel(ApplicationBundle.message((String)"editbox.line.spacing", (Object[])new Object[0]));
    private final JTextField myLineSpacingField = new JBTextField(4);

    protected AbstractFontOptionsPanel() {
        this((Boolean)null);
    }

    protected AbstractFontOptionsPanel(@Nullable Boolean isMonospacedOnly) {
        this.myPrimaryCombo = this.createPrimaryFontCombo();
        this.mySecondaryCombo = this.createSecondaryFontCombo();
        this.myPrimaryLabel.setLabelFor((Component)((Object)this.myPrimaryCombo));
        this.mySizeLabel.setLabelFor(this.myEditorFontSizeField);
        this.myEditorFontSizeField.setColumns(4);
        this.myLineSpacingLabel.setLabelFor(this.myLineSpacingField);
        this.enableLigaturesHintLabel.setToolTipText(ApplicationBundle.message((String)"ligatures.tooltip", (Object[])new Object[0]));
        this.myOnlyMonospacedCheckBox.setFont((Font)JBUI.Fonts.smallFont());
        this.addControls();
        this.myEditorFontSizeField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (AbstractFontOptionsPanel.this.myIsInSchemeChange || !EDT.isCurrentThreadEdt()) {
                    return;
                }
                String selectedFont = AbstractFontOptionsPanel.this.myPrimaryCombo.getFontName();
                if (selectedFont != null) {
                    AbstractFontOptionsPanel.this.setFontSize(AbstractFontOptionsPanel.this.getFontSizeFromField());
                }
                AbstractFontOptionsPanel.this.updateDescription(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/colors/AbstractFontOptionsPanel$1", "textChanged"));
            }
        });
        this.myEditorFontSizeField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 38 && e.getKeyCode() != 40) {
                    return;
                }
                boolean up = e.getKeyCode() == 38;
                try {
                    float value = Float.parseFloat(AbstractFontOptionsPanel.this.myEditorFontSizeField.getText());
                    value += (float)(up ? 1 : -1);
                    value = MathUtil.clamp((float)value, (float)EditorFontsConstants.getMinEditorFontSize(), (float)EditorFontsConstants.getMaxEditorFontSize());
                    AbstractFontOptionsPanel.this.myEditorFontSizeField.setText(String.valueOf(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.mySecondaryCombo.setEnabled(false);
        if (this.myPrimaryCombo.isMonospacedOnlySupported()) {
            this.myOnlyMonospacedCheckBox.setVisible(true);
            this.myOnlyMonospacedCheckBox.setBorder(null);
            this.myOnlyMonospacedCheckBox.setSelected(isMonospacedOnly != null ? isMonospacedOnly.booleanValue() : EditorColorsManager.getInstance().isUseOnlyMonospacedFonts());
            this.myOnlyMonospacedCheckBox.addActionListener(e -> {
                EditorColorsManager.getInstance().setUseOnlyMonospacedFonts(this.myOnlyMonospacedCheckBox.isSelected());
                this.myPrimaryCombo.setMonospacedOnly(this.myOnlyMonospacedCheckBox.isSelected());
                this.mySecondaryCombo.setMonospacedOnly(this.myOnlyMonospacedCheckBox.isSelected());
            });
        } else {
            this.myOnlyMonospacedCheckBox.setVisible(false);
        }
        this.myPrimaryCombo.setMonospacedOnly(this.myOnlyMonospacedCheckBox.isSelected());
        this.mySecondaryCombo.setMonospacedOnly(this.myOnlyMonospacedCheckBox.isSelected());
        ItemListener itemListener = this::syncFontFamilies;
        this.myPrimaryCombo.addItemListener(itemListener);
        this.mySecondaryCombo.addItemListener(itemListener);
        ActionListener actionListener = this::syncFontFamilies;
        this.myPrimaryCombo.addActionListener(actionListener);
        this.mySecondaryCombo.addActionListener(actionListener);
        this.myLineSpacingField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (AbstractFontOptionsPanel.this.myIsInSchemeChange) {
                    return;
                }
                float lineSpacing = AbstractFontOptionsPanel.this.getLineSpacingFromField();
                if (AbstractFontOptionsPanel.this.getLineSpacing() != lineSpacing) {
                    AbstractFontOptionsPanel.this.setCurrentLineSpacing(lineSpacing);
                }
                AbstractFontOptionsPanel.this.updateDescription(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/colors/AbstractFontOptionsPanel$3", "textChanged"));
            }
        });
        this.myLineSpacingField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 38 && e.getKeyCode() != 40) {
                    return;
                }
                boolean up = e.getKeyCode() == 38;
                try {
                    float value = Float.parseFloat(AbstractFontOptionsPanel.this.myLineSpacingField.getText());
                    value += (float)(up ? 1 : -1) * 0.1f;
                    value = MathUtil.clamp((float)value, (float)EditorFontsConstants.getMinEditorLineSpacing(), (float)EditorFontsConstants.getMaxEditorLineSpacing());
                    AbstractFontOptionsPanel.this.myLineSpacingField.setText(String.format(Locale.ENGLISH, "%.1f", Float.valueOf(value)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.myEnableLigaturesCheckbox.addActionListener(e -> {
            FontPreferences preferences = this.getFontPreferences();
            if (preferences instanceof ModifiableFontPreferences) {
                ((ModifiableFontPreferences)preferences).setUseLigatures(this.myEnableLigaturesCheckbox.isSelected());
                this.updateDescription(true);
            }
        });
    }

    protected JLabel getPrimaryLabel() {
        return this.myPrimaryLabel;
    }

    protected AbstractFontCombo<?> getPrimaryCombo() {
        return this.myPrimaryCombo;
    }

    protected AbstractFontCombo<?> getSecondaryCombo() {
        return this.mySecondaryCombo;
    }

    protected void setSecondaryFontLabel(JLabel secondaryFontLabel) {
        this.mySecondaryFontLabel = secondaryFontLabel;
    }

    protected JLabel getSizeLabel() {
        return this.mySizeLabel;
    }

    protected JTextField getEditorFontSizeField() {
        return this.myEditorFontSizeField;
    }

    protected JLabel getLineSpacingLabel() {
        return this.myLineSpacingLabel;
    }

    protected JTextField getLineSpacingField() {
        return this.myLineSpacingField;
    }

    protected JCheckBox getEnableLigaturesCheckbox() {
        return this.myEnableLigaturesCheckbox;
    }

    protected JLabel getEnableLigaturesHintLabel() {
        return this.enableLigaturesHintLabel;
    }

    protected void addControls() {
        this.setLayout(new FlowLayout(0));
        this.add(this.createControls());
    }

    protected AbstractFontCombo<?> createPrimaryFontCombo() {
        FontComboBox primaryCombo = new FontComboBox();
        primaryCombo.setRenderer(DEFAULT_FONT_COMBO_RENDERER);
        return primaryCombo;
    }

    protected AbstractFontCombo<?> createSecondaryFontCombo() {
        FontComboBox secondaryCombo = new FontComboBox(false, false, true);
        secondaryCombo.setRenderer(DEFAULT_FONT_COMBO_RENDERER);
        return secondaryCombo;
    }

    protected JComponent createControls() {
        return this.createFontSettingsPanel();
    }

    protected final JPanel createFontSettingsPanel() {
        Insets baseInsets = AbstractFontOptionsPanel.getInsets(0, 0);
        JPanel fontPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = baseInsets;
        c.gridx = 0;
        c.gridy = 0;
        fontPanel.add((Component)this.myPrimaryLabel, c);
        c.gridx = 1;
        fontPanel.add((Component)((Object)this.myPrimaryCombo), c);
        c.gridx = 1;
        ++c.gridy;
        c.insets = AbstractFontOptionsPanel.getInsets(0, 5);
        fontPanel.add((Component)this.myOnlyMonospacedCheckBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.insets = baseInsets;
        fontPanel.add((Component)this.mySizeLabel, c);
        c.gridx = 1;
        JPanel sizePanel = new JPanel();
        FlowLayout sizeLayout = new FlowLayout(0);
        sizeLayout.setHgap(0);
        sizePanel.setLayout(sizeLayout);
        sizePanel.setBorder((Border)JBUI.Borders.empty());
        sizePanel.add(this.myEditorFontSizeField);
        sizePanel.add(Box.createHorizontalStrut(20));
        sizePanel.add(this.myLineSpacingLabel);
        sizePanel.add(this.myLineSpacingField);
        fontPanel.add((Component)sizePanel, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = AbstractFontOptionsPanel.getInsets(12, 0);
        JPanel panel2 = new JPanel(new FlowLayout(1, 0, 0));
        panel2.setBorder((Border)JBUI.Borders.empty());
        panel2.add(this.myEnableLigaturesCheckbox);
        this.enableLigaturesHintLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        panel2.add(this.enableLigaturesHintLabel);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.insets = AbstractFontOptionsPanel.getInsets(12, 0);
        c.insets.bottom = 5;
        fontPanel.add((Component)panel2, c);
        c.gridx = 0;
        ++c.gridy;
        fontPanel.add((Component)AbstractFontOptionsPanel.createReaderModeComment(), c);
        return fontPanel;
    }

    @NotNull
    private static JEditorPane createReaderModeComment() {
        DslLabel dslLabel = UtilsKt.createComment(ApplicationBundle.message((String)"comment.use.ligatures.with.reader.mode", (Object[])new Object[0]), -1, e -> AbstractFontOptionsPanel.goToReaderMode());
        if (dslLabel == null) {
            AbstractFontOptionsPanel.$$$reportNull$$$0(0);
        }
        return dslLabel;
    }

    protected static void goToReaderMode() {
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            if (context == null) {
                return;
            }
            Settings settings = (Settings)Settings.KEY.getData(context);
            if (settings == null) {
                return;
            }
            settings.select(settings.find("editor.reader.mode"));
            ReaderModeStatsCollector.logSeeAlsoNavigation();
        });
    }

    protected final void createSecondaryFontComboAndLabel(@NotNull JPanel target, @NotNull GridBagConstraints c) {
        if (target == null) {
            AbstractFontOptionsPanel.$$$reportNull$$$0(1);
        }
        if (c == null) {
            AbstractFontOptionsPanel.$$$reportNull$$$0(2);
        }
        this.mySecondaryFontLabel = new JLabel(ApplicationBundle.message((String)"secondary.font", (Object[])new Object[0]));
        this.mySecondaryFontLabel.setLabelFor((Component)((Object)this.mySecondaryCombo));
        target.add((Component)this.mySecondaryFontLabel, c);
        c.insets = AbstractFontOptionsPanel.getInsets(0, 0);
        c.gridx = 1;
        target.add((Component)((Object)this.mySecondaryCombo), c);
        ++c.gridy;
        JBLabel fallbackLabel = new JBLabel("<html>" + ApplicationBundle.message((String)"label.fallback.fonts.list.description", (Object[])new Object[0]));
        fallbackLabel.setFont((Font)JBUI.Fonts.smallFont());
        fallbackLabel.setForeground(UIUtil.getContextHelpForeground());
        target.add((Component)fallbackLabel, c);
    }

    protected static Insets getInsets(int extraTopSpacing, int extraLeftSpacing) {
        return JBUI.insets((int)(5 + extraTopSpacing), (int)(5 + extraLeftSpacing), (int)0, (int)0);
    }

    protected void setDelegatingPreferences(boolean isDelegating) {
    }

    private float getFontSizeFromField() {
        try {
            return MathUtil.clamp((float)Float.parseFloat(this.myEditorFontSizeField.getText()), (float)EditorFontsConstants.getMinEditorFontSize(), (float)EditorFontsConstants.getMaxEditorFontSize());
        }
        catch (NumberFormatException e) {
            return EditorFontsConstants.getDefaultEditorFontSize();
        }
    }

    private float getLineSpacingFromField() {
        try {
            return MathUtil.clamp((float)Float.parseFloat(this.myLineSpacingField.getText()), (float)EditorFontsConstants.getMinEditorLineSpacing(), (float)EditorFontsConstants.getMaxEditorLineSpacing());
        }
        catch (NumberFormatException e) {
            return EditorFontsConstants.getDefaultEditorLineSpacing();
        }
    }

    private void syncFontFamilies(AWTEvent event) {
        AbstractFontCombo combo2;
        Object source = event.getSource();
        if (source instanceof AbstractFontCombo && (combo2 = (AbstractFontCombo)((Object)source)).isEnabled() && combo2.isShowing() && combo2.getSelectedItem() != null) {
            this.syncFontFamilies();
        }
    }

    private void syncFontFamilies() {
        if (this.myIsInSchemeChange) {
            return;
        }
        FontPreferences fontPreferences = this.getFontPreferences();
        if (fontPreferences instanceof ModifiableFontPreferences) {
            ModifiableFontPreferences modifiableFontPreferences = (ModifiableFontPreferences)fontPreferences;
            modifiableFontPreferences.clearFonts();
            modifiableFontPreferences.setUseLigatures(this.myEnableLigaturesCheckbox.isSelected());
            String primaryFontFamily = this.myPrimaryCombo.getFontName();
            String secondaryFontFamily = this.mySecondaryCombo.isNoFontSelected() ? null : this.mySecondaryCombo.getFontName();
            float fontSize = this.getFontSizeFromField();
            if (primaryFontFamily != null) {
                if (!FontPreferences.DEFAULT_FONT_NAME.equals(primaryFontFamily)) {
                    modifiableFontPreferences.addFontFamily(primaryFontFamily);
                }
                modifiableFontPreferences.register(primaryFontFamily, fontSize);
            }
            if (secondaryFontFamily != null) {
                if (!FontPreferences.DEFAULT_FONT_NAME.equals(secondaryFontFamily)) {
                    modifiableFontPreferences.addFontFamily(secondaryFontFamily);
                }
                modifiableFontPreferences.register(secondaryFontFamily, fontSize);
            }
            this.updateDescription(true);
        }
    }

    @Override
    public void updateOptionsList() {
        this.myIsInSchemeChange = true;
        this.myLineSpacingField.setText(Float.toString(this.getLineSpacing()));
        FontPreferences fontPreferences = this.getFontPreferences();
        List fontFamilies = fontPreferences.getEffectiveFontFamilies();
        this.myPrimaryCombo.setFontName(fontPreferences.getFontFamily());
        boolean isThereSecondaryFont = fontFamilies.size() > 1;
        this.mySecondaryCombo.setFontName(isThereSecondaryFont ? (String)fontFamilies.get(1) : null);
        this.myEditorFontSizeField.setText(String.valueOf(fontPreferences.getSize2D(fontPreferences.getFontFamily())));
        boolean isReadOnlyColorScheme = this.isReadOnly();
        this.updateCustomOptions();
        boolean readOnly = isReadOnlyColorScheme || !(this.getFontPreferences() instanceof ModifiableFontPreferences);
        this.myPrimaryCombo.setEnabled(!readOnly);
        this.myPrimaryLabel.setEnabled(!readOnly);
        this.mySecondaryCombo.setEnabled(!readOnly);
        if (this.mySecondaryFontLabel != null) {
            this.mySecondaryFontLabel.setEnabled(!readOnly);
        }
        this.myOnlyMonospacedCheckBox.setEnabled(!readOnly);
        this.myLineSpacingField.setEnabled(!readOnly);
        this.myLineSpacingLabel.setEnabled(!readOnly);
        this.myEditorFontSizeField.setEnabled(!readOnly);
        this.mySizeLabel.setEnabled(!readOnly);
        this.myEnableLigaturesCheckbox.setEnabled(!readOnly);
        this.myEnableLigaturesCheckbox.setSelected(fontPreferences.useLigatures());
        this.myIsInSchemeChange = false;
    }

    protected void updateCustomOptions() {
    }

    protected abstract boolean isReadOnly();

    protected abstract boolean isDelegating();

    @NotNull
    protected abstract FontPreferences getFontPreferences();

    protected abstract void setFontSize(int var1);

    protected void setFontSize(float fontSize) {
        this.setFontSize((int)((double)fontSize + 0.5));
    }

    protected abstract float getLineSpacing();

    protected abstract void setCurrentLineSpacing(float var1);

    @Override
    @Nullable
    public Runnable showOption(String option2) {
        return null;
    }

    @Override
    public void applyChangesToScheme() {
    }

    @Override
    public void selectOption(String typeToSelect) {
    }

    public boolean updateDescription(boolean modified) {
        if (modified && this.isReadOnly()) {
            return false;
        }
        this.fireFontChanged();
        return true;
    }

    @Override
    public void addListener(ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void fireFontChanged() {
        ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).fontChanged();
    }

    public void fireSchemeChanged() {
        ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(this);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public Set<String> processListOptions() {
        return new HashSet<String>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/AbstractFontOptionsPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createReaderModeComment";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/AbstractFontOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSecondaryFontComboAndLabel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

