/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\nH\u0002R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006R\u00020\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/diagnostic/GcPauseWatcher;", "", "<init>", "()V", "watchers", "", "Lcom/intellij/diagnostic/GcPauseWatcher$SingleCollectorWatcher;", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "recordGcPauseTime", "", "name", "", "currPauseDuration", "", "checkForPauses", "SingleCollectorWatcher", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGcPauseWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GcPauseWatcher.kt\ncom/intellij/diagnostic/GcPauseWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1586#2:73\n1661#2,3:74\n1915#2,2:77\n*S KotlinDebug\n*F\n+ 1 GcPauseWatcher.kt\ncom/intellij/diagnostic/GcPauseWatcher\n*L\n29#1:73\n29#1:74,3\n62#1:77,2\n*E\n"})
public class GcPauseWatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<SingleCollectorWatcher> watchers;
    @NotNull
    private final AtomicInteger counter;
    private static final long SAMPLING_RATE_MS = 50L;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public GcPauseWatcher() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<GarbageCollectorMXBean> list2 = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getGarbageCollectorMXBeans(...)");
        Iterable iterable = list2;
        GcPauseWatcher gcPauseWatcher = this;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SingleCollectorWatcher((GarbageCollectorMXBean)p0));
        }
        gcPauseWatcher.watchers = (List)destination$iv$iv;
        this.counter = new AtomicInteger();
        AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this::checkForPauses, 0L, 50L, TimeUnit.MILLISECONDS);
    }

    protected void recordGcPauseTime(@NotNull String name2, long currPauseDuration) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (StartUpMeasurer.isEnabled()) {
            StartUpMeasurer.addCompletedActivity((long)(System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(currPauseDuration)), (String)String.valueOf(this.counter.incrementAndGet()), (ActivityCategory)ActivityCategory.GC, null);
        }
    }

    private final void checkForPauses() {
        Iterable $this$forEach$iv = this.watchers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleCollectorWatcher it = (SingleCollectorWatcher)element$iv;
            boolean bl = false;
            it.update();
        }
    }

    static {
        Logger logger = Logger.getInstance(GcPauseWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/diagnostic/GcPauseWatcher$Companion;", "", "<init>", "()V", "SAMPLING_RATE_MS", "", "getInstance", "Lcom/intellij/diagnostic/GcPauseWatcher;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GcPauseWatcher getInstance() {
            Object object = ApplicationManager.getApplication().getService(GcPauseWatcher.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (GcPauseWatcher)object;
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/diagnostic/GcPauseWatcher$SingleCollectorWatcher;", "", "bean", "Ljava/lang/management/GarbageCollectorMXBean;", "<init>", "(Lcom/intellij/diagnostic/GcPauseWatcher;Ljava/lang/management/GarbageCollectorMXBean;)V", "getBean", "()Ljava/lang/management/GarbageCollectorMXBean;", "count", "", "cumulativePauseTime", "update", "", "intellij.platform.ide.impl"})
    private final class SingleCollectorWatcher {
        @NotNull
        private final GarbageCollectorMXBean bean;
        private long count;
        private long cumulativePauseTime;

        public SingleCollectorWatcher(GarbageCollectorMXBean bean) {
            Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
            this.bean = bean;
            this.count = this.bean.getCollectionCount();
            this.cumulativePauseTime = this.bean.getCollectionTime();
        }

        @NotNull
        public final GarbageCollectorMXBean getBean() {
            return this.bean;
        }

        public final void update() {
            long newCount = this.bean.getCollectionCount();
            long newPauseTime = this.bean.getCollectionTime();
            long currPauseDuration = newPauseTime - this.cumulativePauseTime;
            if (newCount - this.count > 0L && currPauseDuration > 0L) {
                String string = this.bean.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                GcPauseWatcher.this.recordGcPauseTime(string, currPauseDuration);
            }
            this.count = newCount;
            this.cumulativePauseTime = newPauseTime;
        }
    }
}

