/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.RecoveredThrowable;
import com.intellij.errorreport.error.InternalEAPException;
import com.intellij.errorreport.error.UpdateAvailableException;
import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.UnhandledException;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.platform.buildData.productInfo.CustomProperty;
import com.intellij.platform.ide.productInfo.IdeProductInfo;
import com.intellij.ui.JBAccountInfoService;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u00014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010\"J\u0014\u0010&\u001a\u00020'2\n\u0010(\u001a\u00060)j\u0002`*H\u0002J\u0014\u0010+\u001a\u00060)j\u0002`*2\u0006\u0010\u001f\u001a\u00020 H\u0002J&\u0010,\u001a\u00020'2\n\u0010(\u001a\u00060)j\u0002`*2\u0006\u0010-\u001a\u00020\u00052\b\u0010.\u001a\u0004\u0018\u00010\u0005H\u0002J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0005002\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u000203H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0012\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010#\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b$\u0010\u0003\u001a\u0004\b%\u0010\n\u00a8\u00065"}, d2={"Lcom/intellij/diagnostic/ITNProxy;", "", "<init>", "()V", "DEFAULT_USER", "", "DEFAULT_PASS", "DIOGEN_VIEW_URL", "DEVICE_ID", "getDEVICE_ID$intellij_platform_ide_impl", "()Ljava/lang/String;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "TEMPLATE", "", "getTEMPLATE", "()Ljava/util/Map;", "TEMPLATE$delegate", "Lkotlin/Lazy;", "getBrowseUrl", "threadId", "", "isInternalUser", "", "httpClient", "Ljava/net/http/HttpClient;", "kotlin.jvm.PlatformType", "getHttpClient", "()Ljava/net/http/HttpClient;", "httpClient$delegate", "sendError", "error", "Lcom/intellij/diagnostic/ITNProxy$ErrorBean;", "newThreadPostUrl", "(Lcom/intellij/diagnostic/ITNProxy$ErrorBean;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "appInfoString", "getAppInfoString$annotations", "getAppInfoString", "appendAppInfo", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "createRequest", "append", "key", "value", "post", "Ljava/net/http/HttpResponse;", "url", "formData", "", "ErrorBean", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nITNProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ITNProxy.kt\ncom/intellij/diagnostic/ITNProxy\n+ 2 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,227:1\n375#2:228\n1#3:229\n106#4:230\n78#4,22:231\n13#5:253\n*S KotlinDebug\n*F\n+ 1 ITNProxy.kt\ncom/intellij/diagnostic/ITNProxy\n*L\n117#1:228\n186#1:230\n186#1:231,22\n52#1:253\n*E\n"})
public final class ITNProxy {
    @NotNull
    public static final ITNProxy INSTANCE = new ITNProxy();
    @NotNull
    private static final String DEFAULT_USER = "idea_anonymous";
    @NotNull
    private static final String DEFAULT_PASS = "guest";
    @NotNull
    private static final String DIOGEN_VIEW_URL = "https://diogen.labs.jb.gg/report/";
    @NotNull
    private static final String DEVICE_ID;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Lazy TEMPLATE$delegate;
    @NotNull
    private static final Lazy httpClient$delegate;

    private ITNProxy() {
    }

    @NotNull
    public final String getDEVICE_ID$intellij_platform_ide_impl() {
        return DEVICE_ID;
    }

    private final Map<String, String> getTEMPLATE() {
        Lazy lazy = TEMPLATE$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public final String getBrowseUrl(long threadId) {
        return this.isInternalUser() ? DIOGEN_VIEW_URL + threadId : null;
    }

    private final boolean isInternalUser() {
        boolean isJetBrainsEmail;
        Object object = JBAccountInfoService.getInstance();
        boolean bl = object != null && (object = object.getUserData()) != null && (object = ((JBAccountInfoService.JBAData)object).email) != null ? StringsKt.endsWith$default((String)object, (String)"@jetbrains.com", (boolean)false, (int)2, null) : (isJetBrainsEmail = false);
        Object object2 = LicensingFacade.getInstance();
        boolean isJetBrainsTeam = object2 != null && (object2 = ((LicensingFacade)object2).licensedTo) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object2), (CharSequence)"JetBrains Team", (boolean)false, (int)2, null) : false;
        return isJetBrainsEmail || isJetBrainsTeam;
    }

    private final HttpClient getHttpClient() {
        Lazy lazy = httpClient$delegate;
        return (HttpClient)lazy.getValue();
    }

    @Nullable
    public final Object sendError(@NotNull ErrorBean error, @NotNull String newThreadPostUrl, @NotNull Continuation<? super Long> $completion) throws Exception {
        boolean $i$f$currentCoroutineContext = false;
        CoroutineContext context = $completion.getContext();
        HttpResponse<String> response = this.post(newThreadPostUrl, this.createRequest(error));
        int responseCode = response.statusCode();
        if (responseCode != 200) {
            Object[] objectArray = new Object[]{Boxing.boxInt((int)responseCode)};
            throw new InternalEAPException(DiagnosticBundle.message("error.http.result.code", objectArray));
        }
        JobKt.ensureActive((CoroutineContext)context);
        String responseText = response.body();
        if (Intrinsics.areEqual((Object)responseText, (Object)"unauthorized")) {
            throw new InternalEAPException("Authorization failed");
        }
        Intrinsics.checkNotNull((Object)responseText);
        if (StringsKt.startsWith$default((String)responseText, (String)"update ", (boolean)false, (int)2, null)) {
            String string = responseText;
            int n = 7;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            throw new UpdateAvailableException(string2);
        }
        if (StringsKt.startsWith$default((String)responseText, (String)"message ", (boolean)false, (int)2, null)) {
            String string = responseText;
            int n = 8;
            String string3 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            throw new InternalEAPException(string3);
        }
        try {
            String reportId2 = ((Object)StringsKt.trim((CharSequence)responseText)).toString();
            LOG.info("report ID: " + reportId2 + ", host ID: " + DEVICE_ID);
            return Boxing.boxLong((long)Long.parseLong(reportId2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InternalEAPException(DiagnosticBundle.message("error.itn.returns.wrong.data", new Object[0]));
        }
    }

    @NotNull
    public static final String getAppInfoString() {
        StringBuilder builder = new StringBuilder();
        INSTANCE.appendAppInfo(builder);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void getAppInfoString$annotations() {
    }

    private final void appendAppInfo(StringBuilder builder) {
        for (Map.Entry<String, String> entry : this.getTEMPLATE().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.append(builder, key, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final StringBuilder createRequest(ErrorBean error) {
        String string;
        String string2;
        StringBuilder stringBuilder;
        ITNProxy iTNProxy;
        StringBuilder builder;
        block16: {
            block15: {
                void $this$trim$iv;
                String appInfo;
                builder = new StringBuilder(8192);
                Object eventData = error.event().getData();
                String string3 = appInfo = eventData instanceof AbstractMessage ? ((AbstractMessage)eventData).getAppInfo() : null;
                if (appInfo != null) {
                    builder.append(appInfo);
                } else {
                    this.appendAppInfo(builder);
                }
                this.append(builder, "user.login", DEFAULT_USER);
                this.append(builder, "user.password", DEFAULT_PASS);
                Object object = JBAccountInfoService.getInstance();
                if (object != null && (object = object.getUserData()) != null && (object = ((JBAccountInfoService.JBAData)object).email) != null) {
                    Object object2;
                    Object it = object2 = object;
                    boolean bl = false;
                    object = StringsKt.endsWith((String)it, (String)"@jetbrains.com", (boolean)true) ? object2 : null;
                    if (object != null) {
                        it = object;
                        boolean bl2 = false;
                        INSTANCE.append(builder, "user.email", (String)it);
                    }
                }
                UpdateSettings updateSettings = UpdateSettings.getInstance();
                this.append(builder, "update.channel.status", updateSettings.getSelectedChannelStatus().getCode());
                this.append(builder, "update.ignored.builds", String.join((CharSequence)",", (Iterable<? extends CharSequence>)updateSettings.getIgnoredBuildNumbers()));
                this.append(builder, "plugin.id", error.pluginId());
                this.append(builder, "plugin.name", error.pluginName());
                this.append(builder, "plugin.version", error.pluginVersion());
                this.append(builder, "last.action", error.lastActionId());
                iTNProxy = this;
                stringBuilder = builder;
                string2 = "error.message";
                string = error.event().getMessage();
                if (string == null) break block15;
                String string4 = string;
                String string5 = string2;
                StringBuilder stringBuilder2 = stringBuilder;
                ITNProxy iTNProxy2 = iTNProxy;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String string6 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                iTNProxy = iTNProxy2;
                stringBuilder = stringBuilder2;
                string2 = string5;
                string = string6;
                if (string != null) break block16;
            }
            string = "";
        }
        iTNProxy.append(stringBuilder, string2, string);
        this.append(builder, "error.stacktrace", error.event().getThrowableText());
        Throwable throwable = error.event().getThrowable();
        UnhandledException unhandledException = throwable instanceof UnhandledException ? (UnhandledException)throwable : null;
        if (unhandledException != null) {
            UnhandledException it = unhandledException;
            boolean bl = false;
            INSTANCE.append(builder, "error.unhandled.interactive", String.valueOf(it.isInteractive()));
        }
        this.append(builder, "error.description", error.comment());
        if (error.event().getThrowable() instanceof RecoveredThrowable) {
            this.append(builder, "error.redacted", "true");
        }
        for (Attachment attachment : error.event().getAttachments()) {
            this.append(builder, "attachment.name", attachment.getName());
            this.append(builder, "attachment.value", attachment.getEncodedBytes());
        }
        return builder;
    }

    private final void append(StringBuilder builder, String key, String value) {
        CharSequence charSequence = value;
        if (!(charSequence == null || charSequence.length() == 0)) {
            if (((CharSequence)builder).length() > 0) {
                builder.append('&');
            }
            builder.append(key).append('=').append(URLEncoder.encode(value, StandardCharsets.UTF_8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HttpResponse<String> post(String url, CharSequence formData) throws Exception {
        BufferExposingByteArrayOutputStream compressed = new BufferExposingByteArrayOutputStream(formData.length());
        Closeable closeable = new OutputStreamWriter((OutputStream)new GZIPOutputStream((OutputStream)compressed), StandardCharsets.UTF_8);
        Throwable throwable = null;
        try {
            OutputStreamWriter writer = (OutputStreamWriter)closeable;
            boolean bl = false;
            for (int j = 0; j < formData.length(); ++j) {
                char element = formData.charAt(j);
                writer.write(element);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        HttpRequest request = HttpRequest.newBuilder(new URI(url)).header("Content-Type", "application/x-www-form-urlencoded; charset=" + StandardCharsets.UTF_8.name()).header("Content-Encoding", "gzip").POST(HttpRequest.BodyPublishers.ofByteArray(compressed.toByteArray(), 0, compressed.size())).build();
        HttpResponse<String> httpResponse = this.getHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        Intrinsics.checkNotNullExpressionValue(httpResponse, (String)"send(...)");
        return httpResponse;
    }

    private static final LinkedHashMap TEMPLATE_delegate$lambda$0() {
        LinkedHashMap template;
        block3: {
            Object v4;
            block2: {
                template = new LinkedHashMap();
                ((Map)template).put("protocol.version", "1.1");
                ((Map)template).put("os.cpu.arch", CpuArch.isEmulated() ? CpuArch.CURRENT + "(emulated)" : String.valueOf(CpuArch.CURRENT));
                ((Map)template).put("os.name", OS.CURRENT.name());
                ((Map)template).put("os.version", OS.CURRENT.version());
                ((Map)template).put("host.id", DEVICE_ID);
                ((Map)template).put("java.version", SystemInfo.JAVA_RUNTIME_VERSION);
                ((Map)template).put("java.vm.vendor", SystemInfo.JAVA_VENDOR);
                ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
                ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"getInstance(...)");
                ApplicationNamesInfo namesInfo = applicationNamesInfo;
                BuildNumber buildNumber = appInfo.getBuild();
                Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
                BuildNumber build2 = buildNumber;
                String string = build2.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                String buildNumberWithAllDetails = string;
                if (StringsKt.startsWith$default((String)buildNumberWithAllDetails, (String)(build2.getProductCode() + "-"), (boolean)false, (int)2, null)) {
                    String string2 = buildNumberWithAllDetails.substring(build2.getProductCode().length() + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    buildNumberWithAllDetails = string2;
                }
                ((Map)template).put("app.name", namesInfo.getProductName());
                ((Map)template).put("app.name.full", namesInfo.getFullProductName());
                ((Map)template).put("app.name.version", appInfo.getVersionName());
                ((Map)template).put("app.eap", Boolean.toString(appInfo.isEAP()));
                ((Map)template).put("app.build", appInfo.getApiVersion());
                ((Map)template).put("app.version.major", appInfo.getMajorVersion());
                ((Map)template).put("app.version.minor", appInfo.getMinorVersion());
                ((Map)template).put("app.build.date", String.valueOf(appInfo.getBuildTime().toInstant().toEpochMilli()));
                ((Map)template).put("app.build.date.release", String.valueOf(appInfo.getMajorReleaseBuildDate().getTime().getTime()));
                ((Map)template).put("app.product.code", build2.getProductCode());
                ((Map)template).put("app.build.number", buildNumberWithAllDetails);
                Iterable iterable = IdeProductInfo.Companion.getInstance().getCurrentProductInfo().getCustomProperties();
                for (Object t : iterable) {
                    CustomProperty it = (CustomProperty)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getKey(), (Object)"source.git.revision")) continue;
                    v4 = t;
                    break block2;
                }
                v4 = null;
            }
            CustomProperty customProperty = v4;
            if (customProperty == null) break block3;
            CustomProperty it = customProperty;
            boolean bl = false;
            ((Map)template).put("app.source.revision", it.getValue());
        }
        return template;
    }

    private static final HttpClient httpClient_delegate$lambda$0() {
        return HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofMinutes(2L)).build();
    }

    static {
        String string = DeviceIdManager.getOrGenerateId((DeviceIdManager.DeviceIdToken)new DeviceIdManager.DeviceIdToken(){}, (String)"EA");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOrGenerateId(...)");
        DEVICE_ID = string;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ITNProxy.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        TEMPLATE$delegate = LazyKt.lazy(ITNProxy::TEMPLATE_delegate$lambda$0);
        httpClient$delegate = LazyKt.lazy(ITNProxy::httpClient_delegate$lambda$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003JO\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0014\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0083\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004J\n\u0010\u001b\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\rR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/intellij/diagnostic/ITNProxy$ErrorBean;", "Ljava/lang/Record;", "event", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "comment", "", "pluginId", "pluginName", "pluginVersion", "lastActionId", "<init>", "(Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "()Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    public static final class ErrorBean
    extends Record {
        @NotNull
        private final IdeaLoggingEvent event;
        @Nullable
        private final String comment;
        @Nullable
        private final String pluginId;
        @Nullable
        private final String pluginName;
        @Nullable
        private final String pluginVersion;
        @Nullable
        private final String lastActionId;

        public ErrorBean(@NotNull IdeaLoggingEvent event, @Nullable String comment2, @Nullable String pluginId, @Nullable String pluginName, @Nullable String pluginVersion, @Nullable String lastActionId) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.event = event;
            this.comment = comment2;
            this.pluginId = pluginId;
            this.pluginName = pluginName;
            this.pluginVersion = pluginVersion;
            this.lastActionId = lastActionId;
        }

        @NotNull
        public final IdeaLoggingEvent event() {
            return this.event;
        }

        @Nullable
        public final String comment() {
            return this.comment;
        }

        @Nullable
        public final String pluginId() {
            return this.pluginId;
        }

        @Nullable
        public final String pluginName() {
            return this.pluginName;
        }

        @Nullable
        public final String pluginVersion() {
            return this.pluginVersion;
        }

        @Nullable
        public final String lastActionId() {
            return this.lastActionId;
        }

        @NotNull
        public final IdeaLoggingEvent component1() {
            return this.event;
        }

        @Nullable
        public final String component2() {
            return this.comment;
        }

        @Nullable
        public final String component3() {
            return this.pluginId;
        }

        @Nullable
        public final String component4() {
            return this.pluginName;
        }

        @Nullable
        public final String component5() {
            return this.pluginVersion;
        }

        @Nullable
        public final String component6() {
            return this.lastActionId;
        }

        @NotNull
        public final ErrorBean copy(@NotNull IdeaLoggingEvent event, @Nullable String comment2, @Nullable String pluginId, @Nullable String pluginName, @Nullable String pluginVersion, @Nullable String lastActionId) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return new ErrorBean(event, comment2, pluginId, pluginName, pluginVersion, lastActionId);
        }

        public static /* synthetic */ ErrorBean copy$default(ErrorBean errorBean, IdeaLoggingEvent ideaLoggingEvent, String string, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                ideaLoggingEvent = errorBean.event;
            }
            if ((n & 2) != 0) {
                string = errorBean.comment;
            }
            if ((n & 4) != 0) {
                string2 = errorBean.pluginId;
            }
            if ((n & 8) != 0) {
                string3 = errorBean.pluginName;
            }
            if ((n & 0x10) != 0) {
                string4 = errorBean.pluginVersion;
            }
            if ((n & 0x20) != 0) {
                string5 = errorBean.lastActionId;
            }
            return errorBean.copy(ideaLoggingEvent, string, string2, string3, string4, string5);
        }

        @Override
        @NotNull
        public String toString() {
            return "ErrorBean(event=" + this.event + ", comment=" + this.comment + ", pluginId=" + this.pluginId + ", pluginName=" + this.pluginName + ", pluginVersion=" + this.pluginVersion + ", lastActionId=" + this.lastActionId + ")";
        }

        @Override
        public int hashCode() {
            int result2 = this.event.hashCode();
            result2 = result2 * 31 + (this.comment == null ? 0 : this.comment.hashCode());
            result2 = result2 * 31 + (this.pluginId == null ? 0 : this.pluginId.hashCode());
            result2 = result2 * 31 + (this.pluginName == null ? 0 : this.pluginName.hashCode());
            result2 = result2 * 31 + (this.pluginVersion == null ? 0 : this.pluginVersion.hashCode());
            result2 = result2 * 31 + (this.lastActionId == null ? 0 : this.lastActionId.hashCode());
            return result2;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ErrorBean)) {
                return false;
            }
            ErrorBean errorBean = (ErrorBean)other;
            if (!Intrinsics.areEqual((Object)this.event, (Object)errorBean.event)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.comment, (Object)errorBean.comment)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pluginId, (Object)errorBean.pluginId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pluginName, (Object)errorBean.pluginName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pluginVersion, (Object)errorBean.pluginVersion)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lastActionId, (Object)errorBean.lastActionId);
        }
    }
}

