/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.diagnostic.EditMemorySettingsDialog;
import com.intellij.diagnostic.UILatencyLogger;
import com.intellij.diagnostic.VMOptions;
import com.intellij.diagnostic.hprof.action.HeapDumpSnapshotRunnable;
import com.intellij.diagnostic.report.MemoryReportReason;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import io.opentelemetry.api.metrics.DoubleGauge;
import io.opentelemetry.api.metrics.Meter;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
@VisibleForTesting
public final class LowMemoryNotifier
implements Disposable {
    private static final Logger LOG = Logger.getInstance(LowMemoryNotifier.class);
    private static final Set<VMOptions.MemoryKind> notifications = ConcurrentCollectionFactory.createConcurrentSet();
    private static final long SUMMARISING_WINDOW_MS = SystemProperties.getLongProperty((String)"LowMemoryNotifier.SUMMARISING_WINDOW_MS", (long)TimeUnit.MINUTES.toMillis(15L));
    private static final long THROTTLING_PERIOD_MS = SystemProperties.getLongProperty((String)"LowMemoryNotifier.THROTTLING_PERIOD_MS", (long)TimeUnit.SECONDS.toMillis(20L));
    private static final double LONG_TERM_MEMORY_DEFICIT_THRESHOLD = SystemProperties.getFloatProperty((String)"LowMemoryNotifier.LONG_TERM_MEMORY_DEFICIT_THRESHOLD", (float)5.0f);
    private final ThrottlingWindowedFilter throttlingFilter = new ThrottlingWindowedFilter(SUMMARISING_WINDOW_MS, THROTTLING_PERIOD_MS);
    private final LowMemoryWatcher watcher;

    LowMemoryNotifier() {
        Meter otelMeter = TelemetryManager.getInstance().getMeter(PlatformScopesKt.PlatformMetrics);
        DoubleGauge memoryDeficitScoreMetric = otelMeter.gaugeBuilder("LowMemory.memoryDeficitScore").build();
        this.watcher = LowMemoryWatcher.register(() -> {
            double memoryDeficitScore = this.throttlingFilter.throttledSum(System.currentTimeMillis());
            memoryDeficitScoreMetric.set(memoryDeficitScore);
            LOG.info("Memory deficit score: " + memoryDeficitScore + ", threshold: " + LONG_TERM_MEMORY_DEFICIT_THRESHOLD);
            if (memoryDeficitScore > LONG_TERM_MEMORY_DEFICIT_THRESHOLD) {
                this.throttlingFilter.reset();
                LowMemoryNotifier.showNotification(VMOptions.MemoryKind.HEAP, false);
            }
        }, (LowMemoryWatcher.LowMemoryWatcherType)LowMemoryWatcher.LowMemoryWatcherType.ONLY_AFTER_GC);
    }

    public void dispose() {
        this.watcher.stop();
    }

    static void showNotificationFromCrashAnalysis() {
        LowMemoryNotifier.showNotification(VMOptions.MemoryKind.HEAP, true, true);
    }

    static void showNotification(@NotNull VMOptions.MemoryKind kind, boolean oomError) {
        if (kind == null) {
            LowMemoryNotifier.$$$reportNull$$$0(0);
        }
        LowMemoryNotifier.showNotification(kind, oomError, false);
    }

    private static void showNotification(@NotNull VMOptions.MemoryKind kind, boolean oomError, boolean fromCrashReport) {
        if (kind == null) {
            LowMemoryNotifier.$$$reportNull$$$0(1);
        }
        int currentXmx = VMOptions.readOption(VMOptions.MemoryKind.HEAP, true);
        Object[] projects = ProjectManager.getInstance().getOpenProjects();
        int projectCount = projects.length;
        boolean isDumb = ContainerUtil.exists((Object[])projects, p -> DumbService.isDumb((Project)p));
        UILatencyLogger.lowMemory(kind, currentXmx, projectCount, oomError, fromCrashReport, isDumb);
        if (isDumb && kind == VMOptions.MemoryKind.HEAP && !oomError && !fromCrashReport && Registry.is((String)"ide.suppress.low.memory.notifications.when.dumb")) {
            LOG.info("Skipped Low Memory notifications because indexing is in progress");
            return;
        }
        if (!notifications.add(kind)) {
            return;
        }
        String message = oomError ? IdeBundle.message((String)"low.memory.notification.error", (Object[])new Object[]{kind.label()}) : IdeBundle.message((String)"low.memory.notification.warning", (Object[])new Object[0]);
        NotificationType type = oomError ? NotificationType.ERROR : NotificationType.WARNING;
        Notification notification2 = new Notification("Low Memory", IdeBundle.message((String)"low.memory.notification.title", (Object[])new Object[0]), message, type);
        if (!fromCrashReport) {
            notification2.addAction((AnAction)NotificationAction.createSimpleExpiring((String)IdeBundle.message((String)"low.memory.notification.analyze.action", (Object[])new Object[0]), () -> new HeapDumpSnapshotRunnable(MemoryReportReason.UserInvoked, HeapDumpSnapshotRunnable.AnalysisOption.SCHEDULE_ON_NEXT_START).run()));
        }
        if (VMOptions.canWriteOptions()) {
            notification2.addAction((AnAction)NotificationAction.createSimpleExpiring((String)IdeBundle.message((String)"low.memory.notification.action", (Object[])new Object[0]), () -> new EditMemorySettingsDialog(kind).show()));
        }
        notification2.whenExpired(() -> notifications.remove((Object)kind));
        Notifications.Bus.notify((Notification)notification2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/diagnostic/LowMemoryNotifier", "showNotification"));
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static class ThrottlingWindowedFilter {
        private final long windowSizeMs;
        private final long throttlingPeriodMs;
        private long recentUpdateTimestampMs = 0L;
        private final Queue<DataPoint> history = new ArrayDeque<DataPoint>();

        public ThrottlingWindowedFilter(long windowSizeMs, long throttlingPeriodMs) {
            this.windowSizeMs = windowSizeMs;
            this.throttlingPeriodMs = throttlingPeriodMs;
        }

        public synchronized double throttledSum(long currentTimeMs) {
            if (this.history.isEmpty() || currentTimeMs - this.recentUpdateTimestampMs > this.throttlingPeriodMs) {
                this.history.offer(new DataPoint(currentTimeMs, 1L));
                this.recentUpdateTimestampMs = currentTimeMs;
                while (!this.history.isEmpty() && this.history.peek().timestamp < currentTimeMs - this.windowSizeMs) {
                    this.history.poll();
                }
            }
            return this.history.stream().mapToLong(period -> period.value).sum();
        }

        public synchronized void reset() {
            this.history.clear();
        }

        private record DataPoint(long timestamp, long value) {
        }
    }
}

