/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.action;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.HeapDumpAnalysisSupport;
import com.intellij.diagnostic.hprof.action.AnalysisRunnable;
import com.intellij.diagnostic.hprof.action.AnalysisRunnableKt;
import com.intellij.diagnostic.hprof.action.ShowReportDialog;
import com.intellij.diagnostic.hprof.action.SystemTempFilenameSupplier;
import com.intellij.diagnostic.hprof.analysis.AnalysisContext;
import com.intellij.diagnostic.hprof.analysis.HProfAnalysis;
import com.intellij.diagnostic.hprof.util.HeapDumpAnalysisNotificationGroup;
import com.intellij.diagnostic.hprof.util.ListProvider;
import com.intellij.diagnostic.report.HeapReportProperties;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ui.UIUtil;
import java.io.Closeable;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/diagnostic/hprof/action/AnalysisRunnable;", "Ljava/lang/Runnable;", "hprofPath", "Ljava/nio/file/Path;", "heapProperties", "Lcom/intellij/diagnostic/report/HeapReportProperties;", "deleteAfterAnalysis", "", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/diagnostic/report/HeapReportProperties;Z)V", "getHprofPath", "()Ljava/nio/file/Path;", "getHeapProperties", "()Lcom/intellij/diagnostic/report/HeapReportProperties;", "run", "", "AnalysisTask", "ReviewReportAction", "intellij.platform.ide.impl"})
public final class AnalysisRunnable
implements Runnable {
    @NotNull
    private final Path hprofPath;
    @NotNull
    private final HeapReportProperties heapProperties;
    private final boolean deleteAfterAnalysis;

    public AnalysisRunnable(@NotNull Path hprofPath, @NotNull HeapReportProperties heapProperties, boolean deleteAfterAnalysis) {
        Intrinsics.checkNotNullParameter((Object)hprofPath, (String)"hprofPath");
        Intrinsics.checkNotNullParameter((Object)heapProperties, (String)"heapProperties");
        this.hprofPath = hprofPath;
        this.heapProperties = heapProperties;
        this.deleteAfterAnalysis = deleteAfterAnalysis;
    }

    @NotNull
    public final Path getHprofPath() {
        return this.hprofPath;
    }

    @NotNull
    public final HeapReportProperties getHeapProperties() {
        return this.heapProperties;
    }

    @Override
    public void run() {
        new AnalysisTask().queue();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/diagnostic/hprof/action/AnalysisRunnable$AnalysisTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "<init>", "(Lcom/intellij/diagnostic/hprof/action/AnalysisRunnable;)V", "onThrowable", "", "error", "", "deleteHprofFileAsync", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.ide.impl"})
    public final class AnalysisTask
    extends Task.Backgroundable {
        public AnalysisTask() {
            super(null, DiagnosticBundle.message("heap.dump.analysis.task.title", new Object[0]), false);
        }

        public void onThrowable(@NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            AnalysisRunnableKt.access$getLOG().error(error);
            HeapDumpAnalysisSupport.Companion.getInstance().analysisFailed(AnalysisRunnable.this.getHeapProperties());
            String string = DiagnosticBundle.message("heap.dump.analysis.exception", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Notification notification2 = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string, NotificationType.INFORMATION);
            if (ShowLogAction.isSupported()) {
                notification2.addAction((AnAction)ShowLogAction.notificationAction());
            }
            notification2.notify(null);
            if (AnalysisRunnable.this.deleteAfterAnalysis) {
                this.deleteHprofFileAsync();
            }
        }

        private final void deleteHprofFileAsync() {
            CompletableFuture.runAsync(() -> AnalysisTask.deleteHprofFileAsync$lambda$0(AnalysisRunnable.this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
            indicator2.setIndeterminate(false);
            indicator2.setText(DiagnosticBundle.message("heap.dump.analysis.indicator.title", new Object[0]));
            indicator2.setFraction(0.0);
            Set openOptions = null;
            if (AnalysisRunnable.this.deleteAfterAnalysis) {
                Object[] objectArray = new StandardOpenOption[]{StandardOpenOption.READ, StandardOpenOption.DELETE_ON_CLOSE};
                openOptions = SetsKt.setOf((Object[])objectArray);
            } else {
                openOptions = SetsKt.setOf((Object)StandardOpenOption.READ);
            }
            Closeable closeable = FileChannel.open(AnalysisRunnable.this.getHprofPath(), openOptions, new FileAttribute[0]);
            Throwable throwable = null;
            try {
                FileChannel channel = (FileChannel)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)channel);
                string = new HProfAnalysis(channel, new SystemTempFilenameSupplier(), (Function3<? super AnalysisContext, ? super ListProvider, ? super ProgressIndicator, String>)((Function3)run.reportString.1.1.INSTANCE)).analyze(indicator2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String reportString2 = string;
            if (AnalysisRunnable.this.deleteAfterAnalysis) {
                this.deleteHprofFileAsync();
            }
            String string2 = DiagnosticBundle.message("heap.dump.analysis.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String string3 = DiagnosticBundle.message("heap.dump.analysis.notification.ready.content", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            Notification notification2 = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string2, string3, NotificationType.INFORMATION);
            notification2.setImportant(true);
            notification2.addAction((AnAction)new ReviewReportAction(reportString2, AnalysisRunnable.this.getHeapProperties()));
            notification2.notify(null);
        }

        private static final void deleteHprofFileAsync$lambda$0(AnalysisRunnable this$0) {
            Files.deleteIfExists(this$0.getHprofPath());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/diagnostic/hprof/action/AnalysisRunnable$ReviewReportAction;", "Lcom/intellij/notification/NotificationAction;", "reportText", "", "heapProperties", "Lcom/intellij/diagnostic/report/HeapReportProperties;", "<init>", "(Ljava/lang/String;Lcom/intellij/diagnostic/report/HeapReportProperties;)V", "reportShown", "", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "notification", "Lcom/intellij/notification/Notification;", "intellij.platform.ide.impl"})
    public static final class ReviewReportAction
    extends NotificationAction {
        @NotNull
        private final String reportText;
        @NotNull
        private final HeapReportProperties heapProperties;
        private boolean reportShown;

        public ReviewReportAction(@NotNull String reportText, @NotNull HeapReportProperties heapProperties) {
            Intrinsics.checkNotNullParameter((Object)reportText, (String)"reportText");
            Intrinsics.checkNotNullParameter((Object)heapProperties, (String)"heapProperties");
            super(DiagnosticBundle.message("heap.dump.analysis.notification.action.title", new Object[0]));
            this.reportText = reportText;
            this.heapProperties = heapProperties;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
            JFrame jFrame = WindowManager.getInstance().getFrame(e.getProject());
            if (jFrame == null) {
                return;
            }
            JFrame parentComponent = jFrame;
            if (this.reportShown) {
                return;
            }
            this.reportShown = true;
            UIUtil.invokeLaterIfNeeded(() -> ReviewReportAction.actionPerformed$lambda$0(notification2, this, parentComponent));
        }

        private static final void actionPerformed$lambda$0(Notification $notification, ReviewReportAction this$0, JFrame $parentComponent) {
            $notification.expire();
            ShowReportDialog reportDialog = new ShowReportDialog(this$0.reportText, this$0.heapProperties);
            boolean userAgreedToSendReport = reportDialog.showAndGet();
            HeapDumpAnalysisSupport.Companion.getInstance().analysisComplete(this$0.heapProperties);
            if (userAgreedToSendReport) {
                HeapDumpAnalysisSupport.Companion.getInstance().uploadReport(this$0.reportText, this$0.heapProperties, $parentComponent);
            }
        }
    }
}

