/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView.impl;

import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TooManyListenersException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ErrorViewTextExporter
implements ExporterToTextFile {
    private final JCheckBox myCbShowDetails;
    private final ErrorViewStructure myStructure;
    private ChangeListener myChangeListener;

    public ErrorViewTextExporter(ErrorViewStructure treeStructure) {
        this.myStructure = treeStructure;
        this.myCbShowDetails = new JCheckBox(IdeBundle.message((String)"checkbox.errortree.export.details", (Object[])new Object[0]));
        this.myCbShowDetails.setSelected(true);
        this.myCbShowDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorViewTextExporter.this.myChangeListener.stateChanged(null);
            }
        });
    }

    public JComponent getSettingsEditor() {
        return this.myCbShowDetails;
    }

    public void addSettingsChangedListener(ChangeListener listener2) throws TooManyListenersException {
        if (this.myChangeListener != null) {
            throw new TooManyListenersException();
        }
        this.myChangeListener = listener2;
    }

    public void removeSettingsChangedListener(ChangeListener listener2) {
        this.myChangeListener = null;
    }

    @NotNull
    public String getReportText() {
        StringBuffer buffer2 = new StringBuffer();
        this.getReportText(buffer2, (ErrorTreeElement)this.myStructure.getRootElement(), this.myCbShowDetails.isSelected(), 0);
        String string = buffer2.toString();
        if (string == null) {
            ErrorViewTextExporter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDefaultFilePath() {
        return "";
    }

    public boolean canExport() {
        return true;
    }

    private void getReportText(StringBuffer buffer2, ErrorTreeElement element, boolean withUsages, int indent) {
        ErrorTreeElement[] children2;
        String newline = System.lineSeparator();
        for (ErrorTreeElement child : children2 = this.myStructure.getChildElements(element)) {
            if (!(child instanceof ErrorTreeElement)) continue;
            ErrorTreeElement childElement = child;
            if (!withUsages && child instanceof NavigatableMessageElement) continue;
            if (!buffer2.isEmpty()) {
                buffer2.append(newline);
            }
            ErrorViewTextExporter.shift(buffer2, indent);
            ErrorViewTextExporter.exportElement(childElement, buffer2, indent, newline);
            this.getReportText(buffer2, childElement, withUsages, indent + 4);
        }
    }

    public static void exportElement(ErrorTreeElement element, StringBuffer buffer2, int baseIntent, String newline) {
        int startLength = buffer2.length();
        buffer2.append(element.getKind().getPresentableText());
        buffer2.append(element.getExportTextPrefix());
        int localIndent = startLength - buffer2.length();
        String[] text2 = element.getText();
        if (text2 != null && text2.length > 0) {
            buffer2.append(text2[0]);
            for (int i2 = 1; i2 < text2.length; ++i2) {
                buffer2.append(newline);
                ErrorViewTextExporter.shift(buffer2, baseIntent + localIndent);
                buffer2.append(text2[i2]);
            }
        }
    }

    private static void shift(StringBuffer buffer2, int indent) {
        for (int i2 = 0; i2 < indent; ++i2) {
            buffer2.append(' ');
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/errorTreeView/impl/ErrorViewTextExporter", "getReportText"));
    }
}

