/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.auth;

import com.intellij.ide.plugins.auth.PluginRepositoryAuthProvider;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.HttpRequests;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/plugins/auth/PluginRepositoryAuthService;", "", "<init>", "()V", "connectionTuner", "Lcom/intellij/util/io/HttpRequests$ConnectionTuner;", "getConnectionTuner", "()Lcom/intellij/util/io/HttpRequests$ConnectionTuner;", "getAllCustomHeaders", "", "", "url", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPluginRepositoryAuthService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginRepositoryAuthService.kt\ncom/intellij/ide/plugins/auth/PluginRepositoryAuthService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,50:1\n777#2:51\n873#2:52\n874#2:54\n23#3:53\n23#3:55\n23#3:56\n23#3:59\n221#4,2:57\n*S KotlinDebug\n*F\n+ 1 PluginRepositoryAuthService.kt\ncom/intellij/ide/plugins/auth/PluginRepositoryAuthService\n*L\n25#1:51\n25#1:52\n25#1:54\n30#1:53\n38#1:55\n45#1:56\n20#1:59\n17#1:57,2\n*E\n"})
public final class PluginRepositoryAuthService {
    @NotNull
    private final HttpRequests.ConnectionTuner connectionTuner = arg_0 -> PluginRepositoryAuthService.connectionTuner$lambda$0(this, arg_0);

    @NotNull
    public final HttpRequests.ConnectionTuner getConnectionTuner() {
        return this.connectionTuner;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> getAllCustomHeaders(@NotNull String url) {
        Map map2;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Iterable $this$filter$iv = PluginRepositoryAuthProvider.EP_NAME.getExtensionsIfPointIsRegistered();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            PluginRepositoryAuthProvider it = (PluginRepositoryAuthProvider)element$iv$iv;
            boolean bl2 = false;
            try {
                bl = it.canHandle(url);
            }
            catch (Exception e) {
                PluginRepositoryAuthService $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(PluginRepositoryAuthService.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Error while checking if a provider can handle URL(" + url + "), assuming false", (Throwable)e);
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List contributors = (List)destination$iv$iv;
        if (contributors.isEmpty()) {
            return MapsKt.emptyMap();
        }
        if (contributors.size() > 1) {
            PluginRepositoryAuthService $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PluginRepositoryAuthService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Multiple contributors tried to inject headers in to url(" + url + "): " + CollectionsKt.joinToString$default((Iterable)contributors, null, null, null, (int)0, null, PluginRepositoryAuthService::getAllCustomHeaders$lambda$1, (int)31, null));
        }
        try {
            map2 = ((PluginRepositoryAuthProvider)CollectionsKt.first((List)contributors)).getAuthHeaders(url);
            Intrinsics.checkNotNull(map2);
        }
        catch (Exception e) {
            PluginRepositoryAuthService $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PluginRepositoryAuthService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to get custom headers from provider for URL(" + url + "), returning emptyMap()", (Throwable)e);
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    private static final void connectionTuner$lambda$0(PluginRepositoryAuthService this$0, URLConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        try {
            String string = connection.getURL().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Map<String, String> $this$forEach$iv = this$0.getAllCustomHeaders(string);
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl = false;
                String k = entry.getKey();
                String v = entry.getValue();
                connection.addRequestProperty(k, v);
            }
        }
        catch (Exception e) {
            PluginRepositoryAuthService $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PluginRepositoryAuthService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Filed to inject headers into request(" + connection.getURL() + ")", (Throwable)e);
        }
    }

    private static final CharSequence getAllCustomHeaders$lambda$1(PluginRepositoryAuthProvider it) {
        String string = it.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }
}

