/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.marketplace.MarketplaceRequestsKt;
import com.intellij.ide.plugins.marketplace.PluginChunkDataSourceKt;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.jetbrains.plugin.blockmap.core.BlockMap;
import com.jetbrains.plugin.blockmap.core.Chunk;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0017\u001a\u00020\u0018H\u0096\u0082\u0004J\n\u0010\u0019\u001a\u00020\u0002H\u0096\u0082\u0004J\b\u0010\u001a\u001a\u00020\u0007H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0002J,\u0010$\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0002J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00130\u0012j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0013`\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/ide/plugins/marketplace/PluginChunkDataSource;", "", "", "oldBlockMap", "Lcom/jetbrains/plugin/blockmap/core/BlockMap;", "newBlockMap", "newPluginUrl", "", "<init>", "(Lcom/jetbrains/plugin/blockmap/core/BlockMap;Lcom/jetbrains/plugin/blockmap/core/BlockMap;Ljava/lang/String;)V", "oldSet", "", "Lcom/jetbrains/plugin/blockmap/core/Chunk;", "chunks", "", "pos", "", "chunkSequences", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "curChunkData", "pointer", "hasNext", "", "next", "nextRange", "nextChunkSequence", "bytes", "getRange", "range", "parseHttpMultirangeHeaders", "", "input", "Ljava/io/BufferedInputStream;", "boundary", "parseHttpRangeBody", "sequence", "result", "nextLine", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPluginChunkDataSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginChunkDataSource.kt\ncom/intellij/ide/plugins/marketplace/PluginChunkDataSource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n777#2:161\n873#2,2:162\n*S KotlinDebug\n*F\n+ 1 PluginChunkDataSource.kt\ncom/intellij/ide/plugins/marketplace/PluginChunkDataSource\n*L\n28#1:161\n28#1:162,2\n*E\n"})
public final class PluginChunkDataSource
implements Iterator<byte[]>,
KMappedMarker {
    @NotNull
    private final String newPluginUrl;
    @NotNull
    private final Set<Chunk> oldSet;
    @NotNull
    private final List<Chunk> chunks;
    private int pos;
    @NotNull
    private ArrayList<List<Chunk>> chunkSequences;
    @NotNull
    private List<byte[]> curChunkData;
    private int pointer;

    /*
     * WARNING - void declaration
     */
    public PluginChunkDataSource(@NotNull BlockMap oldBlockMap, @NotNull BlockMap newBlockMap, @NotNull String newPluginUrl) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)oldBlockMap, (String)"oldBlockMap");
        Intrinsics.checkNotNullParameter((Object)newBlockMap, (String)"newBlockMap");
        Intrinsics.checkNotNullParameter((Object)newPluginUrl, (String)"newPluginUrl");
        this.newPluginUrl = newPluginUrl;
        this.oldSet = CollectionsKt.toSet((Iterable)oldBlockMap.getChunks());
        Iterable iterable = newBlockMap.getChunks();
        PluginChunkDataSource pluginChunkDataSource = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Chunk chunk = (Chunk)element$iv$iv;
            boolean bl = false;
            if (!(!this.oldSet.contains(chunk))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        pluginChunkDataSource.chunks = (List)destination$iv$iv;
        this.chunkSequences = new ArrayList();
        this.curChunkData = this.getRange(this.nextRange());
    }

    @Override
    public boolean hasNext() {
        return this.curChunkData.size() != 0;
    }

    @Override
    @NotNull
    public byte[] next() {
        byte[] byArray;
        if (this.curChunkData.size() != 0) {
            if (this.pointer < this.curChunkData.size()) {
                int n = this.pointer;
                this.pointer = n + 1;
                byArray = this.curChunkData.get(n);
            } else {
                this.curChunkData = this.getRange(this.nextRange());
                this.pointer = 0;
                byArray = this.next();
            }
        } else {
            throw new NoSuchElementException();
        }
        return byArray;
    }

    private final String nextRange() {
        List<Chunk> chunkSequence;
        StringBuilder range = new StringBuilder();
        this.chunkSequences.clear();
        for (int bytes = 0; this.pos < this.chunks.size() && range.length() < 19000 && bytes < 10000000; bytes += ((Chunk)CollectionsKt.last(chunkSequence)).getOffset() + ((Chunk)CollectionsKt.last(chunkSequence)).getLength() - chunkSequence.get(0).getOffset()) {
            chunkSequence = this.nextChunkSequence(bytes);
            this.chunkSequences.add(chunkSequence);
            range.append(chunkSequence.get(0).getOffset() + "-" + (((Chunk)CollectionsKt.last(chunkSequence)).getOffset() + ((Chunk)CollectionsKt.last(chunkSequence)).getLength() - 1) + ",");
        }
        return ((Object)StringsKt.removeSuffix((CharSequence)range, (CharSequence)",")).toString();
    }

    private final List<Chunk> nextChunkSequence(int bytes) {
        ArrayList<Chunk> result2 = new ArrayList<Chunk>();
        result2.add(this.chunks.get(this.pos));
        int n = this.pos;
        this.pos = n + 1;
        int sum = ((Chunk)result2.get(0)).getLength();
        while (this.pos < this.chunks.size() - 1 && this.chunks.get(this.pos).getOffset() == this.chunks.get(this.pos - 1).getOffset() + this.chunks.get(this.pos - 1).getLength() && sum + bytes < 10000000) {
            result2.add(this.chunks.get(this.pos));
            sum += this.chunks.get(this.pos).getLength();
            int n2 = this.pos;
            this.pos = n2 + 1;
        }
        return result2;
    }

    private final List<byte[]> getRange(String range) {
        ArrayList result2 = new ArrayList();
        if (((CharSequence)range).length() == 0) {
            PluginChunkDataSourceKt.access$getLOG$p().warn("Empty range: request '" + this.newPluginUrl + "' range '" + range + "'");
        } else {
            RequestBuilder requestBuilder = HttpRequests.requestWithRange((String)this.newPluginUrl, (String)range).productNameAsUserAgent();
            Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"productNameAsUserAgent(...)");
            Unit cfr_ignored_0 = (Unit)MarketplaceRequestsKt.setHeadersViaTuner(requestBuilder).connect(arg_0 -> PluginChunkDataSource.getRange$lambda$0(this, result2, range, arg_0));
        }
        return result2;
    }

    private final void parseHttpMultirangeHeaders(BufferedInputStream input, String boundary) {
        String openingEmptyLine = this.nextLine(input);
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)openingEmptyLine)).toString()).length() > 0) {
            throw new IOException(IdeBundle.message((String)"http.multirange.response.doesnt.include.line.separator", (Object[])new Object[0]));
        }
        String boundaryLine = this.nextLine(input);
        if (!StringsKt.contains$default((CharSequence)boundaryLine, (CharSequence)boundary, (boolean)false, (int)2, null)) {
            Object[] objectArray = new Object[]{boundaryLine, boundary};
            throw new IOException(IdeBundle.message((String)"http.multirange.response.doesnt.contain.boundary", (Object[])objectArray));
        }
        String contentTypeLine = this.nextLine(input);
        if (!StringsKt.startsWith$default((String)contentTypeLine, (String)"Content-Type", (boolean)false, (int)2, null)) {
            Object[] objectArray = new Object[]{contentTypeLine, "Content-Type"};
            throw new IOException(IdeBundle.message((String)"http.multirange.response.includes.incorrect.header", (Object[])objectArray));
        }
        String contentRangeLine = this.nextLine(input);
        if (!StringsKt.startsWith$default((String)contentRangeLine, (String)"Content-Range", (boolean)false, (int)2, null)) {
            Object[] objectArray = new Object[]{contentRangeLine, "Content-Range"};
            throw new IOException(IdeBundle.message((String)"http.multirange.response.includes.incorrect.header", (Object[])objectArray));
        }
        String closingEmptyLine = this.nextLine(input);
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)closingEmptyLine)).toString()).length() > 0) {
            throw new IOException(IdeBundle.message((String)"http.multirange.response.doesnt.include.line.separator", (Object[])new Object[0]));
        }
    }

    private final void parseHttpRangeBody(BufferedInputStream input, List<Chunk> sequence, List<byte[]> result2) {
        for (Chunk chunk : sequence) {
            byte[] data2 = new byte[chunk.getLength()];
            int n = chunk.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                data2[i2] = (byte)input.read();
            }
            result2.add(data2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String nextLine(BufferedInputStream input) {
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            int n;
            ByteArrayOutputStream baos = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            do {
                n = input.read();
                baos.write(n);
                if (baos.size() < 1024) continue;
                Object[] objectArray = new Object[1];
                byte[] byArray = baos.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                byte[] byArray2 = byArray;
                Charset charset = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
                Charset charset2 = charset;
                objectArray[0] = new String(byArray2, charset2);
                throw new IOException(IdeBundle.message((String)"wrong.http.range.response", (Object[])objectArray));
            } while ((char)n != '\n');
            byte[] byArray = baos.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            byte[] byArray3 = byArray;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
            Charset charset3 = charset;
            String string = new String(byArray3, charset3);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit getRange$lambda$0(PluginChunkDataSource this$0, ArrayList $result, String $range, HttpRequests.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = request.getConnection().getContentType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContentType(...)");
        String boundary = StringsKt.removePrefix((String)string, (CharSequence)"multipart/byteranges; boundary=");
        InputStream inputStream = request.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Closeable closeable = inputStream;
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream input = (BufferedInputStream)closeable;
            boolean bl = false;
            if (this$0.chunkSequences.size() > 1) {
                Iterator<List<Chunk>> iterator = this$0.chunkSequences.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator<List<Chunk>> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    List<Chunk> sequence;
                    Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
                    this$0.parseHttpMultirangeHeaders(input, boundary);
                    this$0.parseHttpRangeBody(input, sequence, $result);
                }
            } else if (this$0.chunkSequences.size() == 1) {
                List<Chunk> list2 = this$0.chunkSequences.get(0);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"get(...)");
                this$0.parseHttpRangeBody(input, list2, $result);
            } else {
                PluginChunkDataSourceKt.access$getLOG$p().warn("Zero chunks: request '" + this$0.newPluginUrl + "' range '" + $range + "'");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }
}

