/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.MouseTracker;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005*\u0001\u000f\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bJ\u0012\u0010\u0014\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/ui/MouseTracker;", "", "component", "Ljavax/swing/JComponent;", "<init>", "(Ljavax/swing/JComponent;)V", "moveListeners", "", "Lcom/intellij/ide/ui/MouseTracker$MoveListener;", "value", "Ljava/awt/Point;", "mousePoint", "getMousePoint", "()Ljava/awt/Point;", "mouseListener", "com/intellij/ide/ui/MouseTracker$mouseListener$1", "Lcom/intellij/ide/ui/MouseTracker$mouseListener$1;", "addMoveListener", "", "listener", "updateMousePoint", "point", "MoveListener", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class MouseTracker {
    @NotNull
    private final List<MoveListener> moveListeners;
    @Nullable
    private Point mousePoint;
    @NotNull
    private final mouseListener.1 mouseListener;

    public MouseTracker(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.moveListeners = new ArrayList();
        this.mouseListener = new MouseAdapter(this){
            final /* synthetic */ MouseTracker this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(MouseEvent e) {
                MouseEvent mouseEvent = e;
                MouseTracker.access$updateMousePoint(this.this$0, mouseEvent != null ? mouseEvent.getPoint() : null);
            }

            public void mouseExited(MouseEvent e) {
                MouseTracker.access$updateMousePoint(this.this$0, null);
            }

            public void mouseMoved(MouseEvent e) {
                MouseEvent mouseEvent = e;
                MouseTracker.access$updateMousePoint(this.this$0, mouseEvent != null ? mouseEvent.getPoint() : null);
            }
        };
        component2.addMouseListener(this.mouseListener);
        component2.addMouseMotionListener(this.mouseListener);
    }

    @Nullable
    public final Point getMousePoint() {
        return this.mousePoint;
    }

    public final void addMoveListener(@NotNull MoveListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ((Collection)this.moveListeners).add(listener2);
    }

    private final void updateMousePoint(Point point) {
        if (!Intrinsics.areEqual((Object)point, (Object)this.mousePoint)) {
            Point oldPoint = this.mousePoint;
            this.mousePoint = point;
            for (MoveListener listener2 : this.moveListeners) {
                listener2.changed(oldPoint, this.mousePoint);
            }
        }
    }

    public static final /* synthetic */ void access$updateMousePoint(MouseTracker $this, Point point) {
        $this.updateMousePoint(point);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ide/ui/MouseTracker$MoveListener;", "", "changed", "", "oldMousePoint", "Ljava/awt/Point;", "newMousePoint", "intellij.platform.ide.impl"})
    public static interface MoveListener {
        public void changed(@Nullable Point var1, @Nullable Point var2);
    }
}

