/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.ide.ui.search.IndexedCharsInterner;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchableOptionIndexLoaderKt;
import com.intellij.ide.ui.search.SearchableOptionProcessor;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImplKt;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ResourceUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J>\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J$\u0010\u0017\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001a0\u0018J&\u0010\u001b\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001a0\u0018H\u0002JA\u0010\u001c\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b!R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ide/ui/search/MySearchableOptionProcessor;", "Lcom/intellij/ide/ui/search/SearchableOptionProcessor;", "stopWords", "", "", "<init>", "(Ljava/util/Set;)V", "cache", "Ljava/util/HashSet;", "storage", "", "", "identifierTable", "Lcom/intellij/ide/ui/search/IndexedCharsInterner;", "addOptions", "", "text", "path", "hit", "configurableId", "configurableDisplayName", "applyStemming", "", "computeHighlightOptionToSynonym", "", "Lkotlin/Pair;", "", "loadSynonyms", "putOptionWithHelpId", "words", "", "id", "groupName", "putOptionWithHelpId$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
public final class MySearchableOptionProcessor
extends SearchableOptionProcessor {
    @NotNull
    private final Set<String> stopWords;
    @NotNull
    private final HashSet<String> cache;
    @JvmField
    @NotNull
    public final Map<String, long[]> storage;
    @JvmField
    @NotNull
    public final IndexedCharsInterner identifierTable;

    public MySearchableOptionProcessor(@NotNull Set<String> stopWords) {
        Intrinsics.checkNotNullParameter(stopWords, (String)"stopWords");
        this.stopWords = stopWords;
        this.cache = new HashSet();
        this.storage = new HashMap();
        this.identifierTable = new IndexedCharsInterner();
    }

    public void addOptions(@NotNull String text2, @Nullable String path, @Nullable String hit, @NotNull String configurableId, @Nullable String configurableDisplayName, boolean applyStemming) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)configurableId, (String)"configurableId");
        this.cache.clear();
        if (applyStemming) {
            SearchableOptionsRegistrarImplKt.collectProcessedWords(text2, (Set<String>)this.cache, this.stopWords);
        } else {
            SearchableOptionsRegistrarImplKt.collectProcessedWordsWithoutStemming(text2, (Set<String>)this.cache, this.stopWords);
        }
        this.putOptionWithHelpId$intellij_platform_ide_impl((Iterable<String>)this.cache, configurableId, configurableDisplayName, hit, path);
    }

    @NotNull
    public final Map<Pair<String, String>, Set<String>> computeHighlightOptionToSynonym() {
        SearchableOptionIndexLoaderKt.access$processSearchableOptions(this);
        return this.loadSynonyms();
    }

    private final Map<Pair<String, String>, Set<String>> loadSynonyms() {
        HashMap<Object, Set> result2 = new HashMap<Object, Set>();
        Element root = JDOMUtil.load((InputStream)ResourceUtil.getResourceAsStream((ClassLoader)SearchableOptionsRegistrar.class.getClassLoader(), (String)"search", (String)"synonyms.xml"));
        HashSet cache = new HashSet();
        for (Element configurable : root.getChildren("configurable")) {
            String id2;
            if (configurable.getAttributeValue("id") == null) continue;
            String groupName = configurable.getAttributeValue("configurable_name");
            List synonyms = configurable.getChildren("synonym");
            for (Element synonymElement : synonyms) {
                String synonym;
                if (synonymElement.getTextNormalize() == null) continue;
                cache.clear();
                SearchableOptionsRegistrarImplKt.collectProcessedWords(synonym, cache, this.stopWords);
                this.putOptionWithHelpId$intellij_platform_ide_impl(cache, id2, groupName, synonym, null);
            }
            for (Element optionElement : configurable.getChildren("option")) {
                String option2 = optionElement.getAttributeValue("name");
                List list2 = optionElement.getChildren("synonym");
                for (Element synonymElement : list2) {
                    String synonym;
                    if (synonymElement.getTextNormalize() == null) continue;
                    cache.clear();
                    SearchableOptionsRegistrarImplKt.collectProcessedWords(synonym, cache, this.stopWords);
                    this.putOptionWithHelpId$intellij_platform_ide_impl(cache, id2, groupName, synonym, null);
                    result2.computeIfAbsent(new Pair((Object)option2, (Object)id2), arg_0 -> MySearchableOptionProcessor.loadSynonyms$lambda$1(MySearchableOptionProcessor::loadSynonyms$lambda$0, arg_0)).add(synonym);
                }
            }
        }
        return result2;
    }

    public final void putOptionWithHelpId$intellij_platform_ide_impl(@NotNull Iterable<String> words, @NotNull String id2, @Nullable String groupName, @Nullable String hit, @Nullable String path) {
        Intrinsics.checkNotNullParameter(words, (String)"words");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        for (String word : words) {
            String stopWord;
            if (this.stopWords.contains(word) || (stopWord = PorterStemmerUtil.stem(word)) == null || this.stopWords.contains(stopWord)) continue;
            long[] configs = this.storage.get(word);
            long packed = SearchableOptionsRegistrarImplKt.packSearchableOptions(id2, hit, path, groupName, this.identifierTable);
            if (configs == null) {
                long[] lArray = new long[]{packed};
                this.storage.put(word, lArray);
                continue;
            }
            if (ArraysKt.contains((long[])configs, (long)packed)) continue;
            this.storage.put(word, ArraysKt.plus((long[])configs, (long)packed));
        }
    }

    private static final Set loadSynonyms$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final Set loadSynonyms$lambda$1(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }
}

