/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector;

import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J7\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000b\u0010\u000b\u001a\u00070\u0005\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/inspector/UiInspectorActionUtil;", "", "<init>", "()V", "getActionId", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "collectActionGroupInfo", "", "Lcom/intellij/internal/inspector/PropertyBean;", "prefix", "Lorg/jetbrains/annotations/NonNls;", "group", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "place", "presentationFactory", "Lcom/intellij/openapi/actionSystem/impl/PresentationFactory;", "collectAnActionInfo", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nUiInspectorActionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiInspectorActionUtil.kt\ncom/intellij/internal/inspector/UiInspectorActionUtil\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1172#2:69\n1342#2:70\n1343#2:72\n1173#2:73\n1#3:71\n*S KotlinDebug\n*F\n+ 1 UiInspectorActionUtil.kt\ncom/intellij/internal/inspector/UiInspectorActionUtil\n*L\n31#1:69\n31#1:70\n31#1:72\n31#1:73\n31#1:71\n*E\n"})
public final class UiInspectorActionUtil {
    @NotNull
    public static final UiInspectorActionUtil INSTANCE = new UiInspectorActionUtil();

    private UiInspectorActionUtil() {
    }

    @JvmStatic
    @Nullable
    public static final String getActionId(@NotNull AnAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        return ActionManager.getInstance().getId(ActionUtil.getDelegateChainRootAction((AnAction)action2));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<PropertyBean> collectActionGroupInfo(@NotNull String prefix, @NotNull ActionGroup group2, @Nullable String place, @Nullable PresentationFactory presentationFactory) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        ArrayList<PropertyBean> result2 = new ArrayList<PropertyBean>();
        result2.add(new PropertyBean(prefix + " Place", (Object)place, true));
        result2.addAll((Collection)INSTANCE.collectAnActionInfo((AnAction)group2));
        if (presentationFactory != null) {
            void $this$mapNotNullTo$iv;
            String groupId = UiInspectorActionUtil.getActionId((AnAction)group2);
            Collection<AnAction> collection = presentationFactory.getActions();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getActions(...)");
            Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), UiInspectorActionUtil::collectActionGroupInfo$lambda$0);
            Collection destination$iv = new TreeSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                AnAction it = (AnAction)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (UiInspectorActionUtil.getActionId(it) == null) continue;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            TreeSet ids = (TreeSet)destination$iv;
            if (ids.size() > 1 || ids.size() == 1 && groupId == null) {
                result2.add(new PropertyBean("All " + prefix + " Groups", (Object)CollectionsKt.joinToString$default((Iterable)ids, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), true));
            }
        }
        return result2;
    }

    @NotNull
    public final List<PropertyBean> collectAnActionInfo(@NotNull AnAction action2) {
        ClassLoader classLoader;
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        ArrayList<PropertyBean> result2 = new ArrayList<PropertyBean>();
        Class<?> clazz = action2.getClass();
        boolean isGroup = action2 instanceof ActionGroup;
        String prefix = isGroup ? "Group" : "Action";
        result2.add(new PropertyBean(prefix + " ID", (Object)UiInspectorActionUtil.getActionId(action2), true));
        if (!Intrinsics.areEqual(clazz, DefaultActionGroup.class)) {
            result2.add(new PropertyBean(prefix + " Class", (Object)clazz.getName(), true));
        }
        if ((classLoader = clazz.getClassLoader()) instanceof PluginAwareClassLoader) {
            result2.add(new PropertyBean(prefix + " Plugin ID", (Object)((PluginAwareClassLoader)classLoader).getPluginId().getIdString(), true));
        }
        ActionManager actionManager = ActionManager.getInstance();
        int depth = 1;
        Object obj = action2;
        while (obj instanceof ActionWithDelegate) {
            Object delegate;
            String suffix = " (" + depth + ")";
            Intrinsics.checkNotNullExpressionValue((Object)((ActionWithDelegate)obj).getDelegate(), (String)"getDelegate(...)");
            if (delegate instanceof AnAction) {
                result2.add(new PropertyBean(prefix + " Delegate Class" + suffix, (Object)delegate.getClass().getName(), false, 4, null));
                result2.add(new PropertyBean(prefix + " Delegate ID" + suffix, (Object)actionManager.getId((AnAction)delegate), false, 4, null));
            }
            result2.add(new PropertyBean(prefix + " Delegate toString" + suffix, delegate, false, 4, null));
            obj = delegate;
            ++depth;
        }
        return result2;
    }

    private static final boolean collectActionGroupInfo$lambda$0(AnAction it) {
        return it instanceof ActionGroup;
    }
}

