/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAnnouncingMode;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationsAnnouncerService;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.accessibility.AccessibleAnnouncerUtil;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0001\u001a\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u001a&\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"mode", "Lcom/intellij/notification/NotificationAnnouncingMode;", "getMode", "()Lcom/intellij/notification/NotificationAnnouncingMode;", "isNotificationAnnouncerEnabled", "", "isNotificationAnnouncerFeatureAvailable", "()Z", "doNotify", "", "notification", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "announceComponents", "components", "", "", "caller", "Ljavax/accessibility/Accessible;", "getComponentsToAnnounce", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nNotificationsAnnouncer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationsAnnouncer.kt\ncom/intellij/notification/impl/NotificationsAnnouncerKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,140:1\n42#2,3:141\n13#3:144\n60#3,5:145\n*S KotlinDebug\n*F\n+ 1 NotificationsAnnouncer.kt\ncom/intellij/notification/impl/NotificationsAnnouncerKt\n*L\n85#1:141,3\n91#1:144\n91#1:145,5\n*E\n"})
public final class NotificationsAnnouncerKt {
    private static final NotificationAnnouncingMode getMode() {
        NotificationAnnouncingMode notificationAnnouncingMode = NotificationsConfiguration.getNotificationsConfiguration().getNotificationAnnouncingMode();
        Intrinsics.checkNotNullExpressionValue((Object)notificationAnnouncingMode, (String)"getNotificationAnnouncingMode(...)");
        return notificationAnnouncingMode;
    }

    @ApiStatus.Experimental
    public static final boolean isNotificationAnnouncerEnabled() {
        return AccessibleAnnouncerUtil.isAnnouncingAvailable() && NotificationsAnnouncerKt.getMode() != NotificationAnnouncingMode.NONE;
    }

    public static final boolean isNotificationAnnouncerFeatureAvailable() {
        return Registry.Companion.is("ide.accessibility.announcing.notifications.available", false);
    }

    private static final void doNotify(Notification notification2, Project project2) {
        Container focusedFrame;
        if (!NotificationsAnnouncerKt.isNotificationAnnouncerEnabled()) {
            return;
        }
        EDT.assertIsEdt();
        WindowManager windowManager = WindowManager.getInstance();
        Project project3 = project2;
        JFrame jFrame = project3 == null ? windowManager.findVisibleFrame() : windowManager.getFrame(project3);
        if (jFrame == null) {
            return;
        }
        JFrame frame = jFrame;
        for (focusedFrame = (Container)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(); focusedFrame != null && frame != focusedFrame; focusedFrame = focusedFrame.getParent()) {
        }
        if (focusedFrame == null) {
            return;
        }
        if (NotificationsConfigurationImpl.getSettings(notification2.getGroupId()).getDisplayType() == NotificationDisplayType.NONE) {
            return;
        }
        boolean $i$f$service = false;
        Class<NotificationsAnnouncerService> serviceClass$iv = NotificationsAnnouncerService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Accessible accessible = ((NotificationsAnnouncerService)object).findCaller(frame);
        if (accessible == null) {
            return;
        }
        Accessible caller = accessible;
        NotificationsAnnouncerKt.announceComponents(NotificationsAnnouncerKt.getComponentsToAnnounce(notification2), caller, NotificationsAnnouncerKt.getMode());
    }

    /*
     * WARNING - void declaration
     */
    private static final void announceComponents(List<String> components, Accessible caller, NotificationAnnouncingMode mode) {
        void $this$debug_u24default$iv;
        String text2 = CollectionsKt.joinToString$default((Iterable)components, (CharSequence)". ", null, null, (int)0, null, null, (int)62, null);
        boolean $i$f$logger22 = false;
        Logger logger = Logger.getInstance(NotificationsAnnouncerService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger $i$f$logger22 = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            void var8_8 = $this$debug_u24default$iv;
            boolean bl = false;
            var8_8.debug("Notification will be announced with mode=" + mode + ", from caller=" + caller + ", text=" + text2, t$iv);
        }
        AccessibleAnnouncerUtil.announce((Accessible)caller, (String)text2, (mode == NotificationAnnouncingMode.HIGH ? 1 : 0) != 0);
    }

    private static final List<String> getComponentsToAnnounce(Notification notification2) {
        String subtitle;
        CharSequence charSequence;
        List components = new ArrayList();
        String string = IdeBundle.message((String)"notification.accessible.announce.prefix", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        components.add(string);
        String string2 = notification2.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTitle(...)");
        if (((CharSequence)string2).length() > 0) {
            String string3 = notification2.getTitle();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getTitle(...)");
            components.add(string3);
        }
        if (!((charSequence = (CharSequence)(subtitle = notification2.getSubtitle())) == null || charSequence.length() == 0)) {
            components.add(subtitle);
        }
        String string4 = notification2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getContent(...)");
        if (((CharSequence)string4).length() > 0) {
            String string5 = StringUtil.removeHtmlTags((String)notification2.getContent());
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"removeHtmlTags(...)");
            components.add(string5);
        }
        return components;
    }

    public static final /* synthetic */ void access$doNotify(Notification notification2, Project project2) {
        NotificationsAnnouncerKt.doNotify(notification2, project2);
    }
}

