/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl.segmentedActionBar;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.segmentedActionBar.MyLayoutStrategy;
import com.intellij.openapi.actionSystem.impl.segmentedActionBar.SegmentedBarPainter;
import com.intellij.openapi.actionSystem.impl.segmentedActionBar.ToolbarActionsUpdatedListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000e\b\u0017\u0018\u0000 42\u00020\u0001:\u00014B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u001e\u0010\u001a\u001a\u00020\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001c\u001a\u00020\u0007H\u0014J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\rH\u0014J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0016J \u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J\b\u0010)\u001a\u00020\u0007H\u0014J\b\u0010*\u001a\u00020\u0011H\u0004J\u001e\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00072\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\u001e\u00100\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00072\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J2\u00101\u001a\u00020\u00112\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/openapi/actionSystem/impl/segmentedActionBar/SegmentedActionToolbarComponent;", "Lcom/intellij/openapi/actionSystem/impl/ActionToolbarImpl;", "place", "", "group", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "paintBorderForSingleItem", "", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/actionSystem/ActionGroup;Z)V", "isActive", "visibleActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "getInsets", "Ljava/awt/Insets;", "setBorder", "", "border", "Ljavax/swing/border/Border;", "createCustomComponent", "Ljavax/swing/JComponent;", "action", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "fillToolBar", "actions", "layoutSecondaries", "isSuitableAction", "paintComponent", "g", "Ljava/awt/Graphics;", "paintActiveBorder", "paintBorder", "paint", "addMetadata", "component", "index", "", "count", "logNeeded", "forceUpdate", "actionsUpdated", "forced", "newVisibleActions", "lastIds", "lastActions", "update", "traceState", "filteredIds", "ides", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSegmentedActionToolbarComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentedActionToolbarComponent.kt\ncom/intellij/openapi/actionSystem/impl/segmentedActionBar/SegmentedActionToolbarComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n777#2:227\n873#2,2:228\n1586#2:230\n1661#2,3:231\n1586#2:234\n1661#2,3:235\n*S KotlinDebug\n*F\n+ 1 SegmentedActionToolbarComponent.kt\ncom/intellij/openapi/actionSystem/impl/segmentedActionBar/SegmentedActionToolbarComponent\n*L\n183#1:227\n183#1:228,2\n186#1:230\n186#1:231,3\n187#1:234\n187#1:235,3\n*E\n"})
public class SegmentedActionToolbarComponent
extends ActionToolbarImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean paintBorderForSingleItem;
    private boolean isActive;
    @Nullable
    private List<? extends AnAction> visibleActions;
    @NotNull
    private List<String> lastIds;
    @NotNull
    private List<? extends AnAction> lastActions;
    @NotNull
    public static final String CONTROL_BAR_PROPERTY = "CONTROL_BAR_PROPERTY";
    @NotNull
    public static final String CONTROL_BAR_FIRST = "CONTROL_BAR_PROPERTY_FIRST";
    @NotNull
    public static final String CONTROL_BAR_LAST = "CONTROL_BAR_PROPERTY_LAST";
    @NotNull
    public static final String CONTROL_BAR_MIDDLE = "CONTROL_BAR_PROPERTY_MIDDLE";
    @NotNull
    public static final String CONTROL_BAR_SINGLE = "CONTROL_BAR_PROPERTY_SINGLE";
    @NotNull
    public static final String RUN_TOOLBAR_COMPONENT_ACTION = "RUN_TOOLBAR_COMPONENT_ACTION";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ActionButtonLook segmentedButtonLook;

    public SegmentedActionToolbarComponent(@NotNull String place, @NotNull ActionGroup group2, boolean paintBorderForSingleItem) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        super(place, group2, true, false, false, 24, null);
        this.paintBorderForSingleItem = paintBorderForSingleItem;
        this.setLayoutStrategy(new MyLayoutStrategy());
        this.setActionButtonBorder((Border)JBUI.Borders.empty((int)0, (int)3));
        this.setCustomButtonLook(segmentedButtonLook);
        this.lastIds = CollectionsKt.emptyList();
        this.lastActions = CollectionsKt.emptyList();
    }

    public /* synthetic */ SegmentedActionToolbarComponent(String string, ActionGroup actionGroup, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(string, actionGroup, bl);
    }

    @Override
    @NotNull
    public Insets getInsets() {
        JBInsets jBInsets = JBInsets.emptyInsets();
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
        return (Insets)jBInsets;
    }

    @Override
    public void setBorder(@Nullable Border border) {
    }

    @Override
    @NotNull
    protected JComponent createCustomComponent(@NotNull CustomComponentAction action2, @NotNull Presentation presentation2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        JComponent component2 = null;
        component2 = super.createCustomComponent(action2, presentation2);
        if (!this.isActive) {
            return component2;
        }
        if (action2 instanceof ComboBoxAction) {
            JBIterable jBIterable = UIUtil.uiTraverser((Component)component2).filter(ComboBoxAction.ComboBoxButton.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            ComboBoxAction.ComboBoxButton comboBoxButton = (ComboBoxAction.ComboBoxButton)CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable));
            if (comboBoxButton != null) {
                ComboBoxAction.ComboBoxButton it = comboBoxButton;
                boolean bl = false;
                component2.remove((Component)it);
                component2 = it;
            }
        }
        if (!(component2 instanceof ActionButton)) {
            component2.setBorder((Border)JBUI.Borders.empty());
        }
        return component2;
    }

    @Override
    protected void fillToolBar(@NotNull List<? extends AnAction> actions, boolean layoutSecondaries) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        if (!this.isActive) {
            super.fillToolBar(actions, layoutSecondaries);
            return;
        }
        List rightAligned = new ArrayList();
        int n = ((Collection)actions).size();
        for (int i2 = 0; i2 < n; ++i2) {
            AnAction action2 = actions.get(i2);
            if (action2 instanceof RightAlignedToolbarAction) {
                rightAligned.add(action2);
                continue;
            }
            JComponent component2 = this.getOrCreateActionComponent(action2);
            String constraints = component2 instanceof ActionButton ? "Constraint.ActionButton" : "Constraint.CustomComponent";
            this.addMetadata(component2, i2, actions.size());
            this.add(constraints, component2);
            component2.putClientProperty(RUN_TOOLBAR_COMPONENT_ACTION, action2);
        }
    }

    protected boolean isSuitableAction(@NotNull AnAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        return true;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        this.paintActiveBorder(g);
    }

    private final void paintActiveBorder(Graphics g) {
        if ((this.isActive || this.paintBorderForSingleItem) && this.visibleActions != null) {
            SegmentedBarPainter.Companion.paintActionBarBorder(this, g);
        }
    }

    @Override
    protected void paintBorder(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintBorder(g);
        this.paintActiveBorder(g);
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paint(g);
        this.paintActiveBorder(g);
    }

    private final void addMetadata(JComponent component2, int index, int count) {
        if (count == 1) {
            component2.putClientProperty(CONTROL_BAR_PROPERTY, CONTROL_BAR_SINGLE);
            return;
        }
        int n = index;
        String property = n == 0 ? CONTROL_BAR_FIRST : (n == count - 1 ? CONTROL_BAR_LAST : CONTROL_BAR_MIDDLE);
        component2.putClientProperty(CONTROL_BAR_PROPERTY, property);
    }

    protected boolean logNeeded() {
        return false;
    }

    protected final void forceUpdate() {
        block1: {
            if (this.logNeeded()) {
                LOG.info("RunToolbar MAIN SLOT forceUpdate");
            }
            List<? extends AnAction> list2 = this.visibleActions;
            if (list2 == null) break block1;
            List<? extends AnAction> it = list2;
            boolean bl = false;
            this.update(true, it);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    protected void actionsUpdated(boolean forced, @NotNull List<? extends AnAction> newVisibleActions) {
        Intrinsics.checkNotNullParameter(newVisibleActions, (String)"newVisibleActions");
        this.visibleActions = newVisibleActions;
        this.update(forced, newVisibleActions);
    }

    /*
     * WARNING - void declaration
     */
    private final void update(boolean forced, List<? extends AnAction> newVisibleActions) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = newVisibleActions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AnAction it = (AnAction)element$iv$iv;
            boolean bl = false;
            if (!this.isSuitableAction(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List<? extends AnAction> filtered = (List<? extends AnAction>)destination$iv$iv;
        ActionManager actionManager = ActionManager.getInstance();
        Iterable $this$map$iv = newVisibleActions;
        boolean $i$f$map = false;
        Iterable $i$f$filterTo22 = $this$map$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            AnAction anAction = (AnAction)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            String string = actionManager.getId((AnAction)it);
            Intrinsics.checkNotNull((Object)string);
            collection.add(string);
        }
        List ides = (List)destination$iv$iv2;
        Iterable $this$map$iv2 = filtered;
        boolean $i$f$map2 = false;
        destination$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AnAction bl = (AnAction)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl2 = false;
            String string = actionManager.getId((AnAction)it);
            Intrinsics.checkNotNull((Object)string);
            collection.add(string);
        }
        List filteredIds = (List)destination$iv$iv3;
        this.traceState(this.lastIds, filteredIds, ides);
        boolean bl = this.isActive = newVisibleActions.size() > 1;
        super.actionsUpdated(forced, filtered.size() > 1 ? filtered : (this.lastActions.isEmpty() ? newVisibleActions : this.lastActions));
        this.lastIds = filteredIds;
        this.lastActions = filtered;
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic<ToolbarActionsUpdatedListener> topic = ToolbarActionsUpdatedListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((ToolbarActionsUpdatedListener)messageBus.syncPublisher(topic)).actionsUpdated();
    }

    protected void traceState(@NotNull List<String> lastIds, @NotNull List<String> filteredIds, @NotNull List<String> ides) {
        Intrinsics.checkNotNullParameter(lastIds, (String)"lastIds");
        Intrinsics.checkNotNullParameter(filteredIds, (String)"filteredIds");
        Intrinsics.checkNotNullParameter(ides, (String)"ides");
    }

    static {
        Logger logger = Logger.getInstance(SegmentedActionToolbarComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        segmentedButtonLook = new ActionButtonLook(){

            public void paintBorder(Graphics g, JComponent c, int state2) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            }

            public void paintBackground(Graphics g, JComponent component2, int state2) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                SegmentedBarPainter.Companion.paintActionButtonBackground(g, component2, state2);
            }
        };
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/actionSystem/impl/segmentedActionBar/SegmentedActionToolbarComponent$Companion;", "", "<init>", "()V", "CONTROL_BAR_PROPERTY", "", "CONTROL_BAR_FIRST", "CONTROL_BAR_LAST", "CONTROL_BAR_MIDDLE", "CONTROL_BAR_SINGLE", "RUN_TOOLBAR_COMPONENT_ACTION", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "segmentedButtonLook", "Lcom/intellij/openapi/actionSystem/ex/ActionButtonLook;", "getSegmentedButtonLook", "()Lcom/intellij/openapi/actionSystem/ex/ActionButtonLook;", "isCustomBar", "", "component", "Ljava/awt/Component;", "paintButtonDecorations", "g", "Ljava/awt/Graphics2D;", "c", "Ljavax/swing/JComponent;", "paint", "Ljava/awt/Paint;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActionButtonLook getSegmentedButtonLook() {
            return segmentedButtonLook;
        }

        public final boolean isCustomBar(@NotNull Component component2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            if (!(component2 instanceof JComponent)) {
                return false;
            }
            Object object = ((JComponent)component2).getClientProperty(SegmentedActionToolbarComponent.CONTROL_BAR_PROPERTY);
            if (object != null) {
                Object it = object;
                boolean bl2 = false;
                bl = !Intrinsics.areEqual((Object)it, (Object)SegmentedActionToolbarComponent.CONTROL_BAR_SINGLE);
            } else {
                bl = false;
            }
            return bl;
        }

        public final boolean paintButtonDecorations(@NotNull Graphics2D g, @NotNull JComponent c, @NotNull Paint paint) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            return SegmentedBarPainter.Companion.paintButtonDecorations(g, c, paint);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

