/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.client;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAwareComponentManagerKt;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.client.ClientSessionImpl;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.client.ClientType;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.serviceContainer.ContainerUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001B\u0011\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\u0007J'\u0010\b\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0016\u00a2\u0006\u0002\u0010\rJ.\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\t0\u000f\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J/\u0010\u0012\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a2\u0006\u0002\u0010\u0015J0\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0010\u0010\u001c\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u001e\u0018\u00010\u001dJ\u001c\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000fJ.\u0010$\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0014H\u0004J\u000e\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\n\u00a8\u0006+"}, d2={"Lcom/intellij/openapi/client/ClientAwareComponentManager;", "Lcom/intellij/serviceContainer/ComponentManagerImpl;", "parent", "<init>", "(Lcom/intellij/serviceContainer/ComponentManagerImpl;)V", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "getServiceForClient", "T", "", "serviceClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "getServices", "", "clientKind", "Lcom/intellij/openapi/client/ClientKind;", "postGetService", "createIfNeeded", "", "(Ljava/lang/Class;Z)Ljava/lang/Object;", "registerComponents", "", "modules", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "app", "Lcom/intellij/openapi/application/Application;", "listenerCallbacks", "", "Ljava/lang/Runnable;", "unloadServices", "module", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "services", "Lcom/intellij/openapi/components/ServiceDescriptor;", "postPreloadServices", "activityPrefix", "", "syncScope", "onlyIfAwait", "isPreInitialized", "service", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nClientAwareComponentManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientAwareComponentManager.kt\ncom/intellij/openapi/client/ClientAwareComponentManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1642#2,10:105\n1915#2:115\n1916#2:117\n1652#2:118\n1#3:116\n*S KotlinDebug\n*F\n+ 1 ClientAwareComponentManager.kt\ncom/intellij/openapi/client/ClientAwareComponentManager\n*L\n29#1:105,10\n29#1:115\n29#1:117\n29#1:118\n29#1:116\n*E\n"})
public abstract class ClientAwareComponentManager
extends ComponentManagerImpl {
    protected ClientAwareComponentManager(@NotNull ComponentManagerImpl parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(parent);
    }

    protected ClientAwareComponentManager(@NotNull CoroutineScope parentScope) {
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        super(parentScope);
    }

    @Nullable
    public <T> T getServiceForClient(@NotNull Class<T> serviceClass) {
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        return this.postGetService(serviceClass, true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T> List<T> getServices(@NotNull Class<T> serviceClass, @NotNull ClientKind clientKind) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        Intrinsics.checkNotNullParameter((Object)clientKind, (String)"clientKind");
        Object object = super.getService(ClientSessionsManager.class);
        Intrinsics.checkNotNull((Object)object);
        ClientSessionsManager sessionsManager = (ClientSessionsManager)object;
        Iterable $this$mapNotNull$iv = ClientSessionsManager.getSessions$default((ClientSessionsManager)sessionsManager, (ClientKind)clientKind, (boolean)false, (int)2, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ClientSession it = (ClientSession)element$iv$iv;
            boolean bl2 = false;
            ClientSessionImpl clientSessionImpl = it instanceof ClientSessionImpl ? (ClientSessionImpl)it : null;
            if ((clientSessionImpl != null ? (Object)clientSessionImpl.doGetService(serviceClass, true, false) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    protected <T> T postGetService(@NotNull Class<T> serviceClass, boolean createIfNeeded) {
        Object service;
        ClientSessionImpl session;
        ClientSession clientSession;
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        ClientSessionsManager sessionManager = null;
        if (this.containerState.get() == ComponentManagerImpl.ContainerState.DISPOSE_COMPLETED) {
            if (createIfNeeded) {
                String string = serviceClass.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                ContainerUtilKt.throwAlreadyDisposedError((String)string, (ComponentManagerImpl)this);
            }
            sessionManager = (ClientSessionsManager)super.doGetService(ClientSessionsManager.class, false);
        } else {
            sessionManager = (ClientSessionsManager)super.doGetService(ClientSessionsManager.class, true);
        }
        ClientId clientId = ClientId.Companion.getCurrentOrNull();
        ClientSessionsManager clientSessionsManager = sessionManager;
        if (clientSessionsManager != null) {
            ClientId clientId2 = clientId;
            if (clientId2 == null) {
                clientId2 = ClientId.Companion.getLocalId();
            }
            clientSession = clientSessionsManager.getSession(clientId2);
        } else {
            clientSession = null;
        }
        ClientSession clientSession2 = clientSession;
        ClientSessionImpl clientSessionImpl = session = clientSession2 instanceof ClientSessionImpl ? (ClientSessionImpl)clientSession2 : null;
        Object object = service = clientSessionImpl != null ? (Object)clientSessionImpl.doGetService(serviceClass, createIfNeeded, false) : null;
        if (clientId == null && service != null && ClientId.Companion.getAbsenceBehaviorValue() == ClientId.AbsenceBehavior.LOG_ERROR) {
            ClientAwareComponentManagerKt.access$getLogger$p().error("Requested existing per-client service '" + service.getClass().getName() + "' under missing ClientId. Host implementation will be returned, but calling code has to be fixed: either set/promote ClientId or mark the service as non per-client");
        }
        if (service == null) {
            ClientSessionImpl clientSessionImpl2 = session;
            if ((clientSessionImpl2 != null ? clientSessionImpl2.getType() : null) == ClientType.FRONTEND) {
                ClientSession clientSession3 = sessionManager.getSession(ClientId.Companion.getLocalId());
                ClientSessionImpl clientSessionImpl3 = clientSession3 instanceof ClientSessionImpl ? (ClientSessionImpl)clientSession3 : null;
                if (clientSessionImpl3 == null) {
                    return null;
                }
                ClientSessionImpl localSession = clientSessionImpl3;
                return localSession.doGetService(serviceClass, createIfNeeded, false);
            }
        }
        return (T)service;
    }

    public final void registerComponents(@NotNull List<? extends IdeaPluginDescriptorImpl> modules, @Nullable Application app, @Nullable List<? super Runnable> listenerCallbacks) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        super.registerComponents(modules, app, listenerCallbacks);
        Object object = super.getService(ClientSessionsManager.class);
        Intrinsics.checkNotNull((Object)object);
        ClientSessionsManager sessionsManager = (ClientSessionsManager)object;
        for (ClientSession session : ClientSessionsManager.getSessions$default((ClientSessionsManager)sessionsManager, (ClientKind)ClientKind.ALL, (boolean)false, (int)2, null)) {
            ClientSessionImpl clientSessionImpl = session instanceof ClientSessionImpl ? (ClientSessionImpl)session : null;
            if (clientSessionImpl == null) continue;
            clientSessionImpl.registerComponents(modules, app, listenerCallbacks);
        }
    }

    public final void unloadServices(@NotNull IdeaPluginDescriptor module, @NotNull List<ServiceDescriptor> services) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(services, (String)"services");
        super.unloadServices(module, services);
        Object object = super.getService(ClientSessionsManager.class);
        Intrinsics.checkNotNull((Object)object);
        ClientSessionsManager sessionsManager = (ClientSessionsManager)object;
        for (ClientSession session : ClientSessionsManager.getSessions$default((ClientSessionsManager)sessionsManager, (ClientKind)ClientKind.ALL, (boolean)false, (int)2, null)) {
            ClientSessionImpl clientSessionImpl = session instanceof ClientSessionImpl ? (ClientSessionImpl)session : null;
            if (clientSessionImpl == null) continue;
            clientSessionImpl.unloadServices(module, services);
        }
    }

    protected final void postPreloadServices(@NotNull List<? extends IdeaPluginDescriptorImpl> modules, @NotNull String activityPrefix, @NotNull CoroutineScope syncScope, boolean onlyIfAwait) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter((Object)activityPrefix, (String)"activityPrefix");
        Intrinsics.checkNotNullParameter((Object)syncScope, (String)"syncScope");
        Object object = super.getService(ClientSessionsManager.class);
        Intrinsics.checkNotNull((Object)object);
        ClientSessionsManager sessionsManager = (ClientSessionsManager)object;
        for (ClientSession session : ClientSessionsManager.getSessions$default((ClientSessionsManager)sessionsManager, (ClientKind)ClientKind.ALL, (boolean)false, (int)2, null)) {
            if ((session instanceof ClientSessionImpl ? (ClientSessionImpl)session : null) == null) continue;
            ((ClientSessionImpl)session).preloadServices(modules, activityPrefix, syncScope, onlyIfAwait, this.getCoroutineScope());
        }
    }

    public final boolean isPreInitialized(@NotNull Object service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        return super.isPreInitialized(service) || service instanceof ClientSessionsManager;
    }
}

