/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.MovementAvailability;
import com.intellij.openapi.command.impl.SharedAdjustableUndoableActionsHolder;
import com.intellij.openapi.command.impl.UndoRedoList;
import com.intellij.openapi.command.impl.UndoRedoStacksHolderBase;
import com.intellij.openapi.command.undo.ActionChangeRange;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.ImmutableActionChangeRange;
import com.intellij.openapi.command.undo.MutableActionChangeRange;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class SharedUndoRedoStacksHolder
extends UndoRedoStacksHolderBase<ImmutableActionChangeRange> {
    private final SharedAdjustableUndoableActionsHolder myAdjustableUndoableActionsHolder;
    final Supplier<Boolean> myIsPerClientSupported;

    SharedUndoRedoStacksHolder(@NotNull SharedAdjustableUndoableActionsHolder undoableActionsHolder, @NotNull Supplier<Boolean> isPerClientSupported, boolean isUndo) {
        if (undoableActionsHolder == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(0);
        }
        if (isPerClientSupported == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(1);
        }
        super(isUndo);
        this.myAdjustableUndoableActionsHolder = undoableActionsHolder;
        this.myIsPerClientSupported = isPerClientSupported;
    }

    void addToStack(@NotNull DocumentReference reference, @NotNull ImmutableActionChangeRange changeRange) {
        if (reference == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(2);
        }
        if (changeRange == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(3);
        }
        UndoRedoList stack = (UndoRedoList)this.getStack(reference);
        this.trimInvalid(stack);
        if (!this.isValid(changeRange).booleanValue()) {
            if (stack.isEmpty()) {
                return;
            }
            ImmutableActionChangeRange lastRange = (ImmutableActionChangeRange)stack.getLast();
            if (!this.isValid(changeRange).booleanValue() && SharedUndoRedoStacksHolder.isRolledBackBy(lastRange, changeRange)) {
                stack.removeLast();
                return;
            }
        }
        stack.add(changeRange);
    }

    private static boolean isRolledBackBy(@NotNull ImmutableActionChangeRange lastRange, @NotNull ImmutableActionChangeRange newRange) {
        if (lastRange == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(4);
        }
        if (newRange == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(5);
        }
        if (lastRange.isSymmetricTo(newRange)) {
            if (lastRange.getOldLength() == 0) {
                return true;
            }
            if (lastRange.hasTheSameOrigin(newRange)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    ImmutableActionChangeRange removeLastFromStack(@NotNull DocumentReference reference) {
        UndoRedoList stack;
        if (reference == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(6);
        }
        if ((stack = (UndoRedoList)this.getStack(reference)).isEmpty()) {
            throw new IllegalStateException("Cannot pop from empty stack");
        }
        ImmutableActionChangeRange last = (ImmutableActionChangeRange)stack.removeLast();
        this.trimInvalid(stack);
        ImmutableActionChangeRange immutableActionChangeRange = last;
        if (immutableActionChangeRange == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(7);
        }
        return immutableActionChangeRange;
    }

    @NotNull
    MovementAvailability canMoveToStackTop(@NotNull DocumentReference reference, @NotNull Map<Integer, MutableActionChangeRange> rangesToMove) {
        if (reference == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(8);
        }
        if (rangesToMove == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(9);
        }
        if (!this.myIsPerClientSupported.get().booleanValue()) {
            MovementAvailability movementAvailability = MovementAvailability.ALREADY_MOVED;
            if (movementAvailability == null) {
                SharedUndoRedoStacksHolder.$$$reportNull$$$0(10);
            }
            return movementAvailability;
        }
        UndoRedoList stack = (UndoRedoList)this.getStack(reference);
        ImmutableActionChangeRange[] affected = SharedUndoRedoStacksHolder.getAffectedRanges(stack, rangesToMove);
        if (affected == null) {
            MovementAvailability movementAvailability = MovementAvailability.ALREADY_MOVED;
            if (movementAvailability == null) {
                SharedUndoRedoStacksHolder.$$$reportNull$$$0(11);
            }
            return movementAvailability;
        }
        MovementAvailability movementAvailability = SharedUndoRedoStacksHolder.moveToEnd(affected, rangesToMove.keySet()) ? MovementAvailability.CAN_MOVE : MovementAvailability.CANNOT_MOVE;
        if (movementAvailability == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(12);
        }
        return movementAvailability;
    }

    ImmutableActionChangeRange[] moveToStackTop(@NotNull DocumentReference reference, @NotNull Map<Integer, ? extends ActionChangeRange> rangesToMove) {
        UndoRedoList stack;
        ImmutableActionChangeRange[] affected;
        if (reference == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(13);
        }
        if (rangesToMove == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(14);
        }
        if ((affected = SharedUndoRedoStacksHolder.getAffectedRanges(stack = (UndoRedoList)this.getStack(reference), rangesToMove)) == null) {
            return null;
        }
        if (!SharedUndoRedoStacksHolder.moveToEnd(affected, rangesToMove.keySet())) {
            throw new IllegalStateException("Cannot move to top: " + String.valueOf(rangesToMove));
        }
        for (int i2 = 0; i2 < affected.length; ++i2) {
            stack.removeLast();
        }
        stack.addAll(Arrays.asList(affected));
        this.trimInvalid(stack);
        return affected;
    }

    private static ImmutableActionChangeRange @Nullable [] getAffectedRanges(@NotNull UndoRedoList<? extends ImmutableActionChangeRange> stack, @NotNull Map<Integer, ? extends ActionChangeRange> rangesToMove) {
        if (stack == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(15);
        }
        if (rangesToMove == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(16);
        }
        HashMap<Integer, ? extends ActionChangeRange> notSeenRanges = new HashMap<Integer, ActionChangeRange>(rangesToMove);
        ListIterator<? extends ImmutableActionChangeRange> iterator = stack.listIterator(stack.size());
        int affectedRangeCount = 0;
        boolean changed = false;
        while (iterator.hasPrevious()) {
            ++affectedRangeCount;
            ImmutableActionChangeRange changeRange = iterator.previous();
            ActionChangeRange removed = (ActionChangeRange)notSeenRanges.remove(changeRange.getId());
            if (removed != null && removed.getTimestamp() != changeRange.getTimestamp()) {
                changed = true;
            }
            if (!notSeenRanges.isEmpty()) continue;
            break;
        }
        if (!notSeenRanges.isEmpty()) {
            throw new IllegalArgumentException("Stack doesn't contain these ranges: " + String.valueOf(notSeenRanges));
        }
        if (affectedRangeCount == rangesToMove.size() && !changed) {
            return null;
        }
        ImmutableActionChangeRange[] affected = new ImmutableActionChangeRange[affectedRangeCount];
        for (int i2 = 0; i2 < affectedRangeCount; ++i2) {
            affected[i2] = iterator.next();
        }
        return affected;
    }

    private static boolean moveToEnd(ImmutableActionChangeRange @NotNull [] ranges, @NotNull Set<Integer> rangesToMove) {
        if (rangesToMove == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(17);
        }
        if (ranges == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(18);
        }
        for (int pass = 0; pass < rangesToMove.size(); ++pass) {
            int destinationIndex;
            int currentIndex;
            for (currentIndex = destinationIndex = ranges.length - pass - 1; currentIndex >= 0 && !rangesToMove.contains(ranges[currentIndex].getId()); --currentIndex) {
            }
            if (currentIndex < 0) {
                throw new IllegalArgumentException("Array doesn't contain specified ranges");
            }
            while (currentIndex < destinationIndex) {
                if (!SharedUndoRedoStacksHolder.swap(ranges, currentIndex)) {
                    return false;
                }
                ++currentIndex;
            }
        }
        return true;
    }

    private static boolean swap(ImmutableActionChangeRange @NotNull [] ranges, int i2) {
        ImmutableActionChangeRange second;
        ImmutableActionChangeRange first;
        ImmutableActionChangeRange firstMoved;
        if (ranges == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(19);
        }
        if ((firstMoved = (first = ranges[i2]).moveAfter(second = ranges[i2 + 1], true)) == null) {
            return false;
        }
        ImmutableActionChangeRange secondMoved = second.moveAfter(firstMoved.asInverted(), false);
        if (secondMoved == null) {
            return false;
        }
        ranges[i2 + 1] = firstMoved;
        ranges[i2] = secondMoved;
        return true;
    }

    void trimStacks(@NotNull Iterable<? extends DocumentReference> references) {
        if (references == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(20);
        }
        for (DocumentReference documentReference : references) {
            this.trimInvalid((List)this.getStack(documentReference));
        }
        this.removeEmptyStacks();
    }

    private void trimInvalid(@NotNull List<ImmutableActionChangeRange> stack) {
        if (stack == null) {
            SharedUndoRedoStacksHolder.$$$reportNull$$$0(21);
        }
        Iterator<ImmutableActionChangeRange> iterator = stack.iterator();
        while (iterator.hasNext()) {
            ImmutableActionChangeRange next = iterator.next();
            if (this.isValid(next).booleanValue()) {
                return;
            }
            iterator.remove();
        }
    }

    private Boolean isValid(ImmutableActionChangeRange range) {
        return this.myAdjustableUndoableActionsHolder.contains(range);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoableActionsHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isPerClientSupported";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastRange";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRange";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/SharedUndoRedoStacksHolder";
                break;
            }
            case 9: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangesToMove";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/SharedUndoRedoStacksHolder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLastFromStack";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "canMoveToStackTop";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addToStack";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isRolledBackBy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeLastFromStack";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canMoveToStackTop";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "moveToStackTop";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedRanges";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "moveToEnd";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "swap";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "trimStacks";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "trimInvalid";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

