/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl.cmd;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.CommandId;
import com.intellij.openapi.command.impl.cmd.CmdHistory;
import com.intellij.openapi.command.impl.cmd.CmdIdGenerator;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\tJ\b\u0010\r\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0012\u0010\u0004\u001a\u00060\u0005R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/command/impl/cmd/CmdIdService;", "", "<init>", "()V", "idGenerator", "Lcom/intellij/openapi/command/impl/cmd/CmdIdService$MyCmdIdGenerator;", "history", "Lcom/intellij/openapi/command/impl/cmd/CmdHistory;", "nextCommandId", "Lcom/intellij/openapi/command/impl/CommandId;", "isTransparent", "", "currentCommandId", "previousCommandId", "register", "", "commandId", "historyDump", "", "createCommandId", "id", "", "createCommandIdImpl", "MyCmdIdGenerator", "Companion", "intellij.platform.ide.impl"})
public class CmdIdService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MyCmdIdGenerator idGenerator = new MyCmdIdGenerator();
    @NotNull
    private final CmdHistory history = new CmdHistory();

    @NotNull
    public final CommandId nextCommandId(boolean isTransparent) {
        CommandId commandId;
        if (isTransparent) {
            CommandId commandId2 = this.idGenerator.nextTransparentId();
            Intrinsics.checkNotNull((Object)commandId2);
            commandId = commandId2;
        } else {
            CommandId commandId3 = this.idGenerator.nextCommandId();
            Intrinsics.checkNotNull((Object)commandId3);
            commandId = commandId3;
        }
        return commandId;
    }

    @Nullable
    public final CommandId currentCommandId() {
        return this.history.getCurrentCommandId();
    }

    @Nullable
    public final CommandId previousCommandId() {
        return this.history.getPreviousCommandId();
    }

    public final void register(@NotNull CommandId commandId) {
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        this.history.add(commandId);
    }

    @NotNull
    public final String historyDump() {
        String string = this.history.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    protected CommandId createCommandId(long id2) {
        CommandId commandId = CommandId.fromLong(id2);
        Intrinsics.checkNotNullExpressionValue((Object)commandId, (String)"fromLong(...)");
        return commandId;
    }

    private final CommandId createCommandIdImpl(long id2) {
        CommandId commandId = this.createCommandId(id2);
        this.register(commandId);
        return commandId;
    }

    @JvmStatic
    @NotNull
    public static final CmdIdService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/command/impl/cmd/CmdIdService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/command/impl/cmd/CmdIdService;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nCmdIdService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CmdIdService.kt\ncom/intellij/openapi/command/impl/cmd/CmdIdService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,61:1\n30#2,2:62\n*S KotlinDebug\n*F\n+ 1 CmdIdService.kt\ncom/intellij/openapi/command/impl/cmd/CmdIdService$Companion\n*L\n57#1:62,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CmdIdService getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNull((Object)application);
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<CmdIdService> serviceClass$iv = CmdIdService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CmdIdService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/command/impl/cmd/CmdIdService$MyCmdIdGenerator;", "Lcom/intellij/openapi/command/impl/cmd/CmdIdGenerator;", "<init>", "(Lcom/intellij/openapi/command/impl/cmd/CmdIdService;)V", "createId", "Lcom/intellij/openapi/command/impl/CommandId;", "commandId", "", "intellij.platform.ide.impl"})
    private final class MyCmdIdGenerator
    extends CmdIdGenerator {
        @Override
        @NotNull
        protected CommandId createId(long commandId) {
            return CmdIdService.this.createCommandIdImpl(commandId);
        }
    }
}

