/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.CloneCaretActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PageDownWithSelectionAction
extends EditorAction
implements ActionRemoteBehaviorSpecification.Frontend {
    public PageDownWithSelectionAction() {
        super((EditorActionHandler)new Handler());
    }

    public static final class Handler
    extends EditorActionHandler {
        public void doExecute(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (!editor2.getCaretModel().supportsMultipleCarets()) {
                EditorActionUtil.moveCaretPageDown(editor2, true);
                return;
            }
            if (editor2.isColumnMode()) {
                int lines = editor2.getScrollingModel().getVisibleArea().height / editor2.getLineHeight();
                CloneCaretActionHandler handler = new CloneCaretActionHandler(false);
                for (int i2 = 0; i2 < lines; ++i2) {
                    handler.execute(editor2, caret, dataContext2);
                    handler.setRepeatedInvocation(true);
                }
            } else if (caret == null) {
                editor2.getCaretModel().runForEachCaret(__ -> EditorActionUtil.moveCaretPageDown(editor2, true));
            } else {
                EditorActionUtil.moveCaretPageDown(editor2, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/PageDownWithSelectionAction$Handler", "doExecute"));
        }
    }
}

