/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.CustomFoldRegionImpl;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorLocation;
import com.intellij.openapi.editor.impl.FoldRegionImpl;
import com.intellij.openapi.editor.impl.FoldRegionsTree;
import com.intellij.openapi.editor.impl.FoldingKeys;
import com.intellij.openapi.editor.impl.FoldingModelInternal;
import com.intellij.openapi.editor.impl.HardReferencingRangeMarkerTree;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.DocumentEventUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IntPair;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.MultiMap;
import java.awt.Point;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class FoldingModelImpl
extends InlayModel.SimpleAdapter
implements FoldingModelEx,
FoldingModelInternal,
PrioritizedDocumentListener,
Dumpable,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance(FoldingModelImpl.class);
    private static final Key<SavedCaretPosition> SAVED_CARET_POSITION = Key.create((String)"saved.position.before.folding");
    private static final Key<Boolean> MARK_FOR_UPDATE = Key.create((String)"marked.for.position.update");
    private static final Key<Boolean> DO_NOT_NOTIFY = Key.create((String)"do.not.notify.on.region.disposal");
    private static final HashingStrategy<FoldRegion> OFFSET_BASED_HASHING_STRATEGY = new FoldRegionHashingStrategy();
    private final EditorImpl myEditor;
    private final RangeMarkerTree<FoldRegionImpl> myRegionTree;
    private final FoldRegionsTree myFoldTree;
    private final MultiMap<FoldingGroup, FoldRegion> myGroups;
    private final AtomicLong myExpansionCounter;
    private final EditorScrollingPositionKeeper myScrollingPositionKeeper;
    private final List<FoldingListener> myListeners;
    private final Set<CustomFoldRegionImpl> myAffectedCustomRegions;
    private TextAttributes myFoldTextAttributes;
    private boolean myIsFoldingEnabled;
    private boolean myIsBatchFoldingProcessing;
    private boolean myDoNotCollapseCaret;
    private boolean myFoldRegionsProcessed;
    private boolean myDocumentChangeProcessed;
    private boolean myRegionWidthChanged;
    private boolean myRegionHeightChanged;
    private boolean myGutterRendererChanged;
    private boolean myIsRepaintRequested;
    private boolean myIsComplexDocumentChange;

    @ApiStatus.Internal
    public static void hideGutterRendererForCollapsedRegion(@NotNull FoldRegion region) {
        if (region == null) {
            FoldingModelImpl.$$$reportNull$$$0(0);
        }
        region.putUserData(FoldingKeys.HIDE_GUTTER_RENDERER_FOR_COLLAPSED, (Object)Boolean.TRUE);
    }

    FoldingModelImpl(@NotNull EditorImpl editor2) {
        if (editor2 == null) {
            FoldingModelImpl.$$$reportNull$$$0(1);
        }
        this.myGroups = new MultiMap();
        this.myExpansionCounter = new AtomicLong();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myAffectedCustomRegions = new HashSet<CustomFoldRegionImpl>();
        this.myIsFoldingEnabled = true;
        this.myDocumentChangeProcessed = true;
        this.myEditor = editor2;
        this.myRegionTree = new MyMarkerTree((Document)editor2.getDocument());
        this.myFoldTree = new MyFoldRegionsTree(this.myRegionTree);
        this.myScrollingPositionKeeper = new EditorScrollingPositionKeeper(editor2);
        Disposer.register((Disposable)editor2.getDisposable(), (Disposable)this.myScrollingPositionKeeper);
        this.updateTextAttributes();
    }

    public FoldRegion addFoldRegion(int startOffset, int endOffset, @NotNull String placeholderText) {
        if (placeholderText == null) {
            FoldingModelImpl.$$$reportNull$$$0(2);
        }
        return this.createFoldRegion(startOffset, endOffset, placeholderText, null, false);
    }

    @Override
    @Nullable
    public FoldRegion createFoldRegion(int startOffset, int endOffset, @NotNull String placeholder, @Nullable FoldingGroup group2, boolean neverExpands) {
        if (placeholder == null) {
            FoldingModelImpl.$$$reportNull$$$0(3);
        }
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (!LOG.assertTrue(this.myIsBatchFoldingProcessing, (Object)"Fold regions must be added or removed inside batchFoldProcessing() only.")) {
            return null;
        }
        if (!this.isFoldingEnabled() || startOffset >= endOffset || neverExpands && group2 != null || DocumentUtil.isInsideCharacterPair((Document)this.myEditor.getDocument(), (int)startOffset) || DocumentUtil.isInsideCharacterPair((Document)this.myEditor.getDocument(), (int)endOffset) || !this.myFoldTree.checkIfValidToCreate(startOffset, endOffset, false, null)) {
            return null;
        }
        FoldRegionImpl region = new FoldRegionImpl(this.myEditor, startOffset, endOffset, placeholder, group2, neverExpands);
        this.myRegionTree.addInterval((RangeMarkerEx)region, startOffset, endOffset, false, false, false, 0);
        LOG.assertTrue(region.isValid());
        if (neverExpands) {
            this.collapseFoldRegion(region, false);
            if (region.isExpanded()) {
                region.putUserData(DO_NOT_NOTIFY, Boolean.TRUE);
                this.myRegionTree.removeInterval((RangeMarkerEx)region);
                return null;
            }
        }
        this.myFoldRegionsProcessed = true;
        if (group2 != null) {
            this.myGroups.putValue((Object)group2, (Object)region);
        }
        this.onFoldRegionStateChange(region);
        LOG.assertTrue(region.isValid());
        return region;
    }

    @Nullable
    public CustomFoldRegion addCustomLinesFolding(int startLine, int endLine, @NotNull CustomFoldRegionRenderer renderer2) {
        if (renderer2 == null) {
            FoldingModelImpl.$$$reportNull$$$0(4);
        }
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
            return null;
        }
        DocumentEx document2 = this.myEditor.getDocument();
        int maxLineNumber = Math.max(0, document2.getLineCount() - 1);
        startLine = Math.max(0, Math.min(maxLineNumber, startLine));
        endLine = Math.max(startLine, Math.min(maxLineNumber, endLine));
        int startOffset = document2.getLineStartOffset(startLine);
        int endOffset = document2.getLineEndOffset(endLine);
        if (!this.isFoldingEnabled() || startOffset >= endOffset || !this.myFoldTree.checkIfValidToCreate(startOffset, endOffset, true, null)) {
            return null;
        }
        CustomFoldRegionImpl region = new CustomFoldRegionImpl(this.myEditor, startOffset, endOffset, renderer2);
        this.myRegionTree.addInterval((RangeMarkerEx)region, startOffset, endOffset, false, false, false, 0);
        LOG.assertTrue(region.isValid());
        this.collapseFoldRegion(region, false);
        if (region.isExpanded()) {
            region.putUserData(DO_NOT_NOTIFY, Boolean.TRUE);
            this.myRegionTree.removeInterval((RangeMarkerEx)region);
            return null;
        }
        this.onFoldRegionStateChange(region);
        LOG.assertTrue(region.isValid());
        return region;
    }

    public void removeFoldRegion(@NotNull FoldRegion region) {
        if (region == null) {
            FoldingModelImpl.$$$reportNull$$$0(5);
        }
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        FoldingModelImpl.assertOurRegion(region);
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
        }
        this.onFoldProcessingStart();
        ((FoldRegionImpl)region).setExpanded(true, false);
        this.onFoldRegionStateChange(region);
        this.beforeFoldRegionRemoved(region);
        region.dispose();
    }

    @Override
    public void clearFoldRegions() {
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
            return;
        }
        FoldRegion[] regions = this.getAllFoldRegions();
        if (regions.length > 0) {
            this.onFoldProcessingStart();
        }
        for (FoldRegion region : regions) {
            if (!region.isExpanded()) {
                this.onFoldRegionStateChange(region);
            }
            this.beforeFoldRegionRemoved(region);
            region.dispose();
        }
        this.doClearFoldRegions();
    }

    @Nullable
    public FoldRegion getFoldRegion(int startOffset, int endOffset) {
        EditorThreading.assertInteractionAllowed();
        return this.myFoldTree.getRegionAt(startOffset, endOffset);
    }

    @Override
    @NotNull
    public List<FoldRegion> getGroupedRegions(@NotNull FoldingGroup group2) {
        if (group2 == null) {
            FoldingModelImpl.$$$reportNull$$$0(6);
        }
        List list2 = (List)this.myGroups.get((Object)group2);
        if (list2 == null) {
            FoldingModelImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull FoldRegion> getRegionsOverlappingWith(int startOffset, int endOffset) {
        EditorThreading.assertInteractionAllowed();
        List<FoldRegion> list2 = this.myFoldTree.fetchOverlapping(startOffset, endOffset);
        if (list2 == null) {
            FoldingModelImpl.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public @NotNull FoldRegion @NotNull [] getAllFoldRegions() {
        EditorThreading.assertInteractionAllowed();
        FoldRegion[] foldRegionArray = this.myFoldTree.fetchAllRegions();
        if (foldRegionArray == null) {
            FoldingModelImpl.$$$reportNull$$$0(9);
        }
        return foldRegionArray;
    }

    @Override
    public @NotNull FoldRegion @Nullable [] fetchTopLevel() {
        return this.myFoldTree.fetchTopLevel();
    }

    @Nullable
    public FoldRegion getCollapsedRegionAtOffset(int offset) {
        return this.myFoldTree.fetchOutermost(offset);
    }

    @Override
    public int getLastCollapsedRegionBefore(int offset) {
        return this.myFoldTree.getLastTopLevelIndexBefore(offset);
    }

    @Override
    public boolean intersectsRegion(int startOffset, int endOffset) {
        return this.myFoldTree.intersectsRegion(startOffset, endOffset);
    }

    public boolean isOffsetCollapsed(int offset) {
        EditorThreading.assertInteractionAllowed();
        return this.getCollapsedRegionAtOffset(offset) != null;
    }

    @Override
    @Nullable
    public FoldRegion getFoldingPlaceholderAt(@NotNull Point p) {
        if (p == null) {
            FoldingModelImpl.$$$reportNull$$$0(10);
        }
        return this.getFoldingPlaceholderAt(new EditorLocation(this.myEditor, p), false);
    }

    @Override
    @Nullable
    public TextAttributes getPlaceholderAttributes() {
        return this.myFoldTextAttributes;
    }

    public void runBatchFoldingOperation(@NotNull Runnable operation2, boolean allowMovingCaret, boolean keepRelativeCaretPosition) {
        if (operation2 == null) {
            FoldingModelImpl.$$$reportNull$$$0(11);
        }
        this.runBatchFoldingOperation(operation2, !allowMovingCaret, true, keepRelativeCaretPosition);
    }

    @Override
    public void addListener(@NotNull FoldingListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            FoldingModelImpl.$$$reportNull$$$0(12);
        }
        if (parentDisposable == null) {
            FoldingModelImpl.$$$reportNull$$$0(13);
        }
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myListeners.remove(listener2));
    }

    @Override
    public void clearDocumentRangesModificationStatus() {
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        this.myFoldTree.clearDocumentRangesModificationStatus();
    }

    @Override
    public boolean hasDocumentRegionChangedFor(@NotNull FoldRegion region) {
        if (region == null) {
            FoldingModelImpl.$$$reportNull$$$0(14);
        }
        EditorThreading.assertInteractionAllowed();
        return region instanceof FoldRegionImpl && ((FoldRegionImpl)region).hasDocumentRegionChanged();
    }

    @Override
    public boolean isFoldingEnabled() {
        return this.myIsFoldingEnabled;
    }

    @Override
    public void setFoldingEnabled(boolean isEnabled) {
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        this.myIsFoldingEnabled = isEnabled;
    }

    @Override
    public void rebuild() {
        if (!this.myEditor.getDocument().isInBulkUpdate()) {
            this.myFoldTree.rebuild();
        }
    }

    public long getModificationCount() {
        return this.myExpansionCounter.get();
    }

    @NotNull
    public String dumpState() {
        String string = Arrays.toString(this.myFoldTree.fetchTopLevel());
        if (string == null) {
            FoldingModelImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            FoldingModelImpl.$$$reportNull$$$0(16);
        }
        if (this.myIsBatchFoldingProcessing) {
            LOG.error("Document changes are not allowed during batch folding update");
        }
        this.myDocumentChangeProcessed = false;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            FoldingModelImpl.$$$reportNull$$$0(17);
        }
        try {
            if (event.getDocument().isInBulkUpdate()) {
                return;
            }
            this.validateAffectedCustomRegions();
            if (DocumentEventUtil.isMoveInsertion((DocumentEvent)event)) {
                this.myFoldTree.rebuild();
            } else {
                this.updateCachedOffsets();
            }
        }
        finally {
            this.myDocumentChangeProcessed = true;
        }
    }

    public int getPriority() {
        return 60;
    }

    public void onUpdated(@NotNull Inlay<?> inlay, int changeFlags) {
        if (inlay == null) {
            FoldingModelImpl.$$$reportNull$$$0(18);
        }
        if ((inlay.getPlacement() == Inlay.Placement.ABOVE_LINE || inlay.getPlacement() == Inlay.Placement.BELOW_LINE) && (changeFlags & 2) != 0) {
            this.myFoldTree.clearCachedInlayValues();
        }
    }

    @Override
    public boolean isInBatchFoldingOperation() {
        return this.myIsBatchFoldingProcessing;
    }

    @Override
    @ApiStatus.Internal
    public void updateCachedOffsets() {
        this.myFoldTree.updateCachedOffsets();
    }

    @Override
    @ApiStatus.Internal
    public int getFoldedLinesCountBefore(int offset) {
        if (!this.myDocumentChangeProcessed && this.myEditor.getDocument().isInEventsHandling()) {
            return 0;
        }
        return this.myFoldTree.getFoldedLinesCountBefore(offset);
    }

    @Override
    @ApiStatus.Internal
    public int getTotalNumberOfFoldedLines() {
        if (!this.myDocumentChangeProcessed && this.myEditor.getDocument().isInEventsHandling()) {
            return 0;
        }
        return this.myFoldTree.getTotalNumberOfFoldedLines();
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public IntPair getCustomRegionsYAdjustment(int offset, int prevFoldRegionIndex) {
        IntPair intPair = this.myFoldTree.getCustomRegionsYAdjustment(offset, prevFoldRegionIndex);
        if (intPair == null) {
            FoldingModelImpl.$$$reportNull$$$0(19);
        }
        return intPair;
    }

    @ApiStatus.Internal
    public @NotNull FoldRegion @Nullable [] fetchVisible() {
        return this.myFoldTree.fetchVisible();
    }

    @ApiStatus.Internal
    public int getEndOffset(@NotNull FoldingGroup group2) {
        if (group2 == null) {
            FoldingModelImpl.$$$reportNull$$$0(20);
        }
        List<FoldRegion> regions = this.getGroupedRegions(group2);
        int endOffset = 0;
        for (FoldRegion region : regions) {
            if (!region.isValid()) continue;
            endOffset = Math.max(endOffset, region.getEndOffset());
        }
        return endOffset;
    }

    void refreshSettings() {
        this.updateTextAttributes();
        this.runBatchFoldingOperation(() -> this.myRegionTree.processAll(region -> {
            if (region instanceof CustomFoldRegion) {
                ((CustomFoldRegion)region).update();
            }
            return true;
        }));
    }

    void onPlaceholderTextChanged(@NotNull FoldRegionImpl region) {
        if (region == null) {
            FoldingModelImpl.$$$reportNull$$$0(21);
        }
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be changed inside batchFoldProcessing() only");
        }
        this.onFoldProcessingStart();
        this.myEditor.myView.invalidateFoldRegionLayout(region);
        this.onFoldRegionStateChange(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runBatchFoldingOperation(@NotNull Runnable operation2, boolean dontCollapseCaret, boolean moveCaret, boolean adjustScrollingPosition) {
        if (operation2 == null) {
            FoldingModelImpl.$$$reportNull$$$0(22);
        }
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (this.myEditor.getInlayModel().isInBatchMode()) {
            LOG.error("Folding operations shouldn't be performed during inlay batch update");
        }
        boolean oldDontCollapseCaret = this.myDoNotCollapseCaret;
        this.myDoNotCollapseCaret |= dontCollapseCaret;
        boolean oldBatchFlag = this.myIsBatchFoldingProcessing;
        if (!oldBatchFlag && adjustScrollingPosition) {
            ((ScrollingModelImpl)this.myEditor.getScrollingModel()).finishAnimation();
            this.myScrollingPositionKeeper.savePosition();
        }
        this.myIsBatchFoldingProcessing = true;
        try {
            operation2.run();
        }
        finally {
            if (!oldBatchFlag) {
                this.myIsBatchFoldingProcessing = false;
                if (this.myFoldRegionsProcessed) {
                    this.onFoldProcessingEnd(moveCaret, adjustScrollingPosition);
                } else {
                    this.update(this.myRegionWidthChanged, this.myRegionHeightChanged, this.myGutterRendererChanged, this.myIsRepaintRequested);
                }
                this.myFoldRegionsProcessed = false;
                this.myRegionWidthChanged = false;
                this.myRegionHeightChanged = false;
                this.myGutterRendererChanged = false;
                this.setRepaintRequested(false);
            }
            this.myDoNotCollapseCaret = oldDontCollapseCaret;
        }
    }

    FoldRegion getFoldingPlaceholderAt(@NotNull EditorLocation location, boolean ignoreCustomRegionWidth) {
        if (location == null) {
            FoldingModelImpl.$$$reportNull$$$0(23);
        }
        Point p = location.getPoint();
        if (p.y < location.getVisualLineStartY() || p.y >= location.getVisualLineEndY()) {
            return null;
        }
        FoldRegion region = location.getCollapsedRegion();
        return !ignoreCustomRegionWidth && region instanceof CustomFoldRegion && p.x >= this.myEditor.getContentComponent().getInsets().left + ((CustomFoldRegion)region).getWidthInPixels() ? null : region;
    }

    void removeRegionFromTree(@NotNull FoldRegionImpl region) {
        if (region == null) {
            FoldingModelImpl.$$$reportNull$$$0(24);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.myEditor.getFoldingModel().isInBatchFoldingOperation()) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
        }
        this.onFoldProcessingStart();
        this.myRegionTree.removeInterval((RangeMarkerEx)region);
        this.removeRegionFromGroup(region);
    }

    void dispose() {
        this.doClearFoldRegions();
        this.myRegionTree.dispose((Document)this.myEditor.getDocument());
    }

    void expandFoldRegion(@NotNull FoldRegion region, boolean notify2) {
        if (region == null) {
            FoldingModelImpl.$$$reportNull$$$0(25);
        }
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (region.isExpanded() || region.shouldNeverExpand()) {
            return;
        }
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be collapsed or expanded inside batchFoldProcessing() only.");
        }
        for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
            SavedCaretPosition savedPosition = (SavedCaretPosition)caret.getUserData(SAVED_CARET_POSITION);
            if (savedPosition != null && savedPosition.isUpToDate(this.myEditor)) {
                int savedOffset = this.myEditor.logicalPositionToOffset(savedPosition.position());
                FoldRegion[] allCollapsed = this.myFoldTree.fetchCollapsedAt(savedOffset);
                if (allCollapsed.length != 1 || allCollapsed[0] != region) continue;
                caret.putUserData(MARK_FOR_UPDATE, (Object)Boolean.TRUE);
                continue;
            }
            if (caret.getOffset() != region.getStartOffset()) continue;
            caret.putUserData(MARK_FOR_UPDATE, (Object)Boolean.TRUE);
            caret.putUserData(SAVED_CARET_POSITION, (Object)new SavedCaretPosition(caret));
        }
        this.onFoldProcessingStart();
        this.myExpansionCounter.incrementAndGet();
        ((FoldRegionImpl)region).setExpandedInternal(true);
        if (notify2) {
            this.onFoldRegionStateChange(region);
        }
    }

    void collapseFoldRegion(@NotNull FoldRegion region, boolean notify2) {
        if (region == null) {
            FoldingModelImpl.$$$reportNull$$$0(26);
        }
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (!region.isExpanded()) {
            return;
        }
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be collapsed or expanded inside batchFoldProcessing() only.");
        }
        List<Caret> carets = this.myEditor.getCaretModel().getAllCarets();
        if (this.myDoNotCollapseCaret) {
            for (Caret caret : carets) {
                if (!FoldRegionsTree.containsStrict(region, caret.getOffset())) continue;
                return;
            }
        }
        for (Caret caret : carets) {
            SavedCaretPosition savedPosition;
            if (!FoldRegionsTree.containsStrict(region, caret.getOffset()) || (savedPosition = (SavedCaretPosition)caret.getUserData(SAVED_CARET_POSITION)) != null && savedPosition.isUpToDate(this.myEditor)) continue;
            caret.putUserData(SAVED_CARET_POSITION, (Object)new SavedCaretPosition(caret));
        }
        this.onFoldProcessingStart();
        ((FoldRegionImpl)region).setExpandedInternal(false);
        if (notify2) {
            this.onFoldRegionStateChange(region);
        }
    }

    int getHeightOfFoldedBlockInlaysBefore(int prevFoldRegionIndex) {
        return this.myFoldTree.getHeightOfFoldedBlockInlaysBefore(prevFoldRegionIndex);
    }

    int getTotalHeightOfFoldedBlockInlays() {
        return this.myFoldTree.getTotalHeightOfFoldedBlockInlays();
    }

    @NotNull
    @NotNull FoldRegion @NotNull [] fetchCollapsedAt(int offset) {
        FoldRegion[] foldRegionArray = this.myFoldTree.fetchCollapsedAt(offset);
        if (foldRegionArray == null) {
            FoldingModelImpl.$$$reportNull$$$0(27);
        }
        return foldRegionArray;
    }

    void flushCaretPosition(@NotNull Caret caret) {
        if (caret == null) {
            FoldingModelImpl.$$$reportNull$$$0(28);
        }
        caret.putUserData(SAVED_CARET_POSITION, null);
    }

    void onBulkDocumentUpdateStarted() {
        this.clearCachedValues();
    }

    void onBulkDocumentUpdateFinished() {
        this.validateAffectedCustomRegions();
        this.myFoldTree.rebuild();
    }

    void onCustomFoldRegionPropertiesChange(@NotNull CustomFoldRegion foldRegion, int flags) {
        boolean gutterMarkChanged;
        if (foldRegion == null) {
            FoldingModelImpl.$$$reportNull$$$0(29);
        }
        for (FoldingListener listener2 : this.myListeners) {
            listener2.onCustomFoldRegionPropertiesChange(foldRegion, flags);
        }
        boolean widthChanged = (flags & 1) != 0;
        boolean heightChanged = (flags & 2) != 0;
        boolean bl = gutterMarkChanged = (flags & 4) != 0;
        if (this.myIsBatchFoldingProcessing) {
            this.myRegionWidthChanged |= widthChanged;
            this.myRegionHeightChanged |= heightChanged;
            this.myGutterRendererChanged |= gutterMarkChanged;
        } else {
            this.update(widthChanged, heightChanged, gutterMarkChanged, false);
        }
    }

    void setRepaintRequested(boolean repaintRequested) {
        this.myIsRepaintRequested = repaintRequested;
    }

    void setComplexDocumentChange(boolean complexDocumentChange) {
        this.myIsComplexDocumentChange = complexDocumentChange;
    }

    void addAffectedCustomRegions(@NotNull CustomFoldRegionImpl customFoldRegion) {
        if (customFoldRegion == null) {
            FoldingModelImpl.$$$reportNull$$$0(30);
        }
        this.myAffectedCustomRegions.add(customFoldRegion);
    }

    @TestOnly
    void validateState() {
        FoldRegion[] actualTopLevels;
        DocumentEx document2 = this.myEditor.getDocument();
        if (document2.isInBulkUpdate()) {
            return;
        }
        FoldRegion[] allFoldRegions = this.getAllFoldRegions();
        boolean[] invisibleRegions = new boolean[allFoldRegions.length];
        for (int i2 = 0; i2 < allFoldRegions.length; ++i2) {
            FoldRegion r1 = allFoldRegions[i2];
            int r1s = r1.getStartOffset();
            int r1e = r1.getEndOffset();
            int r1c = r1 instanceof CustomFoldRegion;
            LOG.assertTrue(r1.isValid() && !DocumentUtil.isInsideCharacterPair((Document)document2, (int)r1s) && !DocumentUtil.isInsideCharacterPair((Document)document2, (int)r1e), (Object)"Invalid region");
            if (r1c != 0) {
                LOG.assertTrue(!r1.isExpanded(), (Object)"Expanded custom region");
                LOG.assertTrue(r1s == DocumentUtil.getLineStartOffset((int)r1s, (Document)document2) && r1e == DocumentUtil.getLineEndOffset((int)r1e, (Document)document2), (Object)"Wrong custom region position");
            }
            for (int j = i2 + 1; j < allFoldRegions.length; ++j) {
                FoldRegion r2 = allFoldRegions[j];
                int r2s = r2.getStartOffset();
                int r2e = r2.getEndOffset();
                int r2c = r2 instanceof CustomFoldRegion;
                LOG.assertTrue(r1c == r2c && (r1s < r2s && (r1e <= r2s || r1e >= r2e) || r1s == r2s && r1e != r2e || r1s > r2s && r1s < r2e && r1e <= r2e || r1s >= r2e) || r1c != 0 && r2c == 0 && (r1s > r2e || r1e < r2s || r1s > r2s && r1e < r2e || r1s <= r2s && r1e >= r2e) || r1c == 0 && r2c != 0 && (r1s > r2e || r1e < r2s || r2s > r1s && r2e < r1e || r2s <= r1s && r2e >= r1e), (Object)"Disallowed relative position of regions");
                if (!(r1.isExpanded() || r1s > r2s || r1e < r2e || r1s == r2s && r1e == r2e && r1c == 0)) {
                    invisibleRegions[j] = true;
                }
                if (r2.isExpanded() || r2s > r1s || r2e < r1e || r1s == r2s && r1e == r2e && r2c == 0) continue;
                invisibleRegions[i2] = true;
            }
        }
        Set visibleRegions = CollectionFactory.createCustomHashingStrategySet(OFFSET_BASED_HASHING_STRATEGY);
        ArrayList<FoldRegion> topLevelRegions = new ArrayList<FoldRegion>();
        for (int i3 = 0; i3 < allFoldRegions.length; ++i3) {
            if (invisibleRegions[i3]) continue;
            FoldRegion region = allFoldRegions[i3];
            LOG.assertTrue(visibleRegions.add(region), (Object)"Duplicate visible regions");
            if (region.isExpanded()) continue;
            topLevelRegions.add(region);
        }
        topLevelRegions.sort(Comparator.comparingInt(r -> r.getStartOffset()));
        FoldRegion[] actualVisibles = this.fetchVisible();
        if (actualVisibles != null) {
            for (FoldRegion r2 : actualVisibles) {
                LOG.assertTrue(visibleRegions.remove(r2), (Object)"Unexpected visible region");
            }
            LOG.assertTrue(visibleRegions.isEmpty(), (Object)"Missing visible region");
        }
        if ((actualTopLevels = this.fetchTopLevel()) != null) {
            LOG.assertTrue(actualTopLevels.length == topLevelRegions.size(), (Object)"Wrong number of top-level regions");
            for (int i4 = 0; i4 < actualTopLevels.length; ++i4) {
                LOG.assertTrue(OFFSET_BASED_HASHING_STRATEGY.equals((Object)actualTopLevels[i4], (Object)((FoldRegion)topLevelRegions.get(i4))), (Object)"Unexpected top-level region");
            }
        }
    }

    private void updateTextAttributes() {
        this.myFoldTextAttributes = this.myEditor.getColorsScheme().getAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES);
    }

    private boolean isOffsetInsideCollapsedRegion(int offset) {
        EditorThreading.assertInteractionAllowed();
        FoldRegion region = this.getCollapsedRegionAtOffset(offset);
        return region != null && region.getStartOffset() < offset;
    }

    private void update(boolean widthChanged, boolean heightChanged, boolean gutterMarkChanged, boolean repaintRequested) {
        if (heightChanged) {
            this.updateCachedOffsets();
            this.myEditor.getCaretModel().updateVisualPosition();
        }
        if (widthChanged || heightChanged) {
            this.myEditor.recalculateSizeAndRepaint();
        } else if (repaintRequested) {
            this.myEditor.getContentComponent().repaint();
        }
        if (gutterMarkChanged) {
            ((EditorGutterComponentImpl)this.myEditor.getGutterComponentEx()).updateSize();
        }
    }

    private void removeRegionFromGroup(@NotNull FoldRegion region) {
        if (region == null) {
            FoldingModelImpl.$$$reportNull$$$0(31);
        }
        this.myGroups.remove((Object)region.getGroup(), (Object)region);
    }

    private void doClearFoldRegions() {
        this.myGroups.clear();
        this.myFoldTree.clear();
    }

    private void onFoldProcessingEnd(boolean moveCaretFromCollapsedRegion, boolean adjustScrollingPosition) {
        this.clearCachedValues();
        for (FoldingListener listener2 : this.myListeners) {
            listener2.onFoldProcessingEnd();
        }
        this.myEditor.updateCaretCursor();
        this.myEditor.recalculateSizeAndRepaint();
        ((EditorGutterComponentImpl)this.myEditor.getGutterComponentEx()).updateSize();
        this.myEditor.getGutterComponentEx().repaint();
        this.myEditor.invokeDelayedErrorStripeRepaint();
        this.myEditor.getCaretModel().runBatchCaretOperation(() -> {
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                boolean markedForUpdate;
                LogicalPosition positionToUse = null;
                int offsetToUse = -1;
                SavedCaretPosition savedPosition = (SavedCaretPosition)caret.getUserData(SAVED_CARET_POSITION);
                boolean bl = markedForUpdate = caret.getUserData(MARK_FOR_UPDATE) != null;
                if (ClientId.isLocal((ClientId)ClientEditorManager.getClientId((Editor)this.myEditor)) && savedPosition != null && savedPosition.isUpToDate(this.myEditor)) {
                    int savedOffset = this.myEditor.logicalPositionToOffset(savedPosition.position());
                    FoldRegion collapsedAtSaved = this.myFoldTree.fetchOutermost(savedOffset);
                    if (collapsedAtSaved == null) {
                        positionToUse = savedPosition.position();
                    } else {
                        int n = offsetToUse = collapsedAtSaved.getPlaceholderText().isEmpty() && !(collapsedAtSaved instanceof CustomFoldRegion) ? collapsedAtSaved.getEndOffset() : collapsedAtSaved.getStartOffset();
                    }
                }
                if ((markedForUpdate || moveCaretFromCollapsedRegion) && caret.isUpToDate()) {
                    if (offsetToUse >= 0) {
                        caret.moveToOffset(offsetToUse);
                    } else if (positionToUse != null) {
                        caret.moveToLogicalPosition(positionToUse);
                    } else {
                        ((CaretImpl)caret).updateVisualPosition();
                    }
                }
                caret.putUserData(SAVED_CARET_POSITION, (Object)savedPosition);
                caret.putUserData(MARK_FOR_UPDATE, null);
                int selectionStart = caret.getSelectionStart();
                int selectionEnd = caret.getSelectionEnd();
                if (this.isOffsetInsideCollapsedRegion(selectionStart) || this.isOffsetInsideCollapsedRegion(selectionEnd)) {
                    caret.removeSelection();
                    continue;
                }
                if (!caret.hasSelection() || selectionEnd > this.myEditor.getDocument().getTextLength()) continue;
                caret.setSelection(selectionStart, selectionEnd);
            }
        });
        if (adjustScrollingPosition) {
            this.myScrollingPositionKeeper.restorePosition(true);
        }
    }

    private void clearCachedValues() {
        this.myFoldTree.clearCachedValues();
    }

    private void validateAffectedCustomRegions() {
        if (this.myIsComplexDocumentChange) {
            this.myRegionTree.processAll(r -> {
                if (r instanceof CustomFoldRegionImpl) {
                    CustomFoldRegionImpl customFoldRegion = (CustomFoldRegionImpl)((Object)r);
                    this.addAffectedCustomRegions(customFoldRegion);
                }
                return true;
            });
            this.setComplexDocumentChange(false);
        }
        for (CustomFoldRegionImpl region : this.myAffectedCustomRegions) {
            if (!region.isValid() || this.myFoldTree.checkIfValidToCreate(region.getStartOffset(), region.getEndOffset(), true, region)) continue;
            this.myRegionTree.removeInterval((RangeMarkerEx)region);
        }
        this.myAffectedCustomRegions.clear();
    }

    private void onFoldProcessingStart() {
        if (!this.myFoldRegionsProcessed) {
            for (FoldingListener listener2 : this.myListeners) {
                listener2.onFoldProcessingStart();
            }
            this.myFoldRegionsProcessed = true;
        }
    }

    private void onFoldRegionStateChange(@NotNull FoldRegion foldRegion) {
        if (foldRegion == null) {
            FoldingModelImpl.$$$reportNull$$$0(32);
        }
        for (FoldingListener listener2 : this.myListeners) {
            listener2.onFoldRegionStateChange(foldRegion);
        }
    }

    private void beforeFoldRegionDisposed(@NotNull FoldRegion foldRegion) {
        if (foldRegion == null) {
            FoldingModelImpl.$$$reportNull$$$0(33);
        }
        for (FoldingListener listener2 : this.myListeners) {
            listener2.beforeFoldRegionDisposed(foldRegion);
        }
    }

    private void beforeFoldRegionRemoved(@NotNull FoldRegion foldRegion) {
        if (foldRegion == null) {
            FoldingModelImpl.$$$reportNull$$$0(34);
        }
        for (FoldingListener listener2 : this.myListeners) {
            listener2.beforeFoldRegionRemoved(foldRegion);
        }
    }

    public void onFoldInitializationStatusChanged(boolean initInProgress) {
        for (FoldingListener listener2 : this.myListeners) {
            listener2.onFoldInitializationStatusChanged(initInProgress);
        }
    }

    public String toString() {
        return this.dumpState();
    }

    private static void assertOurRegion(@NotNull FoldRegion region) {
        if (region == null) {
            FoldingModelImpl.$$$reportNull$$$0(35);
        }
        if (!(region instanceof FoldRegionImpl)) {
            throw new IllegalArgumentException("Only regions created by this instance of FoldingModel are accepted");
        }
    }

    private static void assertIsDispatchThreadForEditor() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 15, 19, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholderText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FoldingModelImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 29: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldRegion";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customFoldRegion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FoldingModelImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupedRegions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegionsOverlappingWith";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFoldRegions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomRegionsYAdjustment";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchCollapsedAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hideGutterRendererForCollapsedRegion";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addFoldRegion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFoldRegion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCustomLinesFolding";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeFoldRegion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGroupedRegions";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 19: 
            case 27: {
                break;
            }
            case 10: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingPlaceholderAt";
                break;
            }
            case 11: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runBatchFoldingOperation";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasDocumentRegionChangedFor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onUpdated";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEndOffset";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "onPlaceholderTextChanged";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeRegionFromTree";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "expandFoldRegion";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collapseFoldRegion";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "flushCaretPosition";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "onCustomFoldRegionPropertiesChange";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addAffectedCustomRegions";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeRegionFromGroup";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "onFoldRegionStateChange";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "beforeFoldRegionDisposed";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "beforeFoldRegionRemoved";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "assertOurRegion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 15, 19, 27 -> new IllegalStateException(string);
        };
    }

    private final class MyMarkerTree
    extends HardReferencingRangeMarkerTree<FoldRegionImpl> {
        private boolean inCollectCall;

        private MyMarkerTree(Document document2) {
            if (document2 == null) {
                MyMarkerTree.$$$reportNull$$$0(0);
            }
            super(document2);
        }

        protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<FoldRegionImpl> i1, @NotNull IntervalTreeImpl.IntervalNode<FoldRegionImpl> i2) {
            boolean c2;
            int baseResult;
            if (i1 == null) {
                MyMarkerTree.$$$reportNull$$$0(1);
            }
            if (i2 == null) {
                MyMarkerTree.$$$reportNull$$$0(2);
            }
            if ((baseResult = super.compareEqualStartIntervals(i1, i2)) != 0) {
                return baseResult;
            }
            boolean c1 = i1.isFlagSet((byte)64);
            return c1 == (c2 = i2.isFlagSet((byte)64)) ? 0 : (c1 ? 1 : -1);
        }

        @NotNull
        protected RangeMarkerTree.RMNode<FoldRegionImpl> createNewNode(@NotNull FoldRegionImpl key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
            if (key == null) {
                MyMarkerTree.$$$reportNull$$$0(3);
            }
            return new FRNode(this, key, start2, end);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ApiStatus.Internal
        protected void collectAffectedMarkersAndShiftSubtrees(@Nullable IntervalTreeImpl.IntervalNode<FoldRegionImpl> root, int start2, int end, int lengthDelta, @NotNull List<? super IntervalTreeImpl.IntervalNode<FoldRegionImpl>> affected) {
            if (affected == null) {
                MyMarkerTree.$$$reportNull$$$0(4);
            }
            if (this.inCollectCall) {
                super.collectAffectedMarkersAndShiftSubtrees(root, start2, end, lengthDelta, affected);
                return;
            }
            this.inCollectCall = true;
            try {
                super.collectAffectedMarkersAndShiftSubtrees(root, start2, end, lengthDelta, affected);
            }
            finally {
                this.inCollectCall = false;
            }
            int oldLength = end - start2;
            if (oldLength > 0) {
                for (IntervalTreeImpl.IntervalNode<FoldRegionImpl> intervalNode : affected) {
                    RangeMarkerTree.RMNode node = (RangeMarkerTree.RMNode)intervalNode;
                    FoldRegionImpl region = MyMarkerTree.getRegion((IntervalTreeImpl.IntervalNode<FoldRegionImpl>)node);
                    region.mySizeBeforeUpdate = region.isExpanded() ? 0 : node.intervalEnd() - node.intervalStart();
                }
            }
        }

        @ApiStatus.Internal
        protected void fireBeforeRemoved(@NotNull FoldRegionImpl markerEx) {
            if (markerEx == null) {
                MyMarkerTree.$$$reportNull$$$0(5);
            }
            if (markerEx.getUserData(DO_NOT_NOTIFY) == null) {
                FoldingModelImpl.this.beforeFoldRegionDisposed(markerEx);
            }
        }

        @NotNull
        private static FoldRegionImpl getRegion(@NotNull IntervalTreeImpl.IntervalNode<FoldRegionImpl> node) {
            if (node == null) {
                MyMarkerTree.$$$reportNull$$$0(6);
            }
            assert (node.intervals.size() == 1);
            FoldRegionImpl region = (FoldRegionImpl)((Object)((Supplier)node.intervals.get(0)).get());
            assert (region != null);
            FoldRegionImpl foldRegionImpl = region;
            if (foldRegionImpl == null) {
                MyMarkerTree.$$$reportNull$$$0(7);
            }
            return foldRegionImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "i1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "i2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "affected";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markerEx";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/FoldingModelImpl$MyMarkerTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/FoldingModelImpl$MyMarkerTree";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRegion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compareEqualStartIntervals";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "collectAffectedMarkersAndShiftSubtrees";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "fireBeforeRemoved";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getRegion";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7 -> new IllegalStateException(string);
            };
        }

        private final class FRNode
        extends RangeMarkerTree.RMNode<FoldRegionImpl> {
            static final byte CUSTOM_FLAG = 64;

            private FRNode(@NotNull RangeMarkerTree<FoldRegionImpl> rangeMarkerTree, FoldRegionImpl key, int start2, int end) {
                if (rangeMarkerTree == null) {
                    FRNode.$$$reportNull$$$0(0);
                }
                if (key == null) {
                    FRNode.$$$reportNull$$$0(1);
                }
                super(rangeMarkerTree, (RangeMarkerEx)key, start2, end, false, false, false);
                this.setFlag((byte)64, key instanceof CustomFoldRegion);
            }

            protected void onRemoved() {
                for (Supplier getter : this.intervals) {
                    FoldingModelImpl.this.removeRegionFromGroup((FoldRegion)getter.get());
                }
            }

            protected void addIntervalsFrom(@NotNull IntervalTreeImpl.IntervalNode<FoldRegionImpl> otherNode) {
                if (otherNode == null) {
                    FRNode.$$$reportNull$$$0(2);
                }
                FoldRegionImpl region = MyMarkerTree.getRegion((IntervalTreeImpl.IntervalNode<FoldRegionImpl>)this);
                FoldRegionImpl otherRegion = MyMarkerTree.getRegion(otherNode);
                if (otherRegion.mySizeBeforeUpdate > region.mySizeBeforeUpdate) {
                    MyMarkerTree.this.setNode((RangeMarkerEx)region, null);
                    FoldingModelImpl.this.removeRegionFromGroup(region);
                    this.removeIntervalInternal(0, (RangeMarkerEx)region);
                    super.addIntervalsFrom(otherNode);
                } else {
                    otherNode.setValid(false);
                    ((RangeMarkerTree.RMNode)otherNode).onRemoved();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rangeMarkerTree";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "otherNode";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/editor/impl/FoldingModelImpl$MyMarkerTree$FRNode";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addIntervalsFrom";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private final class MyFoldRegionsTree
    extends FoldRegionsTree {
        MyFoldRegionsTree(RangeMarkerTree<? extends FoldRegionImpl> markerTree) {
            if (markerTree == null) {
                MyFoldRegionsTree.$$$reportNull$$$0(0);
            }
            super(markerTree);
        }

        @Override
        protected boolean isFoldingEnabled() {
            return FoldingModelImpl.this.isFoldingEnabled();
        }

        @Override
        protected boolean hasBlockInlays() {
            return FoldingModelImpl.this.myEditor.getInlayModel().hasBlockElements();
        }

        @Override
        protected int getFoldedBlockInlaysHeight(int foldStartOffset, int foldEndOffset) {
            int sum = 0;
            for (Inlay<?> inlay : FoldingModelImpl.this.myEditor.getInlayModel().getBlockElementsInRange(foldStartOffset, foldEndOffset)) {
                int offset = inlay.getOffset();
                boolean relatedToPrecedingText = inlay.isRelatedToPrecedingText();
                if (!relatedToPrecedingText && offset == foldStartOffset || relatedToPrecedingText && offset == foldEndOffset || InlayModelImpl.showWhenFolded(inlay)) continue;
                sum += inlay.getHeightInPixels();
            }
            return sum;
        }

        @Override
        protected int getLineHeight() {
            return FoldingModelImpl.this.myEditor.getLineHeight();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markerTree", "com/intellij/openapi/editor/impl/FoldingModelImpl$MyFoldRegionsTree", "<init>"));
        }
    }

    private static final class SavedCaretPosition
    extends Record {
        private final LogicalPosition position;
        private final long docStamp;

        SavedCaretPosition(@NotNull Caret caret) {
            if (caret == null) {
                SavedCaretPosition.$$$reportNull$$$0(0);
            }
            this(caret.getLogicalPosition(), caret.getEditor().getDocument().getModificationStamp());
        }

        private SavedCaretPosition(LogicalPosition position, long docStamp) {
            this.position = position;
            this.docStamp = docStamp;
        }

        private boolean isUpToDate(@NotNull Editor editor2) {
            if (editor2 == null) {
                SavedCaretPosition.$$$reportNull$$$0(1);
            }
            return this.docStamp == editor2.getDocument().getModificationStamp();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SavedCaretPosition.class, "position;docStamp", "position", "docStamp"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SavedCaretPosition.class, "position;docStamp", "position", "docStamp"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SavedCaretPosition.class, "position;docStamp", "position", "docStamp"}, this, o);
        }

        public LogicalPosition position() {
            return this.position;
        }

        public long docStamp() {
            return this.docStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/FoldingModelImpl$SavedCaretPosition";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUpToDate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class FoldRegionHashingStrategy
    implements HashingStrategy<FoldRegion> {
        private FoldRegionHashingStrategy() {
        }

        public int hashCode(@Nullable FoldRegion o) {
            return o == null ? 0 : o.getStartOffset() * 31 + o.getEndOffset();
        }

        public boolean equals(@Nullable FoldRegion o1, @Nullable FoldRegion o2) {
            return o1 == o2 || o1 != null && o2 != null && o1.getStartOffset() == o2.getStartOffset() && o1.getEndOffset() == o2.getEndOffset();
        }
    }
}

