/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.annotations.Unmodifiable;

public final class FileChooserUtil {
    private static final String LAST_OPENED_FILE = "last_opened_file_path";
    private static final String RECENT_FILES = "file.chooser.recent.files";
    private static final int RECENT_FILES_LIMIT = 30;

    @ApiStatus.Internal
    public static boolean isLastOpenedPathSet(@Nullable Project project2) {
        String last = FileChooserUtil.getLastOpenedFilePath(project2);
        return last != null;
    }

    @Nullable
    public static VirtualFile getLastOpenedFile(@Nullable Project project2) {
        String last = FileChooserUtil.getLastOpenedFilePath(project2);
        return last != null ? LocalFileSystem.getInstance().findFileByPath(last) : null;
    }

    @NonNls
    @Nullable
    private static String getLastOpenedFilePath(@Nullable Project project2) {
        return (project2 != null ? PropertiesComponent.getInstance((Project)project2) : PropertiesComponent.getInstance()).getValue(LAST_OPENED_FILE);
    }

    @Deprecated(forRemoval=true)
    public static void setLastOpenedFile(@Nullable Project project2, @Nullable VirtualFile file2) {
        if (file2 != null) {
            FileChooserUtil.setLastOpenedPath(project2, file2.getPath());
        }
    }

    public static void setLastOpenedFile(@Nullable Project project2, @NotNull Path file2) {
        if (file2 == null) {
            FileChooserUtil.$$$reportNull$$$0(0);
        }
        FileChooserUtil.setLastOpenedPath(project2, FileUtil.toSystemIndependentName((String)file2.toString()));
    }

    private static void setLastOpenedPath(@Nullable Project project2, String path) {
        if (project2 == null) {
            PropertiesComponent.getInstance().setValue(LAST_OPENED_FILE, path);
        } else if (!project2.isDisposed()) {
            PropertiesComponent.getInstance((Project)project2).setValue(LAST_OPENED_FILE, path);
        }
    }

    @ApiStatus.Internal
    public static @NotNull List<@SystemIndependent String> getRecentPaths() {
        List<String> values = PropertiesComponent.getInstance().getList(RECENT_FILES);
        List<String> list2 = values != null ? values : List.of();
        if (list2 == null) {
            FileChooserUtil.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @ApiStatus.Internal
    public static void updateRecentPaths(@Nullable Project project2, @NotNull VirtualFile file2) {
        VirtualFileSystem fs;
        if (file2 == null) {
            FileChooserUtil.$$$reportNull$$$0(2);
        }
        if ((fs = file2.getFileSystem()) instanceof ArchiveFileSystem && (file2 = ((ArchiveFileSystem)fs).getLocalByEntry(file2)) == null) {
            return;
        }
        String path = file2.getPath();
        FileChooserUtil.setLastOpenedPath(project2, path);
        List recent = Stream.concat(Stream.of(path), FileChooserUtil.getRecentPaths().stream()).distinct().limit(30L).collect(Collectors.toList());
        PropertiesComponent.getInstance().setList(RECENT_FILES, recent);
    }

    @ApiStatus.Internal
    @Nullable
    public static VirtualFile getFileToSelect(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project2, @Nullable VirtualFile toSelect) {
        VirtualFile result2;
        if (descriptor2 == null) {
            FileChooserUtil.$$$reportNull$$$0(3);
        }
        return (result2 = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)FileChooserUtil.pathToSelect(descriptor2, project2, toSelect)))) != null && descriptor2 instanceof FileSaverDescriptor && !result2.isDirectory() ? result2.getParent() : result2;
    }

    @ApiStatus.Internal
    @Nullable
    static Path getInitialPath(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project2, @Nullable VirtualFile toSelect) {
        Path result2;
        if (descriptor2 == null) {
            FileChooserUtil.$$$reportNull$$$0(4);
        }
        return (result2 = NioFiles.toPath((String)FileUtil.toSystemDependentName((String)FileChooserUtil.pathToSelect(descriptor2, project2, toSelect)))) != null && descriptor2 instanceof FileSaverDescriptor && !Files.isDirectory(result2, new LinkOption[0]) ? result2.getParent() : result2;
    }

    private static String pathToSelect(FileChooserDescriptor descriptor2, @Nullable Project project2, @Nullable VirtualFile toSelect) {
        VirtualFile projectDir;
        String last = FileChooserUtil.getLastOpenedFilePath(project2);
        if (last != null && (toSelect == null || descriptor2.getUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT) == Boolean.TRUE)) {
            return last;
        }
        if (toSelect != null) {
            return toSelect.getPath();
        }
        if (project2 != null && !project2.isDefault() && (projectDir = ProjectUtil.guessProjectDir((Project)project2)) != null) {
            return projectDir.getPath();
        }
        return SystemProperties.getUserHome();
    }

    public static @Unmodifiable @NotNull List<VirtualFile> getChosenFiles(@NotNull FileChooserDescriptor descriptor2, @NotNull List<VirtualFile> selectedFiles2) {
        if (descriptor2 == null) {
            FileChooserUtil.$$$reportNull$$$0(5);
        }
        if (selectedFiles2 == null) {
            FileChooserUtil.$$$reportNull$$$0(6);
        }
        List list2 = ContainerUtil.mapNotNull(selectedFiles2, file2 -> file2 != null && file2.isValid() ? descriptor2.getFileToSelect(file2) : null);
        if (list2 == null) {
            FileChooserUtil.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/impl/FileChooserUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/impl/FileChooserUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentPaths";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChosenFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setLastOpenedFile";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateRecentPaths";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileToSelect";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInitialPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChosenFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7 -> new IllegalStateException(string);
        };
    }
}

