/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.LargeFileEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class LargeFileNotificationProvider
implements EditorNotificationProvider {
    private static final Key<String> HIDDEN_KEY = Key.create((String)"large.file.editor.notification.hidden");
    private static final String DISABLE_KEY = "large.file.editor.notification.disabled";

    @NotNull
    public @NotNull Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            LargeFileNotificationProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            LargeFileNotificationProvider.$$$reportNull$$$0(1);
        }
        Function<FileEditor, JComponent> function = fileEditor -> {
            if (!(fileEditor instanceof TextEditor) || fileEditor.getUserData(LargeFileEditorProvider.IS_LARGE) != Boolean.TRUE) {
                return null;
            }
            Editor editor2 = ((TextEditor)fileEditor).getEditor();
            if (editor2.getUserData(HIDDEN_KEY) != null || PropertiesComponent.getInstance().isTrueValue(DISABLE_KEY)) {
                return null;
            }
            EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
            panel2.createActionLabel(IdeBundle.message((String)"action.label.hide.notification", (Object[])new Object[0]), () -> {
                editor2.putUserData(HIDDEN_KEY, (Object)"true");
                LargeFileNotificationProvider.update(file2, project2);
            });
            panel2.createActionLabel(IdeBundle.message((String)"label.dont.show", (Object[])new Object[0]), () -> {
                PropertiesComponent.getInstance().setValue(DISABLE_KEY, "true");
                LargeFileNotificationProvider.update(file2, project2);
            });
            return panel2.text(IdeBundle.message((String)"large.file.preview.notification", (Object[])new Object[]{StringUtil.formatFileSize((long)file2.getLength()), StringUtil.formatFileSize((long)FileSizeLimit.getPreviewLimit((String)file2.getExtension()))}));
        };
        if (function == null) {
            LargeFileNotificationProvider.$$$reportNull$$$0(2);
        }
        return function;
    }

    private static void update(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            LargeFileNotificationProvider.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            LargeFileNotificationProvider.$$$reportNull$$$0(4);
        }
        EditorNotifications.getInstance((Project)project2).updateNotifications(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/LargeFileNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/LargeFileNotificationProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNotificationData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNotificationData";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

