/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorCaretState;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtilRt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u001a\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u001a \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0012H\u0000\u001a\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u0018\u0010!\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0006H\u0002\u001a \u0010#\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0012H\u0002\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\t\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\n\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u000b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\f\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\r\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u000e\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u000f\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0010\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"TEXT_EDITOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/fileEditor/TextEditor;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "TEXT_EDITOR_PROVIDER_TYPE_ID", "", "Lorg/jetbrains/annotations/NonNls;", "LINE_ATTR", "COLUMN_ATTR", "LEAN_FORWARD_ATTR", "SELECTION_START_LINE_ATTR", "SELECTION_START_COLUMN_ATTR", "SELECTION_END_LINE_ATTR", "SELECTION_END_COLUMN_ATTR", "RELATIVE_CARET_POSITION_ATTR", "CARET_ELEMENT", "getLine", "", "position", "Lcom/intellij/openapi/editor/LogicalPosition;", "getColumn", "scrollToCaret", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "exactState", "", "relativeCaretPosition", "readCaretInfo", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorCaretState;", "element", "Lorg/jdom/Element;", "parseWithDefault", "attributeName", "writeIfNot0", "name", "value", "intellij.platform.ide.impl"})
public final class TextEditorProviderKt {
    @NotNull
    private static final Key<TextEditor> TEXT_EDITOR_KEY;
    @NotNull
    public static final String TEXT_EDITOR_PROVIDER_TYPE_ID = "text-editor";
    @NotNull
    private static final String LINE_ATTR = "line";
    @NotNull
    private static final String COLUMN_ATTR = "column";
    @NotNull
    private static final String LEAN_FORWARD_ATTR = "lean-forward";
    @NotNull
    private static final String SELECTION_START_LINE_ATTR = "selection-start-line";
    @NotNull
    private static final String SELECTION_START_COLUMN_ATTR = "selection-start-column";
    @NotNull
    private static final String SELECTION_END_LINE_ATTR = "selection-end-line";
    @NotNull
    private static final String SELECTION_END_COLUMN_ATTR = "selection-end-column";
    @NotNull
    private static final String RELATIVE_CARET_POSITION_ATTR = "relative-caret-position";
    @NotNull
    private static final String CARET_ELEMENT = "caret";

    private static final int getLine(LogicalPosition position) {
        LogicalPosition logicalPosition = position;
        return logicalPosition != null ? logicalPosition.line : 0;
    }

    private static final int getColumn(LogicalPosition position) {
        LogicalPosition logicalPosition = position;
        return logicalPosition != null ? logicalPosition.column : 0;
    }

    public static final void scrollToCaret(@NotNull Editor editor2, boolean exactState, int relativeCaretPosition) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        ScrollingModel scrollingModel = editor2.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModel, (String)"getScrollingModel(...)");
        ScrollingModel scrollingModel2 = scrollingModel;
        scrollingModel2.disableAnimation();
        if (relativeCaretPosition != Integer.MAX_VALUE) {
            EditorUtil.setRelativeCaretPosition(editor2, relativeCaretPosition);
        }
        if (!exactState) {
            scrollingModel2.scrollToCaret(ScrollType.RELATIVE);
        }
        scrollingModel2.enableAnimation();
    }

    private static final TextEditorCaretState readCaretInfo(Element element) {
        TextEditorCaretState caretState = new TextEditorCaretState(TextEditorProviderKt.parseWithDefault(element, LINE_ATTR), TextEditorProviderKt.parseWithDefault(element, COLUMN_ATTR), Boolean.parseBoolean(element.getAttributeValue(LEAN_FORWARD_ATTR)), 0, TextEditorProviderKt.parseWithDefault(element, SELECTION_START_LINE_ATTR), TextEditorProviderKt.parseWithDefault(element, SELECTION_START_COLUMN_ATTR), TextEditorProviderKt.parseWithDefault(element, SELECTION_END_LINE_ATTR), TextEditorProviderKt.parseWithDefault(element, SELECTION_END_COLUMN_ATTR));
        return caretState;
    }

    private static final int parseWithDefault(Element element, String attributeName) {
        return StringUtilRt.parseInt((String)element.getAttributeValue(attributeName), (int)0);
    }

    private static final void writeIfNot0(Element element, String name2, int value) {
        if (value != 0) {
            element.setAttribute(name2, String.valueOf(value));
        }
    }

    public static final /* synthetic */ Key access$getTEXT_EDITOR_KEY$p() {
        return TEXT_EDITOR_KEY;
    }

    public static final /* synthetic */ TextEditorCaretState access$readCaretInfo(Element element) {
        return TextEditorProviderKt.readCaretInfo(element);
    }

    public static final /* synthetic */ void access$writeIfNot0(Element element, String name2, int value) {
        TextEditorProviderKt.writeIfNot0(element, name2, value);
    }

    public static final /* synthetic */ int access$getLine(LogicalPosition position) {
        return TextEditorProviderKt.getLine(position);
    }

    public static final /* synthetic */ int access$getColumn(LogicalPosition position) {
        return TextEditorProviderKt.getColumn(position);
    }

    static {
        Key key = Key.create((String)"textEditor");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TEXT_EDITOR_KEY = key;
    }
}

