/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.KeyboardAwareFocusOwner;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionProcessor;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcherKt;
import com.intellij.openapi.keymap.impl.KeyProcessorContext;
import com.intellij.openapi.keymap.impl.KeyState;
import com.intellij.openapi.keymap.impl.SystemShortcuts;
import com.intellij.openapi.keymap.impl.UpdateResult;
import com.intellij.openapi.keymap.impl.keyGestures.KeyboardGestureProcessor;
import com.intellij.openapi.keymap.impl.ui.ShortcutTextField;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.KeyStrokeAdapter;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.MacUIUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 I2\u00020\u0001:\u0001IB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020\tH\u0002J\b\u0010(\u001a\u00020\tH\u0002J\b\u0010)\u001a\u00020\tH\u0002J\b\u0010*\u001a\u00020\tH\u0002J\b\u0010+\u001a\u00020\tH\u0002J\u0012\u0010,\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u001d\u00103\u001a\u000704\u00a2\u0006\u0002\b52\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u0016\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u000207JF\u00108\u001a\u00020\t2\u0006\u0010%\u001a\u00020:2\u0006\u0010<\u001a\u0002042\u0006\u0010\u001d\u001a\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002000?2\u0006\u0010;\u001a\u0002072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010@\u001a\u00020AH\u0001J\u0018\u0010C\u001a\u00020\u001b2\b\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010@\u001a\u00020AJ\u0010\u0010F\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020AH\u0002J\u0018\u0010G\u001a\u00020\u001b2\u0006\u0010H\u001a\u0002002\u0006\u0010@\u001a\u00020AH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e8G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000bR\u0013\u0010\u001d\u001a\u00020\u001e8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000bR\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/intellij/openapi/keymap/impl/IdeKeyEventDispatcher;", "", "queue", "Lcom/intellij/ide/IdeEventQueue;", "<init>", "(Lcom/intellij/ide/IdeEventQueue;)V", "firstKeyStroke", "Ljavax/swing/KeyStroke;", "value", "", "isPressedWasProcessed", "()Z", "ignoreNextKeyTypedEvent", "keyState", "Lcom/intellij/openapi/keymap/impl/KeyState;", "presentationFactory", "Lcom/intellij/openapi/actionSystem/impl/PresentationFactory;", "leftCtrlPressed", "rightAltPressed", "keyGestureProcessor", "Lcom/intellij/openapi/keymap/impl/keyGestures/KeyboardGestureProcessor;", "state", "getState", "()Lcom/intellij/openapi/keymap/impl/KeyState;", "setState", "(Lcom/intellij/openapi/keymap/impl/KeyState;)V", "resetState", "", "isReady", "context", "Lcom/intellij/openapi/keymap/impl/KeyProcessorContext;", "getContext", "()Lcom/intellij/openapi/keymap/impl/KeyProcessorContext;", "secondStrokeTimeout", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "isWaitingForSecondKeyStroke", "dispatchKeyEvent", "e", "Ljava/awt/event/KeyEvent;", "inWaitForSecondStrokeState", "inWaitForPossibleAltGr", "inSecondStrokeInProgressState", "inProcessedState", "inInitState", "processActionOrWaitSecondStroke", "keyStroke", "waitSecondStroke", "chosenAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "getSecondStrokeMessage", "", "Lcom/intellij/openapi/util/NlsContexts$StatusBarText;", "actionProcessor", "Lcom/intellij/openapi/keymap/impl/ActionProcessor;", "processAction", "event", "Ljava/awt/event/InputEvent;", "processor", "place", "Lcom/intellij/openapi/actionSystem/DataContext;", "actions", "", "shortcut", "Lcom/intellij/openapi/actionSystem/Shortcut;", "lastKeyEventForCurrentContext", "updateCurrentContext", "component", "Ljava/awt/Component;", "addActionsFromActiveKeymap", "addAction", "action", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIdeKeyEventDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeKeyEventDispatcher.kt\ncom/intellij/openapi/keymap/impl/IdeKeyEventDispatcher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,958:1\n60#2,5:959\n67#2,4:965\n67#2,4:970\n58#3:964\n1#4:969\n1#4:985\n1642#5,10:974\n1915#5:984\n1916#5:986\n1652#5:987\n*S KotlinDebug\n*F\n+ 1 IdeKeyEventDispatcher.kt\ncom/intellij/openapi/keymap/impl/IdeKeyEventDispatcher\n*L\n223#1:959,5\n533#1:965,4\n549#1:970,4\n299#1:964\n567#1:985\n567#1:974,10\n567#1:984\n567#1:986\n567#1:987\n*E\n"})
public final class IdeKeyEventDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final IdeEventQueue queue;
    @Nullable
    private KeyStroke firstKeyStroke;
    private boolean isPressedWasProcessed;
    private boolean ignoreNextKeyTypedEvent;
    @NotNull
    private KeyState keyState;
    @NotNull
    private final PresentationFactory presentationFactory;
    private boolean leftCtrlPressed;
    private boolean rightAltPressed;
    @NotNull
    private final KeyboardGestureProcessor keyGestureProcessor;
    @NotNull
    private final KeyProcessorContext context;
    @NotNull
    private final MutableSharedFlow<Unit> secondStrokeTimeout;
    @NotNull
    private final ActionProcessor actionProcessor;
    @Nullable
    private KeyEvent lastKeyEventForCurrentContext;

    public IdeKeyEventDispatcher(@Nullable IdeEventQueue queue) {
        this.queue = queue;
        this.keyState = KeyState.STATE_INIT;
        this.presentationFactory = new PresentationFactory();
        this.keyGestureProcessor = new KeyboardGestureProcessor(this);
        this.context = new KeyProcessorContext();
        this.secondStrokeTimeout = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ IdeKeyEventDispatcher this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.secondStrokeTimeout), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ IdeKeyEventDispatcher this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = DelayKt.delay((long)Registry.Companion.intValue("actionSystem.secondKeystrokeTimeout", 2000), (Continuation)((Continuation)this));
                                        if (v0 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        if (IdeKeyEventDispatcher.access$getKeyState$p(this.this$0) == KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE) {
                                            IdeKeyEventDispatcher.access$resetState(this.this$0);
                                            StatusBar.Info.set$default(null, (Project)this.this$0.getContext().getProject(), null, (int)4, null);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.actionProcessor = new ActionProcessor(this){
            final /* synthetic */ IdeKeyEventDispatcher this$0;
            {
                this.this$0 = $receiver;
            }

            public AnActionEvent createEvent(InputEvent inputEvent, DataContext context, String place, Presentation presentation2, ActionManager manager2) {
                Intrinsics.checkNotNullParameter((Object)inputEvent, (String)"inputEvent");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
                Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
                return new AnActionEvent(inputEvent, context, place, presentation2, manager2, 0);
            }

            public void onUpdatePassed(InputEvent inputEvent, AnAction action2, AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)inputEvent, (String)"inputEvent");
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.setState(KeyState.STATE_PROCESSED);
                IdeKeyEventDispatcher.access$setPressedWasProcessed$p(this.this$0, inputEvent.getID() == 401);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void performAction(InputEvent inputEvent, AnAction action2, AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)inputEvent, (String)"inputEvent");
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                try {
                    super.performAction(inputEvent, action2, event);
                }
                finally {
                    if (Registry.Companion.is("actionSystem.fixLostTyping", true)) {
                        IdeEventQueue.Companion.getInstance().doWhenReady(actionProcessor.1::performAction$lambda$0);
                    }
                }
            }

            private static final void performAction$lambda$0() {
                IdeKeyEventDispatcher.access$resetState(IdeEventQueue.Companion.getInstance().getKeyEventDispatcher());
            }
        };
    }

    public final boolean isPressedWasProcessed() {
        return this.isPressedWasProcessed;
    }

    @ApiStatus.Internal
    @NotNull
    public final KeyState getState() {
        return this.keyState;
    }

    @ApiStatus.Internal
    public final void setState(@NotNull KeyState state2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
            this.keyState = state2;
            IdeEventQueue ideEventQueue = this.queue;
            if (ideEventQueue == null) break block0;
            ideEventQueue.maybeReady$intellij_platform_ide_impl();
        }
    }

    private final void resetState() {
        this.setState(KeyState.STATE_INIT);
        this.isPressedWasProcessed = false;
    }

    public final boolean isReady() {
        return this.keyState == KeyState.STATE_INIT || this.keyState == KeyState.STATE_PROCESSED;
    }

    @ApiStatus.Internal
    @NotNull
    public final KeyProcessorContext getContext() {
        return this.context;
    }

    public final boolean isWaitingForSecondKeyStroke() {
        return this.getState() == KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE || this.isPressedWasProcessed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean dispatchKeyEvent(@NotNull KeyEvent e) {
        Application application;
        boolean isModalContext;
        Component focusOwner;
        block40: {
            block39: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getID() == 401) {
                    IdeKeyEventDispatcherKt.access$storeAsciiForChar(e);
                }
                if (e.isConsumed()) {
                    return false;
                }
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                focusOwner = focusManager.getFocusOwner();
                if (focusOwner instanceof KeyboardAwareFocusOwner && ((KeyboardAwareFocusOwner)((Object)focusOwner)).skipKeyEventDispatcher(e)) {
                    Logger $this$debug_u24default$iv = IdeKeyEventDispatcherKt.access$getLOG$p();
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug("Key event not processed because " + focusOwner + " is in focus and implements " + KeyboardAwareFocusOwner.class, t$iv);
                    }
                    return false;
                }
                int id2 = e.getID();
                if (this.ignoreNextKeyTypedEvent) {
                    if (400 == id2) {
                        return true;
                    }
                    this.ignoreNextKeyTypedEvent = false;
                }
                if (e.getKeyCode() == 17) {
                    switch (id2) {
                        case 401: {
                            this.leftCtrlPressed = e.getKeyLocation() == 2;
                            break;
                        }
                        case 402: {
                            this.leftCtrlPressed = false;
                        }
                    }
                } else if (e.getKeyCode() == 18) {
                    switch (id2) {
                        case 401: {
                            this.rightAltPressed = e.getKeyLocation() == 3;
                            break;
                        }
                        case 402: {
                            this.rightAltPressed = false;
                        }
                    }
                }
                if (focusOwner instanceof ShortcutTextField) {
                    if (SystemInfoRt.isWindows && 401 == id2) {
                        Companion.removeAltGraph(e);
                    }
                    return false;
                }
                if (this.getState() == KeyState.STATE_INIT && e.getKeyChar() != '\uffff' && e.getModifiersEx() == 0 && (e.getKeyCode() == 8 || e.getKeyCode() == 32 || Character.isLetterOrDigit(e.getKeyChar()))) {
                    SpeedSearchSupply supply;
                    SpeedSearchSupply speedSearchSupply = supply = focusOwner instanceof JComponent ? SpeedSearchSupply.getSupply((JComponent)((JComponent)focusOwner)) : null;
                    if (supply != null) {
                        return false;
                    }
                }
                if (this.getState() == KeyState.STATE_INIT && e.getKeyChar() != '\uffff' && focusOwner instanceof JTextComponent && ((JTextComponent)focusOwner).isEditable()) {
                    if (id2 == 401 && e.getKeyCode() != 27) {
                        MacUIUtil.hideCursor();
                    }
                    if (e.getModifiersEx() == 0 && Character.isLetterOrDigit(e.getKeyChar()) && !Intrinsics.areEqual((Object)((JTextComponent)focusOwner).getClientProperty(ActionUtil.ALLOW_PlAIN_LETTER_SHORTCUTS), (Object)true)) {
                        return false;
                    }
                }
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
                Intrinsics.checkNotNull((Object)selectedPath);
                if (!(selectedPath.length == 0) && !(selectedPath[0] instanceof ComboPopup)) {
                    this.setState(KeyState.STATE_PROCESSED);
                    MenuElement menuElement = selectedPath[0];
                    Intrinsics.checkNotNullExpressionValue((Object)menuElement, (String)"get(...)");
                    return IdeKeyEventDispatcherKt.access$processMenuActions(e, menuElement);
                }
                Window focusedWindow = focusManager.getFocusedWindow();
                isModalContext = focusedWindow != null && Companion.isModalContext(focusedWindow);
                application = ApplicationManager.getApplication();
                if (application == null) break block39;
                ComponentManager $this$serviceIfCreated$iv = (ComponentManager)application;
                boolean $i$f$serviceIfCreated = false;
                application = (DataManager)$this$serviceIfCreated$iv.getServiceIfCreated(DataManager.class);
                if (application != null) break block40;
            }
            return false;
        }
        DataContext dataContext2 = application.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext dataContext3 = dataContext2;
        this.context.setDataContext(dataContext3);
        this.context.setFocusOwner(focusOwner);
        this.context.setModalContext(isModalContext);
        this.context.setInputEvent(e);
        this.context.setProject((Project)CommonDataKeys.PROJECT.getData(dataContext3));
        try {
            boolean bl = switch (WhenMappings.$EnumSwitchMapping$0[this.getState().ordinal()]) {
                case 1 -> this.inInitState();
                case 2 -> this.inProcessedState();
                case 3 -> this.inWaitForSecondStrokeState();
                case 4 -> this.inSecondStrokeInProgressState();
                case 5 -> this.keyGestureProcessor.process();
                case 6 -> this.inWaitForPossibleAltGr();
                default -> throw new NoWhenBranchMatchedException();
            };
            return bl;
        }
        finally {
            this.context.clear();
        }
    }

    private final boolean inWaitForSecondStrokeState() {
        if (401 == this.context.getInputEvent().getID()) {
            this.setState(KeyState.STATE_SECOND_STROKE_IN_PROGRESS);
            return this.inSecondStrokeInProgressState();
        }
        return true;
    }

    private final boolean inWaitForPossibleAltGr() {
        boolean bl;
        KeyEvent e = this.context.getInputEvent();
        KeyStroke keyStroke = this.firstKeyStroke;
        this.firstKeyStroke = null;
        this.setState(KeyState.STATE_INIT);
        int eventId = e.getID();
        if (400 == eventId && e.isAltGraphDown()) {
            bl = false;
        } else if (402 == eventId) {
            Component component2 = this.context.getFoundComponent();
            KeyStroke keyStroke2 = keyStroke;
            Intrinsics.checkNotNull((Object)keyStroke2);
            this.updateCurrentContext(component2, (Shortcut)new KeyboardShortcut(keyStroke2, null));
            bl = this.context.getActions().isEmpty() ? false : this.processActionOrWaitSecondStroke(keyStroke);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean inSecondStrokeInProgressState() {
        boolean bl;
        KeyEvent e = this.context.getInputEvent();
        if (402 == e.getID()) {
            this.firstKeyStroke = null;
            this.setState(KeyState.STATE_INIT);
            Project project2 = this.context.getProject();
            StatusBar.Info.set$default(null, (Project)project2, null, (int)4, null);
            return false;
        }
        KeyStroke keyStroke = KeyStrokeAdapter.getDefaultKeyStroke(e);
        if (keyStroke == null) {
            return false;
        }
        KeyStroke originalKeyStroke = keyStroke;
        KeyStroke keyStroke2 = IdeKeyEventDispatcherKt.access$getKeyStrokeWithoutMouseModifiers(originalKeyStroke);
        Component component2 = this.context.getFoundComponent();
        KeyStroke keyStroke3 = this.firstKeyStroke;
        Intrinsics.checkNotNull((Object)keyStroke3);
        this.updateCurrentContext(component2, (Shortcut)new KeyboardShortcut(keyStroke3, keyStroke2));
        if (this.context.getActions().isEmpty()) {
            bl = true;
        } else {
            Intrinsics.checkNotNull((Object)e);
            if (this.processAction(e, this.actionProcessor)) {
                StatusBar.Info.set$default(null, (Project)this.context.getProject(), null, (int)4, null);
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean inProcessedState() {
        boolean bl;
        KeyEvent e = this.context.getInputEvent();
        if (400 == e.getID() && this.isPressedWasProcessed) {
            bl = true;
        } else if (402 == e.getID() && 18 == e.getKeyCode() && this.isPressedWasProcessed) {
            bl = true;
        } else {
            this.setState(KeyState.STATE_INIT);
            this.isPressedWasProcessed = false;
            bl = this.inInitState();
        }
        return bl;
    }

    private final boolean inInitState() {
        KeyStroke keyStroke;
        boolean isCandidateForAltGr;
        Component focusOwner;
        block13: {
            block14: {
                focusOwner = this.context.getFocusOwner();
                KeyEvent e = this.context.getInputEvent();
                if (SystemInfoRt.isWindows && 401 == e.getID()) {
                    Intrinsics.checkNotNull((Object)e);
                    if (Companion.removeAltGraph(e) && e.isControlDown()) {
                        this.firstKeyStroke = KeyStrokeAdapter.getDefaultKeyStroke(e);
                        if (this.firstKeyStroke == null) {
                            return false;
                        }
                        this.setState(KeyState.STATE_WAIT_FOR_POSSIBLE_ALT_GR);
                        return true;
                    }
                }
                boolean bl = isCandidateForAltGr = this.leftCtrlPressed && this.rightAltPressed && focusOwner != null && (e.getModifiers() & 0xFFFFFFFE) == 10;
                if (isCandidateForAltGr) {
                    if (Registry.Companion.is("actionSystem.force.alt.gr", false)) {
                        return false;
                    }
                    if (Companion.isAltGrLayout(focusOwner)) {
                        return false;
                    }
                }
                KeyStroke keyStroke2 = KeyStrokeAdapter.getDefaultKeyStroke(e);
                if (keyStroke2 == null) {
                    return false;
                }
                keyStroke = IdeKeyEventDispatcherKt.access$getKeyStrokeWithoutMouseModifiers(keyStroke2);
                if (this.keyGestureProcessor.processInitState()) {
                    return true;
                }
                if (512 != e.getModifiersEx() || SystemInfoRt.isMac && !Registry.Companion.is("ide.mac.alt.mnemonic.without.ctrl", true)) break block13;
                if (400 == e.getID() && !IdeEventQueue.Companion.getInstance().isInputMethodEnabled()) break block14;
                Intrinsics.checkNotNull((Object)e);
                if (!Companion.hasMnemonicInWindow(focusOwner, e)) break block13;
            }
            this.ignoreNextKeyTypedEvent = true;
            return false;
        }
        this.updateCurrentContext(focusOwner, (Shortcut)new KeyboardShortcut(keyStroke, null));
        if (this.context.getActions().isEmpty()) {
            return false;
        }
        if (isCandidateForAltGr && SystemInfoRt.isWindows && Registry.Companion.is("actionSystem.fix.alt.gr", true)) {
            this.firstKeyStroke = keyStroke;
            this.setState(KeyState.STATE_WAIT_FOR_POSSIBLE_ALT_GR);
            return true;
        }
        return this.processActionOrWaitSecondStroke(keyStroke) || Intrinsics.areEqual((Object)keyStroke, (Object)IdeKeyEventDispatcherKt.access$getF10());
    }

    private final boolean processActionOrWaitSecondStroke(KeyStroke keyStroke) {
        if (!this.context.getSecondStrokeActions().isEmpty()) {
            this.firstKeyStroke = keyStroke;
        }
        KeyEvent keyEvent = this.context.getInputEvent();
        Intrinsics.checkNotNullExpressionValue((Object)keyEvent, (String)"getInputEvent(...)");
        return this.processAction(keyEvent, this.actionProcessor);
    }

    private final void waitSecondStroke(AnAction chosenAction, Presentation presentation2) {
        StatusBar.Info.set$default((String)this.getSecondStrokeMessage(chosenAction, presentation2), (Project)this.context.getProject(), null, (int)4, null);
        if (!this.secondStrokeTimeout.tryEmit((Object)Unit.INSTANCE)) {
            throw new IllegalStateException("Check failed.");
        }
        this.setState(KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE);
    }

    private final String getSecondStrokeMessage(AnAction chosenAction, Presentation presentation2) {
        StringBuilder message = new StringBuilder();
        message.append(KeyMapBundle.message((String)"prefix.key.pressed.message", (Object[])new Object[0]));
        message.append(": ");
        message.append(presentation2.getText());
        message.append(" (");
        KeyStroke keyStroke = this.firstKeyStroke;
        Intrinsics.checkNotNull((Object)keyStroke);
        message.append(KeymapUtil.getKeystrokeText((KeyStroke)IdeKeyEventDispatcherKt.access$getSecondKeystroke(chosenAction, keyStroke)));
        message.append(")");
        for (AnAction action2 : this.context.getSecondStrokeActions()) {
            if (action2 == chosenAction) continue;
            message.append(", ");
            message.append(action2.getTemplatePresentation().getText());
            message.append(" (");
            Intrinsics.checkNotNull((Object)action2);
            KeyStroke keyStroke2 = this.firstKeyStroke;
            Intrinsics.checkNotNull((Object)keyStroke2);
            message.append(KeymapUtil.getKeystrokeText((KeyStroke)IdeKeyEventDispatcherKt.access$getSecondKeystroke(action2, keyStroke2)));
            message.append(")");
        }
        String string = message.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final boolean processAction(@NotNull InputEvent event, @NotNull ActionProcessor processor2) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)processor2, (String)"processor");
        DataContext dataContext2 = this.context.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        List<AnAction> list2 = this.context.getActions();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getActions(...)");
        List list3 = CollectionsKt.toList((Iterable)list2);
        Shortcut shortcut = this.context.getShortcut();
        Intrinsics.checkNotNullExpressionValue((Object)shortcut, (String)"getShortcut(...)");
        return this.processAction(event, "keyboard shortcut", dataContext2, list3, processor2, this.presentationFactory, shortcut);
    }

    @JvmName(name="processAction")
    public final boolean processAction(@NotNull InputEvent e, @NotNull String place, @NotNull DataContext context, @NotNull List<? extends AnAction> actions, @NotNull ActionProcessor processor2, @NotNull PresentationFactory presentationFactory, @NotNull Shortcut shortcut) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)processor2, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)presentationFactory, (String)"presentationFactory");
        Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
        if (actions.isEmpty()) {
            return false;
        }
        Logger $this$trace$iv = IdeKeyEventDispatcherKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("processAction(shortcut=" + shortcut + ", actions=" + actions + ")");
        }
        DataContext wrappedContext = Utils.createAsyncDataContext(context);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(wrappedContext);
        boolean dumb = project2 != null && DumbService.Companion.getInstance(project2).isDumb();
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList(...)");
        List wouldBeEnabledIfNotDumb = list2;
        IdeKeyEventDispatcherKt.access$fireBeforeShortcutTriggered(shortcut, actions, context);
        UpdateResult chosen2 = (UpdateResult)WriteIntentReadAction.compute(() -> IdeKeyEventDispatcher.processAction$lambda$1(actions, e, wrappedContext, place, processor2, presentationFactory, this, wouldBeEnabledIfNotDumb, project2, dumb, shortcut));
        return chosen2 != null;
    }

    public final void updateCurrentContext(@Nullable Component component2, @NotNull Shortcut shortcut) {
        Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
        Component component3 = component2;
        this.context.setFoundComponent(null);
        this.context.getSecondStrokeActions().clear();
        this.context.getActions().clear();
        this.context.setShortcut(null);
        if (Registry.Companion.is("ide.edt.update.context.only.on.key.pressed.event")) {
            KeyEvent keyEvent = this.context.getInputEvent();
            if (keyEvent == null || keyEvent.getID() != 401 || keyEvent == this.lastKeyEventForCurrentContext) {
                return;
            }
            this.lastKeyEventForCurrentContext = keyEvent;
        }
        if (IdeKeyEventDispatcherKt.access$isControlEnterOnDialog(component3, shortcut)) {
            return;
        }
        while (component3 != null) {
            if (!(component3 instanceof JComponent)) {
                component3 = component3.getParent();
                continue;
            }
            List listOfActions = ActionUtil.getActions((JComponent)((JComponent)component3));
            if (listOfActions.isEmpty()) {
                component3 = ((JComponent)component3).getParent();
                continue;
            }
            for (AnAction action2 : listOfActions) {
                this.addAction(action2, shortcut);
            }
            if (!this.context.getActions().isEmpty()) {
                this.context.setFoundComponent((JComponent)component3);
                break;
            }
            component3 = ((JComponent)component3).getParent();
        }
        if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
            this.addActionsFromActiveKeymap(shortcut);
            if (this.context.getSecondStrokeActions().isEmpty() && shortcut instanceof KeyboardShortcut) {
                KeyStroke keyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke();
                Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getFirstKeyStroke(...)");
                KeyStroke firstKeyStroke = keyStroke;
                KeyStroke secondKeyStroke = ((KeyboardShortcut)shortcut).getSecondKeyStroke();
                if (secondKeyStroke != null && secondKeyStroke.getModifiers() != 0 && firstKeyStroke.getModifiers() != 0) {
                    KeyboardShortcut altShortCut = new KeyboardShortcut(firstKeyStroke, KeyStroke.getKeyStroke(secondKeyStroke.getKeyCode(), 0));
                    this.addActionsFromActiveKeymap((Shortcut)altShortCut);
                }
            }
        }
    }

    private final void addActionsFromActiveKeymap(Shortcut shortcut) {
        Object object;
        Object keymap2;
        Application app;
        block7: {
            block6: {
                Object object2;
                KeymapManager keymapManager;
                app = ApplicationManager.getApplication();
                KeymapManager keymapManager2 = keymapManager = KeymapManager.getInstance();
                keymap2 = keymapManager2 != null ? keymapManager2.getActiveKeymap() : null;
                object = keymap2;
                if (object == null || (object = object.getActionIdList(shortcut)) == null) break block6;
                Object it = object2 = object;
                boolean bl = false;
                object = !((Collection)it).isEmpty() ? object2 : null;
                if (object != null) break block7;
            }
            return;
        }
        Object actionIds = object;
        ActionManager actionManager = (ActionManager)app.getServiceIfCreated(ActionManager.class);
        if (actionManager == null) {
            return;
        }
        ActionManager actionManager2 = actionManager;
        Iterator iterator = actionIds.iterator();
        while (iterator.hasNext()) {
            String actionId = (String)iterator.next();
            AnAction action2 = actionManager2.getAction(actionId);
            if (action2 == null || this.context.isModalContext() && !action2.isEnabledInModalContext()) continue;
            this.addAction(action2, shortcut);
        }
        if (shortcut instanceof KeyboardShortcut) {
            SystemShortcuts.getInstance().onUserPressedShortcut((Keymap)keymap2, (List<String>)actionIds, (KeyboardShortcut)shortcut);
        }
    }

    private final void addAction(AnAction action2, Shortcut shortcut) {
        if (action2 instanceof EmptyAction) {
            return;
        }
        boolean isNotTwoStroke = shortcut instanceof KeyboardShortcut && ((KeyboardShortcut)shortcut).getSecondKeyStroke() == null;
        Shortcut[] shortcutArray = action2.getShortcutSet().getShortcuts();
        Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
        for (Shortcut each : shortcutArray) {
            if (each == null) {
                throw new NullPointerException("unexpected shortcut of action: " + action2);
            }
            if (!each.isKeyboard() || !each.startsWith(shortcut)) continue;
            if (each instanceof KeyboardShortcut && ((KeyboardShortcut)each).getSecondKeyStroke() != null && isNotTwoStroke && !this.context.getSecondStrokeActions().contains(action2)) {
                this.context.getSecondStrokeActions().add(action2);
            }
            if (this.context.getActions().contains(action2)) continue;
            this.context.getActions().add(action2);
            this.context.setShortcut(shortcut);
        }
    }

    private static final Unit processAction$lambda$1$3$0$0(IdeKeyEventDispatcher this$0, InputEvent $e, String $place, List $actions, ActionProcessor $processor, PresentationFactory $presentationFactory, Shortcut $shortcut, DataContext dataContext2) {
        Intrinsics.checkNotNull((Object)dataContext2);
        this$0.processAction($e, $place, dataContext2, $actions, $processor, $presentationFactory, $shortcut);
        return Unit.INSTANCE;
    }

    private static final void processAction$lambda$1$3$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void processAction$lambda$1$3$0(IdeKeyEventDispatcher this$0, InputEvent $e, String $place, List $actions, ActionProcessor $processor, PresentationFactory $presentationFactory, Shortcut $shortcut) {
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(arg_0 -> IdeKeyEventDispatcher.processAction$lambda$1$3$0$1(arg_0 -> IdeKeyEventDispatcher.processAction$lambda$1$3$0$0(this$0, $e, $place, $actions, $processor, $presentationFactory, $shortcut, arg_0), arg_0));
    }

    private static final boolean processAction$lambda$1$1(InputEvent $e, Object it) {
        return $e.isConsumed();
    }

    private static final void processAction$lambda$1$3(IdeKeyEventDispatcher this$0, InputEvent $e, String $place, List $actions, ActionProcessor $processor, PresentationFactory $presentationFactory, Shortcut $shortcut) {
        ApplicationManager.getApplication().invokeLater(() -> IdeKeyEventDispatcher.processAction$lambda$1$3$0(this$0, $e, $place, $actions, $processor, $presentationFactory, $shortcut));
    }

    /*
     * WARNING - void declaration
     */
    private static final UpdateResult processAction$lambda$1(List $actions, InputEvent $e, DataContext $wrappedContext, String $place, ActionProcessor $processor, PresentationFactory $presentationFactory, IdeKeyEventDispatcher this$0, List $wouldBeEnabledIfNotDumb, Project $project, boolean $dumb, Shortcut $shortcut) {
        boolean hasSecondStroke;
        Logger logger;
        UpdateResult chosen2 = (UpdateResult)Utils.INSTANCE.runUpdateSessionForInputEvent($actions, $e, $wrappedContext, $place, $processor, $presentationFactory, (Function4)new Function4<List<? extends AnAction>, Function2<? super AnAction, ? super Continuation<? super Presentation>, ? extends Object>, Map<Presentation, ? extends AnActionEvent>, Continuation<? super UpdateResult>, Object>($dumb, (List<AnAction>)$wouldBeEnabledIfNotDumb, null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            /* synthetic */ Object L$2;
            final /* synthetic */ boolean $dumb;
            final /* synthetic */ List<AnAction> $wouldBeEnabledIfNotDumb;
            {
                this.$dumb = $dumb;
                this.$wouldBeEnabledIfNotDumb = $wouldBeEnabledIfNotDumb;
                super(4, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                List list2 = (List)this.L$0;
                Function2 function2 = (Function2)this.L$1;
                Map map2 = (Map)this.L$2;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void events;
                        void updater;
                        void rearranged;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)rearranged);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)updater);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)events);
                        this.label = 1;
                        Object object2 = IdeKeyEventDispatcherKt.access$doUpdateActionsInner((List)rearranged, (Function2)updater, (Map)events, this.$dumb, this.$wouldBeEnabledIfNotDumb, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(List<? extends AnAction> p1, Function2<? super AnAction, ? super Continuation<? super Presentation>, ? extends Object> p2, Map<Presentation, ? extends AnActionEvent> p3, Continuation<? super UpdateResult> p4) {
                var var5_5 = new /* invalid duplicate definition of identical inner class */;
                var5_5.L$0 = p1;
                var5_5.L$1 = p2;
                var5_5.L$2 = p3;
                return var5_5.invokeSuspend(Unit.INSTANCE);
            }
        });
        boolean doPerform = chosen2 != null && !this$0.context.getSecondStrokeActions().contains(chosen2.action);
        Logger $this$trace$iv = IdeKeyEventDispatcherKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("updateResult: chosen=" + chosen2 + ", doPerform=" + doPerform);
        }
        boolean bl = hasSecondStroke = chosen2 != null && this$0.context.getSecondStrokeActions().contains(chosen2.action);
        if (!($e.getID() != 401 || hasSecondStroke || chosen2 == null && $wouldBeEnabledIfNotDumb.isEmpty())) {
            this$0.ignoreNextKeyTypedEvent = true;
        }
        if (doPerform) {
            IdeKeyEventDispatcherKt.access$doPerformActionInner($e, $processor, chosen2.action, chosen2.event);
            IdeKeyEventDispatcherKt.access$logTimeMillis(chosen2.startedAt, chosen2.action);
        } else if (hasSecondStroke) {
            AnAction anAction = chosen2.action;
            Presentation presentation2 = chosen2.event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
            this$0.waitSecondStroke(anAction, presentation2);
        } else if (!$wouldBeEnabledIfNotDumb.isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            ActionManager actionManager = ActionManager.getInstance();
            Iterable bl2 = $actions;
            Condition condition = arg_0 -> IdeKeyEventDispatcher.processAction$lambda$1$1($e, arg_0);
            String string = IdeKeyEventDispatcherKt.access$getActionUnavailableMessage($wouldBeEnabledIfNotDumb);
            logger = $project;
            boolean $i$f$mapNotNull = false;
            void var17_23 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                AnAction action2 = (AnAction)element$iv$iv;
                boolean bl4 = false;
                if (actionManager.getId(action2) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            IdeKeyEventDispatcherKt.access$showDumbModeBalloonLater((Project)logger, string, condition, list2, () -> IdeKeyEventDispatcher.processAction$lambda$1$3(this$0, $e, $place, $actions, $processor, $presentationFactory, $shortcut));
        }
        return chosen2;
    }

    @JvmStatic
    public static final boolean isModalContext(@NotNull Component component2) {
        return Companion.isModalContext(component2);
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final Boolean isModalContextOrNull(@NotNull Component component2) {
        return Companion.isModalContextOrNull(component2);
    }

    @JvmStatic
    public static final boolean hasMnemonicInWindow(@Nullable Component focusOwner, @NotNull KeyEvent event) {
        return Companion.hasMnemonicInWindow(focusOwner, event);
    }

    public static final /* synthetic */ KeyState access$getKeyState$p(IdeKeyEventDispatcher $this) {
        return $this.keyState;
    }

    public static final /* synthetic */ void access$resetState(IdeKeyEventDispatcher $this) {
        $this.resetState();
    }

    public static final /* synthetic */ void access$setPressedWasProcessed$p(IdeKeyEventDispatcher $this, boolean bl) {
        $this.isPressedWasProcessed = bl;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$Companion;", "", "<init>", "()V", "isModalContext", "", "component", "Ljava/awt/Component;", "isModalContextOrNull", "(Ljava/awt/Component;)Ljava/lang/Boolean;", "hasMnemonicInWindow", "focusOwner", "event", "Ljava/awt/event/KeyEvent;", "removeAltGraph", "e", "Ljava/awt/event/InputEvent;", "isAltGrLayout", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isModalContext(@NotNull Component component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Boolean bl = this.isModalContextOrNull(component2);
            return bl != null ? bl : true;
        }

        @JvmStatic
        @ApiStatus.Internal
        @Nullable
        public final Boolean isModalContextOrNull(@NotNull Component component2) {
            boolean isPopup;
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Window window = ComponentUtil.getWindow((Component)component2);
            if (window == null) {
                return null;
            }
            Window window2 = window;
            if (window2 instanceof IdeFrameImpl) {
                Component pane2;
                JRootPane jRootPane = ((IdeFrameImpl)window2).getRootPane();
                Component component3 = pane2 = jRootPane != null ? jRootPane.getGlassPane() : null;
                if (pane2 instanceof IdeGlassPaneEx) {
                    return ((IdeGlassPaneEx)((Object)pane2)).isInModalContext();
                }
            }
            if (window2 instanceof JDialog && !((JDialog)window2).isModal()) {
                Window owner = window2.getOwner();
                return owner != null && this.isModalContext(owner);
            }
            if (window2 instanceof JFrame) {
                return false;
            }
            boolean isFloatingDecorator = window2 instanceof FloatingDecorator;
            boolean bl = isPopup = !(component2 instanceof JFrame) && !(component2 instanceof JDialog);
            if (isPopup && component2 instanceof JWindow) {
                JBPopup popup2;
                Object object = ((JWindow)component2).getRootPane().getClientProperty("JBPopup");
                JBPopup jBPopup = popup2 = object instanceof JBPopup ? (JBPopup)object : null;
                if (popup2 != null) {
                    return popup2.isModalContext();
                }
            }
            return !isFloatingDecorator;
        }

        @JvmStatic
        public final boolean hasMnemonicInWindow(@Nullable Component focusOwner, @NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return 400 == event.getID() && IdeKeyEventDispatcherKt.access$hasMnemonicInWindow(focusOwner, event.getKeyChar()) || 401 == event.getID() && IdeKeyEventDispatcherKt.access$hasMnemonicInWindow(focusOwner, event.getKeyCode());
        }

        public final boolean removeAltGraph(@NotNull InputEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.isAltGraphDown()) {
                try {
                    Field field = InputEvent.class.getDeclaredField("modifiers");
                    field.setAccessible(true);
                    field.setInt(e, 0xFFFFDFDF & field.getInt(e));
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }

        public final boolean isAltGrLayout(@Nullable Component component2) {
            Object object = component2;
            if (object == null || (object = ((Component)object).getInputContext()) == null || (object = ((InputContext)object).getLocale()) == null) {
                return false;
            }
            Object locale = object;
            String language = ((Locale)locale).getLanguage();
            boolean contains = Intrinsics.areEqual((Object)language, (Object)"en") ? IdeKeyEventDispatcherKt.access$getALT_GR_COUNTRIES$p().contains(((Locale)locale).getCountry()) : IdeKeyEventDispatcherKt.access$getALT_GR_LANGUAGES$p().contains(language);
            Object[] objectArray = new Object[]{contains ? "" : " not", " supported for ", locale};
            IdeKeyEventDispatcherKt.access$getLOG$p().debug("AltGr", objectArray);
            return contains;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KeyState.values().length];
            try {
                nArray[KeyState.STATE_INIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyState.STATE_PROCESSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyState.STATE_SECOND_STROKE_IN_PROGRESS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyState.STATE_KEY_GESTURE_PROCESSOR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyState.STATE_WAIT_FOR_POSSIBLE_ALT_GR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

