/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbModeStatisticsCollector;
import com.intellij.openapi.project.MergeableQueueTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class MergingTaskQueue<T extends MergeableQueueTask<T>> {
    private static final Logger LOG = Logger.getInstance(MergingTaskQueue.class);
    private final Object myLock = new Object();
    private final List<@NotNull T> myTasksQueue = new ArrayList<T>();
    private final Map<T, ProgressIndicatorBase> myProgresses = new HashMap<T, ProgressIndicatorBase>();
    private final AtomicLong mySubmittedTasksCount = new AtomicLong();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposePendingTasks() {
        ArrayList<ProgressIndicatorBase> indicatorsQueue;
        ArrayList<T> disposeQueue;
        Object object = this.myLock;
        synchronized (object) {
            disposeQueue = new ArrayList<T>(this.myTasksQueue);
            indicatorsQueue = new ArrayList<ProgressIndicatorBase>(this.myProgresses.values());
            this.myTasksQueue.clear();
            this.myProgresses.clear();
        }
        MergingTaskQueue.cancelIndicatorSafe(indicatorsQueue);
        MergingTaskQueue.disposeSafe(disposeQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void cancelAllTasks() {
        ArrayList<ProgressIndicatorBase> tasks;
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            tasks = new ArrayList<ProgressIndicatorBase>(this.myProgresses.values());
        }
        for (ProgressIndicatorEx progressIndicatorEx : tasks) {
            progressIndicatorEx.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTask(@NotNull T task) {
        ProgressIndicatorEx indicator2;
        if (task == null) {
            MergingTaskQueue.$$$reportNull$$$0(0);
        }
        Object object = this.myLock;
        synchronized (object) {
            indicator2 = (ProgressIndicatorEx)this.myProgresses.get(task);
        }
        if (indicator2 != null) {
            indicator2.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubmissionReceipt addTask(@NotNull T task) {
        SubmissionReceipt receipt;
        if (task == null) {
            MergingTaskQueue.$$$reportNull$$$0(1);
        }
        ArrayList<Object> disposeQueue = new ArrayList<Object>(1);
        Object newTask = task;
        Object object = this.myLock;
        synchronized (object) {
            T taskToAdd;
            for (int i2 = this.myTasksQueue.size() - 1; i2 >= 0; --i2) {
                MergeableQueueTask oldTask = (MergeableQueueTask)this.myTasksQueue.get(i2);
                ProgressIndicatorBase indicator2 = this.myProgresses.get(oldTask);
                if (indicator2 == null || indicator2.isCanceled()) {
                    this.myTasksQueue.remove(i2);
                    disposeQueue.add(oldTask);
                    continue;
                }
                if (task.getClass() != oldTask.getClass()) continue;
                MergeableQueueTask mergedTask = task.tryMergeWith(oldTask);
                boolean contextsEqual = true;
                if (mergedTask == oldTask) {
                    newTask = null;
                    disposeQueue.add(task);
                    break;
                }
                if (mergedTask == null) continue;
                LOG.debug("Merged " + String.valueOf(task) + " with " + String.valueOf(oldTask));
                newTask = mergedTask;
                this.myTasksQueue.remove(i2);
                disposeQueue.add(oldTask);
                if (mergedTask == task) break;
                disposeQueue.add(task);
                break;
            }
            if ((taskToAdd = newTask) != null) {
                this.myTasksQueue.add(taskToAdd);
                this.mySubmittedTasksCount.incrementAndGet();
                ProgressIndicatorBase progress = new ProgressIndicatorBase();
                this.myProgresses.put(taskToAdd, progress);
                Disposer.register(taskToAdd, () -> {
                    Object object = this.myLock;
                    synchronized (object) {
                        this.myProgresses.remove(taskToAdd);
                    }
                    progress.cancel();
                });
            }
            receipt = new SubmissionReceipt(this.mySubmittedTasksCount.get());
        }
        MergingTaskQueue.disposeSafe(disposeQueue);
        return receipt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubmissionReceipt getLatestSubmissionReceipt() {
        Object object = this.myLock;
        synchronized (object) {
            return new SubmissionReceipt(this.mySubmittedTasksCount.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public QueuedTask<T> extractNextTask() {
        ArrayList<MergeableQueueTask> disposeQueue = new ArrayList<MergeableQueueTask>(1);
        try {
            Object object = this.myLock;
            synchronized (object) {
            }
        }
        catch (Throwable throwable) {
            MergingTaskQueue.disposeSafe(disposeQueue);
            throw throwable;
        }
        {
            while (true) {
                if (this.myTasksQueue.isEmpty()) {
                    QueuedTask<T> queuedTask = null;
                    // MONITOREXIT @DISABLED, blocks:[4, 6, 8] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    MergingTaskQueue.disposeSafe(disposeQueue);
                    return queuedTask;
                }
                MergeableQueueTask task = (MergeableQueueTask)this.myTasksQueue.remove(0);
                ProgressIndicatorBase indicator2 = this.myProgresses.get(task);
                if (indicator2 != null && !indicator2.isCanceled()) {
                    QueuedTask<MergeableQueueTask> queuedTask = this.wrapTask(task, indicator2);
                    // MONITOREXIT @DISABLED, blocks:[4, 6, 7] lbl19 : MonitorExitStatement: MONITOREXIT : var2_2
                    MergingTaskQueue.disposeSafe(disposeQueue);
                    return queuedTask;
                }
                disposeQueue.add(task);
            }
        }
    }

    protected QueuedTask<T> wrapTask(T task, ProgressIndicatorBase indicator2) {
        return new QueuedTask<T>(task, (ProgressIndicatorEx)indicator2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myTasksQueue.isEmpty();
        }
    }

    private static void disposeSafe(@NotNull Collection<? extends Disposable> tasks) {
        if (tasks == null) {
            MergingTaskQueue.$$$reportNull$$$0(2);
        }
        for (Disposable disposable : tasks) {
            MergingTaskQueue.disposeSafe(disposable);
        }
    }

    private static void disposeSafe(@NotNull Disposable task) {
        block4: {
            if (task == null) {
                MergingTaskQueue.$$$reportNull$$$0(3);
            }
            try {
                if (Disposer.isDisposed((Disposable)task)) {
                    return;
                }
                Disposer.dispose((Disposable)task);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) break block4;
                LOG.warn("Failed to dispose task: " + t.getMessage(), t);
            }
        }
    }

    private static void cancelIndicatorSafe(@NotNull List<? extends ProgressIndicatorEx> indicators) {
        if (indicators == null) {
            MergingTaskQueue.$$$reportNull$$$0(4);
        }
        for (ProgressIndicatorEx progressIndicatorEx : indicators) {
            MergingTaskQueue.cancelIndicatorSafe(progressIndicatorEx);
        }
    }

    private static void cancelIndicatorSafe(@NotNull ProgressIndicatorEx indicator2) {
        block3: {
            if (indicator2 == null) {
                MergingTaskQueue.$$$reportNull$$$0(5);
            }
            try {
                indicator2.cancel();
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) break block3;
                LOG.warn("Failed to cancel task indicator: " + t.getMessage(), t);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicators";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/MergingTaskQueue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addTask";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "disposeSafe";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelIndicatorSafe";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class SubmissionReceipt {
        private final long submittedTaskCount;

        private SubmissionReceipt(long submittedTaskCount) {
            this.submittedTaskCount = submittedTaskCount;
        }

        public boolean isAfter(@NotNull SubmissionReceipt other) {
            if (other == null) {
                SubmissionReceipt.$$$reportNull$$$0(0);
            }
            return this.submittedTaskCount > other.submittedTaskCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.submittedTaskCount == ((SubmissionReceipt)o).submittedTaskCount;
        }

        public int hashCode() {
            return Long.hashCode(this.submittedTaskCount);
        }

        public String toString() {
            return "SubmissionReceipt{" + this.submittedTaskCount + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/openapi/project/MergingTaskQueue$SubmissionReceipt", "isAfter"));
        }
    }

    public static class QueuedTask<T extends MergeableQueueTask<T>>
    implements AutoCloseable {
        private final T task;
        private final ProgressIndicatorEx indicator;

        QueuedTask(@NotNull T task, @NotNull ProgressIndicatorEx progress) {
            if (task == null) {
                QueuedTask.$$$reportNull$$$0(0);
            }
            if (progress == null) {
                QueuedTask.$$$reportNull$$$0(1);
            }
            this.task = task;
            this.indicator = progress;
        }

        @Override
        public void close() {
            Disposer.dispose(this.task);
        }

        @NotNull
        public ProgressIndicatorEx getIndicator() {
            ProgressIndicatorEx progressIndicatorEx = this.indicator;
            if (progressIndicatorEx == null) {
                QueuedTask.$$$reportNull$$$0(2);
            }
            return progressIndicatorEx;
        }

        public void executeTask() {
            this.executeTask(null);
        }

        public void executeTask(@Nullable ProgressIndicator customIndicator) {
            this.indicator.checkCanceled();
            this.indicator.setIndeterminate(true);
            ProgressIndicator indicator2 = customIndicator == null ? this.indicator : customIndicator;
            indicator2.checkCanceled();
            this.beforeTask();
            this.task.perform(indicator2);
        }

        String getInfoString() {
            return String.valueOf(this.task);
        }

        protected T getTask() {
            return this.task;
        }

        @Nullable
        StructuredIdeActivity registerStageStarted(@NotNull StructuredIdeActivity activity, @NotNull Project project2) {
            if (activity == null) {
                QueuedTask.$$$reportNull$$$0(3);
            }
            if (project2 == null) {
                QueuedTask.$$$reportNull$$$0(4);
            }
            return null;
        }

        void registerStageFinished(@NotNull StructuredIdeActivity parentActivity, @Nullable StructuredIdeActivity childActivity, @NotNull DumbModeStatisticsCollector.IndexingFinishType finishType) {
            if (parentActivity == null) {
                QueuedTask.$$$reportNull$$$0(5);
            }
            if (finishType == null) {
                QueuedTask.$$$reportNull$$$0(6);
            }
        }

        public void beforeTask() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/project/MergingTaskQueue$QueuedTask";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activity";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentActivity";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "finishType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/project/MergingTaskQueue$QueuedTask";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "registerStageStarted";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "registerStageFinished";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

