/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.impl.GenericZipFile;
import com.intellij.openapi.vfs.impl.ZipHandlerBase;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.ResourceHandle;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TimedZipHandler
extends ZipHandlerBase {
    private static final Logger LOG = Logger.getInstance(TimedZipHandler.class);
    private static final long RETENTION_MS = 2000L;
    private static final int LRU_CACHE_SIZE = 30;
    private static final Object2ObjectLinkedOpenHashMap<TimedZipHandler, ScheduledFuture<?>> handlersLRUCache = new Object2ObjectLinkedOpenHashMap(31);
    private static final ScheduledExecutorService postponedInvalidationsExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"Zip Handle Janitor", (int)1);
    private final ZipResourceHandle handle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void closeOpenZipReferences() {
        ArrayList<Pair.NonNull> entriesToClearAndCancel = new ArrayList<Pair.NonNull>();
        Object2ObjectLinkedOpenHashMap<TimedZipHandler, ScheduledFuture<?>> object2ObjectLinkedOpenHashMap = handlersLRUCache;
        synchronized (object2ObjectLinkedOpenHashMap) {
            for (Map.Entry entry : handlersLRUCache.entrySet()) {
                entriesToClearAndCancel.add(Pair.createNonNull((Object)((Object)((TimedZipHandler)((Object)entry.getKey()))), (Object)((ScheduledFuture)entry.getValue())));
            }
            handlersLRUCache.clear();
        }
        for (Pair pair : entriesToClearAndCancel) {
            TimedZipHandler handler = (TimedZipHandler)((Object)pair.first);
            handler.clearCaches();
            ScheduledFuture invalidationRequest = (ScheduledFuture)pair.second;
            invalidationRequest.cancel(false);
        }
    }

    public TimedZipHandler(@NotNull String path) {
        if (path == null) {
            TimedZipHandler.$$$reportNull$$$0(0);
        }
        super(path);
        this.handle = new ZipResourceHandle();
    }

    public void clearCaches() {
        super.clearCaches();
        this.handle.invalidateZipReference(null);
    }

    @NotNull
    protected ResourceHandle<GenericZipFile> acquireZipHandle() throws IOException {
        this.handle.attach();
        ZipResourceHandle zipResourceHandle = this.handle;
        if (zipResourceHandle == null) {
            TimedZipHandler.$$$reportNull$$$0(1);
        }
        return zipResourceHandle;
    }

    protected long getEntryFileStamp() {
        return this.handle.getFileStamp();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/jar/TimedZipHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/jar/TimedZipHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireZipHandle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private final class ZipResourceHandle
    extends ResourceHandle<GenericZipFile> {
        private final ReentrantLock lock = new ReentrantLock();
        private GenericZipFile zipFile;
        private long lastModifiedMs;
        private ScheduledFuture<?> scheduledInvalidationRequest = null;
        private int referenceCount = 0;

        private ZipResourceHandle() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void attach() throws IOException {
            Object2ObjectLinkedOpenHashMap<TimedZipHandler, ScheduledFuture<?>> object2ObjectLinkedOpenHashMap = handlersLRUCache;
            synchronized (object2ObjectLinkedOpenHashMap) {
                handlersLRUCache.remove((Object)TimedZipHandler.this);
            }
            this.lock.lock();
            try {
                if (this.zipFile != null) {
                    this.cancelPostponedInvalidation();
                } else {
                    Path path = TimedZipHandler.this.getPath();
                    this.zipFile = ZipHandlerBase.getZipFileWrapper((Path)path);
                    this.lastModifiedMs = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                }
                ++this.referenceCount;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.lock.lock();
            try {
                if (this.zipFile == null || this.referenceCount == 0) {
                    return;
                }
                --this.referenceCount;
                ScheduledFuture<?> invalidationRequest = this.schedulePostponedInvalidation();
                Object2ObjectLinkedOpenHashMap<TimedZipHandler, ScheduledFuture<?>> object2ObjectLinkedOpenHashMap = handlersLRUCache;
                synchronized (object2ObjectLinkedOpenHashMap) {
                    handlersLRUCache.putAndMoveToFirst((Object)TimedZipHandler.this, invalidationRequest);
                }
            }
            finally {
                this.lock.unlock();
            }
            for (int i2 = 0; i2 < 30; ++i2) {
                ScheduledFuture invalidationRequest;
                TimedZipHandler leastUsedHandler;
                Object2ObjectLinkedOpenHashMap<TimedZipHandler, ScheduledFuture<?>> object2ObjectLinkedOpenHashMap = handlersLRUCache;
                synchronized (object2ObjectLinkedOpenHashMap) {
                    if (handlersLRUCache.size() <= 30) {
                        break;
                    }
                    leastUsedHandler = (TimedZipHandler)((Object)handlersLRUCache.lastKey());
                    invalidationRequest = (ScheduledFuture)handlersLRUCache.removeLast();
                }
                if (leastUsedHandler == null) continue;
                leastUsedHandler.handle.invalidateZipReference(invalidationRequest);
            }
        }

        @NotNull
        private ScheduledFuture<?> schedulePostponedInvalidation() {
            this.cancelPostponedInvalidation();
            ScheduledFuture<?> invalidationRequest = postponedInvalidationsExecutor.schedule(() -> this.invalidateZipReference(null), 2000L, TimeUnit.MILLISECONDS);
            this.scheduledInvalidationRequest = invalidationRequest;
            ScheduledFuture<?> scheduledFuture = invalidationRequest;
            if (scheduledFuture == null) {
                ZipResourceHandle.$$$reportNull$$$0(0);
            }
            return scheduledFuture;
        }

        private void cancelPostponedInvalidation() {
            assert (this.lock.isHeldByCurrentThread()) : "Lock must be acquired before this method invocation";
            if (this.scheduledInvalidationRequest != null) {
                this.scheduledInvalidationRequest.cancel(false);
                this.scheduledInvalidationRequest = null;
            }
        }

        private void invalidateZipReference(@Nullable ScheduledFuture<?> expectedInvalidationRequest) {
            GenericZipFile zipFileLocalCopy;
            this.lock.lock();
            try {
                if (this.referenceCount > 0) {
                    return;
                }
                if (this.zipFile == null || expectedInvalidationRequest != null && this.scheduledInvalidationRequest != expectedInvalidationRequest) {
                    return;
                }
                this.cancelPostponedInvalidation();
                zipFileLocalCopy = this.zipFile;
                this.zipFile = null;
            }
            finally {
                this.lock.unlock();
            }
            try {
                zipFileLocalCopy.close();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        @NotNull
        public GenericZipFile get() {
            this.lock.lock();
            if (this.zipFile == null) {
                throw new IllegalStateException("Handler is closed");
            }
            GenericZipFile genericZipFile = this.zipFile;
            GenericZipFile genericZipFile2 = genericZipFile;
            if (genericZipFile2 == null) {
                ZipResourceHandle.$$$reportNull$$$0(1);
            }
            return genericZipFile2;
            finally {
                this.lock.unlock();
            }
        }

        private long getFileStamp() {
            this.lock.lock();
            try {
                if (this.zipFile == null) {
                    throw new IllegalStateException("Handler is closed");
                }
                long l = this.lastModifiedMs;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/vfs/impl/jar/TimedZipHandler$ZipResourceHandle";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "schedulePostponedInvalidation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

