/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.core.CoreBundle;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LargeFileWriteRequestor;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemEelUtil;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SlowOperations;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PreemptiveSafeFileOutputStream;
import com.intellij.util.io.SafeFileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Deprecated(forRemoval=true)
@ApiStatus.Internal
public abstract class LocalFileSystemBase
extends LocalFileSystem {
    private static final Boolean EXTRACT_ROOTS_USING_NIO = SystemProperties.getBooleanProperty((String)"vfs.extract.roots.using.nio", (boolean)true);
    private static final ExtensionPointName<LocalFileOperationsHandler> FILE_OPERATIONS_HANDLER_EP_NAME = ExtensionPointName.create((String)"com.intellij.vfs.local.fileOperationsHandler");
    protected static final Logger LOG = Logger.getInstance(LocalFileSystemBase.class);
    private final List<LocalFileOperationsHandler> myHandlers = new ArrayList<LocalFileOperationsHandler>();

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            LocalFileSystemBase.$$$reportNull$$$0(0);
        }
        return LocalFileSystemBase.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            LocalFileSystemBase.$$$reportNull$$$0(1);
        }
        return LocalFileSystemBase.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            LocalFileSystemBase.$$$reportNull$$$0(2);
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    protected static String toIoPath(@NotNull VirtualFile file2) {
        Object path;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(3);
        }
        if (((String)(path = file2.getPath())).length() == 2 && SystemInfo.isWindows && OSAgnosticPathUtil.startsWithWindowsDrive((String)path)) {
            path = (String)path + "/";
        }
        String string = path;
        if (string == null) {
            LocalFileSystemBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public Path getNioPath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(5);
        }
        return file2.getFileSystem() == this ? Path.of(LocalFileSystemBase.toIoPath(file2), new String[0]) : null;
    }

    private Path convertToNioFileAndCheck(VirtualFile file2, boolean assertSlowOp) throws NoSuchFileException {
        if (assertSlowOp) {
            SlowOperations.assertSlowOperationsAreAllowed();
        }
        if (SystemInfo.isUnix && file2.is(VFileProperty.SPECIAL)) {
            throw new NoSuchFileException(file2.getPath(), null, "Not a file");
        }
        Path path = this.getNioPath(file2);
        if (path == null) {
            throw new NoSuchFileException(file2.getPath());
        }
        return path;
    }

    public boolean exists(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(6);
        }
        return this.getAttributes(file2) != null;
    }

    public long getLength(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(7);
        }
        return (attributes = this.getAttributes(file2)) != null ? attributes.length : 0L;
    }

    public long getTimeStamp(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(8);
        }
        return (attributes = this.getAttributes(file2)) != null ? attributes.lastModified : 0L;
    }

    public boolean isDirectory(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(9);
        }
        return (attributes = this.getAttributes(file2)) != null && attributes.isDirectory();
    }

    public boolean isWritable(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(10);
        }
        return (attributes = this.getAttributes(file2)) != null && attributes.isWritable();
    }

    public boolean isSymLink(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(11);
        }
        return (attributes = this.getAttributes(file2)) != null && attributes.isSymLink();
    }

    @Nullable
    public String resolveSymLink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(12);
        }
        try {
            return this.convertToNioFileAndCheck(file2, false).toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String @NotNull [] list(@NotNull VirtualFile dir) {
        if (dir == null) {
            LocalFileSystemBase.$$$reportNull$$$0(13);
        }
        Path nioFile = Path.of(LocalFileSystemBase.toIoPath(dir), new String[0]);
        String[] stringArray = (String[])NioFiles.list((Path)nioFile).stream().map(NioFiles::getFileName).toArray(String[]::new);
        if (stringArray == null) {
            LocalFileSystemBase.$$$reportNull$$$0(14);
        }
        return stringArray;
    }

    @NotNull
    public String getProtocol() {
        return "file";
    }

    public boolean isReadOnly() {
        return false;
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        if (path == null) {
            LocalFileSystemBase.$$$reportNull$$$0(15);
        }
        if (SystemInfoRt.isWindows) {
            if (path.length() > 1 && path.charAt(0) == '/' && path.charAt(1) != '/') {
                path = path.substring(1);
            }
            try {
                path = FileUtil.resolveShortWindowsName((String)path);
            }
            catch (IOException e) {
                return null;
            }
        }
        try {
            Path file2 = Path.of(path, new String[0]);
            if (!(file2.isAbsolute() || SystemInfo.isWindows && path.length() == 2 && OSAgnosticPathUtil.startsWithWindowsDrive((String)path))) {
                path = file2.toAbsolutePath().toString();
            }
        }
        catch (IOError | InvalidPathException e) {
            Logger.getInstance(((Object)((Object)this)).getClass()).trace(e);
            return null;
        }
        return FileUtil.normalize((String)path);
    }

    public void refreshIoFiles(@NotNull Iterable<? extends File> files2, boolean async2, boolean recursive, @Nullable Runnable onFinish2) {
        if (files2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(16);
        }
        this.refreshFiles(ContainerUtil.mapNotNull(files2, arg_0 -> ((LocalFileSystemBase)this).refreshAndFindFileByIoFile(arg_0)), async2, recursive, onFinish2);
    }

    public void refreshNioFiles(@NotNull Iterable<? extends Path> files2, boolean async2, boolean recursive, @Nullable Runnable onFinish2) {
        if (files2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(17);
        }
        this.refreshFiles(ContainerUtil.mapNotNull(files2, arg_0 -> ((LocalFileSystemBase)this).refreshAndFindFileByNioFile(arg_0)), async2, recursive, onFinish2);
    }

    public void refreshFiles(@NotNull Iterable<? extends VirtualFile> files2, boolean async2, boolean recursive, @Nullable Runnable onFinish2) {
        if (files2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(18);
        }
        RefreshQueue.getInstance().refresh(async2, recursive, onFinish2, ContainerUtil.toCollection(files2));
    }

    public void registerAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler) {
        if (handler == null) {
            LocalFileSystemBase.$$$reportNull$$$0(19);
        }
        if (this.myHandlers.contains(handler)) {
            LOG.error("Handler " + String.valueOf(handler) + " already registered.");
        }
        this.myHandlers.add(handler);
    }

    public void unregisterAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler) {
        if (handler == null) {
            LocalFileSystemBase.$$$reportNull$$$0(20);
        }
        if (!this.myHandlers.remove(handler)) {
            LOG.error("Handler " + String.valueOf(handler) + " haven't been registered or already unregistered.");
        }
    }

    private Iterable<LocalFileOperationsHandler> handlers() {
        return ContainerUtil.concat((Iterable)FILE_OPERATIONS_HANDLER_EP_NAME.getIterable(), this.myHandlers);
    }

    private boolean auxDelete(VirtualFile file2) throws IOException {
        for (LocalFileOperationsHandler handler : this.handlers()) {
            if (!handler.delete(file2)) continue;
            return true;
        }
        return false;
    }

    private boolean auxMove(VirtualFile file2, VirtualFile toDir) throws IOException {
        for (LocalFileOperationsHandler handler : this.handlers()) {
            if (!handler.move(file2, toDir)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCopy(VirtualFile file2, VirtualFile toDir, String copyName) throws IOException {
        for (LocalFileOperationsHandler handler : this.handlers()) {
            if (handler.copy(file2, toDir, copyName) == null) continue;
            return true;
        }
        return false;
    }

    private boolean auxRename(VirtualFile file2, String newName) throws IOException {
        for (LocalFileOperationsHandler handler : this.handlers()) {
            if (!handler.rename(file2, newName)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateFile(VirtualFile dir, String name2) throws IOException {
        for (LocalFileOperationsHandler handler : this.handlers()) {
            if (!handler.createFile(dir, name2)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateDirectory(VirtualFile dir, String name2) throws IOException {
        for (LocalFileOperationsHandler handler : this.handlers()) {
            if (!handler.createDirectory(dir, name2)) continue;
            return true;
        }
        return false;
    }

    private void auxNotifyCompleted(ThrowableConsumer<LocalFileOperationsHandler, IOException> consumer) {
        for (LocalFileOperationsHandler handler : this.handlers()) {
            handler.afterDone(consumer);
        }
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String name2) throws IOException {
        if (parent == null) {
            LocalFileSystemBase.$$$reportNull$$$0(21);
        }
        if (name2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(22);
        }
        if (!this.isValidName(name2)) {
            throw new IOException(CoreBundle.message((String)"directory.invalid.name.error", (Object[])new Object[]{name2}));
        }
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException(IdeCoreBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{parent.getPath()}));
        }
        if (parent.findChild(name2) != null) {
            throw new IOException(IdeCoreBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + name2}));
        }
        if (!this.auxCreateDirectory(parent, name2)) {
            Path nioFile = this.convertToNioFileAndCheck(parent, false).resolve(name2);
            NioFiles.createDirectories((Path)nioFile);
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler -> handler.createDirectory(parent, name2)));
        return new FakeVirtualFile(parent, name2);
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String name2) throws IOException {
        if (parent == null) {
            LocalFileSystemBase.$$$reportNull$$$0(23);
        }
        if (name2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(24);
        }
        if (!this.isValidName(name2)) {
            throw new IOException(CoreBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{name2}));
        }
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException(IdeCoreBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{parent.getPath()}));
        }
        if (!this.auxCreateFile(parent, name2)) {
            Path nioFile = this.convertToNioFileAndCheck(parent, false).resolve(name2);
            VirtualFile existing = parent.findChild(name2);
            NioFiles.createIfNotExists((Path)nioFile);
            if (existing != null) {
                VFilePropertyChangeEvent event;
                boolean knownCS = parent.isCaseSensitive();
                FileAttributes.CaseSensitivity actualCS = this.fetchCaseSensitivity(parent, name2);
                if (actualCS.isKnown() && actualCS.isSensitive() != knownCS && (event = ((PersistentFSImpl)PersistentFS.getInstance()).prepareCaseSensitivityUpdateIfNeeded((VirtualDirectoryImpl)parent, actualCS.toBooleanOrFail())) != null) {
                    RefreshQueue.getInstance().processEvents(false, List.of(event));
                }
            }
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler -> handler.createFile(parent, name2)));
        return new FakeVirtualFile(parent, name2);
    }

    @ApiStatus.Internal
    @NotNull
    public FileAttributes.CaseSensitivity fetchCaseSensitivity(@NotNull VirtualFile parent, @NotNull String childName) {
        EelPath eelPath;
        if (parent == null) {
            LocalFileSystemBase.$$$reportNull$$$0(25);
        }
        if (childName == null) {
            LocalFileSystemBase.$$$reportNull$$$0(26);
        }
        if (Registry.is((String)"vfs.fetch.case.sensitivity.using.eel", (boolean)false) && (eelPath = LocalFileSystemEelUtil.toEelPath(parent, childName)) != null && (!(eelPath.getDescriptor() instanceof LocalEelDescriptor) || Registry.is((String)"vfs.fetch.case.sensitivity.using.eel.local", (boolean)false))) {
            FileAttributes.CaseSensitivity caseSensitivity = LocalFileSystemEelUtil.fetchCaseSensitivityUsingEel(eelPath);
            if (caseSensitivity == null) {
                LocalFileSystemBase.$$$reportNull$$$0(27);
            }
            return caseSensitivity;
        }
        FileAttributes.CaseSensitivity caseSensitivity = FileSystemUtil.readParentCaseSensitivity((File)new File(parent.getPath(), childName));
        if (caseSensitivity == null) {
            LocalFileSystemBase.$$$reportNull$$$0(28);
        }
        return caseSensitivity;
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(29);
        }
        if (file2.getParent() == null) {
            throw new IOException(IdeCoreBundle.message((String)"cannot.delete.root.directory", (Object[])new Object[]{file2.getPath()}));
        }
        if (!this.auxDelete(file2)) {
            Path nioFile = this.convertToNioFileAndCheck(file2, false);
            NioFiles.deleteRecursively((Path)nioFile);
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler -> handler.delete(file2)));
    }

    public boolean isCaseSensitive() {
        return SystemInfo.isFileSystemCaseSensitive;
    }

    public boolean isValidName(@NotNull String name2) {
        if (name2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(30);
        }
        return PathUtilRt.isValidFileName((String)name2, (boolean)false);
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(31);
        }
        Path path = this.convertToNioFileAndCheck(file2, true);
        return new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
    }

    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(32);
        }
        Path nioFile = this.convertToNioFileAndCheck(file2, true);
        return LocalFileSystemBase.readIfNotTooLarge(nioFile);
    }

    protected static byte @NotNull [] readIfNotTooLarge(Path nioFile) throws IOException {
        byte[] maybeContent = LocalFileSystemEelUtil.readWholeFileIfNotTooLargeWithEel(nioFile);
        if (maybeContent != null) {
            if (maybeContent == null) {
                LocalFileSystemBase.$$$reportNull$$$0(33);
            }
            return maybeContent;
        }
        long length = Files.size(nioFile);
        if (FileSizeLimit.isTooLarge((long)length, (String)FileUtilRt.getExtension((String)nioFile.getFileName().toString()))) {
            throw new FileTooBigException("File " + String.valueOf(nioFile.toAbsolutePath()) + " is too large (=" + length + " b)");
        }
        byte[] byArray = Files.readAllBytes(nioFile);
        if (byArray == null) {
            LocalFileSystemBase.$$$reportNull$$$0(34);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file2, Object requestor, long modStamp, long l) throws IOException {
        void timeStamp;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(35);
        }
        Path path = this.convertToNioFileAndCheck(file2, false);
        OutputStream stream = !SafeWriteRequestor.shouldUseSafeWrite((Object)requestor) ? Files.newOutputStream(path, new OpenOption[0]) : (requestor instanceof LargeFileWriteRequestor ? new PreemptiveSafeFileOutputStream(path) : new SafeFileOutputStream(path));
        return new BufferedOutputStream(this, stream, (long)timeStamp, path){
            final /* synthetic */ long val$timeStamp;
            final /* synthetic */ Path val$path;
            {
                this.val$timeStamp = l;
                this.val$path = path;
                super(arg0);
            }

            @Override
            public void close() throws IOException {
                super.close();
                if (this.val$timeStamp > 0L && Files.exists(this.val$path, new LinkOption[0])) {
                    Files.setLastModifiedTime(this.val$path, FileTime.fromMillis(this.val$timeStamp));
                }
            }
        };
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(36);
        }
        if (newParent == null) {
            LocalFileSystemBase.$$$reportNull$$$0(37);
        }
        String name2 = file2.getName();
        if (!file2.exists()) {
            throw new IOException(IdeCoreBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        if (file2.getParent() == null) {
            throw new IOException(CoreBundle.message((String)"cannot.rename.root.directory", (Object[])new Object[]{file2.getPath()}));
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new IOException(IdeCoreBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{newParent.getPath()}));
        }
        if (newParent.findChild(name2) != null) {
            throw new IOException(IdeCoreBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{newParent.getPath() + "/" + name2}));
        }
        if (!this.auxMove(file2, newParent)) {
            Path nioFile = this.convertToNioFileAndCheck(file2, false);
            Path nioTarget = this.convertToNioFileAndCheck(newParent, false).resolve(nioFile.getFileName());
            try {
                Files.move(nioFile, nioTarget, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                Files.move(nioFile, nioTarget, new CopyOption[0]);
            }
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler -> handler.move(file2, newParent)));
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        boolean sameName;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(38);
        }
        if (newName == null) {
            LocalFileSystemBase.$$$reportNull$$$0(39);
        }
        if (!this.isValidName(newName)) {
            throw new IOException(CoreBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{newName}));
        }
        if (!file2.exists()) {
            throw new IOException(IdeCoreBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        VirtualFile parent = file2.getParent();
        if (parent == null) {
            throw new IOException(CoreBundle.message((String)"cannot.rename.root.directory", (Object[])new Object[]{file2.getPath()}));
        }
        boolean bl = sameName = !file2.isCaseSensitive() && newName.equalsIgnoreCase(file2.getName());
        if (!sameName && parent.findChild(newName) != null) {
            throw new IOException(IdeCoreBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + newName}));
        }
        if (!this.auxRename(file2, newName)) {
            Path nioFile = this.convertToNioFileAndCheck(file2, false);
            Path nioTarget = nioFile.resolveSibling(newName);
            try {
                Files.move(nioFile, nioTarget, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                Files.move(nioFile, nioTarget, new CopyOption[0]);
            }
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler -> handler.rename(file2, newName)));
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String newName) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(40);
        }
        if (newParent == null) {
            LocalFileSystemBase.$$$reportNull$$$0(41);
        }
        if (newName == null) {
            LocalFileSystemBase.$$$reportNull$$$0(42);
        }
        if (!this.isValidName(newName)) {
            throw new IOException(CoreBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{newName}));
        }
        if (!file2.exists()) {
            throw new IOException(IdeCoreBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new IOException(IdeCoreBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{newParent.getPath()}));
        }
        if (newParent.findChild(newName) != null) {
            throw new IOException(IdeCoreBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{newParent.getPath() + "/" + newName}));
        }
        if (!this.auxCopy(file2, newParent, newName)) {
            Path nioFile = this.convertToNioFileAndCheck(file2, false);
            Path nioTarget = this.convertToNioFileAndCheck(newParent, false).resolve(newName);
            NioFiles.copyRecursively((Path)nioFile, (Path)nioTarget);
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler -> handler.copy(file2, newParent, newName)));
        return new FakeVirtualFile(newParent, newName);
    }

    public void setTimeStamp(@NotNull VirtualFile file2, long timeStamp) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(43);
        }
        Path nioFile = this.convertToNioFileAndCheck(file2, false);
        Files.setLastModifiedTime(nioFile, FileTime.fromMillis(timeStamp));
    }

    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(44);
        }
        Path nioFile = this.convertToNioFileAndCheck(file2, false);
        NioFiles.setReadOnly((Path)nioFile, (!writableFlag ? 1 : 0) != 0);
    }

    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        String rootPath;
        if (normalizedPath == null) {
            LocalFileSystemBase.$$$reportNull$$$0(45);
        }
        if (EXTRACT_ROOTS_USING_NIO.booleanValue()) {
            String normalizedPathRootString = Path.of(normalizedPath, new String[0]).getRoot().toString();
            for (Path root : FileSystems.getDefault().getRootDirectories()) {
                String stringRoot = root.toString();
                if (!normalizedPathRootString.equals(stringRoot)) continue;
                if (stringRoot.length() > 1 && (stringRoot.endsWith("\\") || stringRoot.endsWith("/"))) {
                    stringRoot = stringRoot.substring(0, stringRoot.length() - 1);
                }
                if (PathUtilRt.isWindowsUNCRoot((CharSequence)stringRoot, (int)normalizedPath.indexOf(47, 2))) {
                    stringRoot = stringRoot.replace('\\', '/');
                }
                String string = stringRoot;
                if (string == null) {
                    LocalFileSystemBase.$$$reportNull$$$0(46);
                }
                return string;
            }
        }
        return (rootPath = FileUtil.extractRootPath((String)normalizedPath)) != null ? rootPath : "";
    }

    public int getRank() {
        return 1;
    }

    public boolean markNewFilesAsDirty() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getCanonicallyCasedName(@NotNull VirtualFile file2) {
        String string;
        long t;
        block31: {
            String string2;
            block29: {
                String string3;
                block28: {
                    String string4;
                    block27: {
                        VirtualFile parent;
                        if (file2 == null) {
                            LocalFileSystemBase.$$$reportNull$$$0(47);
                        }
                        if ((parent = file2.getParent()) == null || parent.isCaseSensitive()) {
                            String string5 = super.getCanonicallyCasedName(file2);
                            if (string5 == null) {
                                LocalFileSystemBase.$$$reportNull$$$0(48);
                            }
                            return string5;
                        }
                        String originalFileName = file2.getName();
                        t = LOG.isTraceEnabled() ? System.nanoTime() : 0L;
                        try {
                            Path nioFile = this.convertToNioFileAndCheck(file2, false);
                            if (SystemInfo.isWindows) {
                                String string6 = nioFile.toRealPath(LinkOption.NOFOLLOW_LINKS).getFileName().toString();
                                string4 = string6;
                                break block27;
                            }
                            Path realPath = nioFile.toRealPath(new LinkOption[0]);
                            if (realPath.toString().equalsIgnoreCase(file2.getPath())) {
                                String string7 = realPath.getFileName().toString();
                                string3 = string7;
                                break block28;
                            }
                            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.convertToNioFileAndCheck(parent, false));){
                                for (Path path : stream) {
                                    String name2 = path.getFileName().toString();
                                    if (!originalFileName.equalsIgnoreCase(name2) && (!Normalizer.isNormalized(originalFileName, Normalizer.Form.NFC) || !originalFileName.equalsIgnoreCase(Normalizer.normalize(name2, Normalizer.Form.NFC)))) continue;
                                    String string8 = name2;
                                    string2 = string8;
                                    break block29;
                                }
                            }
                            String string9 = originalFileName;
                            string = string9;
                            break block31;
                        }
                        catch (IOException | InvalidPathException e) {
                            LOG.trace((Throwable)e);
                            String string10 = originalFileName;
                            String string11 = string10;
                            if (string11 == null) {
                                LocalFileSystemBase.$$$reportNull$$$0(53);
                            }
                            return string11;
                        }
                    }
                    if (string4 == null) {
                        LocalFileSystemBase.$$$reportNull$$$0(49);
                    }
                    return string4;
                }
                if (string3 == null) {
                    LocalFileSystemBase.$$$reportNull$$$0(50);
                }
                return string3;
            }
            if (string2 == null) {
                LocalFileSystemBase.$$$reportNull$$$0(51);
            }
            return string2;
        }
        if (string == null) {
            LocalFileSystemBase.$$$reportNull$$$0(52);
        }
        return string;
        finally {
            if (t != 0L) {
                t = (System.nanoTime() - t) / 1000L;
                LOG.trace("getCanonicallyCasedName(" + String.valueOf(file2) + "): " + t + " mks");
            }
        }
    }

    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(54);
        }
        try {
            Path nioFile = Path.of(LocalFileSystemBase.toIoPath(file2), new String[0]);
            BasicFileAttributes nioAttributes = Files.readAttributes(nioFile, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            return FileAttributes.fromNio((Path)nioFile, (BasicFileAttributes)nioAttributes);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void refresh(boolean asynchronous) {
        RefreshQueue.getInstance().refresh(asynchronous, true, null, ManagingFS.getInstance().getRoots((NewVirtualFileSystem)this));
    }

    public boolean hasChildren(@NotNull VirtualFile file2) {
        boolean bl;
        block11: {
            if (file2 == null) {
                LocalFileSystemBase.$$$reportNull$$$0(55);
            }
            if (file2.getParent() == null) {
                return true;
            }
            DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(file2.getPath(), new String[0]));
            try {
                bl = stream.iterator().hasNext();
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DirectoryIteratorException e) {
                    return false;
                }
                catch (IOException | SecurityException | InvalidPathException e) {
                    return true;
                }
            }
            stream.close();
        }
        return bl;
    }

    @TestOnly
    public void cleanupForNextTest() {
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 14, 27, 28, 33, 34, 46, 48, 49, 50, 51, 52, 53 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 44: 
            case 47: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 14: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 22: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toIoPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchCaseSensitivity";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "readIfNotTooLarge";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRootPath";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicallyCasedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toIoPath";
                break;
            }
            case 4: 
            case 14: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNioPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "refreshIoFiles";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "refreshNioFiles";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "refreshFiles";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerAuxiliaryFileOperationsHandler";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAuxiliaryFileOperationsHandler";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fetchCaseSensitivity";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicallyCasedName";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 14, 27, 28, 33, 34, 46, 48, 49, 50, 51, 52, 53 -> new IllegalStateException(string);
        };
    }
}

