/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemEelUtil;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.OwnedBuilder;
import com.intellij.platform.eel.fs.EelFileInfo;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFileSystemApiHelpersKt;
import com.intellij.platform.eel.fs.EelFileSystemPosixApi;
import com.intellij.platform.eel.fs.EelFileSystemPosixApiHelpersKt;
import com.intellij.platform.eel.fs.EelPosixFileInfo;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.eel.provider.EelMachineProviderUtil;
import com.intellij.platform.eel.provider.EelMountProviderKt;
import com.intellij.platform.eel.provider.EelMountRoot;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.platform.eel.provider.utils.EelUtilsKt;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystemUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.IoKt;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0000\u001a\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0000\u001a,\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\u00162\u0006\u0010\u0017\u001a\u00020\f2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0019H\u0000\u001a@\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00192\u001e\u0010\u001d\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001eH\u0002\u001a\u0012\u0010\"\u001a\u00020!*\u00020\u001f2\u0006\u0010#\u001a\u00020 \u001a\u0012\u0010$\u001a\u00020\u0013*\u00020%2\u0006\u0010\"\u001a\u00020!\"3\u0010\u0000\u001a'\u0012\u000e\u0012\f0\u0002\u00a2\u0006\u0002\b\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000e\u0012\f0\u0005\u00a2\u0006\u0002\b\u0003\u00a2\u0006\u0002\b\u00040\u0001\u00a2\u0006\u0002\b\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"map", "Ljava/util/concurrent/ConcurrentMap;", "Ljava/nio/file/Path;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/platform/eel/EelApi;", "readWholeFileIfNotTooLargeWithEel", "", "path", "toEelPath", "Lcom/intellij/platform/eel/path/EelPath;", "parent", "Lcom/intellij/openapi/vfs/VirtualFile;", "childName", "", "fetchCaseSensitivityUsingEel", "Lcom/intellij/openapi/util/io/FileAttributes$CaseSensitivity;", "eelPath", "readAttributesUsingEel", "Lcom/intellij/openapi/util/io/FileAttributes;", "nioPath", "listWithAttributesUsingEel", "", "dir", "filter", "", "visitDirectory", "", "directory", "consumer", "Lkotlin/Function3;", "Lcom/intellij/platform/eel/fs/EelPosixFileInfo;", "Lcom/intellij/platform/eel/fs/EelFileSystemPosixApi;", "", "isWritable", "eelFsApi", "toVfs", "Lcom/intellij/platform/eel/fs/EelFileInfo;", "intellij.platform.ide.impl"})
@JvmName(name="LocalFileSystemEelUtil")
public final class LocalFileSystemEelUtil {
    @NotNull
    private static final ConcurrentMap<Path, EelApi> map;

    @Nullable
    public static final byte[] readWholeFileIfNotTooLargeWithEel(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!Registry.Companion.is("vfs.try.eel.for.content.loading", false)) {
            return null;
        }
        Path path2 = path.getRoot();
        if (path2 == null) {
            return null;
        }
        Path root = path2;
        EelDescriptor eelDescriptor = EelProviderUtil.getEelDescriptor((Path)root);
        if (Intrinsics.areEqual((Object)eelDescriptor, (Object)LocalEelDescriptor.INSTANCE)) {
            return null;
        }
        EelApi api2 = map.computeIfAbsent(root, arg_0 -> LocalFileSystemEelUtil.readWholeFileIfNotTooLargeWithEel$lambda$1(arg_0 -> LocalFileSystemEelUtil.readWholeFileIfNotTooLargeWithEel$lambda$0(root, arg_0), arg_0));
        EelPath eelPath = EelNioBridgeServiceKt.asEelPath((Path)path);
        int limit = FileSizeLimit.Companion.getContentLoadLimit(FileUtilRt.getExtension((String)((Object)path.getFileName()).toString()));
        EelFileSystemApi.ReadFileResult result2 = (EelFileSystemApi.ReadFileResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EelFileSystemApi.ReadFileResult>, Object>(api2, eelPath, limit, null){
            int label;
            final /* synthetic */ EelApi $api;
            final /* synthetic */ EelPath $eelPath;
            final /* synthetic */ int $limit;
            {
                this.$api = $api;
                this.$eelPath = $eelPath;
                this.$limit = $limit;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = EelUtilsKt.getOrThrowFileSystemException((OwnedBuilder)((OwnedBuilder)EelFileSystemApiHelpersKt.readFile((EelFileSystemApi)this.$api.getFs(), (EelPath)this.$eelPath).limit(Boxing.boxInt((int)this.$limit)).failFastIfBeyondLimit(true)), (Continuation)((Continuation)this));
                        Object object3 = object2;
                        if (object2 != object) return (EelFileSystemApi.ReadFileResult)object3;
                        return object;
                    }
                    case 1: {
                        Object object3;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return (EelFileSystemApi.ReadFileResult)object3;
                        }
                        catch (FileSystemException err) {
                            Throwable throwable;
                            Throwable it = throwable = err.getCause();
                            boolean bl = false;
                            Throwable throwable2 = it instanceof FileTooBigException ? throwable : null;
                            Throwable throwable3 = throwable2;
                            if (throwable2 != null) throw throwable3;
                            throwable3 = err;
                            throw throwable3;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super EelFileSystemApi.ReadFileResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return IoKt.toByteArray$default((ByteBuffer)result2.getBytes(), (boolean)false, (int)1, null);
    }

    @Nullable
    public static final EelPath toEelPath(@NotNull VirtualFile parent, @NotNull String childName) {
        EelPath eelPath;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)childName, (String)"childName");
        try {
            Path path = parent.toNioPath().resolve(childName);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            eelPath = EelNioBridgeServiceKt.asEelPath((Path)path);
        }
        catch (Exception err) {
            Exception exception = err;
            if (!(exception instanceof UnsupportedOperationException || exception instanceof InvalidPathException || exception instanceof EelPathException)) {
                throw err;
            }
            eelPath = null;
        }
        return eelPath;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final FileAttributes.CaseSensitivity fetchCaseSensitivityUsingEel(@NotNull EelPath eelPath) {
        Intrinsics.checkNotNullParameter((Object)eelPath, (String)"eelPath");
        var2_1 = EelNioBridgeServiceKt.mountProvider((EelDescriptor)eelPath.getDescriptor());
        if (var2_1 == null || (var3_2 = var2_1.getMountRoot(eelPath)) == null) ** GOTO lbl-1000
        it = var5_3 = var3_2;
        $i$a$-takeIf-LocalFileSystemEelUtil$fetchCaseSensitivityUsingEel$directAccessPath$1 = false;
        v0 /* !! */  = var4_6 = (Boolean)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(it, null){
            int label;
            final /* synthetic */ EelMountRoot $it;
            {
                this.$it = $it;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = EelMountProviderKt.canReadPermissionsDirectly((EelMountRoot)this.$it, (EelMountRoot.DirectAccessOptions)((EelMountRoot.DirectAccessOptions)EelMountRoot.DirectAccessOptions.CaseSensitivity.INSTANCE), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null) != false ? var5_3 : null;
        if (var4_6 != null) {
            v1 = EelMountProviderKt.transformPath((EelMountRoot)var4_6, (EelPath)eelPath);
        } else lbl-1000:
        // 2 sources

        {
            v1 = directAccessPath = null;
        }
        if (directAccessPath == null || !Intrinsics.areEqual((Object)directAccessPath.getDescriptor(), (Object)LocalEelDescriptor.INSTANCE)) ** GOTO lbl25
        if (Registry.Companion.is("vfs.fetch.case.sensitivity.using.eel.local")) {
            v2 = directAccessPath;
        } else {
            v3 = directAccessPath.getParent();
            v4 = v3 != null && (v3 = EelNioBridgeServiceKt.asNioPath((EelPath)v3)) != null ? v3.toFile() : (ioFile = null);
            if (ioFile != null) {
                var4_6 = FileSystemUtil.readParentCaseSensitivity((File)ioFile);
                Intrinsics.checkNotNull((Object)var4_6);
                v5 = var4_6;
            } else {
                v5 = FileAttributes.CaseSensitivity.UNKNOWN;
            }
            return v5;
lbl25:
            // 1 sources

            v2 = eelPath;
        }
        eelPathToCheck = v2;
        return (FileAttributes.CaseSensitivity)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FileAttributes.CaseSensitivity>, Object>(eelPathToCheck, null){
            Object L$0;
            int label;
            final /* synthetic */ EelPath $eelPathToCheck;
            {
                this.$eelPathToCheck = $eelPathToCheck;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = EelMachineProviderUtil.toEelApi((EelDescriptor)this.$eelPathToCheck.getDescriptor(), (Continuation)((Continuation)this));
                        if (v0 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        eelApi = (EelApi)v0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)eelApi);
                        this.label = 2;
                        v1 = EelFileSystemApiHelpersKt.stat((EelFileSystemApi)eelApi.getFs(), (EelPath)this.$eelPathToCheck).doNotResolve().eelIt((Continuation)this);
                        if (v1 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        eelApi = (EelApi)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        $this$getOr$iv = (EelResult)v1;
                        $i$f$getOr = false;
                        var6_7 = $this$getOr$iv;
                        if (!(var6_7 instanceof EelResult.Ok)) {
                            if (var6_7 instanceof EelResult.Error) {
                                it = (EelResult.Error)$this$getOr$iv;
                                $i$a$-getOr-LocalFileSystemEelUtil$fetchCaseSensitivityUsingEel$1$stat$1 = false;
                                return FileAttributes.CaseSensitivity.UNKNOWN;
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                        stat = (EelFileInfo)((EelResult.Ok)$this$getOr$iv).getValue();
                        type = stat.getType();
                        if (!(type instanceof EelFileInfo.Type.Directory)) ** GOTO lbl48
                        switch (fetchCaseSensitivityUsingEel.WhenMappings.$EnumSwitchMapping$0[((EelFileInfo.Type.Directory)type).getSensitivity().ordinal()]) {
                            case 1: {
                                v2 = FileAttributes.CaseSensitivity.SENSITIVE;
                                ** GOTO lbl52
                            }
                            case 2: {
                                v2 = FileAttributes.CaseSensitivity.INSENSITIVE;
                                ** GOTO lbl52
                            }
                            case 3: {
                                v2 = FileAttributes.CaseSensitivity.UNKNOWN;
                                ** GOTO lbl52
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
lbl48:
                        // 1 sources

                        if (type instanceof EelFileInfo.Type.Other || type instanceof EelFileInfo.Type.Regular || type instanceof EelPosixFileInfo.Type.Symlink) {
                            v2 = FileAttributes.CaseSensitivity.UNKNOWN;
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
lbl52:
                        // 4 sources

                        return v2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super FileAttributes.CaseSensitivity> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final FileAttributes readAttributesUsingEel(@NotNull Path nioPath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)nioPath, (String)"nioPath");
        eelDescriptor = EelProviderUtil.getEelDescriptor((Path)nioPath);
        if (Intrinsics.areEqual((Object)eelDescriptor, (Object)LocalEelDescriptor.INSTANCE)) {
            var3_2 = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
            nioAttributes = Files.readAttributes(nioPath, BasicFileAttributes.class, var3_2);
            v0 = FileAttributes.fromNio((Path)nioPath, (BasicFileAttributes)nioAttributes);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"fromNio(...)");
            return v0;
        }
        eelPath = EelNioBridgeServiceKt.asEelPath((Path)nioPath, (EelDescriptor)eelDescriptor);
        var4_6 = EelNioBridgeServiceKt.mountProvider((EelDescriptor)eelPath.getDescriptor());
        if (var4_6 == null || (var5_7 = var4_6.getMountRoot(eelPath)) == null) ** GOTO lbl-1000
        it = var7_8 = var5_7;
        $i$a$-takeIf-LocalFileSystemEelUtil$readAttributesUsingEel$directAccessPath$1 = false;
        v1 /* !! */  = var6_11 = (Boolean)IjentNioFileSystemUtil.fsBlocking((Function1)((Function1)new Function1<Continuation<? super Boolean>, Object>((EelMountRoot)it, null){
            int label;
            final /* synthetic */ EelMountRoot $it;
            {
                this.$it = $it;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = EelMountProviderKt.canReadPermissionsDirectly((EelMountRoot)this.$it, (EelMountRoot.DirectAccessOptions)((EelMountRoot.DirectAccessOptions)EelMountRoot.DirectAccessOptions.BasicAttributesAndWritable.INSTANCE), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Boolean> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        })) != false ? var7_8 : null;
        if (var6_11 != null) {
            v2 = EelMountProviderKt.transformPath((EelMountRoot)var6_11, (EelPath)eelPath);
        } else lbl-1000:
        // 2 sources

        {
            v2 = directAccessPath = null;
        }
        if (directAccessPath != null && Intrinsics.areEqual((Object)directAccessPath.getDescriptor(), (Object)LocalEelDescriptor.INSTANCE)) {
            directAccessNioPath = EelNioBridgeServiceKt.asNioPath(directAccessPath);
            var6_11 = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
            nioAttributes = Files.readAttributes(directAccessNioPath, BasicFileAttributes.class, var6_11);
            v3 = FileAttributes.fromNio((Path)directAccessNioPath, (BasicFileAttributes)nioAttributes);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"fromNio(...)");
            return v3;
        }
        return (FileAttributes)IjentNioFileSystemUtil.fsBlocking((Function1)((Function1)new Function1<Continuation<? super FileAttributes>, Object>(eelPath, null){
            Object L$0;
            int label;
            final /* synthetic */ EelPath $eelPath;
            {
                this.$eelPath = $eelPath;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block7: {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = EelMachineProviderUtil.toEelApi((EelDescriptor)this.$eelPath.getDescriptor(), (Continuation)((Continuation)this));
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if (!((eelFsApi = ((EelApi)v0).getFs()) instanceof EelFileSystemPosixApi)) break;
                            this.L$0 = eelFsApi;
                            this.label = 2;
                            v1 = EelFileSystemPosixApiHelpersKt.stat((EelFileSystemPosixApi)((EelFileSystemPosixApi)eelFsApi), (EelPath)this.$eelPath).eelIt((Continuation)this);
                            if (v1 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl24
                        }
                        case 2: {
                            eelFsApi = (EelFileSystemApi)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl24:
                            // 2 sources

                            fileInfo = (EelPosixFileInfo)EelUtilsKt.getOrThrowFileSystemException((EelResult)((EelResult)v1));
                            break block7;
                        }
                    }
                    throw new NotImplementedError(null, 1, null);
                }
                return LocalFileSystemEelUtil.toVfs((EelFileInfo)fileInfo, LocalFileSystemEelUtil.isWritable(fileInfo, (EelFileSystemPosixApi)eelFsApi));
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super FileAttributes> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final Map<String, FileAttributes> listWithAttributesUsingEel(@NotNull VirtualFile dir, @Nullable Set<String> filter) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!dir.isDirectory()) {
            return MapsKt.emptyMap();
        }
        try {
            nioPath = Path.of(LocalFileSystemBase.toIoPath(dir), new String[0]);
            Intrinsics.checkNotNull((Object)nioPath);
            eelDescriptor = EelProviderUtil.getEelDescriptor((Path)nioPath);
            if (eelDescriptor == LocalEelDescriptor.INSTANCE) {
                v0 = LocalFileSystemImpl.listWithAttributesImpl(nioPath, filter);
                Intrinsics.checkNotNullExpressionValue(v0, (String)"listWithAttributesImpl(...)");
                return v0;
            }
            eelPath = EelNioBridgeServiceKt.asEelPath((Path)nioPath, (EelDescriptor)eelDescriptor);
            var6_9 = EelNioBridgeServiceKt.mountProvider((EelDescriptor)eelPath.getDescriptor());
            if (var6_9 == null || (var7_11 = var6_9.getMountRoot(eelPath)) == null) ** GOTO lbl-1000
            it = var9_12 = var7_11;
            $i$a$-takeIf-LocalFileSystemEelUtil$listWithAttributesUsingEel$directAccessPath$1 = false;
            v1 /* !! */  = var8_15 = (Boolean)IjentNioFileSystemUtil.fsBlocking((Function1)((Function1)new Function1<Continuation<? super Boolean>, Object>(it, null){
                int label;
                final /* synthetic */ EelMountRoot $it;
                {
                    this.$it = $it;
                    super(1, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = EelMountProviderKt.canReadPermissionsDirectly((EelMountRoot)this.$it, (EelMountRoot.DirectAccessOptions)((EelMountRoot.DirectAccessOptions)EelMountRoot.DirectAccessOptions.BasicAttributesAndWritable.INSTANCE), (Continuation)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super Boolean> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            })) != false ? var9_12 : null;
            if (var8_15 != null) {
                v2 = EelMountProviderKt.transformPath((EelMountRoot)var8_15, (EelPath)eelPath);
            } else lbl-1000:
            // 2 sources

            {
                v2 = directAccessPath = null;
            }
            if (directAccessPath != null && directAccessPath.getDescriptor() == LocalEelDescriptor.INSTANCE) {
                v3 = LocalFileSystemImpl.listWithAttributesImpl(EelNioBridgeServiceKt.asNioPath(directAccessPath), filter);
                Intrinsics.checkNotNullExpressionValue(v3, (String)"listWithAttributesImpl(...)");
                return v3;
            }
            v4 = filter;
            expectedSize = v4 != null ? v4.size() : 10;
            v5 = CollectionFactory.createFilePathMap((int)expectedSize, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"createFilePathMap(...)");
            childrenWithAttributes = v5;
            LocalFileSystemEelUtil.visitDirectory(eelPath, filter, (Function3<? super EelPath, ? super EelPosixFileInfo, ? super EelFileSystemPosixApi, Boolean>)(Function3)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, listWithAttributesUsingEel$lambda$1(java.util.Map com.intellij.platform.eel.path.EelPath com.intellij.platform.eel.fs.EelPosixFileInfo com.intellij.platform.eel.fs.EelFileSystemPosixApi ), (Lcom/intellij/platform/eel/path/EelPath;Lcom/intellij/platform/eel/fs/EelPosixFileInfo;Lcom/intellij/platform/eel/fs/EelFileSystemPosixApi;)Ljava/lang/Boolean;)((Map)childrenWithAttributes));
            return childrenWithAttributes;
        }
        catch (AccessDeniedException e) {
            LocalFileSystemBase.LOG.debug((Throwable)e);
        }
        catch (NoSuchFileException e) {
            LocalFileSystemBase.LOG.debug((Throwable)e);
        }
        catch (IOException e) {
            LocalFileSystemBase.LOG.warn((Throwable)e);
        }
        catch (RuntimeException e) {
            LocalFileSystemBase.LOG.warn((Throwable)e);
        }
        return MapsKt.emptyMap();
    }

    private static final void visitDirectory(EelPath directory, Set<String> filter2, Function3<? super EelPath, ? super EelPosixFileInfo, ? super EelFileSystemPosixApi, Boolean> consumer) throws IOException, SecurityException {
        if (filter2 != null && filter2.isEmpty()) {
            return;
        }
        IjentNioFileSystemUtil.fsBlocking((Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(directory, filter2, consumer, null){
            Object L$0;
            int label;
            final /* synthetic */ EelPath $directory;
            final /* synthetic */ Set<String> $filter;
            final /* synthetic */ Function3<EelPath, EelPosixFileInfo, EelFileSystemPosixApi, Boolean> $consumer;
            {
                this.$directory = $directory;
                this.$filter = $filter;
                this.$consumer = $consumer;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block8: {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = EelMachineProviderUtil.toEelApi((EelDescriptor)this.$directory.getDescriptor(), (Continuation)((Continuation)this));
                            if (v0 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if (!((eelFsApi = ((EelApi)v0).getFs()) instanceof EelFileSystemPosixApi)) break;
                            this.L$0 = eelFsApi;
                            this.label = 2;
                            v1 = EelFileSystemPosixApiHelpersKt.listDirectoryWithAttrs((EelFileSystemPosixApi)((EelFileSystemPosixApi)eelFsApi), (EelPath)this.$directory).symlinkPolicy(EelFileSystemApi.SymlinkPolicy.RESOLVE_AND_FOLLOW).eelIt((Continuation)this);
                            if (v1 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl24
                        }
                        case 2: {
                            eelFsApi = (EelFileSystemApi)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl24:
                            // 2 sources

                            directoryList = (Collection)EelUtilsKt.getOrThrowFileSystemException((EelResult)((EelResult)v1));
                            for (Pair var5_6 : directoryList) {
                                childName = (String)var5_6.component1();
                                childStat = (EelPosixFileInfo)var5_6.component2();
                                childIjentPath = this.$directory.getChild(childName);
                                if (this.$filter != null && !this.$filter.contains(childIjentPath.getFileName()) || ((Boolean)this.$consumer.invoke((Object)childIjentPath, (Object)childStat, (Object)eelFsApi)).booleanValue()) continue;
                                break block8;
                            }
                            break block8;
                        }
                    }
                    throw new NotImplementedError(null, 1, null);
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final boolean isWritable(@NotNull EelPosixFileInfo $this$isWritable, @NotNull EelFileSystemPosixApi eelFsApi) {
        Intrinsics.checkNotNullParameter((Object)$this$isWritable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)eelFsApi, (String)"eelFsApi");
        AccessMode[] accessModeArray = new AccessMode[]{AccessMode.WRITE};
        return EelPathUtils.INSTANCE.checkAccess(eelFsApi.getUser(), $this$isWritable, accessModeArray) == null;
    }

    @NotNull
    public static final FileAttributes toVfs(@NotNull EelFileInfo $this$toVfs, boolean isWritable) {
        Intrinsics.checkNotNullParameter((Object)$this$toVfs, (String)"<this>");
        EelFileInfo attrs = $this$toVfs;
        boolean isDirectory = attrs.getType() instanceof EelFileInfo.Type.Directory;
        boolean isSpecial = attrs.getType() instanceof EelFileInfo.Type.Other;
        boolean isSymLink = attrs.getType() instanceof EelPosixFileInfo.Type.Symlink;
        boolean isHidden = false;
        EelFileInfo.Type type = attrs.getType();
        EelFileInfo.Type.Regular regular = type instanceof EelFileInfo.Type.Regular ? (EelFileInfo.Type.Regular)type : null;
        long length = regular != null ? regular.getSize() : 0L;
        Comparable<ChronoZonedDateTime<?>> comparable = attrs.getLastModifiedTime();
        if (comparable == null || (comparable = comparable.toInstant()) == null) {
            comparable = Instant.MIN;
        }
        long lastModified = FileTime.from((Instant)comparable).toMillis();
        EelFileInfo.Type type2 = attrs.getType();
        FileAttributes.CaseSensitivity caseSensitivity = type2 instanceof EelFileInfo.Type.Directory ? EelPathUtils.INSTANCE.getCaseSensitivity((EelFileInfo.Type.Directory)type2) : FileAttributes.CaseSensitivity.UNKNOWN;
        return new FileAttributes(isDirectory, isSpecial, isSymLink, isHidden, length, lastModified, isWritable, caseSensitivity);
    }

    private static final EelApi readWholeFileIfNotTooLargeWithEel$lambda$0(Path $root, Path it) {
        return (EelApi)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EelApi>, Object>($root, null){
            int label;
            final /* synthetic */ Path $root;
            {
                this.$root = $root;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = EelMachineProviderUtil.toEelApi((EelDescriptor)EelProviderUtil.getEelDescriptor((Path)this.$root), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super EelApi> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final EelApi readWholeFileIfNotTooLargeWithEel$lambda$1(Function1 $tmp0, Object p0) {
        return (EelApi)$tmp0.invoke(p0);
    }

    private static final boolean listWithAttributesUsingEel$lambda$1(Map $childrenWithAttributes, EelPath file2, EelPosixFileInfo attributes, EelFileSystemPosixApi eelFsApi) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)eelFsApi, (String)"eelFsApi");
        try {
            $childrenWithAttributes.put(file2.getFileName(), LocalFileSystemEelUtil.toVfs((EelFileInfo)attributes, LocalFileSystemEelUtil.isWritable(attributes, eelFsApi)));
        }
        catch (Exception e) {
            LocalFileSystemBase.LOG.debug((Throwable)e);
        }
        return true;
    }

    static {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        map = concurrentMap;
    }
}

