/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import com.intellij.openapi.vfs.newvfs.persistent.FsRootDataLoader;
import com.intellij.openapi.vfs.newvfs.persistent.ListResult;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSAttributeAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.ScannableDataEnumeratorEx;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class PersistentFSTreeAccessor {
    protected static final FileAttribute CHILDREN_ATTR = new FileAttribute("FsRecords.DIRECTORY_CHILDREN");
    protected static final int SUPER_ROOT_ID = 1;
    protected final PersistentFSAttributeAccessor attributeAccessor;
    protected final PersistentFSRecordAccessor recordAccessor;
    protected final PersistentFSConnection connection;
    @Nullable
    protected final FsRootDataLoader fsRootDataLoader;
    protected int[] rootsUrlIds;
    protected int[] rootsIds;

    public PersistentFSTreeAccessor(@NotNull PersistentFSAttributeAccessor attributeAccessor, @NotNull PersistentFSRecordAccessor recordAccessor, @NotNull PersistentFSConnection connection) {
        if (attributeAccessor == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(0);
        }
        if (recordAccessor == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(2);
        }
        this.rootsUrlIds = null;
        this.rootsIds = null;
        this.attributeAccessor = attributeAccessor;
        this.recordAccessor = recordAccessor;
        this.connection = connection;
        this.fsRootDataLoader = SystemProperties.getBooleanProperty((String)"idea.fs.roots.data.loader", (boolean)false) ? (FsRootDataLoader)ApplicationManager.getApplication().getService(FsRootDataLoader.class) : null;
    }

    @VisibleForTesting
    public void doSaveChildren(int parentId, @NotNull ListResult toSave) throws IOException {
        if (toSave == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(3);
        }
        if (parentId == 1) {
            throw new AssertionError((Object)"Incorrect call .doSaveChildren() with a super-root record id(=1). Super-root is a special file record for internal use, it MUST NOT be used directly");
        }
        try (AttributeOutputStream record = this.attributeAccessor.writeAttribute(parentId, CHILDREN_ATTR);){
            DataInputOutputUtil.writeINT((DataOutput)record, (int)toSave.children.size());
            int prevId = parentId;
            for (ChildInfo childInfo : toSave.children) {
                int childId = childInfo.getId();
                if (childId <= 0) {
                    throw new IllegalArgumentException("ids must be >0 but got: " + childId + "; childInfo: " + String.valueOf(childInfo) + "; list: " + String.valueOf(toSave));
                }
                if (childId == parentId) {
                    FSRecords.LOG.error("Cyclic parent-child relations. parentId=" + parentId + "; list: " + String.valueOf(toSave));
                    continue;
                }
                int delta = childId - prevId;
                if (prevId != parentId && delta <= 0) {
                    throw new IllegalArgumentException("The list must be sorted by (unique) id but got parentId: " + parentId + "; delta: " + delta + "; childInfo: " + String.valueOf(childInfo) + "; prevId: " + prevId + "; toSave: " + String.valueOf(toSave));
                }
                DataInputOutputUtil.writeINT((DataOutput)record, (int)delta);
                prevId = childId;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ListResult doLoadChildren(int parentId) throws IOException {
        PersistentFSConnection.ensureIdIsValid(parentId);
        if (parentId == 1) {
            throw new AssertionError((Object)"Incorrect call .doLoadChildren() with a super-root record id(=1). Super-root is a special file record for internal use, it MUST NOT be used directly");
        }
        PersistentFSRecordsStorage records = this.connection.records();
        int parentModCount = records.getModCount(parentId);
        int flags = records.getFlags(parentId);
        AttributeInputStream input = this.attributeAccessor.readAttribute(parentId, CHILDREN_ATTR);
        int count = input == null ? 0 : DataInputOutputUtil.readINT((DataInput)input);
        ArrayList<ChildInfoImpl> children2 = count == 0 ? Collections.emptyList() : new ArrayList<ChildInfoImpl>(count);
        int prevId = parentId;
        int maxAllocatedID = records.maxAllocatedID();
        for (int i2 = 0; i2 < count; ++i2) {
            int childId = DataInputOutputUtil.readINT((DataInput)input) + prevId;
            this.checkChildIdValid(parentId, childId, i2, maxAllocatedID);
            prevId = childId;
            int nameId = records.getNameId(childId);
            this.checkNameIdValid(nameId, parentId, childId);
            ChildInfoImpl child = new ChildInfoImpl(childId, nameId, null, null, null);
            children2.add(child);
        }
        if (FSRecordsImpl.areAllChildrenCached(flags)) {
            ListResult listResult = ListResult.allCached(parentModCount, children2, parentId);
            ListResult listResult2 = listResult;
            if (listResult2 == null) {
                PersistentFSTreeAccessor.$$$reportNull$$$0(4);
            }
            return listResult2;
        }
        ListResult listResult = ListResult.notAllCached(parentModCount, children2, parentId);
        ListResult listResult3 = listResult;
        if (listResult3 == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(5);
        }
        return listResult3;
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    boolean wereChildrenAccessed(int fileId) throws IOException {
        return this.attributeAccessor.hasAttributePage(fileId, CHILDREN_ATTR);
    }

    @VisibleForTesting
    public boolean forEachChild(int fileId, @NotNull IntPredicate childConsumer) throws IOException {
        if (childConsumer == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(6);
        }
        PersistentFSConnection.ensureIdIsValid(fileId);
        if (fileId == 1) {
            throw new AssertionError((Object)"Incorrect call .listIds() with is a super-root record id(=1) -- use .listRoots() instead");
        }
        try (AttributeInputStream input = this.attributeAccessor.readAttribute(fileId, CHILDREN_ATTR);){
            if (input == null) {
                boolean bl = false;
                return bl;
            }
            PersistentFSRecordsStorage records = this.connection.records();
            int maxID = records.maxAllocatedID();
            int count = DataInputOutputUtil.readINT((DataInput)input);
            int prevId = fileId;
            for (int i2 = 0; i2 < count; ++i2) {
                int childId = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                if (childConsumer.test(childId)) {
                    boolean bl = true;
                    return bl;
                }
                prevId = childId;
                this.checkChildIdValid(fileId, prevId, i2, maxID);
            }
            boolean bl = false;
            return bl;
        }
    }

    boolean maybeHaveChildren(int fileId) throws IOException {
        PersistentFSConnection.ensureIdIsValid(fileId);
        if (fileId == 1) {
            throw new AssertionError((Object)"Incorrect call .mayHaveChildren() with is a super-root record id(=1)Super-root is a special file record for internal use, it MUST NOT be used directly");
        }
        try (AttributeInputStream input = this.attributeAccessor.readAttribute(fileId, CHILDREN_ATTR);){
            if (input == null) {
                boolean bl = true;
                return bl;
            }
            int count = DataInputOutputUtil.readINT((DataInput)input);
            boolean bl = count != 0;
            return bl;
        }
    }

    final int @NotNull [] listRoots() throws IOException {
        this.ensureRootsCached();
        if (this.rootsIds == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(7);
        }
        return this.rootsIds;
    }

    protected void ensureRootsCached() throws IOException {
        if (this.rootsIds == null || this.rootsUrlIds == null) {
            this.cacheRoots();
        }
    }

    protected void cacheRoots() throws IOException {
        try (AttributeInputStream input = this.attributeAccessor.readAttribute(1, CHILDREN_ATTR);){
            if (input == null) {
                this.rootsIds = ArrayUtil.EMPTY_INT_ARRAY;
                this.rootsUrlIds = ArrayUtil.EMPTY_INT_ARRAY;
                return;
            }
            int maxAllocatedID = this.connection.records().maxAllocatedID();
            int rootsCount = DataInputOutputUtil.readINT((DataInput)input);
            if (rootsCount < 0) {
                throw new CorruptedException("SUPER_ROOT.CHILDREN attribute is corrupted: roots count(=" + rootsCount + ") must be >=0, VFS.status: {" + this.connection.describeConsistencyStatus() + "}");
            }
            int[] rootsUrlIds = ArrayUtil.newIntArray((int)rootsCount);
            int[] rootsIds = ArrayUtil.newIntArray((int)rootsCount);
            int prevUrlId = 0;
            int prevRootId = 0;
            for (int i2 = 0; i2 < rootsCount; ++i2) {
                int diffUrlId = DataInputOutputUtil.readINT((DataInput)input);
                int diffRootId = DataInputOutputUtil.readINT((DataInput)input);
                if (diffUrlId <= 0) {
                    throw new CorruptedException("SUPER_ROOT.CHILDREN attribute is corrupted: diffUrlId[" + i2 + "](=" + diffUrlId + ") must be >0, VFS.status: {" + this.connection.describeConsistencyStatus() + "}");
                }
                int urlId = diffUrlId + prevUrlId;
                int rootId = diffRootId + prevRootId;
                this.checkChildIdValid(1, rootId, i2, maxAllocatedID);
                rootsUrlIds[i2] = urlId;
                rootsIds[i2] = rootId;
                prevUrlId = urlId;
                prevRootId = rootId;
            }
            this.rootsIds = rootsIds;
            this.rootsUrlIds = rootsUrlIds;
        }
    }

    final int findOrCreateRootRecord(@NotNull String rootUrl) throws IOException {
        int n;
        block10: {
            if (rootUrl == null) {
                PersistentFSTreeAccessor.$$$reportNull$$$0(8);
            }
            this.ensureRootsCached();
            PersistentFSConnection connection = this.connection;
            ScannableDataEnumeratorEx<String> names = connection.names();
            int rootUrlId = names.enumerate((Object)rootUrl);
            int rootIndex = Arrays.binarySearch(this.rootsUrlIds, rootUrlId);
            if (rootIndex >= 0) {
                return this.rootsIds[rootIndex];
            }
            int insertionIndex = -rootIndex - 1;
            int newRootFileId = this.recordAccessor.createRecord(Collections.emptyList());
            this.rootsUrlIds = ArrayUtil.insert((int[])this.rootsUrlIds, (int)insertionIndex, (int)rootUrlId);
            this.rootsIds = ArrayUtil.insert((int[])this.rootsIds, (int)insertionIndex, (int)newRootFileId);
            AttributeOutputStream output = this.attributeAccessor.writeAttribute(1, CHILDREN_ATTR);
            try {
                this.saveUrlAndFileIdsAsDiffCompressed(this.rootsUrlIds, this.rootsIds, (DataOutputStream)output);
                n = newRootFileId;
                if (output == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileTooBigException e) {
                    throw new FileTooBigException("Can't add new root (#" + newRootFileId + ", url=[" + rootUrl + "], urlId=" + rootUrlId + ") to the VFS: too many roots already (= " + this.rootsIds.length + ")", (Throwable)e);
                }
            }
            output.close();
        }
        return n;
    }

    final void deleteRootRecord(int rootId) throws IOException {
        if (this.fsRootDataLoader != null) {
            this.fsRootDataLoader.deleteRootRecord(this.getRootsStoragePath(this.fsRootDataLoader), rootId);
        }
        this.ensureRootsCached();
        int index = ArrayUtil.find((int[])this.rootsIds, (int)rootId);
        if (index < 0) {
            String rootUrlsString = this.rootsIds.length < 128 ? Arrays.toString(this.rootsIds) : Arrays.toString(Arrays.copyOf(this.rootsIds, 128)) + "...";
            throw new IOException("No root[#" + rootId + "] entry found among roots " + rootUrlsString);
        }
        this.rootsUrlIds = ArrayUtil.remove((int[])this.rootsUrlIds, (int)index);
        this.rootsIds = ArrayUtil.remove((int[])this.rootsIds, (int)index);
        try (AttributeOutputStream output = this.attributeAccessor.writeAttribute(1, CHILDREN_ATTR);){
            this.saveUrlAndFileIdsAsDiffCompressed(this.rootsUrlIds, this.rootsIds, (DataOutputStream)output);
        }
    }

    final void forEachRoot(@NotNull RootsConsumer rootConsumer) throws IOException {
        if (rootConsumer == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(9);
        }
        this.ensureRootsCached();
        for (int i2 = 0; i2 < this.rootsIds.length; ++i2) {
            int rootId = this.rootsIds[i2];
            int rootUrlId = this.rootsUrlIds[i2];
            boolean continueProcessing = rootConsumer.processRoot(rootId, rootUrlId);
            if (continueProcessing) continue;
            return;
        }
    }

    void loadDirectoryData(int id2, @NotNull VirtualFile parent, @NotNull CharSequence childName, @NotNull NewVirtualFileSystem fs) throws IOException {
        if (parent == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(10);
        }
        if (childName == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(11);
        }
        if (fs == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(12);
        }
        if (this.fsRootDataLoader != null) {
            this.fsRootDataLoader.loadDirectoryData(this.getRootsStoragePath(this.fsRootDataLoader), id2, parent, childName, fs);
        }
    }

    void loadRootData(int id2, @NotNull String path, @NotNull NewVirtualFileSystem fs) throws IOException {
        if (path == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(13);
        }
        if (fs == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(14);
        }
        if (this.fsRootDataLoader != null) {
            this.fsRootDataLoader.loadRootData(this.getRootsStoragePath(this.fsRootDataLoader), id2, path, fs);
        }
    }

    void deleteDirectoryRecord(int id2) throws IOException {
        if (this.fsRootDataLoader != null) {
            this.fsRootDataLoader.deleteDirectoryRecord(this.getRootsStoragePath(this.fsRootDataLoader), id2);
        }
    }

    void ensureLoaded() throws IOException {
        if (this.fsRootDataLoader != null) {
            this.fsRootDataLoader.ensureLoaded(this.getRootsStoragePath(this.fsRootDataLoader));
        }
        this.connection.enumerateAttributeId(CHILDREN_ATTR.getId());
    }

    private void saveUrlAndFileIdsAsDiffCompressed(int[] urlIds, int[] fileIds, @NotNull DataOutputStream output) throws IOException {
        if (output == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(15);
        }
        if (urlIds.length != fileIds.length) {
            throw new IllegalArgumentException("urlIds.length(=" + urlIds.length + ") != fileIds.length(=" + fileIds.length + "), VFS.status: {" + this.connection.describeConsistencyStatus() + "}");
        }
        DataInputOutputUtil.writeINT((DataOutput)output, (int)urlIds.length);
        int prevUrlId = 0;
        int prevFileId = 0;
        for (int i2 = 0; i2 < urlIds.length; ++i2) {
            int urlId = urlIds[i2];
            int fileId = fileIds[i2];
            int diffUrlId = urlId - prevUrlId;
            int diffFileId = fileId - prevFileId;
            if (diffUrlId <= 0) {
                throw new IllegalStateException("urlIds are not sorted: urlIds[" + i2 + "](=" + urlId + ") <= urlIds[" + (i2 - 1) + "](=" + prevUrlId + "), urlIds: " + Arrays.toString(urlIds) + ", VFS.status: {" + this.connection.describeConsistencyStatus() + "}");
            }
            DataInputOutputUtil.writeINT((DataOutput)output, (int)diffUrlId);
            DataInputOutputUtil.writeINT((DataOutput)output, (int)diffFileId);
            prevFileId = fileId;
            prevUrlId = urlId;
        }
    }

    @NotNull
    private Path getRootsStoragePath(FsRootDataLoader loader) {
        Path path = this.connection.paths().getRootsStorage(loader.getName());
        if (path == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(16);
        }
        return path;
    }

    protected void checkNameIdValid(int nameId, int parentId, int childId) throws CorruptedException {
        if (nameId == 0) {
            throw new CorruptedException("parentId: " + parentId + ", childId: " + childId + ", nameId: " + nameId + " is invalid -> VFS is corrupted (" + this.connection.describeConsistencyStatus() + ")");
        }
    }

    protected void checkChildIdValid(int parentId, int childId, int childNo, int maxAllocatedID) throws CorruptedException {
        if (childId < 1 || maxAllocatedID < childId) {
            throw new CorruptedException("file[" + parentId + "].child[" + childNo + "][#" + childId + "] is out of valid/allocated id range (1.." + maxAllocatedID + "] -> VFS is corrupted (" + this.connection.describeConsistencyStatus() + ")");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeAccessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordAccessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSave";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSTreeAccessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childConsumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootUrl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootConsumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSTreeAccessor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "listRoots";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsStoragePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doSaveChildren";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forEachChild";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateRootRecord";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forEachRoot";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadDirectoryData";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadRootData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "saveUrlAndFileIdsAsDiffCompressed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 16 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static interface RootsConsumer {
        public boolean processRoot(int var1, int var2);
    }
}

