/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.ui.DialogBackgroundImageProvider;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.ClientProperty;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/wm/impl/DialogBackgroundImageProviderBase;", "Lcom/intellij/openapi/ui/DialogBackgroundImageProvider;", "<init>", "()V", "getImageUrl", "Ljava/net/URL;", "isDark", "", "getImage", "Ljava/awt/Image;", "setBackgroundImageToDialog", "", "dialog", "Lcom/intellij/openapi/ui/DialogWrapper;", "image", "hasBackgroundImage", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDialogBackgroundImageProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogBackgroundImageProviderBase.kt\ncom/intellij/openapi/wm/impl/DialogBackgroundImageProviderBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public abstract class DialogBackgroundImageProviderBase
implements DialogBackgroundImageProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Disposable> BACKGROUND_IMAGE_DISPOSABLE_KEY;
    private static final long LOADING_TIMEOUT_MILLIS = 300L;
    @NotNull
    private static final Logger LOG;

    @Nullable
    public URL getImageUrl(boolean isDark) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Image getImage(boolean isDark) {
        URL uRL;
        URL uRL2 = this.getImageUrl(isDark);
        URL uRL3 = uRL2;
        if (uRL2 == null) return null;
        URL it = uRL = uRL3;
        boolean bl = false;
        if (!this.isAvailable()) return null;
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (!StringsKt.endsWith$default((String)string, (String)".svg", (boolean)false, (int)2, null)) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        URL uRL4 = uRL;
        uRL3 = uRL4;
        if (uRL4 == null) {
            return null;
        }
        URL imageUrl = uRL3;
        long timeout = DialogBackgroundImageProviderBase.Companion.getUSE_LONG_TIMEOUT() ? 30000L : 300L;
        return (Image)BackgroundTaskUtil.tryComputeFast(arg_0 -> DialogBackgroundImageProviderBase.getImage$lambda$2(arg_0 -> DialogBackgroundImageProviderBase.getImage$lambda$1(imageUrl, timeout, arg_0), arg_0), (long)timeout);
    }

    public void setBackgroundImageToDialog(@NotNull DialogWrapper dialog2, @Nullable Image image2) {
        Intrinsics.checkNotNullParameter((Object)dialog2, (String)"dialog");
        boolean didHaveImage = false;
        Disposable disposable = (Disposable)ClientProperty.get((Component)dialog2.getRootPane(), BACKGROUND_IMAGE_DISPOSABLE_KEY);
        if (disposable != null) {
            Disposable previousDisposable = disposable;
            boolean bl = false;
            didHaveImage = true;
            Disposer.dispose((Disposable)previousDisposable);
            ClientProperty.remove((JComponent)dialog2.getRootPane(), BACKGROUND_IMAGE_DISPOSABLE_KEY);
        }
        if (image2 == null) {
            if (didHaveImage) {
                dialog2.getRootPane().repaint();
            }
            return;
        }
        Disposable disposable2 = Disposer.newDisposable((Disposable)dialog2.getDisposable());
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        Disposable disposable3 = disposable2;
        ClientProperty.put((JComponent)dialog2.getRootPane(), BACKGROUND_IMAGE_DISPOSABLE_KEY, (Object)disposable3);
        IdeBackgroundUtil.createTemporaryBackgroundTransform(dialog2.getRootPane(), image2, IdeBackgroundUtil.Fill.SCALE, IdeBackgroundUtil.Anchor.CENTER, 1.0f, (Insets)JBInsets.emptyInsets(), disposable3);
        dialog2.getRootPane().repaint();
    }

    public boolean hasBackgroundImage(@NotNull DialogWrapper dialog2) {
        Intrinsics.checkNotNullParameter((Object)dialog2, (String)"dialog");
        return ClientProperty.get((Component)dialog2.getRootPane(), BACKGROUND_IMAGE_DISPOSABLE_KEY) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Image getImage$lambda$1(URL $imageUrl, long $timeout, ProgressIndicator progressIndicator) {
        try {
            Image image2 = SVGLoader.load((URL)$imageUrl, (float)1.0f);
            return image2;
        }
        catch (IOException e) {
            LOG.warn("Onboarding image loading failed: " + e);
            Image image3 = null;
            return image3;
        }
        finally {
            if (progressIndicator.isCanceled()) {
                LOG.warn("Onboarding image loading failed: it took longer than " + $timeout + " ms");
            }
        }
    }

    private static final Image getImage$lambda$2(Function1 $tmp0, Object p0) {
        return (Image)$tmp0.invoke(p0);
    }

    static {
        Key key = Key.create((String)"ide.background.image.provider.background.image");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        BACKGROUND_IMAGE_DISPOSABLE_KEY = key;
        Logger logger = Logger.getInstance(DialogBackgroundImageProviderBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/wm/impl/DialogBackgroundImageProviderBase$Companion;", "", "<init>", "()V", "BACKGROUND_IMAGE_DISPOSABLE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/Disposable;", "LOADING_TIMEOUT_MILLIS", "", "USE_LONG_TIMEOUT", "", "getUSE_LONG_TIMEOUT", "()Z", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean getUSE_LONG_TIMEOUT() {
            return Registry.Companion.is("ide.onboarding.background.use.long.timeout", true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

