/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.customFrameDecorations.frameButtons;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.impl.customFrameDecorations.frameButtons.IconSet;
import com.intellij.openapi.wm.impl.customFrameDecorations.frameButtons.LinuxFrameButton;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UnixDesktopEnv;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonUI;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000O\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005*\u0001\t\b\u0000\u0018\u0000  2\u00020\u0001:\u0003\u001e\u001f B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u001e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/frameButtons/LinuxFrameButton;", "Ljavax/swing/JButton;", "action", "Ljavax/swing/Action;", "type", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/frameButtons/LinuxFrameButton$Type;", "<init>", "(Ljavax/swing/Action;Lcom/intellij/openapi/wm/impl/customFrameDecorations/frameButtons/LinuxFrameButton$Type;)V", "listener", "com/intellij/openapi/wm/impl/customFrameDecorations/frameButtons/LinuxFrameButton$listener$1", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/frameButtons/LinuxFrameButton$listener$1;", "iconPack", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/frameButtons/LinuxFrameButton$IconPack;", "darkHeader", "", "hovered", "pressed", "icons", "", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/frameButtons/IconSet;", "updateUI", "", "updateStyle", "updateIconTheme", "iconTheme", "", "isSimilarIconTheme", "similarIconThemes", "", "initIconPack", "Type", "IconPack", "Companion", "intellij.platform.ide.impl"})
public final class LinuxFrameButton
extends JButton {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Type type;
    @NotNull
    private final listener.1 listener;
    @NotNull
    private IconPack iconPack;
    private boolean darkHeader;
    private boolean hovered;
    private boolean pressed;
    @NotNull
    private final Map<Boolean, IconSet> icons;
    @NotNull
    private static final List<String> gnomeSimilarIconThemes;
    @NotNull
    private static final List<String> kdeSimilarIconThemes;

    public LinuxFrameButton(@NotNull Action action2, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(action2);
        this.type = type;
        this.listener = new MouseAdapter(this){
            final /* synthetic */ LinuxFrameButton this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                LinuxFrameButton.access$setPressed$p(this.this$0, false);
                this.this$0.updateStyle();
            }

            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                LinuxFrameButton.access$setHovered$p(this.this$0, true);
                this.this$0.updateStyle();
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                LinuxFrameButton.access$setHovered$p(this.this$0, false);
                this.this$0.updateStyle();
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                LinuxFrameButton.access$setPressed$p(this.this$0, true);
                this.this$0.updateStyle();
            }
        };
        this.iconPack = LinuxFrameButton.Companion.getDefaultIconPack();
        this.icons = new LinkedHashMap();
        this.setFocusable(false);
        this.setText(null);
        this.setOpaque(false);
        this.setToolTipText(this.type.getText());
        this.putClientProperty("AccessibleName", this.type.getText());
        this.addMouseListener(this.listener);
        this.initIconPack();
    }

    @Override
    public void updateUI() {
        this.setUI(new BasicButtonUI());
        this.setBorder(null);
        Object object = InternalUICustomization.Companion.getInstance();
        if (object == null || (object = ((InternalUICustomization)object).getMainToolbarBackground(true)) == null) {
            Color color = JBUI.CurrentTheme.CustomFrameDecorations.mainToolbarBackground((boolean)true);
            object = color;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"mainToolbarBackground(...)");
        }
        this.darkHeader = ColorUtil.isDark((Color)object);
        this.updateStyle();
    }

    public final void updateStyle() {
        boolean frameActive;
        IconSet iconSet;
        Map<Boolean, IconSet> map2 = this.icons;
        IconSet iconSet2 = iconSet = map2 != null ? map2.get(this.darkHeader) : null;
        if (iconSet == null) {
            this.setIcon(null);
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        boolean bl = window != null ? window.isActive() : (frameActive = false);
        this.setIcon(!this.isEnabled() ? iconSet.getDefaultIcon() : (!frameActive ? iconSet.getInactiveIcon() : (this.pressed ? iconSet.getPressedIcon() : (this.hovered ? iconSet.getHoverIcon() : iconSet.getDefaultIcon()))));
    }

    public final void updateIconTheme(@Nullable String iconTheme) {
        IconPack newIconPack;
        IconPack iconPack;
        IconPack suggestedIconTheme = null;
        if (iconTheme != null) {
            if (this.isSimilarIconTheme(iconTheme, gnomeSimilarIconThemes)) {
                suggestedIconTheme = IconPack.GNOME;
            } else if (this.isSimilarIconTheme(iconTheme, kdeSimilarIconThemes)) {
                suggestedIconTheme = IconPack.KDE;
            }
        }
        if ((iconPack = suggestedIconTheme) == null) {
            iconPack = LinuxFrameButton.Companion.getDefaultIconPack();
        }
        if (this.iconPack != (newIconPack = iconPack)) {
            this.iconPack = newIconPack;
            this.initIconPack();
        }
    }

    private final boolean isSimilarIconTheme(String iconTheme, List<String> similarIconThemes) {
        for (String theme : similarIconThemes) {
            if (!StringsKt.startsWith((String)iconTheme, (String)theme, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private final void initIconPack() {
        IconSet iconSet = this.iconPack.getIconSets().get((Object)this.type);
        Intrinsics.checkNotNull((Object)iconSet);
        IconSet iconSet2 = iconSet;
        Object[] objectArray = new Boolean[]{true, false};
        Iterator iterator = CollectionsKt.listOf((Object[])objectArray).iterator();
        while (iterator.hasNext()) {
            boolean dark = (Boolean)iterator.next();
            this.icons.put(dark, new IconSet(IconLoader.getDarkIcon((Icon)iconSet2.getDefaultIcon(), (boolean)dark), IconLoader.getDarkIcon((Icon)iconSet2.getHoverIcon(), (boolean)dark), IconLoader.getDarkIcon((Icon)iconSet2.getPressedIcon(), (boolean)dark), IconLoader.getDarkIcon((Icon)iconSet2.getInactiveIcon(), (boolean)dark)));
        }
    }

    public static final /* synthetic */ void access$setPressed$p(LinuxFrameButton $this, boolean bl) {
        $this.pressed = bl;
    }

    public static final /* synthetic */ void access$setHovered$p(LinuxFrameButton $this, boolean bl) {
        $this.hovered = bl;
    }

    static {
        Object[] objectArray = new String[]{"adwaita", "yaru"};
        gnomeSimilarIconThemes = CollectionsKt.listOf((Object[])objectArray);
        kdeSimilarIconThemes = CollectionsKt.listOf((Object)"breeze");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/frameButtons/LinuxFrameButton$Companion;", "", "<init>", "()V", "gnomeSimilarIconThemes", "", "", "kdeSimilarIconThemes", "getDefaultIconPack", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/frameButtons/LinuxFrameButton$IconPack;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final IconPack getDefaultIconPack() {
            return UnixDesktopEnv.CURRENT == UnixDesktopEnv.KDE ? IconPack.KDE : IconPack.GNOME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/frameButtons/LinuxFrameButton$IconPack;", "", "iconSets", "", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/frameButtons/LinuxFrameButton$Type;", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/frameButtons/IconSet;", "<init>", "(Ljava/lang/String;ILjava/util/Map;)V", "getIconSets", "()Ljava/util/Map;", "GNOME", "KDE", "intellij.platform.ide.impl"})
    private static final class IconPack
    extends Enum<IconPack> {
        @NotNull
        private final Map<Type, IconSet> iconSets;
        public static final /* enum */ IconPack GNOME;
        public static final /* enum */ IconPack KDE;
        private static final /* synthetic */ IconPack[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private IconPack(Map<Type, IconSet> iconSets) {
            this.iconSets = iconSets;
        }

        @NotNull
        public final Map<Type, IconSet> getIconSets() {
            return this.iconSets;
        }

        public static IconPack[] values() {
            return (IconPack[])$VALUES.clone();
        }

        public static IconPack valueOf(String value) {
            return Enum.valueOf(IconPack.class, value);
        }

        @NotNull
        public static EnumEntries<IconPack> getEntries() {
            return $ENTRIES;
        }

        static {
            Pair[] pairArray = new Pair[4];
            Icon icon2 = AllIcons.Linux.Theme.Gnome.Minimize;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Minimize");
            Icon icon3 = AllIcons.Linux.Theme.Gnome.MinimizeHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"MinimizeHover");
            Icon icon4 = AllIcons.Linux.Theme.Gnome.MinimizePressed;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"MinimizePressed");
            Icon icon5 = AllIcons.Linux.Theme.Gnome.MinimizeInactive;
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"MinimizeInactive");
            pairArray[0] = TuplesKt.to((Object)((Object)Type.MINIMIZE), (Object)new IconSet(icon2, icon3, icon4, icon5));
            Icon icon6 = AllIcons.Linux.Theme.Gnome.Maximize;
            Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"Maximize");
            Icon icon7 = AllIcons.Linux.Theme.Gnome.MaximizeHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"MaximizeHover");
            Icon icon8 = AllIcons.Linux.Theme.Gnome.MaximizePressed;
            Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"MaximizePressed");
            Icon icon9 = AllIcons.Linux.Theme.Gnome.MaximizeInactive;
            Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"MaximizeInactive");
            pairArray[1] = TuplesKt.to((Object)((Object)Type.MAXIMIZE), (Object)new IconSet(icon6, icon7, icon8, icon9));
            Icon icon10 = AllIcons.Linux.Theme.Gnome.Restore;
            Intrinsics.checkNotNullExpressionValue((Object)icon10, (String)"Restore");
            Icon icon11 = AllIcons.Linux.Theme.Gnome.RestoreHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon11, (String)"RestoreHover");
            Icon icon12 = AllIcons.Linux.Theme.Gnome.RestorePressed;
            Intrinsics.checkNotNullExpressionValue((Object)icon12, (String)"RestorePressed");
            Icon icon13 = AllIcons.Linux.Theme.Gnome.RestoreInactive;
            Intrinsics.checkNotNullExpressionValue((Object)icon13, (String)"RestoreInactive");
            pairArray[2] = TuplesKt.to((Object)((Object)Type.RESTORE), (Object)new IconSet(icon10, icon11, icon12, icon13));
            Icon icon14 = AllIcons.Linux.Theme.Gnome.Close;
            Intrinsics.checkNotNullExpressionValue((Object)icon14, (String)"Close");
            Icon icon15 = AllIcons.Linux.Theme.Gnome.CloseHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon15, (String)"CloseHover");
            Icon icon16 = AllIcons.Linux.Theme.Gnome.ClosePressed;
            Intrinsics.checkNotNullExpressionValue((Object)icon16, (String)"ClosePressed");
            Icon icon17 = AllIcons.Linux.Theme.Gnome.CloseInactive;
            Intrinsics.checkNotNullExpressionValue((Object)icon17, (String)"CloseInactive");
            pairArray[3] = TuplesKt.to((Object)((Object)Type.CLOSE), (Object)new IconSet(icon14, icon15, icon16, icon17));
            GNOME = new IconPack(MapsKt.mapOf((Pair[])pairArray));
            pairArray = new Pair[4];
            Icon icon18 = AllIcons.Linux.Theme.Kde.Minimize;
            Intrinsics.checkNotNullExpressionValue((Object)icon18, (String)"Minimize");
            Icon icon19 = AllIcons.Linux.Theme.Kde.MinimizeHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon19, (String)"MinimizeHover");
            Icon icon20 = AllIcons.Linux.Theme.Kde.MinimizePressed;
            Intrinsics.checkNotNullExpressionValue((Object)icon20, (String)"MinimizePressed");
            Icon icon21 = AllIcons.Linux.Theme.Kde.MinimizeInactive;
            Intrinsics.checkNotNullExpressionValue((Object)icon21, (String)"MinimizeInactive");
            pairArray[0] = TuplesKt.to((Object)((Object)Type.MINIMIZE), (Object)new IconSet(icon18, icon19, icon20, icon21));
            Icon icon22 = AllIcons.Linux.Theme.Kde.Maximize;
            Intrinsics.checkNotNullExpressionValue((Object)icon22, (String)"Maximize");
            Icon icon23 = AllIcons.Linux.Theme.Kde.MaximizeHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon23, (String)"MaximizeHover");
            Icon icon24 = AllIcons.Linux.Theme.Kde.MaximizePressed;
            Intrinsics.checkNotNullExpressionValue((Object)icon24, (String)"MaximizePressed");
            Icon icon25 = AllIcons.Linux.Theme.Kde.MaximizeInactive;
            Intrinsics.checkNotNullExpressionValue((Object)icon25, (String)"MaximizeInactive");
            pairArray[1] = TuplesKt.to((Object)((Object)Type.MAXIMIZE), (Object)new IconSet(icon22, icon23, icon24, icon25));
            Icon icon26 = AllIcons.Linux.Theme.Kde.Restore;
            Intrinsics.checkNotNullExpressionValue((Object)icon26, (String)"Restore");
            Icon icon27 = AllIcons.Linux.Theme.Kde.RestoreHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon27, (String)"RestoreHover");
            Icon icon28 = AllIcons.Linux.Theme.Kde.RestorePressed;
            Intrinsics.checkNotNullExpressionValue((Object)icon28, (String)"RestorePressed");
            Icon icon29 = AllIcons.Linux.Theme.Kde.RestoreInactive;
            Intrinsics.checkNotNullExpressionValue((Object)icon29, (String)"RestoreInactive");
            pairArray[2] = TuplesKt.to((Object)((Object)Type.RESTORE), (Object)new IconSet(icon26, icon27, icon28, icon29));
            Icon icon30 = AllIcons.Linux.Theme.Kde.Close;
            Intrinsics.checkNotNullExpressionValue((Object)icon30, (String)"Close");
            Icon icon31 = AllIcons.Linux.Theme.Kde.CloseHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon31, (String)"CloseHover");
            Icon icon32 = AllIcons.Linux.Theme.Kde.ClosePressed;
            Intrinsics.checkNotNullExpressionValue((Object)icon32, (String)"ClosePressed");
            Icon icon33 = AllIcons.Linux.Theme.Kde.CloseInactive;
            Intrinsics.checkNotNullExpressionValue((Object)icon33, (String)"CloseInactive");
            pairArray[3] = TuplesKt.to((Object)((Object)Type.CLOSE), (Object)new IconSet(icon30, icon31, icon32, icon33));
            KDE = new IconPack(MapsKt.mapOf((Pair[])pairArray));
            $VALUES = iconPackArray = new IconPack[]{IconPack.GNOME, IconPack.KDE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0016\b\u0002\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/frameButtons/LinuxFrameButton$Type;", "", "text", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getText", "()Ljava/lang/String;", "MINIMIZE", "MAXIMIZE", "RESTORE", "CLOSE", "intellij.platform.ide.impl"})
    public static final class Type
    extends Enum<Type> {
        @NotNull
        private final String text;
        public static final /* enum */ Type MINIMIZE;
        public static final /* enum */ Type MAXIMIZE;
        public static final /* enum */ Type RESTORE;
        public static final /* enum */ Type CLOSE;
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Type(String text2) {
            this.text = text2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            String string = IdeBundle.message((String)"window.titleButton.minimize", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MINIMIZE = new Type(string);
            String string2 = IdeBundle.message((String)"window.titleButton.maximize", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            MAXIMIZE = new Type(string2);
            String string3 = IdeBundle.message((String)"window.titleButton.restore", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            RESTORE = new Type(string3);
            String string4 = IdeBundle.message((String)"window.titleButton.close", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            CLOSE = new Type(string4);
            $VALUES = typeArray = new Type[]{Type.MINIMIZE, Type.MAXIMIZE, Type.RESTORE, Type.CLOSE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

