/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowWatcher;
import com.intellij.toolWindow.FocusTask;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\tH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "bringOwnerToFront", "", "toolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "focus", "", "getShowingComponentToRequestFocus", "Ljava/awt/Component;", "updateToolWindow", "component", "updateFocusedComponentForWatcher", "c", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nrequestFocusInToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 requestFocusInToolWindow.kt\ncom/intellij/toolWindow/RequestFocusInToolWindowKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n60#2,5:123\n60#2,5:129\n60#2,5:135\n60#2,5:140\n13#2:145\n1915#3:128\n1916#3:134\n*S KotlinDebug\n*F\n+ 1 requestFocusInToolWindow.kt\ncom/intellij/toolWindow/RequestFocusInToolWindowKt\n*L\n70#1:123,5\n79#1:129,5\n88#1:135,5\n103#1:140,5\n14#1:145\n75#1:128\n75#1:134\n*E\n"})
public final class RequestFocusInToolWindowKt {
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void bringOwnerToFront(@NotNull ToolWindowImpl toolWindow2, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        Window window = SwingUtilities.getWindowAncestor(toolWindow2.getComponent());
        if (window == null) {
            return;
        }
        Window owner = window;
        Window activeFrame = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (activeFrame != null && activeFrame != owner && Intrinsics.areEqual((Object)ProjectUtil.getProjectForWindow(activeFrame), (Object)ProjectUtil.getProjectForWindow(owner))) {
            owner.setAutoRequestFocus(focus);
            try {
                owner.toFront();
            }
            finally {
                owner.setAutoRequestFocus(true);
            }
        }
    }

    @Nullable
    public static final Component getShowingComponentToRequestFocus(@NotNull ToolWindowImpl toolWindow2) {
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        ContentManager manager2 = toolWindow2.getContentManager();
        Content lastFocusedContent = toolWindow2.getLastFocusedContent();
        if (lastFocusedContent != null) {
            JComponent component2 = lastFocusedContent.getPreferredFocusableComponent();
            if (component2 == null || !component2.isShowing()) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("tool window " + toolWindow2.getId() + " last focused content's preferred focusable component is hidden: " + component2, t$iv);
                }
                return null;
            }
            return component2;
        }
        List list2 = manager2.getContentsRecursively();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContentsRecursively(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Content content2 = (Content)element$iv;
            boolean bl = false;
            if (!content2.isSelected()) continue;
            JComponent component3 = content2.getPreferredFocusableComponent();
            if (component3 == null || !component3.isShowing()) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl2 = false;
                    logger.debug("tool window " + toolWindow2.getId() + " selected content's (name='" + content2.getDisplayName() + "') preferred focusable component is hidden: " + component3, t$iv);
                }
                return null;
            }
            return component3;
        }
        JComponent container = toolWindow2.getComponentIfInitialized();
        if (container == null || !container.isShowing()) {
            Logger $this$debug_u24default$iv = LOG;
            Iterator t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("tool window " + toolWindow2.getId() + " parent container is hidden: " + container, t$iv);
            }
            return null;
        }
        FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
        if (policy == null) {
            LOG.warn(toolWindow2.getId() + " tool window does not provide focus traversal policy");
            return null;
        }
        Component component4 = toolWindow2.toolWindowManager.getFocusManager().getFocusTargetFor(container);
        if (component4 == null && container.isFocusable()) {
            return container;
        }
        if (component4 == null || !component4.isShowing()) {
            Logger $this$debug_u24default$iv = LOG;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug(" tool window " + toolWindow2.getId() + " default component is hidden: " + container, t$iv);
            }
            return null;
        }
        return component4;
    }

    private static final void updateToolWindow(ToolWindowImpl toolWindow2, Component component2) {
        if (component2.isFocusOwner()) {
            toolWindow2.toolWindowManager.updateToolWindow$intellij_platform_ide_impl(toolWindow2, component2);
        }
        RequestFocusInToolWindowKt.updateFocusedComponentForWatcher(component2);
    }

    private static final void updateFocusedComponentForWatcher(Component c) {
        WindowManager windowManager = WindowManager.getInstance();
        Intrinsics.checkNotNull((Object)windowManager, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.WindowManagerImpl");
        WindowWatcher watcher = ((WindowManagerImpl)windowManager).getWindowWatcher$intellij_platform_ide_impl();
        FocusWatcher focusWatcher = watcher.getFocusWatcherFor(c);
        if (focusWatcher != null && c.isFocusOwner()) {
            focusWatcher.setFocusedComponentImpl(c);
        }
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$updateToolWindow(ToolWindowImpl toolWindow2, Component component2) {
        RequestFocusInToolWindowKt.updateToolWindow(toolWindow2, component2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FocusTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

