/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.colorpicker.ColorAdjustPanel;
import com.intellij.ui.colorpicker.ColorListenerInfo;
import com.intellij.ui.colorpicker.ColorPickerBuilderKt;
import com.intellij.ui.colorpicker.ColorPickerComponentProvider;
import com.intellij.ui.colorpicker.ColorPickerModel;
import com.intellij.ui.colorpicker.ColorPipetteProvider;
import com.intellij.ui.colorpicker.ColorValuePanel;
import com.intellij.ui.colorpicker.GraphicalColorPipetteProvider;
import com.intellij.ui.colorpicker.LightCalloutPopup;
import com.intellij.ui.colorpicker.MyFocusTraversalPolicy;
import com.intellij.ui.colorpicker.OperationPanel;
import com.intellij.ui.colorpicker.SaturationBrightnessComponent;
import com.intellij.ui.picker.ColorListener;
import com.intellij.ui.picker.ColorPickerPopupCloseListener;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u001c\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010\u001d\u001a\u00020\u0000J\u0012\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u001f\u001a\u00020 H\u0007J\u0006\u0010!\u001a\u00020\u0000J2\u0010\"\u001a\u00020\u00002\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020%\u0018\u00010$2\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020%\u0018\u00010$J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\u0000J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0003J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010-\u001a\u00020\u0000J\u0016\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u0017J\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u000203J\u0016\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0003J\u0010\u00105\u001a\u00020%2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0006\u00106\u001a\u000207R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/ui/colorpicker/ColorPickerBuilder;", "", "showAlpha", "", "showAlphaAsPercent", "<init>", "(ZZ)V", "componentsToBuild", "", "Ljavax/swing/JComponent;", "model", "Lcom/intellij/ui/colorpicker/ColorPickerModel;", "getModel", "()Lcom/intellij/ui/colorpicker/ColorPickerModel;", "originalColor", "Ljava/awt/Color;", "requestFocusWhenDisplay", "focusCycleRoot", "focusedComponentIndex", "", "actionMap", "", "Ljavax/swing/KeyStroke;", "Ljavax/swing/Action;", "colorListeners", "Lcom/intellij/ui/colorpicker/ColorListenerInfo;", "popupCloseListener", "Lcom/intellij/ui/picker/ColorPickerPopupCloseListener;", "setOriginalColor", "addSaturationBrightnessComponent", "addColorAdjustPanel", "colorPipetteProvider", "Lcom/intellij/ui/colorpicker/ColorPipetteProvider;", "addColorValuePanel", "addOperationPanel", "okOperation", "Lkotlin/Function1;", "", "cancelOperation", "addCustomComponent", "provider", "Lcom/intellij/ui/colorpicker/ColorPickerComponentProvider;", "addSeparator", "focusWhenDisplay", "setFocusCycleRoot", "withFocus", "addKeyAction", "keyStroke", "action", "addColorListener", "colorListener", "Lcom/intellij/ui/picker/ColorListener;", "invokeOnEveryColorChange", "setPopupCloseListener", "build", "Lcom/intellij/ui/colorpicker/LightCalloutPopup;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nColorPickerBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorPickerBuilder.kt\ncom/intellij/ui/colorpicker/ColorPickerBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,196:1\n1#2:197\n1586#3:198\n1661#3,3:199\n1586#3:202\n1661#3,3:203\n1915#3,2:208\n221#4,2:206\n*S KotlinDebug\n*F\n+ 1 ColorPickerBuilder.kt\ncom/intellij/ui/colorpicker/ColorPickerBuilder\n*L\n135#1:198\n135#1:199,3\n136#1:202\n136#1:203,3\n177#1:208,2\n171#1:206,2\n*E\n"})
public final class ColorPickerBuilder {
    private final boolean showAlpha;
    private final boolean showAlphaAsPercent;
    @NotNull
    private final List<JComponent> componentsToBuild;
    @NotNull
    private final ColorPickerModel model;
    @Nullable
    private Color originalColor;
    private boolean requestFocusWhenDisplay;
    private boolean focusCycleRoot;
    private int focusedComponentIndex;
    @NotNull
    private final Map<KeyStroke, Action> actionMap;
    @NotNull
    private final List<ColorListenerInfo> colorListeners;
    @Nullable
    private ColorPickerPopupCloseListener popupCloseListener;

    public ColorPickerBuilder(boolean showAlpha, boolean showAlphaAsPercent) {
        this.showAlpha = showAlpha;
        this.showAlphaAsPercent = showAlphaAsPercent;
        this.componentsToBuild = new ArrayList();
        this.model = new ColorPickerModel(null, 1, null);
        this.focusedComponentIndex = -1;
        this.actionMap = new LinkedHashMap();
        this.colorListeners = new ArrayList();
    }

    public /* synthetic */ ColorPickerBuilder(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        this(bl, bl2);
    }

    @NotNull
    public final ColorPickerModel getModel() {
        return this.model;
    }

    @NotNull
    public final ColorPickerBuilder setOriginalColor(@Nullable Color originalColor) {
        ColorPickerBuilder colorPickerBuilder;
        ColorPickerBuilder $this$setOriginalColor_u24lambda_u240 = colorPickerBuilder = this;
        boolean bl = false;
        $this$setOriginalColor_u24lambda_u240.originalColor = originalColor;
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder addSaturationBrightnessComponent() {
        ColorPickerBuilder colorPickerBuilder;
        ColorPickerBuilder $this$addSaturationBrightnessComponent_u24lambda_u240 = colorPickerBuilder = this;
        boolean bl = false;
        $this$addSaturationBrightnessComponent_u24lambda_u240.componentsToBuild.add(new SaturationBrightnessComponent($this$addSaturationBrightnessComponent_u24lambda_u240.model));
        return colorPickerBuilder;
    }

    @JvmOverloads
    @NotNull
    public final ColorPickerBuilder addColorAdjustPanel(@NotNull ColorPipetteProvider colorPipetteProvider) {
        ColorPickerBuilder colorPickerBuilder;
        Intrinsics.checkNotNullParameter((Object)colorPipetteProvider, (String)"colorPipetteProvider");
        ColorPickerBuilder $this$addColorAdjustPanel_u24lambda_u240 = colorPickerBuilder = this;
        boolean bl = false;
        $this$addColorAdjustPanel_u24lambda_u240.componentsToBuild.add(new ColorAdjustPanel($this$addColorAdjustPanel_u24lambda_u240.model, colorPipetteProvider, $this$addColorAdjustPanel_u24lambda_u240.showAlpha));
        return colorPickerBuilder;
    }

    public static /* synthetic */ ColorPickerBuilder addColorAdjustPanel$default(ColorPickerBuilder colorPickerBuilder, ColorPipetteProvider colorPipetteProvider, int n, Object object) {
        if ((n & 1) != 0) {
            colorPipetteProvider = new GraphicalColorPipetteProvider();
        }
        return colorPickerBuilder.addColorAdjustPanel(colorPipetteProvider);
    }

    @NotNull
    public final ColorPickerBuilder addColorValuePanel() {
        ColorPickerBuilder colorPickerBuilder;
        ColorPickerBuilder $this$addColorValuePanel_u24lambda_u240 = colorPickerBuilder = this;
        boolean bl = false;
        $this$addColorValuePanel_u24lambda_u240.componentsToBuild.add(new ColorValuePanel($this$addColorValuePanel_u24lambda_u240.model, $this$addColorValuePanel_u24lambda_u240.showAlpha, $this$addColorValuePanel_u24lambda_u240.showAlphaAsPercent));
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder addOperationPanel(@Nullable Function1<? super Color, Unit> okOperation, @Nullable Function1<? super Color, Unit> cancelOperation) {
        ColorPickerBuilder colorPickerBuilder;
        ColorPickerBuilder $this$addOperationPanel_u24lambda_u240 = colorPickerBuilder = this;
        boolean bl = false;
        $this$addOperationPanel_u24lambda_u240.componentsToBuild.add(new OperationPanel($this$addOperationPanel_u24lambda_u240.model, okOperation, cancelOperation));
        if (cancelOperation != null) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
            Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
            $this$addOperationPanel_u24lambda_u240.addKeyAction(keyStroke, new AbstractAction(cancelOperation, $this$addOperationPanel_u24lambda_u240){
                final /* synthetic */ Function1<Color, Unit> $cancelOperation;
                final /* synthetic */ ColorPickerBuilder $this_apply;
                {
                    this.$cancelOperation = $cancelOperation;
                    this.$this_apply = $this_apply;
                }

                public void actionPerformed(ActionEvent e) {
                    this.$cancelOperation.invoke((Object)this.$this_apply.getModel().getColor());
                }
            });
        }
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder addCustomComponent(@NotNull ColorPickerComponentProvider provider) {
        ColorPickerBuilder colorPickerBuilder;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        ColorPickerBuilder $this$addCustomComponent_u24lambda_u240 = colorPickerBuilder = this;
        boolean bl = false;
        $this$addCustomComponent_u24lambda_u240.componentsToBuild.add(provider.createComponent($this$addCustomComponent_u24lambda_u240.model));
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder addSeparator() {
        ColorPickerBuilder colorPickerBuilder;
        ColorPickerBuilder $this$addSeparator_u24lambda_u240 = colorPickerBuilder = this;
        boolean bl = false;
        JSeparator separator = new JSeparator(0);
        separator.setBorder((Border)JBUI.Borders.empty());
        separator.setPreferredSize((Dimension)JBUI.size((int)300, (int)5));
        $this$addSeparator_u24lambda_u240.componentsToBuild.add(separator);
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder focusWhenDisplay(boolean focusWhenDisplay) {
        ColorPickerBuilder colorPickerBuilder;
        ColorPickerBuilder $this$focusWhenDisplay_u24lambda_u240 = colorPickerBuilder = this;
        boolean bl = false;
        $this$focusWhenDisplay_u24lambda_u240.requestFocusWhenDisplay = focusWhenDisplay;
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder setFocusCycleRoot(boolean focusCycleRoot) {
        ColorPickerBuilder colorPickerBuilder;
        ColorPickerBuilder $this$setFocusCycleRoot_u24lambda_u240 = colorPickerBuilder = this;
        boolean bl = false;
        $this$setFocusCycleRoot_u24lambda_u240.focusCycleRoot = focusCycleRoot;
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder withFocus() {
        ColorPickerBuilder colorPickerBuilder;
        ColorPickerBuilder $this$withFocus_u24lambda_u240 = colorPickerBuilder = this;
        boolean bl = false;
        $this$withFocus_u24lambda_u240.focusedComponentIndex = $this$withFocus_u24lambda_u240.componentsToBuild.size() - 1;
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder addKeyAction(@NotNull KeyStroke keyStroke, @NotNull Action action2) {
        ColorPickerBuilder colorPickerBuilder;
        Intrinsics.checkNotNullParameter((Object)keyStroke, (String)"keyStroke");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        ColorPickerBuilder $this$addKeyAction_u24lambda_u240 = colorPickerBuilder = this;
        boolean bl = false;
        $this$addKeyAction_u24lambda_u240.actionMap.put(keyStroke, action2);
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder addColorListener(@NotNull ColorListener colorListener) {
        Intrinsics.checkNotNullParameter((Object)colorListener, (String)"colorListener");
        return this.addColorListener(colorListener, true);
    }

    @NotNull
    public final ColorPickerBuilder addColorListener(@NotNull ColorListener colorListener, boolean invokeOnEveryColorChange) {
        ColorPickerBuilder colorPickerBuilder;
        Intrinsics.checkNotNullParameter((Object)colorListener, (String)"colorListener");
        ColorPickerBuilder $this$addColorListener_u24lambda_u240 = colorPickerBuilder = this;
        boolean bl = false;
        $this$addColorListener_u24lambda_u240.colorListeners.add(new ColorListenerInfo(colorListener, invokeOnEveryColorChange));
        return colorPickerBuilder;
    }

    public final void setPopupCloseListener(@Nullable ColorPickerPopupCloseListener popupCloseListener) {
        this.popupCloseListener = popupCloseListener;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LightCalloutPopup build() {
        boolean bl;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (this.componentsToBuild.isEmpty()) {
            throw new IllegalStateException("The Color Picker should have at least one picking component.");
        }
        Iterable $this$map$iv = this.componentsToBuild;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            JComponent jComponent = (JComponent)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(jComponent.getPreferredSize().width);
        }
        Comparable comparable = CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNull((Object)comparable);
        int width = ((Number)((Object)comparable)).intValue();
        Iterable $this$map$iv2 = this.componentsToBuild;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            JComponent bl2 = (JComponent)t;
            collection = destination$iv$iv2;
            boolean bl22 = false;
            collection.add(it.getPreferredSize().height);
        }
        int height = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv2));
        Ref.ObjectRef defaultFocusComponent = new Ref.ObjectRef();
        defaultFocusComponent.element = CollectionsKt.getOrNull(this.componentsToBuild, (int)this.focusedComponentIndex);
        if (defaultFocusComponent.element instanceof ColorValuePanel) {
            defaultFocusComponent.element = ((ColorValuePanel)defaultFocusComponent.element).getHexField();
        }
        JPanel panel2 = new JPanel((Ref.ObjectRef<JComponent>)defaultFocusComponent, this){
            final /* synthetic */ Ref.ObjectRef<JComponent> $defaultFocusComponent;
            final /* synthetic */ ColorPickerBuilder this$0;
            {
                this.$defaultFocusComponent = $defaultFocusComponent;
                this.this$0 = $receiver;
            }

            public boolean requestFocusInWindow() {
                JComponent jComponent = (JComponent)this.$defaultFocusComponent.element;
                return jComponent != null ? jComponent.requestFocusInWindow() : false;
            }

            public void addNotify() {
                super.addNotify();
                if (ColorPickerBuilder.access$getRequestFocusWhenDisplay$p(this.this$0)) {
                    this.requestFocusInWindow();
                }
            }
        };
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.setBorder((Border)ColorPickerBuilderKt.access$getPICKER_BORDER$p());
        panel2.setPreferredSize(new Dimension(width, height));
        panel2.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        Color c = this.originalColor;
        if (c != null) {
            this.model.setColor(c, null);
        }
        for (JComponent component2 : this.componentsToBuild) {
            panel2.add(component2);
        }
        panel2.setFocusCycleRoot(this.focusCycleRoot);
        panel2.setFocusTraversalPolicyProvider(true);
        panel2.setFocusTraversalPolicy(new MyFocusTraversalPolicy((Component)defaultFocusComponent.element));
        Object $this$forEach$iv = this.actionMap;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry it = entry = (Map.Entry)iterator.next();
            bl = false;
            KeyStroke keyStroke = (KeyStroke)it.getKey();
            Action action2 = (Action)it.getValue();
            DumbAwareAction.create(arg_0 -> ColorPickerBuilder.build$lambda$2$1(arg_0 -> ColorPickerBuilder.build$lambda$2$0(action2, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke), (JComponent)panel2);
        }
        $this$forEach$iv = this.colorListeners;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            ColorListenerInfo it = (ColorListenerInfo)object;
            bl = false;
            this.model.addListener(it.getColorListener(), it.getInvokeOnEveryColorChange());
        }
        return new LightCalloutPopup(panel2, () -> ColorPickerBuilder.build$lambda$4(this), () -> ColorPickerBuilder.build$lambda$5(this), null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final ColorPickerBuilder addColorAdjustPanel() {
        return ColorPickerBuilder.addColorAdjustPanel$default(this, null, 1, null);
    }

    private static final Unit build$lambda$2$0(Action $action, AnActionEvent e) {
        AnActionEvent anActionEvent = e;
        $action.actionPerformed(new ActionEvent(anActionEvent != null ? anActionEvent.getInputEvent() : null, 0, ""));
        return Unit.INSTANCE;
    }

    private static final void build$lambda$2$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit build$lambda$4(ColorPickerBuilder this$0) {
        block0: {
            this$0.model.onClose();
            ColorPickerPopupCloseListener colorPickerPopupCloseListener = this$0.popupCloseListener;
            if (colorPickerPopupCloseListener == null) break block0;
            colorPickerPopupCloseListener.onPopupClosed();
        }
        return Unit.INSTANCE;
    }

    private static final Unit build$lambda$5(ColorPickerBuilder this$0) {
        block0: {
            this$0.model.onCancel();
            ColorPickerPopupCloseListener colorPickerPopupCloseListener = this$0.popupCloseListener;
            if (colorPickerPopupCloseListener == null) break block0;
            colorPickerPopupCloseListener.onPopupClosed();
        }
        return Unit.INSTANCE;
    }

    public ColorPickerBuilder() {
        this(false, false, 3, null);
    }

    public static final /* synthetic */ boolean access$getRequestFocusWhenDisplay$p(ColorPickerBuilder $this) {
        return $this.requestFocusWhenDisplay;
    }
}

