/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.docking.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorComposite;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.DockableEditor;
import com.intellij.openapi.fileEditor.impl.DockableEditorContainerFactoryKt;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeGlassPaneImplKt;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.DevicePoint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DockableContentContainer;
import com.intellij.ui.docking.DragSession;
import com.intellij.ui.docking.impl.DockWindow;
import com.intellij.ui.drag.DialogDragImageView;
import com.intellij.ui.drag.DialogWithImage;
import com.intellij.ui.drag.DragImageView;
import com.intellij.ui.drag.GlassPaneDragImageView;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DockManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")}, getStateRequiresEdt=true)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 [2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0003[\\]B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u001fJ\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007J \u0010 \u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0016J\u000e\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110)H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u0010\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\fH\u0016J$\u0010.\u001a\u0004\u0018\u00010\u00112\b\u0010/\u001a\u0004\u0018\u0001002\u000e\u00101\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001102H\u0017J\u001c\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\n\u00107\u001a\u0006\u0012\u0002\b\u000308H\u0016J\u0006\u00109\u001a\u00020\u001dJ\u001e\u0010>\u001a\u0004\u0018\u00010\u00112\u0006\u0010?\u001a\u00020@2\n\u00107\u001a\u0006\u0012\u0002\b\u000308H\u0002J\u0010\u0010A\u001a\u00020\r2\u0006\u0010B\u001a\u00020\fH\u0002J\u001a\u0010C\u001a\u00020\u001d2\n\u00107\u001a\u0006\u0012\u0002\b\u0003082\u0006\u0010D\u001a\u00020EJ9\u0010C\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020'2\u0012\u0010L\u001a\u000e\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020F0MH\u0000\u00a2\u0006\u0002\bOJ,\u0010P\u001a\u00020\u00142\b\u0010Q\u001a\u0004\u0018\u00010\f2\b\u0010#\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010R\u001a\u00020'H\u0002J\u0018\u0010S\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\b\u0010T\u001a\u00020\u0003H\u0016J\u000e\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00110VH\u0002J\n\u0010W\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010X\u001a\u00020\u001d2\u0006\u0010Y\u001a\u00020\u0003H\u0016J\u0018\u0010Z\u001a\u00020\u001d2\u0006\u0010B\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u000bj\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0014`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0018\u00010\u0016R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\u00020;8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006^"}, d2={"Lcom/intellij/ui/docking/impl/DockManagerImpl;", "Lcom/intellij/ui/docking/DockManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "factories", "Ljava/util/HashMap;", "", "Lcom/intellij/ui/docking/DockContainerFactory;", "Lkotlin/collections/HashMap;", "containers", "Ljava/util/HashSet;", "Lcom/intellij/ui/docking/DockContainer;", "Lkotlin/collections/HashSet;", "containerToWindow", "Lcom/intellij/ui/docking/impl/DockWindow;", "currentDragSession", "Lcom/intellij/ui/docking/impl/DockManagerImpl$MyDragSession;", "busyObject", "Lcom/intellij/openapi/util/BusyObject$Impl;", "windowIdCounter", "", "loadedState", "removeContainer", "", "container", "removeContainer$intellij_platform_ide_impl", "register", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "id", "factory", "readState", "requestFocus", "", "getContainers", "", "getIdeFrame", "Lcom/intellij/openapi/wm/IdeFrame;", "getDimensionKeyForFocus", "key", "getContainerFor", "c", "Ljava/awt/Component;", "filter", "Ljava/util/function/Predicate;", "createDragSession", "Lcom/intellij/ui/docking/DragSession;", "mouseEvent", "Ljava/awt/event/MouseEvent;", "content", "Lcom/intellij/ui/docking/DockableContent;", "stopCurrentDragSession", "ready", "Lcom/intellij/openapi/util/ActionCallback;", "getReady$intellij_platform_ide_impl", "()Lcom/intellij/openapi/util/ActionCallback;", "findContainerFor", "devicePoint", "Lcom/intellij/ui/awt/DevicePoint;", "getFactory", "type", "createNewDockContainerFor", "point", "Lcom/intellij/ui/awt/RelativePoint;", "Lcom/intellij/openapi/fileEditor/FileEditorComposite;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditorManager", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl;", "isSingletonEditorInWindow", "openFile", "Lkotlin/Function1;", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "createNewDockContainerFor$intellij_platform_ide_impl", "createWindowFor", "dimensionKey", "canReopenWindow", "getOrCreateWindowFor", "getState", "getAllContainers", "Lkotlin/sequences/Sequence;", "getFileManagerContainer", "loadState", "state", "readStateFor", "Companion", "MyDragSession", "DragImageDialog", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDockManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockManagerImpl.kt\ncom/intellij/ui/docking/impl/DockManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,569:1\n1#2:570\n296#3,2:571\n*S KotlinDebug\n*F\n+ 1 DockManagerImpl.kt\ncom/intellij/ui/docking/impl/DockManagerImpl\n*L\n483#1:571,2\n*E\n"})
public final class DockManagerImpl
extends DockManager
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final HashMap<String, DockContainerFactory> factories;
    @NotNull
    private final HashSet<DockContainer> containers;
    @NotNull
    private final HashMap<DockContainer, DockWindow> containerToWindow;
    @Nullable
    private MyDragSession currentDragSession;
    @NotNull
    private final BusyObject.Impl busyObject;
    private int windowIdCounter;
    @Nullable
    private Element loadedState;
    @NotNull
    private static final Key<Boolean> SHOW_NORTH_PANEL = FileEditorManagerKeys.SHOW_NORTH_PANEL;
    @NotNull
    private static final Key<String> WINDOW_DIMENSION_KEY = FileEditorManagerKeys.WINDOW_DIMENSION_KEY;

    public DockManagerImpl(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        this.coroutineScope = coroutineScope;
        this.factories = new HashMap();
        this.containers = new HashSet();
        this.containerToWindow = new HashMap();
        this.busyObject = new BusyObject.Impl(this){
            final /* synthetic */ DockManagerImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isReady() {
                return DockManagerImpl.access$getCurrentDragSession$p(this.this$0) == null;
            }
        };
        this.windowIdCounter = 1;
    }

    public final void removeContainer$intellij_platform_ide_impl(@NotNull DockContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.containers.remove(container);
    }

    public void register(@NotNull DockContainer container, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.containers.add(container);
        Disposer.register((Disposable)parentDisposable, () -> DockManagerImpl.register$lambda$0(this, container));
    }

    public final void register(@NotNull DockContainer container, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.containers.add(container);
        IdeGlassPaneImplKt.executeOnCancelInEdt(coroutineScope, (Function0<Unit>)((Function0)() -> DockManagerImpl.register$lambda$1(this, container)));
    }

    public void register(@NotNull String id2, @NotNull DockContainerFactory factory2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.factories.put(id2, factory2);
        if (parentDisposable != this.project) {
            Disposer.register((Disposable)parentDisposable, () -> DockManagerImpl.register$lambda$2(this, id2));
        }
        this.readStateFor(id2, true);
    }

    public final void readState(boolean requestFocus) {
        Iterator<String> iterator = this.factories.keySet().iterator();
        while (iterator.hasNext()) {
            String id2;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            this.readStateFor(id2, requestFocus);
        }
    }

    @NotNull
    public Set<DockContainer> getContainers() {
        return SequencesKt.toSet(this.getAllContainers());
    }

    @Nullable
    public IdeFrame getIdeFrame(@NotNull DockContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Component component2 = ComponentUtil.findUltimateParent((Component)container.getContainerComponent());
        return component2 instanceof IdeFrame ? (IdeFrame)component2 : null;
    }

    @NotNull
    public String getDimensionKeyForFocus(@NotNull String key) {
        DockWindow window;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Component component2 = IdeFocusManager.getInstance((Project)this.project).getFocusOwner();
        if (component2 == null) {
            return key;
        }
        Component owner = component2;
        Map map2 = this.containerToWindow;
        DockWindow dockWindow = window = (DockWindow)map2.get(this.getContainerFor(owner, arg_0 -> DockManagerImpl.getDimensionKeyForFocus$lambda$1(DockManagerImpl::getDimensionKeyForFocus$lambda$0, arg_0)));
        return dockWindow == null ? key : key + "#" + dockWindow.getId();
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public DockContainer getContainerFor(@Nullable Component c, @NotNull Predicate<? super DockContainer> filter2) {
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        if (c == null) {
            return null;
        }
        for (DockContainer eachContainer : this.getAllContainers()) {
            if (!SwingUtilities.isDescendingFrom(c, eachContainer.getContainerComponent()) || !filter2.test((DockContainer)eachContainer)) continue;
            return eachContainer;
        }
        Component component2 = ComponentUtil.findUltimateParent((Component)c);
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"findUltimateParent(...)");
        Component parent = component2;
        for (DockContainer eachContainer : this.getAllContainers()) {
            if (parent != ComponentUtil.findUltimateParent((Component)eachContainer.getContainerComponent()) || !filter2.test((DockContainer)eachContainer)) continue;
            return eachContainer;
        }
        return null;
    }

    @NotNull
    public DragSession createDragSession(@NotNull MouseEvent mouseEvent, @NotNull DockableContent<?> content2) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Intrinsics.checkNotNullParameter(content2, (String)"content");
        this.stopCurrentDragSession();
        Object object = this.getAllContainers().iterator();
        while (object.hasNext()) {
            DockContainer container = (DockContainer)object.next();
            if (!container.isEmpty() || !container.isDisposeWhenEmpty()) continue;
            DockWindow dockWindow = this.containerToWindow.get(container);
            if (dockWindow == null) continue;
            dockWindow.setTransparent(true);
        }
        Object it = object = new MyDragSession(mouseEvent, content2);
        boolean bl = false;
        this.currentDragSession = it;
        return (DragSession)object;
    }

    public final void stopCurrentDragSession() {
        if (this.currentDragSession == null) {
            return;
        }
        MyDragSession myDragSession = this.currentDragSession;
        Intrinsics.checkNotNull((Object)myDragSession);
        myDragSession.cancelSession();
        this.currentDragSession = null;
        this.busyObject.onReady();
        for (DockContainer container : this.getAllContainers()) {
            if (container.isEmpty()) continue;
            DockWindow dockWindow = this.containerToWindow.get(container);
            if (dockWindow == null) continue;
            dockWindow.setTransparent(false);
        }
    }

    @NotNull
    public final ActionCallback getReady$intellij_platform_ide_impl() {
        ActionCallback actionCallback = this.busyObject.getReady((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"getReady(...)");
        return actionCallback;
    }

    private final DockContainer findContainerFor(DevicePoint devicePoint, DockableContent<?> content2) {
        DockContainer startDragContainer;
        List containers = SequencesKt.toMutableList(this.getAllContainers());
        DockContainer dockContainer = this.getFileManagerContainer();
        if (dockContainer != null) {
            DockContainer p0 = dockContainer;
            boolean bl = false;
            containers.add(p0);
        }
        MyDragSession myDragSession = this.currentDragSession;
        Object object = startDragContainer = myDragSession != null ? myDragSession.getStartDragContainer() : null;
        if (startDragContainer != null) {
            containers.remove(startDragContainer);
            containers.add(0, startDragContainer);
        }
        for (DockContainer each : containers) {
            RelativeRectangle rec;
            Intrinsics.checkNotNullExpressionValue((Object)each.getAcceptArea(), (String)"getAcceptArea(...)");
            if (!rec.contains(devicePoint)) continue;
            JComponent jComponent = each.getContainerComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContainerComponent(...)");
            if (!each.getContentResponse(content2, devicePoint.toRelativePoint((Component)jComponent)).canAccept()) continue;
            return each;
        }
        for (DockContainer each : containers) {
            RelativeRectangle rec;
            Intrinsics.checkNotNullExpressionValue((Object)each.getAcceptAreaFallback(), (String)"getAcceptAreaFallback(...)");
            if (!rec.contains(devicePoint)) continue;
            JComponent jComponent = each.getContainerComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContainerComponent(...)");
            if (!each.getContentResponse(content2, devicePoint.toRelativePoint((Component)jComponent)).canAccept()) continue;
            return each;
        }
        return null;
    }

    private final DockContainerFactory getFactory(String type) {
        DockContainerFactory dockContainerFactory = this.factories.get(type);
        if (dockContainerFactory == null) {
            boolean bl = false;
            String string = "No factory for content type=" + type;
            throw new IllegalArgumentException(string.toString());
        }
        return dockContainerFactory;
    }

    public final void createNewDockContainerFor(@NotNull DockableContent<?> content2, @NotNull RelativePoint point) {
        boolean isNorthPanelAvailable;
        boolean isSingletonEditorInWindow;
        Intrinsics.checkNotNullParameter(content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        String string = content2.getDockContainerType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDockContainerType(...)");
        DockContainer dockContainer = this.getFactory(string).createContainer(content2);
        Intrinsics.checkNotNullExpressionValue((Object)dockContainer, (String)"createContainer(...)");
        DockContainer container = dockContainer;
        DockableEditor dockableEditor = content2 instanceof DockableEditor ? (DockableEditor)content2 : null;
        VirtualFile file2 = dockableEditor != null ? dockableEditor.file : null;
        Boolean canReopenWindow = (Boolean)FileEditorManagerKeys.REOPEN_WINDOW.get((UserDataHolder)file2, (Object)true);
        String string2 = DockManagerImpl.Companion.getWindowDimensionKey(content2);
        Intrinsics.checkNotNull((Object)canReopenWindow);
        DockWindow window = this.createWindowFor(string2, null, container, canReopenWindow);
        DockableEditor dockableEditor2 = content2 instanceof DockableEditor ? (DockableEditor)content2 : null;
        boolean bl = isSingletonEditorInWindow = dockableEditor2 != null ? dockableEditor2.isSingletonEditorInWindow : false;
        if (!isSingletonEditorInWindow) {
            window.setupToolWindowPane();
        }
        DockableEditor dockableEditor3 = content2 instanceof DockableEditor ? (DockableEditor)content2 : null;
        boolean bl2 = isNorthPanelAvailable = dockableEditor3 != null ? dockableEditor3.isNorthPanelAvailable : true;
        if (isNorthPanelAvailable) {
            window.setupNorthPanel();
        }
        Dimension size2 = content2.getPreferredSize();
        Point showPoint = new DevicePoint(point).getLocationOnScreen();
        showPoint.x -= size2.width / 2;
        showPoint.y -= size2.height / 2;
        Rectangle target = new Rectangle(showPoint, size2);
        ScreenUtil.moveRectangleToFitTheScreen((Rectangle)target);
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)target);
        Point point2 = target.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getLocation(...)");
        window.setLocation(point2);
        window.getDockContentUiContainer().setPreferredSize(target.getSize());
        window.show(false);
        window.getFrame().pack();
        container.add(content2, new RelativePoint(target.getLocation()));
        SwingUtilities.invokeLater(() -> DockManagerImpl.createNewDockContainerFor$lambda$0(window));
    }

    @NotNull
    public final FileEditorComposite createNewDockContainerFor$intellij_platform_ide_impl(@NotNull VirtualFile file2, @NotNull FileEditorManagerImpl fileEditorManager, boolean isSingletonEditorInWindow, @NotNull Function1<? super EditorWindow, ? extends FileEditorComposite> openFile2) {
        boolean isNorthPanelAvailable;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)fileEditorManager), (String)"fileEditorManager");
        Intrinsics.checkNotNullParameter(openFile2, (String)"openFile");
        DockableEditorTabbedContainer container = DockableEditorContainerFactoryKt.createEditorDockContainer(fileEditorManager, false, CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, null, (boolean)false, (int)3, null), isSingletonEditorInWindow);
        String string = DockManagerImpl.Companion.getWindowDimensionKey(file2);
        DockContainer dockContainer = (DockContainer)container;
        Object object = FileEditorManagerKeys.REOPEN_WINDOW.get((UserDataHolder)file2, (Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        DockWindow window = this.createWindowFor(string, null, dockContainer, (Boolean)object);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            window.show(true);
        }
        EditorWindow editorWindow = container.splitters.getOrCreateCurrentWindow$intellij_platform_ide_impl(file2);
        FileEditorComposite result2 = (FileEditorComposite)openFile2.invoke((Object)editorWindow);
        if (!isSingletonEditorInWindow) {
            window.setupToolWindowPane();
        }
        if (isNorthPanelAvailable = Companion.isNorthPanelAvailable(result2.getAllEditors())) {
            window.setupNorthPanel();
        }
        container.add(new DockableEditor(null, file2, new Presentation(file2.getName()), editorWindow.getSize(), editorWindow.isFilePinned(file2), isSingletonEditorInWindow, isNorthPanelAvailable), null);
        SwingUtilities.invokeLater(() -> DockManagerImpl.createNewDockContainerFor$lambda$1(window));
        return result2;
    }

    private final DockWindow createWindowFor(String dimensionKey, String id2, DockContainer container, boolean canReopenWindow) {
        String string = id2;
        if (string == null) {
            int n = this.windowIdCounter;
            this.windowIdCounter = n + 1;
            string = String.valueOf(n);
        }
        String windowId = string;
        CoroutineScope coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)("DockWindow #" + windowId), null, (boolean)false, (int)6, null);
        boolean bl = container instanceof DockContainer.Dialog;
        DockWindow window = new DockWindow(this, dimensionKey, windowId, container, bl, canReopenWindow, coroutineScope);
        this.containerToWindow.put(container, window);
        JobKt.getJob((CoroutineContext)coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> DockManagerImpl.createWindowFor$lambda$0(this, container, arg_0));
        return window;
    }

    private final DockWindow getOrCreateWindowFor(String id2, DockContainer container) {
        Object v1;
        block3: {
            Collection<DockWindow> collection = this.containerToWindow.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DockWindow it = (DockWindow)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id2)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        DockWindow existingWindow = v1;
        if (existingWindow != null) {
            DockContainer oldContainer = existingWindow.replaceContainer(container);
            this.containerToWindow.remove(oldContainer);
            this.containerToWindow.put(container, existingWindow);
            if (oldContainer instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)oldContainer));
            }
            return existingWindow;
        }
        return this.createWindowFor(null, id2, container, true);
    }

    @NotNull
    public Element getState() {
        Element root = new Element("state");
        for (DockContainer container : this.getAllContainers()) {
            DockWindow window = this.containerToWindow.get(container);
            if (window == null || !window.getSupportReopen() || !(container instanceof DockContainer.Persistent)) continue;
            Element eachWindowElement = new Element("window");
            eachWindowElement.setAttribute("id", window.getId());
            eachWindowElement.setAttribute("withNorthPanel", String.valueOf(window.getNorthPanelAvailable()));
            eachWindowElement.setAttribute("withToolWindowPane", String.valueOf(window.getToolWindowPane() != null));
            Element content2 = new Element("content");
            content2.setAttribute("type", ((DockContainer.Persistent)container).getDockContainerType());
            content2.addContent(((DockContainer.Persistent)container).getState());
            eachWindowElement.addContent(content2);
            root.addContent(eachWindowElement);
        }
        return root;
    }

    private final Sequence<DockContainer> getAllContainers() {
        Sequence sequence = SequencesKt.plus((Sequence)UtilKt.sequenceOfNotNull((Object)this.getFileManagerContainer()), (Sequence)CollectionsKt.asSequence((Iterable)this.containers));
        Set<DockContainer> set = this.containerToWindow.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return SequencesKt.plus((Sequence)sequence, (Iterable)set);
    }

    private final DockContainer getFileManagerContainer() {
        return this.project.isDefault() ? null : FileEditorManagerEx.Companion.getInstanceEx(this.project).getDockContainer();
    }

    public void loadState(@NotNull Element state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.loadedState = state2;
    }

    private final void readStateFor(String type, boolean requestFocus) {
        Element element = this.loadedState;
        if (element == null) {
            return;
        }
        for (Element windowElement : element.getChildren("window")) {
            DockContainerFactory.Persistent factory2;
            DockContainerFactory dockContainerFactory;
            Element eachContent;
            String eachType;
            if (windowElement.getChild("content") == null || !Intrinsics.areEqual((Object)type, (Object)(eachType = eachContent.getAttributeValue("type"))) || !this.factories.containsKey(eachType) || ((dockContainerFactory = this.factories.get(eachType)) instanceof DockContainerFactory.Persistent ? (DockContainerFactory.Persistent)dockContainerFactory : null) == null) continue;
            factory2 = factory2;
            DockContainer container = factory2.loadContainerFrom(eachContent);
            String string = windowElement.getAttributeValue("id");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
            Intrinsics.checkNotNull((Object)container);
            DockWindow window = this.getOrCreateWindowFor(string, container);
            if (Boolean.parseBoolean(windowElement.getAttributeValue("withNorthPanel", "true"))) {
                window.setupNorthPanel();
            }
            if (Boolean.parseBoolean(windowElement.getAttributeValue("withToolWindowPane", "true"))) {
                window.setupToolWindowPane();
            }
            EdtInvocationManager.invokeLaterIfNeeded(() -> DockManagerImpl.readStateFor$lambda$0(window, container, requestFocus));
        }
    }

    private static final void register$lambda$0(DockManagerImpl this$0, DockContainer $container) {
        this$0.containers.remove($container);
    }

    private static final Unit register$lambda$1(DockManagerImpl this$0, DockContainer $container) {
        this$0.containers.remove($container);
        return Unit.INSTANCE;
    }

    private static final void register$lambda$2(DockManagerImpl this$0, String $id) {
        this$0.factories.remove($id);
    }

    private static final boolean getDimensionKeyForFocus$lambda$0(DockContainer dockContainer) {
        Intrinsics.checkNotNullParameter((Object)dockContainer, (String)"<unused var>");
        return true;
    }

    private static final boolean getDimensionKeyForFocus$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void createNewDockContainerFor$lambda$0(DockWindow $window) {
        $window.getUiContainer().setPreferredSize(null);
    }

    private static final void createNewDockContainerFor$lambda$1(DockWindow $window) {
        $window.getUiContainer().setPreferredSize(null);
    }

    private static final Unit createWindowFor$lambda$0(DockManagerImpl this$0, DockContainer $container, Throwable it) {
        this$0.containerToWindow.remove($container);
        if ($container instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)$container));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void readStateFor$lambda$0(DockWindow $window, DockContainer $container, boolean $requestFocus) {
        Window frame = $window.getFrame();
        if (!frame.isVisible()) {
            DockableEditorTabbedContainer dockableEditorTabbedContainer = $container instanceof DockableEditorTabbedContainer ? (DockableEditorTabbedContainer)$container : null;
            if (dockableEditorTabbedContainer != null) {
                dockableEditorTabbedContainer.setFocusOnShowing$intellij_platform_ide_impl($requestFocus);
            }
            frame.setAutoRequestFocus($requestFocus);
            try {
                $window.show();
            }
            finally {
                frame.setAutoRequestFocus(true);
            }
        }
    }

    @JvmStatic
    public static final boolean isNorthPanelVisible(@NotNull UISettings uiSettings) {
        return Companion.isNorthPanelVisible(uiSettings);
    }

    @JvmStatic
    public static final boolean isNorthPanelAvailable(@NotNull List<? extends FileEditor> editors) {
        return Companion.isNorthPanelAvailable(editors);
    }

    public static final /* synthetic */ MyDragSession access$getCurrentDragSession$p(DockManagerImpl $this) {
        return $this.currentDragSession;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0016\u0010\u0016\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0007R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ui/docking/impl/DockManagerImpl$Companion;", "", "<init>", "()V", "SHOW_NORTH_PANEL", "Lcom/intellij/openapi/util/Key;", "", "getSHOW_NORTH_PANEL$annotations", "getSHOW_NORTH_PANEL", "()Lcom/intellij/openapi/util/Key;", "WINDOW_DIMENSION_KEY", "", "getWINDOW_DIMENSION_KEY$annotations", "getWINDOW_DIMENSION_KEY", "getWindowDimensionKey", "content", "Lcom/intellij/ui/docking/DockableContent;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isNorthPanelVisible", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "isNorthPanelAvailable", "editors", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getSHOW_NORTH_PANEL() {
            return SHOW_NORTH_PANEL;
        }

        @Deprecated(message="Prefer using FileEditorManagerKeys.SHOW_NORTH_PANEL", replaceWith=@ReplaceWith(expression="FileEditorManagerKeys.SHOW_NORTH_PANEL", imports={"com.intellij.openapi.fileEditor.FileEditorManagerKeys"}))
        public static /* synthetic */ void getSHOW_NORTH_PANEL$annotations() {
        }

        @NotNull
        public final Key<String> getWINDOW_DIMENSION_KEY() {
            return WINDOW_DIMENSION_KEY;
        }

        @Deprecated(message="Prefer using FileEditorManagerKeys.WINDOW_DIMENSION_KEY", replaceWith=@ReplaceWith(expression="FileEditorManagerKeys.WINDOW_DIMENSION_KEY", imports={"com.intellij.openapi.fileEditor.FileEditorManagerKeys"}))
        public static /* synthetic */ void getWINDOW_DIMENSION_KEY$annotations() {
        }

        private final String getWindowDimensionKey(DockableContent<?> content2) {
            return content2 instanceof DockableEditor ? this.getWindowDimensionKey(((DockableEditor)content2).file) : null;
        }

        private final String getWindowDimensionKey(VirtualFile file2) {
            return (String)FileEditorManagerKeys.WINDOW_DIMENSION_KEY.get((UserDataHolder)file2);
        }

        @JvmStatic
        public final boolean isNorthPanelVisible(@NotNull UISettings uiSettings) {
            Intrinsics.checkNotNullParameter((Object)uiSettings, (String)"uiSettings");
            return uiSettings.getShowNavigationBar() && !uiSettings.getPresentationMode();
        }

        @JvmStatic
        public final boolean isNorthPanelAvailable(@NotNull List<? extends FileEditor> editors) {
            Intrinsics.checkNotNullParameter(editors, (String)"editors");
            for (FileEditor fileEditor : editors) {
                Boolean value;
                Boolean bl = value = (Boolean)FileEditorManagerKeys.SHOW_NORTH_PANEL.get((UserDataHolder)fileEditor);
                if (bl == null) continue;
                return bl;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ui/docking/impl/DockManagerImpl$DragImageDialog;", "Ljavax/swing/JDialog;", "Lcom/intellij/ui/drag/DialogWithImage;", "owner", "Ljava/awt/Window;", "initialImage", "Ljava/awt/Image;", "<init>", "(Ljava/awt/Window;Ljava/awt/Image;)V", "imageContainer", "Ljavax/swing/JLabel;", "value", "image", "getImage", "()Ljava/awt/Image;", "setImage", "(Ljava/awt/Image;)V", "setVisible", "", "isVisible", "", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nDockManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockManagerImpl.kt\ncom/intellij/ui/docking/impl/DockManagerImpl$DragImageDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,569:1\n1#2:570\n*E\n"})
    private static final class DragImageDialog
    extends JDialog
    implements DialogWithImage {
        @NotNull
        private final JLabel imageContainer;
        @Nullable
        private Image image;

        public DragImageDialog(@Nullable Window owner, final @NotNull Image initialImage) {
            Intrinsics.checkNotNullParameter((Object)initialImage, (String)"initialImage");
            super(owner);
            this.image = initialImage;
            this.setUndecorated(true);
            final DragImageDialog observer = this;
            this.imageContainer = new JLabel(new Icon(){

                @Override
                public int getIconWidth() {
                    return initialImage.getWidth(observer);
                }

                @Override
                public int getIconHeight() {
                    return initialImage.getHeight(observer);
                }

                @Override
                public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
                    Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    StartupUiUtil.drawImage$default((Graphics)g, (Image)initialImage, (int)x, (int)y, (int)0, (int)0, null, null, (ImageObserver)observer, (int)48, null);
                }
            });
            this.setContentPane(this.imageContainer);
            this.pack();
        }

        @Override
        @Nullable
        public Image getImage() {
            return this.image;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setImage(@Nullable Image value) {
            JBImageIcon jBImageIcon;
            this.image = value;
            JLabel jLabel = this.imageContainer;
            Image image2 = value;
            if (image2 != null) {
                void it;
                Image image3 = image2;
                JLabel jLabel2 = jLabel;
                boolean bl = false;
                jBImageIcon = IconUtil.createImageIcon((Image)it);
                jLabel = jLabel2;
            } else {
                jBImageIcon = null;
            }
            jLabel.setIcon((Icon)jBImageIcon);
            this.pack();
        }

        @Override
        public void setVisible(boolean isVisible) {
            super.setVisible(isVisible);
            if (isVisible) {
                WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
                windowManager.setAlphaModeEnabled(this, true);
                windowManager.setAlphaModeRatio(this, 0.1f);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\u0006\u0010\u001a\u001a\u00020\u0013R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ui/docking/impl/DockManagerImpl$MyDragSession;", "Lcom/intellij/ui/docking/DragSession;", "mouseEvent", "Ljava/awt/event/MouseEvent;", "content", "Lcom/intellij/ui/docking/DockableContent;", "<init>", "(Lcom/intellij/ui/docking/impl/DockManagerImpl;Ljava/awt/event/MouseEvent;Lcom/intellij/ui/docking/DockableContent;)V", "view", "Lcom/intellij/ui/drag/DragImageView;", "dragImage", "Ljava/awt/Image;", "defaultDragImage", "startDragContainer", "Lcom/intellij/ui/docking/DockContainer;", "getStartDragContainer", "()Lcom/intellij/ui/docking/DockContainer;", "currentOverContainer", "setLocationFrom", "", "me", "getResponse", "Lcom/intellij/ui/docking/DockContainer$ContentResponse;", "e", "process", "cancel", "cancelSession", "intellij.platform.ide.impl"})
    private final class MyDragSession
    implements DragSession {
        @NotNull
        private final DockableContent<?> content;
        @NotNull
        private final DragImageView view;
        @Nullable
        private Image dragImage;
        @NotNull
        private final Image defaultDragImage;
        @Nullable
        private final DockContainer startDragContainer;
        @Nullable
        private DockContainer currentOverContainer;

        public MyDragSession(@NotNull MouseEvent mouseEvent, DockableContent<?> content2) {
            DragImageView dragImageView;
            Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
            Intrinsics.checkNotNullParameter(content2, (String)"content");
            this.content = content2;
            this.startDragContainer = DockManagerImpl.this.getContainerFor(mouseEvent.getComponent(), arg_0 -> MyDragSession.startDragContainer$lambda$1(MyDragSession::startDragContainer$lambda$0, arg_0));
            BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)this.content.getPreviewImage());
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"toBufferedImage(...)");
            BufferedImage buffer2 = bufferedImage;
            double requiredSize = 220.0;
            double width = buffer2.getWidth(null);
            double height = buffer2.getHeight(null);
            double ratio = width > height ? requiredSize / width : requiredSize / height;
            Image image2 = buffer2.getScaledInstance((int)(width * ratio), (int)(height * ratio), 4);
            Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"getScaledInstance(...)");
            this.dragImage = this.defaultDragImage = image2;
            if (StartupUiUtil.isWaylandToolkit()) {
                IdeGlassPane ideGlassPane = IdeGlassPaneUtil.find((Component)mouseEvent.getComponent());
                Intrinsics.checkNotNullExpressionValue((Object)ideGlassPane, (String)"find(...)");
                dragImageView = new GlassPaneDragImageView(ideGlassPane);
            } else {
                dragImageView = new DialogDragImageView(new DragImageDialog(ComponentUtil.getWindow((Component)mouseEvent.getComponent()), this.defaultDragImage));
            }
            this.view = dragImageView;
            this.setLocationFrom(mouseEvent);
            this.view.show();
        }

        @Nullable
        public final DockContainer getStartDragContainer() {
            return this.startDragContainer;
        }

        private final void setLocationFrom(MouseEvent me) {
            DevicePoint devicePoint = new DevicePoint(me);
            Point showPoint = devicePoint.getLocationOnScreen();
            Dimension size2 = this.view.getSize();
            showPoint.x -= size2.width / 2;
            showPoint.y -= size2.height / 2;
            this.view.setLocation(showPoint);
        }

        @NotNull
        public DockContainer.ContentResponse getResponse(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DevicePoint point = new DevicePoint(e);
            for (DockContainer each : DockManagerImpl.this.getAllContainers()) {
                DockContainer.ContentResponse response;
                JComponent component2;
                RelativeRectangle rec;
                Intrinsics.checkNotNullExpressionValue((Object)each.getAcceptArea(), (String)"getAcceptArea(...)");
                if (!rec.contains(point)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)each.getContainerComponent(), (String)"getContainerComponent(...)");
                if (component2.getGraphicsConfiguration() == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)each.getContentResponse(this.content, point.toRelativePoint((Component)component2)), (String)"getContentResponse(...)");
                if (!response.canAccept()) continue;
                return response;
            }
            return DockContainer.ContentResponse.DENY;
        }

        public void process(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DevicePoint devicePoint = new DevicePoint(e);
            Image img = null;
            if (e.getID() == 506) {
                RelativePoint point;
                DockContainer over = DockManagerImpl.this.findContainerFor(devicePoint, this.content);
                if (this.currentOverContainer != null && this.currentOverContainer != over) {
                    DockContainer dockContainer = this.currentOverContainer;
                    Intrinsics.checkNotNull((Object)dockContainer);
                    dockContainer.resetDropOver(this.content);
                    this.currentOverContainer = null;
                }
                if (this.currentOverContainer == null && over != null) {
                    this.currentOverContainer = over;
                    JComponent jComponent = over.getContainerComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContainerComponent(...)");
                    point = devicePoint.toRelativePoint((Component)jComponent);
                    DockContainer dockContainer = this.currentOverContainer;
                    Intrinsics.checkNotNull((Object)dockContainer);
                    img = dockContainer.startDropOver(this.content, point);
                }
                if (this.currentOverContainer != null) {
                    DockContainer dockContainer = this.currentOverContainer;
                    Intrinsics.checkNotNull((Object)dockContainer);
                    JComponent jComponent = dockContainer.getContainerComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContainerComponent(...)");
                    point = devicePoint.toRelativePoint((Component)jComponent);
                    DockContainer dockContainer2 = this.currentOverContainer;
                    Intrinsics.checkNotNull((Object)dockContainer2);
                    img = dockContainer2.processDropOver(this.content, point);
                }
                if (img == null) {
                    img = this.defaultDragImage;
                }
                if (img != this.dragImage) {
                    Image image2 = this.dragImage = img;
                    Intrinsics.checkNotNull((Object)image2);
                    this.view.setImage(image2);
                }
                this.setLocationFrom(e);
            } else if (e.getID() == 502) {
                DockContainer currentOverContainer = this.currentOverContainer;
                if (currentOverContainer == null) {
                    RelativePoint point = new RelativePoint(e);
                    if (this.content instanceof DockableContentContainer) {
                        ((DockableContentContainer)this.content).add(point);
                    } else {
                        DockManagerImpl.this.createNewDockContainerFor(this.content, point);
                    }
                    e.consume();
                } else {
                    JComponent jComponent = currentOverContainer.getContainerComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContainerComponent(...)");
                    RelativePoint point = devicePoint.toRelativePoint((Component)jComponent);
                    currentOverContainer.add(this.content, point);
                    if (currentOverContainer instanceof DockableEditorTabbedContainer && ((DockableEditorTabbedContainer)currentOverContainer).getCurrentDropSide() == 0) {
                        e.consume();
                    }
                }
                DockManagerImpl.this.stopCurrentDragSession();
            }
        }

        public void cancel() {
            DockManagerImpl.this.stopCurrentDragSession();
        }

        public final void cancelSession() {
            this.view.hide();
            if (this.currentOverContainer != null) {
                DockContainer dockContainer = this.currentOverContainer;
                Intrinsics.checkNotNull((Object)dockContainer);
                dockContainer.resetDropOver(this.content);
                this.currentOverContainer = null;
            }
        }

        private static final boolean startDragContainer$lambda$0(DockContainer it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return true;
        }

        private static final boolean startDragContainer$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

