/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.builder.components;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ui.dsl.builder.components.SegmentedButtonToolbarKt;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ui/dsl/builder/components/SegmentedButtonBorder;", "Ljavax/swing/border/Border;", "<init>", "()V", "paintBorder", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "", "y", "width", "height", "getBorderInsets", "Ljava/awt/Insets;", "isBorderOpaque", "", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class SegmentedButtonBorder
implements Border {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(x, y);
            Rectangle r = new Rectangle(0, 0, width, height);
            float arc = DarculaUIUtil.BUTTON_ARC.getFloat();
            DarculaUIUtil.Outline outline = DarculaUIUtil.getOutline((JComponent)c);
            if (outline == null && c.hasFocus()) {
                outline = DarculaUIUtil.Outline.focus;
            }
            if (outline == null) {
                g2.setPaint(SegmentedButtonToolbarKt.getSegmentedButtonBorderPaint(c, false));
                JBInsets.removeFrom((Rectangle)r, (Insets)((Insets)JBUI.insets((int)((int)DarculaUIUtil.BW.getUnscaled()))));
                SegmentedButtonToolbarKt.paintBorder(g2, r);
            } else {
                DarculaUIUtil.paintOutlineBorder(g2, r.width, r.height, arc, true, c.hasFocus(), outline);
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    @NotNull
    public Insets getBorderInsets(@Nullable Component c) {
        float unscaledSize = DarculaUIUtil.BW.getUnscaled() + DarculaUIUtil.LW.getUnscaled();
        JBInsets.JBInsetsUIResource jBInsetsUIResource = JBUI.insets((int)((int)unscaledSize)).asUIResource();
        Intrinsics.checkNotNullExpressionValue((Object)jBInsetsUIResource, (String)"asUIResource(...)");
        return (Insets)jBInsetsUIResource;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

