/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.builder.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.dsl.builder.components.DslLabel;
import com.intellij.ui.dsl.builder.impl.CellBaseImpl;
import com.intellij.ui.dsl.builder.impl.CellImpl;
import com.intellij.ui.dsl.builder.impl.DialogPanelConfig;
import com.intellij.ui.dsl.builder.impl.DslComponentPropertyInternal;
import com.intellij.ui.dsl.builder.impl.GeneratedComponentData;
import com.intellij.ui.dsl.builder.impl.PanelImpl;
import com.intellij.ui.dsl.builder.impl.PlaceholderBaseImpl;
import com.intellij.ui.dsl.builder.impl.RowImpl;
import com.intellij.ui.dsl.builder.impl.UtilsKt;
import com.intellij.ui.dsl.gridLayout.Constraints;
import com.intellij.ui.dsl.gridLayout.Grid;
import com.intellij.ui.dsl.gridLayout.HorizontalAlign;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsY;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsYKt;
import com.intellij.ui.dsl.gridLayout.VerticalAlign;
import com.intellij.ui.dsl.gridLayout.builders.RowsGridBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 <2\u00020\u0001:\u0001<B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0004H\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J<\u0010\"\u001a\u00020\u00162\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001b0\u00032\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002JF\u0010'\u001a\u00020\u00162\f\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020%2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010,\u001a\u00020%H\u0002J&\u0010-\u001a\u00020%2\f\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010*\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J<\u0010.\u001a\u00020\u00162\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001b0\u00032\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010/\u001a\u0002002\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J<\u00101\u001a\u00020\u00162\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001b0\u00032\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010/\u001a\u0002002\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J.\u0010\"\u001a\u00020\u00162\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u00032\u0006\u0010&\u001a\u00020%2\u0006\u00104\u001a\u0002052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u00106\u001a\u00020%2\f\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bH\u0002J\u001c\u00107\u001a\b\u0012\u0004\u0012\u0002080\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J \u00109\u001a\u0002082\u0006\u0010 \u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u00192\u0006\u0010;\u001a\u00020\u0019H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006="}, d2={"Lcom/intellij/ui/dsl/builder/impl/PanelBuilder;", "", "rows", "", "Lcom/intellij/ui/dsl/builder/impl/RowImpl;", "dialogPanelConfig", "Lcom/intellij/ui/dsl/builder/impl/DialogPanelConfig;", "spacingConfiguration", "Lcom/intellij/ui/dsl/builder/SpacingConfiguration;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "grid", "Lcom/intellij/ui/dsl/gridLayout/Grid;", "<init>", "(Ljava/util/List;Lcom/intellij/ui/dsl/builder/impl/DialogPanelConfig;Lcom/intellij/ui/dsl/builder/SpacingConfiguration;Lcom/intellij/openapi/ui/DialogPanel;Lcom/intellij/ui/dsl/gridLayout/Grid;)V", "getRows", "()Ljava/util/List;", "getPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "getGrid", "()Lcom/intellij/ui/dsl/gridLayout/Grid;", "build", "", "preprocess", "isLabelGap", "", "cellAfterLabel", "Lcom/intellij/ui/dsl/builder/impl/CellBaseImpl;", "setLastColumnResizable", "builder", "Lcom/intellij/ui/dsl/gridLayout/builders/RowsGridBuilder;", "checkRow", "row", "checkNoDoubleRowGaps", "buildRow", "cells", "firstCellIndent", "", "maxColumnsCount", "buildCell", "cell", "leftGap", "lastCell", "width", "getMaxColumnsCount", "getRightGap", "buildLabelRow", "layout", "Lcom/intellij/ui/dsl/builder/RowLayout;", "buildCommentRow", "columnsAndComponents", "Lcom/intellij/ui/dsl/builder/impl/GeneratedComponentData;", "verticalAlign", "Lcom/intellij/ui/dsl/gridLayout/VerticalAlign;", "getAdditionalHorizontalIndent", "getRowsGaps", "Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsY;", "getRowGaps", "first", "last", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPanelBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PanelBuilder.kt\ncom/intellij/ui/dsl/builder/impl/PanelBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,434:1\n1606#2:435\n1617#2:436\n1924#2,2:437\n1926#2:440\n1618#2:441\n1606#2:442\n1617#2:443\n1924#2,2:444\n1926#2:447\n1618#2:448\n363#2,7:449\n1#3:439\n1#3:446\n23#4:456\n*S KotlinDebug\n*F\n+ 1 PanelBuilder.kt\ncom/intellij/ui/dsl/builder/impl/PanelBuilder\n*L\n299#1:435\n299#1:436\n299#1:437,2\n299#1:440\n299#1:441\n323#1:442\n323#1:443\n323#1:444,2\n323#1:447\n323#1:448\n339#1:449,7\n299#1:439\n323#1:446\n22#1:456\n*E\n"})
public final class PanelBuilder {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final List<RowImpl> rows;
    @NotNull
    private final DialogPanelConfig dialogPanelConfig;
    @NotNull
    private final SpacingConfiguration spacingConfiguration;
    @NotNull
    private final DialogPanel panel;
    @NotNull
    private final Grid grid;
    @NotNull
    private static final Logger log;

    public PanelBuilder(@NotNull List<? extends RowImpl> rows, @NotNull DialogPanelConfig dialogPanelConfig, @NotNull SpacingConfiguration spacingConfiguration, @NotNull DialogPanel panel2, @NotNull Grid grid) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        Intrinsics.checkNotNullParameter((Object)dialogPanelConfig, (String)"dialogPanelConfig");
        Intrinsics.checkNotNullParameter((Object)spacingConfiguration, (String)"spacingConfiguration");
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.rows = rows;
        this.dialogPanelConfig = dialogPanelConfig;
        this.spacingConfiguration = spacingConfiguration;
        this.panel = panel2;
        this.grid = grid;
    }

    @NotNull
    public final List<RowImpl> getRows() {
        return this.rows;
    }

    @NotNull
    public final DialogPanel getPanel() {
        return this.panel;
    }

    @NotNull
    public final Grid getGrid() {
        return this.grid;
    }

    public final void build() {
        if (this.rows.isEmpty()) {
            return;
        }
        this.preprocess();
        int maxColumnsCount = this.getMaxColumnsCount();
        RowsGridBuilder rowsGridBuilder = new RowsGridBuilder((JComponent)this.panel, this.grid).defaultVerticalAlign(VerticalAlign.CENTER).defaultBaselineAlign(true);
        List<UnscaledGapsY> allRowsGaps = this.getRowsGaps(this.rows);
        Iterator iterator = ((Iterable)this.rows).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i2 = n++;
            RowImpl row2 = (RowImpl)iterator.next();
            if (!this.checkRow(row2)) continue;
            UnscaledGapsY rowGaps = allRowsGaps.get(i2);
            rowsGridBuilder.setRowGaps(UnscaledGapsYKt.UnscaledGapsY$default((int)rowGaps.getTop(), (int)0, (int)2, null));
            VerticalAlign subRowVerticalAlign = row2.getResizableRow() ? VerticalAlign.FILL : VerticalAlign.CENTER;
            switch (WhenMappings.$EnumSwitchMapping$0[row2.getRowLayout().ordinal()]) {
                case 1: {
                    RowsGridBuilder subGridBuilder = RowsGridBuilder.subGridBuilder$default((RowsGridBuilder)rowsGridBuilder, (int)maxColumnsCount, (HorizontalAlign)HorizontalAlign.FILL, (VerticalAlign)subRowVerticalAlign, (boolean)false, (boolean)false, (UnscaledGaps)UnscaledGapsKt.UnscaledGaps$default((int)0, (int)row2.getIndent(), (int)0, (int)0, (int)13, null), null, (int)88, null);
                    List<CellBaseImpl<?>> cells = row2.getCells();
                    this.buildLabelRow(cells, 0, cells.size(), row2.getRowLayout(), subGridBuilder);
                    subGridBuilder.resizableRow();
                    this.buildRow(cells, 0, cells.size(), this.panel, subGridBuilder);
                    RowsGridBuilder.row$default((RowsGridBuilder)subGridBuilder, null, (boolean)false, (int)3, null);
                    this.buildCommentRow(cells, 0, cells.size(), row2.getRowLayout(), subGridBuilder);
                    this.setLastColumnResizable(subGridBuilder);
                    if (row2.getResizableRow()) {
                        rowsGridBuilder.resizableRow();
                    }
                    RowsGridBuilder.row$default((RowsGridBuilder)rowsGridBuilder, null, (boolean)false, (int)3, null);
                    break;
                }
                case 2: {
                    RowsGridBuilder subGridBuilder;
                    this.buildLabelRow(row2.getCells(), row2.getIndent(), maxColumnsCount, row2.getRowLayout(), rowsGridBuilder);
                    this.buildCell(row2.getCells().get(0), this.isLabelGap((CellBaseImpl)CollectionsKt.getOrNull(row2.getCells(), (int)1)), row2.getIndent(), row2.getCells().size() == 1, 1, this.panel, rowsGridBuilder);
                    if (row2.getCells().size() > 1) {
                        subGridBuilder = RowsGridBuilder.subGridBuilder$default((RowsGridBuilder)rowsGridBuilder, (int)(maxColumnsCount - 1), (HorizontalAlign)HorizontalAlign.FILL, (VerticalAlign)subRowVerticalAlign, (boolean)false, (boolean)false, null, null, (int)120, null).resizableRow();
                        List<CellBaseImpl<?>> cells = row2.getCells().subList(1, row2.getCells().size());
                        this.buildRow(cells, 0, cells.size(), this.panel, subGridBuilder);
                        this.setLastColumnResizable(subGridBuilder);
                    }
                    if (row2.getResizableRow()) {
                        rowsGridBuilder.resizableRow();
                    }
                    RowsGridBuilder.row$default((RowsGridBuilder)rowsGridBuilder, null, (boolean)false, (int)3, null);
                    this.buildCommentRow(row2.getCells(), row2.getIndent(), maxColumnsCount, row2.getRowLayout(), rowsGridBuilder);
                    break;
                }
                case 3: {
                    this.buildLabelRow(row2.getCells(), row2.getIndent(), maxColumnsCount, row2.getRowLayout(), rowsGridBuilder);
                    this.buildRow(row2.getCells(), row2.getIndent(), maxColumnsCount, this.panel, rowsGridBuilder);
                    if (row2.getResizableRow()) {
                        rowsGridBuilder.resizableRow();
                    }
                    RowsGridBuilder.row$default((RowsGridBuilder)rowsGridBuilder, null, (boolean)false, (int)3, null);
                    this.buildCommentRow(row2.getCells(), row2.getIndent(), maxColumnsCount, row2.getRowLayout(), rowsGridBuilder);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (row2.getRowComment() != null) {
                DslLabel it;
                boolean bl = false;
                UnscaledGaps gaps = UnscaledGapsKt.UnscaledGaps$default((int)0, (int)row2.getIndent(), (int)this.spacingConfiguration.getVerticalComponentGap(), (int)0, (int)9, null);
                HorizontalAlign horizontalAlign = it.getMaxLineLength() == -1 ? HorizontalAlign.FILL : HorizontalAlign.LEFT;
                RowsGridBuilder.cell$default((RowsGridBuilder)rowsGridBuilder, (JComponent)it, (int)maxColumnsCount, (HorizontalAlign)horizontalAlign, null, (boolean)false, (boolean)false, (UnscaledGaps)gaps, null, null, (int)440, null);
                RowsGridBuilder.row$default((RowsGridBuilder)rowsGridBuilder, null, (boolean)false, (int)3, null);
            }
            List rowsGaps = rowsGridBuilder.getGrid().getRowsGaps();
            rowsGaps.set(rowsGaps.size() - 2, UnscaledGapsY.copy$default((UnscaledGapsY)((UnscaledGapsY)rowsGaps.get(rowsGaps.size() - 2)), (int)0, (int)rowGaps.getBottom(), (int)1, null));
        }
        this.setLastColumnResizable(rowsGridBuilder);
        this.checkNoDoubleRowGaps(this.grid);
    }

    private final void preprocess() {
        for (RowImpl row2 : this.rows) {
            int i2 = 0;
            while (i2 < row2.getCells().size()) {
                CellBaseImpl<?> cell = row2.getCells().get(i2);
                if (cell instanceof CellImpl) {
                    if (((CellImpl)cell).getLabel() != null) {
                        JLabel it;
                        boolean bl = false;
                        if (((CellImpl)cell).getLabelPosition() == LabelPosition.LEFT) {
                            CellImpl labelCell = new CellImpl(this.dialogPanelConfig, it, row2, null, 8, null);
                            row2.getCells().add(i2, labelCell);
                        }
                        UtilsKt.labelCell(it, cell);
                    }
                }
                int n = ++i2;
                i2 = n + 1;
            }
        }
    }

    private final boolean isLabelGap(CellBaseImpl<?> cellAfterLabel) {
        CellImpl cellImpl = cellAfterLabel instanceof CellImpl ? (CellImpl)cellAfterLabel : null;
        Object component2 = cellImpl != null ? cellImpl.getComponent() : null;
        return !(component2 instanceof JCheckBox) && !(component2 instanceof JRadioButton);
    }

    private final void setLastColumnResizable(RowsGridBuilder builder) {
        if (builder.getResizableColumns().isEmpty() && builder.getColumnsCount() > 0) {
            builder.getResizableColumns().add(builder.getColumnsCount() - 1);
        }
    }

    private final boolean checkRow(RowImpl row2) {
        if (row2.getCells().isEmpty()) {
            UtilsKt.warn("Row should not be empty");
            return false;
        }
        return true;
    }

    private final void checkNoDoubleRowGaps(Grid grid) {
        List gaps = grid.getRowsGaps();
        int n = ((Collection)gaps).size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 <= 0 || ((UnscaledGapsY)gaps.get(i2 - 1)).getBottom() <= 0 || ((UnscaledGapsY)gaps.get(i2)).getTop() <= 0) continue;
            UtilsKt.warn("There is double gap between two near rows");
        }
    }

    private final void buildRow(List<? extends CellBaseImpl<?>> cells, int firstCellIndent, int maxColumnsCount, DialogPanel panel2, RowsGridBuilder builder) {
        Iterator iterator = ((Iterable)cells).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int cellIndex = n++;
            CellBaseImpl cell = (CellBaseImpl)iterator.next();
            boolean lastCell = cellIndex == cells.size() - 1;
            int width = lastCell ? maxColumnsCount - cellIndex : 1;
            int leftGap = cellIndex == 0 ? firstCellIndent : 0;
            boolean isLabel = cell instanceof CellImpl && (Intrinsics.areEqual((Object)((JComponent)((CellImpl)cell).getComponent()).getClientProperty(DslComponentProperty.ROW_LABEL), (Object)true) || Intrinsics.areEqual((Object)((JComponent)((CellImpl)cell).getComponent()).getClientProperty((Object)DslComponentPropertyInternal.CELL_LABEL), (Object)true));
            this.buildCell(cell, isLabel && this.isLabelGap((CellBaseImpl)CollectionsKt.getOrNull(cells, (int)(cellIndex + 1))), leftGap, lastCell, width, panel2, builder);
        }
    }

    private final void buildCell(CellBaseImpl<?> cell, boolean isLabelGap, int leftGap, boolean lastCell, int width, DialogPanel panel2, RowsGridBuilder builder) {
        int rightGap = this.getRightGap(cell, lastCell, isLabelGap);
        CellBaseImpl<?> cellBaseImpl = cell;
        if (cellBaseImpl instanceof CellImpl) {
            UnscaledGaps unscaledGaps = ((CellImpl)cell).getCustomGaps();
            if (unscaledGaps == null) {
                unscaledGaps = UtilsKt.getComponentGaps(leftGap, rightGap, ((CellImpl)cell).getComponent(), this.spacingConfiguration);
            }
            UnscaledGaps gaps = unscaledGaps;
            DslLabel commentRight2 = ((CellImpl)cell).getCommentRight();
            ContextHelpLabel contextHelpLabel = ((CellImpl)cell).getContextHelpLabel();
            if (commentRight2 == null && contextHelpLabel == null) {
                RowsGridBuilder.cell$default((RowsGridBuilder)builder, (JComponent)((CellImpl)cell).getViewComponent(), (int)width, (HorizontalAlign)((CellImpl)cell).getHorizontalAlign(), (VerticalAlign)((CellImpl)cell).getVerticalAlign(), (boolean)false, (boolean)((CellImpl)cell).getResizableColumn(), (UnscaledGaps)gaps, (UnscaledGaps)UtilsKt.prepareVisualPaddings(((CellImpl)cell).getViewComponent()), (String)((CellImpl)cell).getWidthGroup(), (int)16, null);
            } else {
                if (((CellImpl)cell).getVerticalAlign() == VerticalAlign.FILL) {
                    DslLabel dslLabel = commentRight2;
                    CellImpl.ContextHelpInfo contextHelpInfo = ((CellImpl)cell).getContextHelpInfo();
                    log.error("Vertical align FILL is not supported for cells with right comment or context help, commentRight = " + (dslLabel != null ? dslLabel.getUserText() : null) + ", contextHelp = " + (contextHelpInfo != null ? contextHelpInfo.getDescription() : null));
                }
                RowsGridBuilder subGridBuilder = RowsGridBuilder.subGridBuilder$default((RowsGridBuilder)builder, (int)width, (HorizontalAlign)((CellImpl)cell).getHorizontalAlign(), (VerticalAlign)((CellImpl)cell).getVerticalAlign(), (boolean)false, (boolean)((CellImpl)cell).getResizableColumn(), (UnscaledGaps)gaps, null, (int)72, null);
                boolean isHorizontalFill = ((CellImpl)cell).getHorizontalAlign() == HorizontalAlign.FILL;
                RowsGridBuilder.cell$default((RowsGridBuilder)subGridBuilder, (JComponent)((CellImpl)cell).getViewComponent(), (int)0, (HorizontalAlign)(isHorizontalFill ? HorizontalAlign.FILL : HorizontalAlign.LEFT), (VerticalAlign)(((CellImpl)cell).getVerticalAlign() == VerticalAlign.FILL ? VerticalAlign.FILL : VerticalAlign.CENTER), (boolean)false, (boolean)isHorizontalFill, null, (UnscaledGaps)UtilsKt.prepareVisualPaddings(((CellImpl)cell).getViewComponent()), (String)((CellImpl)cell).getWidthGroup(), (int)82, null);
                if (contextHelpLabel != null) {
                    RowsGridBuilder.cell$default((RowsGridBuilder)subGridBuilder, (JComponent)((JComponent)contextHelpLabel), (int)0, null, null, (boolean)false, (boolean)false, (UnscaledGaps)UnscaledGapsKt.UnscaledGaps$default((int)0, (int)this.spacingConfiguration.getHorizontalSmallGap(), (int)0, (int)0, (int)13, null), null, null, (int)446, null);
                }
                if (commentRight2 != null) {
                    RowsGridBuilder.cell$default((RowsGridBuilder)subGridBuilder, (JComponent)commentRight2, (int)0, null, null, (boolean)false, (boolean)false, (UnscaledGaps)UnscaledGapsKt.UnscaledGaps$default((int)0, (int)this.spacingConfiguration.getHorizontalCommentGap(), (int)0, (int)0, (int)13, null), null, null, (int)446, null);
                }
            }
        } else if (cellBaseImpl instanceof PanelImpl) {
            UnscaledGaps unscaledGaps = ((PanelImpl)cell).getCustomGaps();
            if (unscaledGaps == null) {
                unscaledGaps = UnscaledGapsKt.UnscaledGaps$default((int)0, (int)leftGap, (int)0, (int)rightGap, (int)5, null);
            }
            UnscaledGaps gaps = unscaledGaps;
            Grid subGrid = RowsGridBuilder.subGrid$default((RowsGridBuilder)builder, (int)width, (HorizontalAlign)((PanelImpl)cell).getHorizontalAlign(), (VerticalAlign)((PanelImpl)cell).getVerticalAlign(), (boolean)false, (boolean)((PanelImpl)cell).getResizableColumn(), (UnscaledGaps)gaps, null, (int)72, null);
            PanelBuilder subBuilder = new PanelBuilder(((PanelImpl)cell).getRows(), this.dialogPanelConfig, ((PanelImpl)cell).getSpacingConfiguration(), panel2, subGrid);
            subBuilder.build();
        } else if (cellBaseImpl instanceof PlaceholderBaseImpl) {
            UnscaledGaps gaps;
            UnscaledGaps unscaledGaps = ((PlaceholderBaseImpl)cell).getCustomGaps();
            if (unscaledGaps == null) {
                unscaledGaps = gaps = UnscaledGapsKt.UnscaledGaps$default((int)0, (int)leftGap, (int)0, (int)rightGap, (int)5, null);
            }
            if (((PlaceholderBaseImpl)cell).getResizableColumn()) {
                builder.addResizableColumn();
            }
            Constraints constraints = RowsGridBuilder.constraints$default((RowsGridBuilder)builder, (int)width, (HorizontalAlign)((PlaceholderBaseImpl)cell).getHorizontalAlign(), (VerticalAlign)((PlaceholderBaseImpl)cell).getVerticalAlign(), (boolean)false, (UnscaledGaps)gaps, null, null, (int)104, null);
            ((PlaceholderBaseImpl)cell).init(panel2, constraints, this.spacingConfiguration);
        } else {
            builder.skip(1);
        }
    }

    private final int getMaxColumnsCount() {
        Iterator iterator = ((Iterable)this.rows).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        RowImpl it = (RowImpl)iterator.next();
        boolean bl = false;
        int n = switch (WhenMappings.$EnumSwitchMapping$0[it.getRowLayout().ordinal()]) {
            case 1 -> 1;
            case 2 -> Math.min(2, it.getCells().size());
            case 3 -> it.getCells().size();
            default -> throw new NoWhenBranchMatchedException();
        };
        while (iterator.hasNext()) {
            RowImpl it2 = (RowImpl)iterator.next();
            $i$a$-maxOf-PanelBuilder$getMaxColumnsCount$1 = false;
            int n2 = switch (WhenMappings.$EnumSwitchMapping$0[it2.getRowLayout().ordinal()]) {
                case 1 -> 1;
                case 2 -> Math.min(2, it2.getCells().size());
                case 3 -> it2.getCells().size();
                default -> throw new NoWhenBranchMatchedException();
            };
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    private final int getRightGap(CellBaseImpl<?> cell, boolean lastCell, boolean isLabelGap) {
        if (cell == null) {
            return 0;
        }
        RightGap rightGap = cell.getRightGap();
        if (lastCell) {
            return 0;
        }
        if (rightGap != null) {
            return switch (WhenMappings.$EnumSwitchMapping$1[rightGap.ordinal()]) {
                case 1 -> this.spacingConfiguration.getHorizontalSmallGap();
                case 2 -> this.spacingConfiguration.getHorizontalColumnsGap();
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        return isLabelGap ? this.spacingConfiguration.getHorizontalSmallGap() : this.spacingConfiguration.getHorizontalDefaultGap();
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLabelRow(List<? extends CellBaseImpl<?>> cells, int firstCellIndent, int maxColumnsCount, RowLayout layout2, RowsGridBuilder builder) {
        void $this$mapIndexedNotNullTo$iv$iv;
        Iterable $this$mapIndexedNotNull$iv = cells;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            GeneratedComponentData generatedComponentData;
            JLabel label2;
            void cell;
            CellImpl cellImpl;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            CellBaseImpl cellBaseImpl = (CellBaseImpl)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            CellImpl cellImpl2 = cellImpl = cell instanceof CellImpl ? (CellImpl)cell : null;
            JLabel jLabel = label2 = cellImpl2 != null ? cellImpl2.getLabel() : null;
            if (label2 == null || cellImpl.getLabelPosition() != LabelPosition.TOP || layout2 == RowLayout.LABEL_ALIGNED && index > 1) {
                generatedComponentData = null;
            } else {
                int left = index == 0 ? firstCellIndent : 0;
                generatedComponentData = new GeneratedComponentData(label2, UnscaledGapsKt.UnscaledGaps$default((int)this.spacingConfiguration.getVerticalComponentGap(), (int)left, (int)0, (int)0, (int)12, null), HorizontalAlign.LEFT, index);
            }
            if (generatedComponentData == null) continue;
            GeneratedComponentData it$iv$iv = generatedComponentData;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List columnsAndLabels = (List)destination$iv$iv;
        this.buildRow(columnsAndLabels, maxColumnsCount, VerticalAlign.BOTTOM, builder);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildCommentRow(List<? extends CellBaseImpl<?>> cells, int firstCellIndent, int maxColumnsCount, RowLayout layout2, RowsGridBuilder builder) {
        void $this$mapIndexedNotNullTo$iv$iv;
        Iterable $this$mapIndexedNotNull$iv = cells;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            GeneratedComponentData generatedComponentData;
            DslLabel comment2;
            void cell;
            CellImpl cellImpl;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            CellBaseImpl cellBaseImpl = (CellBaseImpl)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            CellImpl cellImpl2 = cellImpl = cell instanceof CellImpl ? (CellImpl)cell : null;
            DslLabel dslLabel = comment2 = cellImpl2 != null ? cellImpl2.getComment() : null;
            if (comment2 == null) {
                generatedComponentData = null;
            } else {
                int left = this.getAdditionalHorizontalIndent((CellBaseImpl<?>)cell) + (index == 0 ? firstCellIndent : 0);
                HorizontalAlign horizontalAlign = comment2.getMaxLineLength() == -1 ? HorizontalAlign.FILL : HorizontalAlign.LEFT;
                generatedComponentData = new GeneratedComponentData(comment2, UnscaledGapsKt.UnscaledGaps$default((int)0, (int)left, (int)this.spacingConfiguration.getVerticalComponentGap(), (int)0, (int)9, null), horizontalAlign, index);
            }
            if (generatedComponentData == null) continue;
            GeneratedComponentData it$iv$iv = generatedComponentData;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List columnsAndComments = (List)destination$iv$iv;
        if (layout2 == RowLayout.LABEL_ALIGNED) {
            int index;
            block9: {
                int n;
                List $this$indexOfFirst$iv = columnsAndComments;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    GeneratedComponentData it = (GeneratedComponentData)item$iv;
                    boolean bl = false;
                    if (it.getColumn() >= 1) {
                        n = index$iv;
                        break block9;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index >= 0) {
                List mutableColumnsAndComments = CollectionsKt.toMutableList((Collection)columnsAndComments.subList(0, index + 1));
                GeneratedComponentData lastData = (GeneratedComponentData)mutableColumnsAndComments.get(index);
                if (lastData.getColumn() > 1) {
                    UnscaledGaps unscaledGaps = UnscaledGaps.copy$default((UnscaledGaps)lastData.getGaps(), (int)0, (int)0, (int)0, (int)0, (int)13, null);
                    mutableColumnsAndComments.set(index, GeneratedComponentData.copy$default(lastData, null, unscaledGaps, null, 1, 5, null));
                }
                columnsAndComments = mutableColumnsAndComments;
            }
        }
        builder.setRowGaps(UnscaledGapsYKt.UnscaledGapsY$default((int)0, (int)this.spacingConfiguration.getVerticalCommentBottomGap(), (int)1, null));
        this.buildRow(columnsAndComments, maxColumnsCount, VerticalAlign.TOP, builder);
    }

    private final void buildRow(List<GeneratedComponentData> columnsAndComponents, int maxColumnsCount, VerticalAlign verticalAlign, RowsGridBuilder builder) {
        if (columnsAndComponents.isEmpty()) {
            return;
        }
        builder.skip(columnsAndComponents.get(0).getColumn());
        Iterator iterator = ((Iterable)columnsAndComponents).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i2 = n++;
            GeneratedComponentData data2 = (GeneratedComponentData)iterator.next();
            int nextColumn = i2 + 1 < columnsAndComponents.size() ? columnsAndComponents.get(i2 + 1).getColumn() : maxColumnsCount;
            RowsGridBuilder.cell$default((RowsGridBuilder)builder, (JComponent)data2.getComponent(), (int)(nextColumn - data2.getColumn()), (HorizontalAlign)data2.getHorizontalAlign(), (VerticalAlign)verticalAlign, (boolean)false, (boolean)false, (UnscaledGaps)data2.getGaps(), null, null, (int)416, null);
        }
        RowsGridBuilder.row$default((RowsGridBuilder)builder, null, (boolean)false, (int)3, null);
    }

    private final int getAdditionalHorizontalIndent(CellBaseImpl<?> cell) {
        return cell instanceof CellImpl && ((CellImpl)cell).getViewComponent() instanceof JToggleButton ? this.spacingConfiguration.getHorizontalToggleButtonIndent() : 0;
    }

    private final List<UnscaledGapsY> getRowsGaps(List<? extends RowImpl> rows) {
        List result2 = new ArrayList();
        Iterator iterator = ((Iterable)rows).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            UnscaledGapsY previousRowGaps;
            int i2 = n++;
            RowImpl row2 = (RowImpl)iterator.next();
            UnscaledGapsY rowGaps = this.getRowGaps(row2, i2 == 0, i2 == rows.size() - 1);
            result2.add(rowGaps);
            if (i2 <= 0 || (previousRowGaps = (UnscaledGapsY)result2.get(i2 - 1)).getBottom() == 0 || rowGaps.getTop() == 0) continue;
            if (previousRowGaps.getBottom() > rowGaps.getTop()) {
                result2.set(i2, UnscaledGapsY.copy$default((UnscaledGapsY)rowGaps, (int)0, (int)0, (int)2, null));
                continue;
            }
            result2.set(i2 - 1, UnscaledGapsY.copy$default((UnscaledGapsY)previousRowGaps, (int)0, (int)0, (int)1, null));
        }
        return result2;
    }

    private final UnscaledGapsY getRowGaps(RowImpl row2, boolean first, boolean last) {
        UnscaledGapsY unscaledGapsY = row2.getCustomGaps();
        if (unscaledGapsY != null) {
            UnscaledGapsY it = unscaledGapsY;
            boolean bl = false;
            return it;
        }
        TopGap topGap = row2.getTopGap();
        int top = switch (topGap == null ? -1 : WhenMappings.$EnumSwitchMapping$2[topGap.ordinal()]) {
            case 1 -> 0;
            case 2 -> this.spacingConfiguration.getVerticalSmallGap();
            case 3 -> this.spacingConfiguration.getVerticalMediumGap();
            case -1 -> {
                if (first) {
                    yield 0;
                }
                yield row2.getInternalGaps().getTop();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        BottomGap bottomGap = row2.getBottomGap();
        int bottom = switch (bottomGap == null ? -1 : WhenMappings.$EnumSwitchMapping$3[bottomGap.ordinal()]) {
            case 1 -> 0;
            case 2 -> this.spacingConfiguration.getVerticalSmallGap();
            case 3 -> this.spacingConfiguration.getVerticalMediumGap();
            case -1 -> {
                if (last) {
                    yield 0;
                }
                yield row2.getInternalGaps().getBottom();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        return top > 0 || bottom > 0 ? UnscaledGapsYKt.UnscaledGapsY((int)top, (int)bottom) : UnscaledGapsY.EMPTY;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ui/dsl/builder/impl/PanelBuilder$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[RowLayout.values().length];
            try {
                nArray[RowLayout.INDEPENDENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RowLayout.LABEL_ALIGNED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RowLayout.PARENT_GRID.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RightGap.values().length];
            try {
                nArray[RightGap.SMALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RightGap.COLUMNS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[TopGap.values().length];
            try {
                nArray[TopGap.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TopGap.SMALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TopGap.MEDIUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[BottomGap.values().length];
            try {
                nArray[BottomGap.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BottomGap.SMALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BottomGap.MEDIUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

