/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.beg;

import com.intellij.ide.ProjectWindowCustomizerService;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.darcula.ui.DarculaMenuItemBorder;
import com.intellij.ide.ui.laf.intellij.IdeaPopupMenuUI;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.toolbar.ShowMode;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.hover.HoverListener;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.plaf.beg.BegMenuItemUI;
import com.intellij.ui.plaf.beg.BegResources;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicMenuUI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IdeaMenuUI
extends BasicMenuUI {
    private static final Rectangle ourZeroRect = new Rectangle(0, 0, 0, 0);
    private static final Rectangle ourTextRect = new Rectangle();
    private static final Rectangle ourArrowIconRect = new Rectangle();
    private int myMaxGutterIconWidth;
    private int myMaxGutterIconWidth2;
    private int a;
    private int k;
    private int e;
    private static final Rectangle ourAcceleratorRect = new Rectangle();
    private static final Rectangle ourCheckIconRect = new Rectangle();
    private static final Rectangle ourIconRect = new Rectangle();
    private static final Rectangle ourViewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    private final MyHoverListener hoverListener = new MyHoverListener();

    public static ComponentUI createUI(JComponent component2) {
        return new IdeaMenuUI();
    }

    public static void paintRoundSelection(Graphics g, Component c, int width, int height) {
        JBInsets outerInsets;
        int radius;
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        if (IdeaPopupMenuUI.isPartOfPopupMenu(c)) {
            radius = JBUI.CurrentTheme.PopupMenu.Selection.ARC.get();
            outerInsets = JBUI.CurrentTheme.PopupMenu.Selection.outerInsets();
        } else if (IdeaPopupMenuUI.isMenuBarItem(c)) {
            if (ShowMode.Companion.isMergedMainMenu()) {
                outerInsets = JBUI.insets((int)(height / JBUIScale.scale((int)8)), (int)0);
                radius = JBUI.CurrentTheme.MainToolbar.Dropdown.hoverArc().get();
            } else {
                outerInsets = DarculaMenuItemBorder.menuBarItemOuterInsets();
                radius = 0;
            }
        } else {
            radius = JBUI.CurrentTheme.Menu.Selection.ARC.get();
            outerInsets = JBUI.CurrentTheme.Menu.Selection.outerInsets();
        }
        g.fillRoundRect(outerInsets.left, outerInsets.top, width - outerInsets.width(), height - outerInsets.height(), radius, radius);
        config.restore();
    }

    @NotNull
    public static Dimension patchPreferredSize(Component c, Dimension preferredSize) {
        if (ExperimentalUI.isNewUI() && !IdeaPopupMenuUI.isMenuBarItem(c)) {
            JBInsets outerInsets = IdeaPopupMenuUI.isPartOfPopupMenu(c) ? JBUI.CurrentTheme.PopupMenu.Selection.outerInsets() : JBUI.CurrentTheme.Menu.Selection.outerInsets();
            return new Dimension(preferredSize.width, JBUI.CurrentTheme.List.rowHeight() + outerInsets.height());
        }
        Dimension dimension = preferredSize;
        if (dimension == null) {
            IdeaMenuUI.$$$reportNull$$$0(0);
        }
        return dimension;
    }

    public IdeaMenuUI() {
        this.myMaxGutterIconWidth = JBUIScale.scale((int)18);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JMenuItem && ShowMode.Companion.isMergedMainMenu()) {
            this.hoverListener.addTo(c);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.hoverListener.removeFrom(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Integer integer = UIUtil.getPropertyMaxGutterIconWidth((String)this.getPropertyPrefix());
        if (integer != null) {
            this.myMaxGutterIconWidth2 = this.myMaxGutterIconWidth = integer.intValue();
        }
        this.selectionBackground = IdeaMenuUI.getDefaultSelectionBackground();
        if (this.isHeaderMenu()) {
            this.menuItem.setBackground(IdeaMenuUI.getMenuBackgroundColor());
            this.menuItem.setForeground((Color)JBColor.namedColor((String)"MainMenu.foreground", (Color)UIManager.getColor("Menu.foreground")));
            this.selectionForeground = JBColor.namedColor((String)"MainMenu.selectionForeground", (Color)this.selectionForeground);
            this.selectionBackground = JBColor.namedColor((String)"MainMenu.selectionBackground", (Color)this.selectionBackground);
            if (ShowMode.Companion.isMergedMainMenu()) {
                JBColor hoverBG = JBColor.namedColor((String)"MainToolbar.Dropdown.hoverBackground", (Color)JBColor.background());
                this.selectionBackground = ProjectWindowCustomizerService.Companion.getInstance().isActive() ? JBColor.namedColor((String)"MainToolbar.Dropdown.transparentHoverBackground", (Color)IdeaMenuUI.getDefaultSelectionBackground()) : hoverBG;
            }
        }
    }

    @ApiStatus.Internal
    public static Color getDefaultSelectionBackground() {
        return JBColor.namedColor((String)"Menu.selectionBackground", (Color)UIUtil.getListSelectionBackground((boolean)true));
    }

    @ApiStatus.Internal
    public void setSelectionBackground(Color selectionBackground) {
        this.selectionBackground = selectionBackground;
    }

    @ApiStatus.Internal
    @NotNull
    public static Color getMenuBackgroundColor() {
        JBColor jBColor = JBColor.namedColor((String)"MainMenu.background", (Color)UIManager.getColor("Menu.background"));
        if (jBColor == null) {
            IdeaMenuUI.$$$reportNull$$$0(1);
        }
        return jBColor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isHeaderMenu() {
        JMenuItem jMenuItem = this.menuItem;
        if (!(jMenuItem instanceof ActionMenu)) return false;
        ActionMenu actionMenu = (ActionMenu)((Object)jMenuItem);
        if (!actionMenu.isHeaderMenuItem) return false;
        return true;
    }

    private void checkEmptyIcon(JComponent comp) {
        this.myMaxGutterIconWidth = this.getAllowedIcon() == null && IdeaPopupMenuUI.hideEmptyIcon(comp) ? 0 : this.myMaxGutterIconWidth2;
    }

    @Override
    public void paint(Graphics g, JComponent comp) {
        UISettings.setupAntialiasing((Graphics)g);
        JMenu jMenu = (JMenu)comp;
        ButtonModel buttonmodel = jMenu.getModel();
        int mnemonicIndex = jMenu.getDisplayedMnemonicIndex();
        Icon icon2 = this.getIcon();
        Icon allowedIcon = this.getAllowedIcon();
        this.checkEmptyIcon(comp);
        Insets insets = comp.getInsets();
        IdeaMenuUI.resetRects();
        ourViewRect.setBounds(0, 0, jMenu.getWidth(), jMenu.getHeight());
        JBInsets.removeFrom((Rectangle)ourViewRect, (Insets)insets);
        Font font = g.getFont();
        Font font1 = comp.getFont();
        g.setFont(font1);
        FontMetrics fontmetrics = g.getFontMetrics(font1);
        String s1 = this.layoutMenuItem(fontmetrics, jMenu.getText(), icon2, allowedIcon, this.arrowIcon, jMenu.getVerticalAlignment(), jMenu.getHorizontalAlignment(), jMenu.getVerticalTextPosition(), jMenu.getHorizontalTextPosition(), ourViewRect, ourIconRect, ourTextRect, ourAcceleratorRect, ourCheckIconRect, ourArrowIconRect, jMenu.getText() != null ? this.defaultTextIconGap : 0, this.defaultTextIconGap);
        Color mainColor = g.getColor();
        this.fillBackground(g, comp, jMenu, buttonmodel, allowedIcon);
        if (allowedIcon != null) {
            if (buttonmodel.isArmed() || buttonmodel.isSelected()) {
                g.setColor(this.selectionForeground);
            } else {
                g.setColor(jMenu.getForeground());
            }
            if (this.useCheckAndArrow()) {
                allowedIcon.paintIcon(comp, g, IdeaMenuUI.ourCheckIconRect.x, IdeaMenuUI.ourCheckIconRect.y);
            }
            g.setColor(mainColor);
            if (this.menuItem.isArmed()) {
                this.drawIconBorder(g);
            }
        }
        if (icon2 != null) {
            if (!buttonmodel.isEnabled()) {
                icon2 = jMenu.getDisabledIcon();
            } else if (buttonmodel.isPressed() && buttonmodel.isArmed() && (icon2 = jMenu.getPressedIcon()) == null) {
                icon2 = jMenu.getIcon();
            }
            if (icon2 != null) {
                icon2.paintIcon(comp, g, IdeaMenuUI.ourIconRect.x, IdeaMenuUI.ourIconRect.y);
            }
        }
        if (s1 != null && !s1.isEmpty()) {
            if (buttonmodel.isEnabled()) {
                if (buttonmodel.isArmed() || buttonmodel.isSelected()) {
                    g.setColor(this.selectionForeground);
                } else {
                    g.setColor(jMenu.getForeground());
                }
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, s1, mnemonicIndex, IdeaMenuUI.ourTextRect.x, IdeaMenuUI.ourTextRect.y + fontmetrics.getAscent());
            } else {
                Color disabledForeground = UIUtil.getMenuItemDisabledForeground();
                if (disabledForeground != null) {
                    g.setColor(disabledForeground);
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, s1, mnemonicIndex, IdeaMenuUI.ourTextRect.x, IdeaMenuUI.ourTextRect.y + fontmetrics.getAscent());
                } else {
                    g.setColor(jMenu.getBackground().brighter());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, s1, mnemonicIndex, IdeaMenuUI.ourTextRect.x, IdeaMenuUI.ourTextRect.y + fontmetrics.getAscent());
                    g.setColor(jMenu.getBackground().darker());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, s1, mnemonicIndex, IdeaMenuUI.ourTextRect.x - 1, IdeaMenuUI.ourTextRect.y + fontmetrics.getAscent() - 1);
                }
            }
        }
        if (this.arrowIcon != null) {
            if (SystemInfo.isMac) {
                IdeaMenuUI.ourArrowIconRect.y += JBUIScale.scale((int)1);
            }
            if (buttonmodel.isArmed() || buttonmodel.isSelected()) {
                g.setColor(this.selectionForeground);
            }
            if (this.useCheckAndArrow()) {
                this.arrowIcon.paintIcon(comp, g, IdeaMenuUI.ourArrowIconRect.x, IdeaMenuUI.ourArrowIconRect.y);
            }
        }
        g.setColor(mainColor);
        g.setFont(font);
    }

    private void fillBackground(Graphics g, JComponent comp, JMenu jMenu, ButtonModel buttonmodel, Icon allowedIcon) {
        if (comp.isOpaque()) {
            g.setColor(jMenu.getBackground());
            g.fillRect(0, 0, jMenu.getWidth(), jMenu.getHeight());
        }
        if (buttonmodel.isArmed() || buttonmodel.isSelected()) {
            this.paintHover(g, comp, jMenu, allowedIcon);
        }
    }

    protected final void paintHover(Graphics g, JComponent comp, JMenu jMenu, Icon allowedIcon) {
        g.setColor(this.selectionBackground);
        if (allowedIcon != null && !UIUtil.isUnderIntelliJLaF() && !StartupUiUtil.isUnderDarcula()) {
            g.fillRect(this.k, 0, jMenu.getWidth() - this.k, jMenu.getHeight());
        } else if (ExperimentalUI.isNewUI() || IdeaPopupMenuUI.isRoundBorder()) {
            IdeaMenuUI.paintRoundSelection(g, comp, jMenu.getWidth(), jMenu.getHeight());
        } else {
            g.fillRect(0, 0, jMenu.getWidth(), jMenu.getHeight());
        }
    }

    private boolean useCheckAndArrow() {
        return !((JMenu)this.menuItem).isTopLevelMenu();
    }

    @Override
    public MenuElement[] getPath() {
        MenuElement[] amenuelement1;
        MenuSelectionManager menuselectionmanager = MenuSelectionManager.defaultManager();
        MenuElement[] amenuelement = menuselectionmanager.getSelectedPath();
        int i1 = amenuelement.length;
        if (i1 == 0) {
            return new MenuElement[0];
        }
        Container container = this.menuItem.getParent();
        if (amenuelement[i1 - 1].getComponent() == container) {
            amenuelement1 = new MenuElement[i1 + 1];
            System.arraycopy(amenuelement, 0, amenuelement1, 0, i1);
            amenuelement1[i1] = this.menuItem;
        } else {
            int j1;
            for (j1 = amenuelement.length - 1; j1 >= 0 && amenuelement[j1].getComponent() != container; --j1) {
            }
            amenuelement1 = new MenuElement[j1 + 2];
            System.arraycopy(amenuelement, 0, amenuelement1, 0, j1 + 1);
            amenuelement1[j1 + 1] = this.menuItem;
        }
        return amenuelement1;
    }

    private String layoutMenuItem(FontMetrics fontmetrics, @Nls String text2, Icon icon2, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fontmetrics, text2, icon2, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        acceleratorRect.height = 0;
        acceleratorRect.width = 0;
        if (this.useCheckAndArrow()) {
            if (checkIcon != null) {
                checkIconRect.width = checkIcon.getIconWidth();
                checkIconRect.height = checkIcon.getIconHeight();
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
            textRect.x += this.myMaxGutterIconWidth;
            iconRect.x += this.myMaxGutterIconWidth;
        }
        textRect.x += menuItemGap;
        iconRect.x += menuItemGap;
        Rectangle labelRect = iconRect.union(textRect);
        acceleratorRect.x = viewRect.x + viewRect.width - arrowIconRect.width - menuItemGap - acceleratorRect.width;
        acceleratorRect.y = viewRect.y + viewRect.height / 2 - acceleratorRect.height / 2;
        if (this.useCheckAndArrow()) {
            arrowIconRect.x = viewRect.x + viewRect.width - arrowIconRect.width;
            arrowIconRect.y = labelRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            if (checkIcon != null) {
                checkIconRect.y = labelRect.y + labelRect.height / 2 - checkIconRect.height / 2;
                checkIconRect.x += viewRect.x + this.myMaxGutterIconWidth / 2 - checkIcon.getIconWidth() / 2;
                this.a = viewRect.x;
                this.e = viewRect.y + labelRect.height / 2 - this.myMaxGutterIconWidth / 2;
                this.k = viewRect.x + this.myMaxGutterIconWidth + 2;
            } else {
                checkIconRect.y = 0;
                checkIconRect.x = 0;
            }
        }
        return text2;
    }

    private Icon getIcon() {
        Icon icon2 = this.menuItem.getIcon();
        if (icon2 != null && this.getAllowedIcon() != null) {
            icon2 = null;
        }
        return icon2;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent comp, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenu jMenu = (JMenu)comp;
        Icon icon1 = this.getIcon();
        Icon icon2 = this.getAllowedIcon();
        this.checkEmptyIcon(comp);
        String text2 = jMenu.getText();
        Font font = jMenu.getFont();
        FontMetrics fontmetrics = jMenu.getToolkit().getFontMetrics(font);
        IdeaMenuUI.resetRects();
        this.layoutMenuItem(fontmetrics, text2, icon1, icon2, arrowIcon, jMenu.getVerticalAlignment(), jMenu.getHorizontalAlignment(), jMenu.getVerticalTextPosition(), jMenu.getHorizontalTextPosition(), ourViewRect, ourIconRect, ourTextRect, ourAcceleratorRect, ourCheckIconRect, ourArrowIconRect, text2 != null ? defaultTextIconGap : 0, defaultTextIconGap);
        Rectangle ourPreferredSizeRect = new Rectangle();
        ourPreferredSizeRect.setBounds(ourTextRect);
        SwingUtilities.computeUnion(IdeaMenuUI.ourIconRect.x, IdeaMenuUI.ourIconRect.y, IdeaMenuUI.ourIconRect.width, IdeaMenuUI.ourIconRect.height, ourPreferredSizeRect);
        if (this.useCheckAndArrow()) {
            ourPreferredSizeRect.width += this.myMaxGutterIconWidth;
            ourPreferredSizeRect.width += defaultTextIconGap;
            ourPreferredSizeRect.width += defaultTextIconGap;
            ourPreferredSizeRect.width += IdeaMenuUI.ourArrowIconRect.width;
        }
        ourPreferredSizeRect.width += 2 * defaultTextIconGap;
        Insets insets = jMenu.getInsets();
        if (insets != null) {
            ourPreferredSizeRect.width += insets.left + insets.right;
            ourPreferredSizeRect.height += insets.top + insets.bottom;
        }
        if (ourPreferredSizeRect.width % 2 == 0) {
            ++ourPreferredSizeRect.width;
        }
        if (ourPreferredSizeRect.height % 2 == 0) {
            ++ourPreferredSizeRect.height;
        }
        return IdeaMenuUI.patchPreferredSize(comp, ourPreferredSizeRect.getSize());
    }

    private void drawIconBorder(Graphics g) {
        int i1 = this.a - 1;
        int j1 = this.e - 2;
        int k1 = i1 + this.myMaxGutterIconWidth + 1;
        int l1 = j1 + this.myMaxGutterIconWidth + 4;
        g.setColor(BegResources.m);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)i1, (double)j1, (double)i1, (double)l1);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)i1, (double)j1, (double)k1, (double)j1);
        g.setColor(BegResources.j);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)k1, (double)j1, (double)k1, (double)l1);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)i1, (double)l1, (double)k1, (double)l1);
    }

    private static void resetRects() {
        ourIconRect.setBounds(ourZeroRect);
        ourTextRect.setBounds(ourZeroRect);
        ourAcceleratorRect.setBounds(ourZeroRect);
        ourCheckIconRect.setBounds(ourZeroRect);
        ourArrowIconRect.setBounds(ourZeroRect);
        ourViewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private Icon getAllowedIcon() {
        Icon icon2;
        Icon icon3 = icon2 = this.menuItem.isEnabled() ? this.menuItem.getIcon() : this.menuItem.getDisabledIcon();
        if (this.menuItem.isEnabled() && BegMenuItemUI.isSelected(this.menuItem) && this.menuItem.getSelectedIcon() != null) {
            icon2 = this.menuItem.getSelectedIcon();
        }
        if (icon2 != null && icon2.getIconWidth() > this.myMaxGutterIconWidth) {
            icon2 = null;
        }
        return icon2;
    }

    @Override
    public void update(Graphics g, JComponent comp) {
        this.paint(g, comp);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ui/plaf/beg/IdeaMenuUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "patchPreferredSize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMenuBackgroundColor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyHoverListener
    extends HoverListener {
        private MyHoverListener() {
        }

        public void mouseEntered(@NotNull Component component2, int x, int y) {
            if (component2 == null) {
                MyHoverListener.$$$reportNull$$$0(0);
            }
            if (component2.getParent() instanceof JMenuBar) {
                ((JMenuItem)component2).getModel().setArmed(true);
            }
        }

        public void mouseExited(@NotNull Component component2) {
            if (component2 == null) {
                MyHoverListener.$$$reportNull$$$0(1);
            }
            if (component2.getParent() instanceof JMenuBar) {
                ((JMenuItem)component2).getModel().setArmed(false);
            }
        }

        public void mouseMoved(@NotNull Component component2, int x, int y) {
            if (component2 == null) {
                MyHoverListener.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "component";
            objectArray2[1] = "com/intellij/ui/plaf/beg/IdeaMenuUI$MyHoverListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

