/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.Key;
import java.awt.FontMetrics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwingTextTrimmer {
    public static final SwingTextTrimmer ELLIPSIS_AT_LEFT = new SwingTextTrimmer("\u2026", 2);
    public static final SwingTextTrimmer ELLIPSIS_AT_RIGHT = new SwingTextTrimmer("\u2026", 4);
    public static final SwingTextTrimmer ELLIPSIS_IN_CENTER = new SwingTextTrimmer("\u2026", 0);
    public static final SwingTextTrimmer THREE_DOTS_AT_LEFT = new SwingTextTrimmer("...", 2);
    public static final SwingTextTrimmer THREE_DOTS_AT_RIGHT = new SwingTextTrimmer("...", 4);
    public static final SwingTextTrimmer THREE_DOTS_IN_CENTER = new SwingTextTrimmer("...", 0);
    public static final Key<SwingTextTrimmer> KEY = Key.create((String)SwingTextTrimmer.class.getSimpleName());
    private final String ellipsis;
    private final int alignment;
    private final float ratio;
    private boolean trimmed;

    public static SwingTextTrimmer createCenterTrimmer(float ratio) {
        return new SwingTextTrimmer("\u2026", 0, ratio);
    }

    SwingTextTrimmer(@NotNull String ellipsis, int alignment) {
        if (ellipsis == null) {
            SwingTextTrimmer.$$$reportNull$$$0(0);
        }
        this(ellipsis, alignment, 0.5f);
    }

    SwingTextTrimmer(@NotNull String ellipsis, int alignment, float ratio) {
        if (ellipsis == null) {
            SwingTextTrimmer.$$$reportNull$$$0(1);
        }
        this.ellipsis = ellipsis;
        this.alignment = alignment;
        this.ratio = ratio;
    }

    @NotNull
    public String trim(@Nullable String text2, @NotNull FontMetrics metrics, int availableWidth) {
        if (metrics == null) {
            SwingTextTrimmer.$$$reportNull$$$0(2);
        }
        if (text2 == null || availableWidth <= 0) {
            return "";
        }
        boolean bl = this.trimmed = !SwingTextTrimmer.isFit(text2, metrics, availableWidth);
        if (!this.trimmed) {
            String string = text2;
            if (string == null) {
                SwingTextTrimmer.$$$reportNull$$$0(3);
            }
            return string;
        }
        int ellipsisWidth = metrics.stringWidth(this.ellipsis);
        if (availableWidth <= ellipsisWidth) {
            String string = this.ellipsis;
            if (string == null) {
                SwingTextTrimmer.$$$reportNull$$$0(4);
            }
            return string;
        }
        int width = availableWidth - ellipsisWidth;
        if (this.alignment == 2) {
            String string = this.ellipsis + SwingTextTrimmer.trimLeft(text2, metrics, width);
            if (string == null) {
                SwingTextTrimmer.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (this.alignment == 4) {
            String string = SwingTextTrimmer.trimRight(text2, metrics, width) + this.ellipsis;
            if (string == null) {
                SwingTextTrimmer.$$$reportNull$$$0(6);
            }
            return string;
        }
        String postfix = SwingTextTrimmer.trimRight(text2, metrics, (int)((float)width * this.ratio)) + this.ellipsis;
        String string = postfix + SwingTextTrimmer.trimLeft(text2, metrics, availableWidth - metrics.stringWidth(postfix));
        if (string == null) {
            SwingTextTrimmer.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isTrimmed() {
        return this.trimmed;
    }

    public void setTrimmed(boolean trimmed) {
        this.trimmed = trimmed;
    }

    private static boolean isFit(@NotNull String text2, @NotNull FontMetrics metrics, int width) {
        if (text2 == null) {
            SwingTextTrimmer.$$$reportNull$$$0(8);
        }
        if (metrics == null) {
            SwingTextTrimmer.$$$reportNull$$$0(9);
        }
        return text2.isEmpty() || metrics.stringWidth(text2) <= width;
    }

    @NotNull
    private static String trimLeft(@NotNull String text2, @NotNull FontMetrics metrics, int width) {
        if (text2 == null) {
            SwingTextTrimmer.$$$reportNull$$$0(10);
        }
        if (metrics == null) {
            SwingTextTrimmer.$$$reportNull$$$0(11);
        }
        int min = 0;
        int max = text2.length();
        while (true) {
            int pos = max - (max - min) / 2;
            String str = text2.substring(pos);
            if (pos == max) {
                String string = str;
                if (string == null) {
                    SwingTextTrimmer.$$$reportNull$$$0(12);
                }
                return string;
            }
            if (SwingTextTrimmer.isFit(str, metrics, width)) {
                max = pos;
                continue;
            }
            min = pos;
        }
    }

    @NotNull
    private static String trimRight(@NotNull String text2, @NotNull FontMetrics metrics, int width) {
        if (text2 == null) {
            SwingTextTrimmer.$$$reportNull$$$0(13);
        }
        if (metrics == null) {
            SwingTextTrimmer.$$$reportNull$$$0(14);
        }
        int min = 0;
        int max = text2.length();
        while (true) {
            int pos = min + (max - min) / 2;
            String str = text2.substring(0, pos);
            if (pos == min) {
                String string = str;
                if (string == null) {
                    SwingTextTrimmer.$$$reportNull$$$0(15);
                }
                return string;
            }
            if (SwingTextTrimmer.isFit(str, metrics, width)) {
                min = pos;
                continue;
            }
            max = pos;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ellipsis";
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/SwingTextTrimmer";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/SwingTextTrimmer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "trim";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeft";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "trimRight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 15: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFit";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "trimLeft";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "trimRight";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 12, 15 -> new IllegalStateException(string);
        };
    }
}

