/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.jetbrains.JBR;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017J\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0007J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000bRb\u0010\u0004\u001aV\u0012\u0004\u0012\u00020\u0006\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\t0\u0005j*\u0012\u0004\u0012\u00020\u0006\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\t`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rb\u0010\n\u001aV\u0012\u0004\u0012\u00020\u0006\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0005j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\t0\u0005j*\u0012\u0004\u0012\u00020\u0006\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0005j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\t`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/application/options/colors/FontGlyphHashCache;", "", "<init>", "()V", "fontGlyphCache", "Ljava/util/HashMap;", "Lcom/intellij/application/options/colors/FontGlyphHashCache$FontKey;", "", "", "Lkotlin/collections/HashMap;", "ligatureCache", "", "", "computeCaches", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "text", "", "computeLigatureCaches", "", "font", "Ljava/awt/Font;", "ligatures", "", "getGlyphCache", "key", "char", "getLigatureCache", "ligature", "FontKey", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFontGlyphHashCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontGlyphHashCache.kt\ncom/intellij/application/options/colors/FontGlyphHashCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,66:1\n1586#2:67\n1661#2,3:68\n383#3,7:71\n*S KotlinDebug\n*F\n+ 1 FontGlyphHashCache.kt\ncom/intellij/application/options/colors/FontGlyphHashCache\n*L\n38#1:67\n38#1:68,3\n45#1:71,7\n*E\n"})
public final class FontGlyphHashCache {
    @NotNull
    private final HashMap<FontKey, HashMap<Character, Integer>> fontGlyphCache = new HashMap();
    @NotNull
    private final HashMap<FontKey, HashMap<String, int[]>> ligatureCache = new HashMap();

    @NotNull
    public final FontKey computeCaches(@NotNull EditorColorsScheme scheme, @NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Font font = scheme.getFont(EditorFontType.PLAIN).deriveFont(13.0f);
        Intrinsics.checkNotNull((Object)font);
        return this.computeCaches(font, text2);
    }

    /*
     * WARNING - void declaration
     */
    public final void computeLigatureCaches(@NotNull Font font, @NotNull List<String> ligatures) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter(ligatures, (String)"ligatures");
        FontKey key = FontKey.Companion.fromFont(font);
        if (this.ligatureCache.get(key) == null) {
            ((Map)this.ligatureCache).put(key, new HashMap());
        }
        Lazy context = LazyKt.lazy(FontGlyphHashCache::computeLigatureCaches$lambda$0);
        for (String ligature : ligatures) {
            void $this$mapTo$iv$iv;
            HashMap<String, int[]> hashMap = this.ligatureCache.get(key);
            Intrinsics.checkNotNull(hashMap);
            if (hashMap.containsKey(ligature)) continue;
            FontRenderContext fontRenderContext = (FontRenderContext)context.getValue();
            char[] cArray = ligature.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            GlyphVector glyphVector = font.layoutGlyphVector(fontRenderContext, cArray, 0, ligature.length(), 0);
            Iterable $this$map$iv = (Iterable)StringsKt.getIndices((CharSequence)ligature);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(glyphVector.getGlyphCode((int)it));
            }
            int[] array = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
            HashMap<String, int[]> hashMap2 = this.ligatureCache.get(key);
            Intrinsics.checkNotNull(hashMap2);
            ((Map)hashMap2).put(ligature, array);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FontKey computeCaches(@NotNull Font font, @NotNull CharSequence text2) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        FontKey key = FontKey.Companion.fromFont(font);
        Map map2 = this.fontGlyphCache;
        FontKey key$iv = key;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashMap answer$iv = new HashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        HashMap cache = (HashMap)object;
        Lazy context = LazyKt.lazy(FontGlyphHashCache::computeCaches$lambda$1);
        for (int j = 0; j < text2.length(); ++j) {
            char c = text2.charAt(j);
            if (cache.containsKey(Character.valueOf(c))) continue;
            Character[] characterArray = new Character[]{Character.valueOf(c)};
            int code = font.layoutGlyphVector((FontRenderContext)context.getValue(), ArraysKt.toCharArray((Character[])characterArray), 0, 1, 0).getGlyphCode(0);
            ((Map)cache).put(Character.valueOf(c), code);
        }
        return key;
    }

    public final int getGlyphCache(@NotNull FontKey key, char c) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Serializable serializable = this.fontGlyphCache.get(key);
        return serializable != null && (serializable = ((HashMap)serializable).get(Character.valueOf(c))) != null ? (Integer)serializable : 0;
    }

    @Nullable
    public final int[] getLigatureCache(@NotNull FontKey key, @NotNull String ligature) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)ligature, (String)"ligature");
        HashMap<String, int[]> hashMap = this.ligatureCache.get(key);
        return hashMap != null ? hashMap.get(ligature) : null;
    }

    private static final FontRenderContext computeLigatureCaches$lambda$0() {
        return new FontRenderContext(null, false, false);
    }

    private static final FontRenderContext computeCaches$lambda$1() {
        return new FontRenderContext(null, false, false);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/application/options/colors/FontGlyphHashCache$FontKey;", "", "fontFamily", "", "features", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getFontFamily", "()Ljava/lang/String;", "getFeatures", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.platform.ide.impl"})
    public static final class FontKey {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String fontFamily;
        @NotNull
        private final String features;

        public FontKey(@NotNull String fontFamily, @NotNull String features) {
            Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
            Intrinsics.checkNotNullParameter((Object)features, (String)"features");
            this.fontFamily = fontFamily;
            this.features = features;
        }

        @NotNull
        public final String getFontFamily() {
            return this.fontFamily;
        }

        @NotNull
        public final String getFeatures() {
            return this.features;
        }

        @NotNull
        public final String component1() {
            return this.fontFamily;
        }

        @NotNull
        public final String component2() {
            return this.features;
        }

        @NotNull
        public final FontKey copy(@NotNull String fontFamily, @NotNull String features) {
            Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
            Intrinsics.checkNotNullParameter((Object)features, (String)"features");
            return new FontKey(fontFamily, features);
        }

        public static /* synthetic */ FontKey copy$default(FontKey fontKey, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = fontKey.fontFamily;
            }
            if ((n & 2) != 0) {
                string2 = fontKey.features;
            }
            return fontKey.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "FontKey(fontFamily=" + this.fontFamily + ", features=" + this.features + ")";
        }

        public int hashCode() {
            int result2 = this.fontFamily.hashCode();
            result2 = result2 * 31 + this.features.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FontKey)) {
                return false;
            }
            FontKey fontKey = (FontKey)other;
            if (!Intrinsics.areEqual((Object)this.fontFamily, (Object)fontKey.fontFamily)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.features, (Object)fontKey.features);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/application/options/colors/FontGlyphHashCache$FontKey$Companion;", "", "<init>", "()V", "fromFont", "Lcom/intellij/application/options/colors/FontGlyphHashCache$FontKey;", "f", "Ljava/awt/Font;", "intellij.platform.ide.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FontKey fromFont(@NotNull Font f) {
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                String string = f.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String[] stringArray = JBR.getFontExtensions().getEnabledFeatures(f);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getEnabledFeatures(...)");
                return new FontKey(string, ArraysKt.joinToString$default((Object[])stringArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

