/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.application.options.colors.AbstractFontOptionsPanel;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.FontGlyphHashCache;
import com.intellij.application.options.editor.fonts.FontDiffPopup;
import com.intellij.application.options.editor.fonts.FontFamilyCombo;
import com.intellij.application.options.editor.fonts.FontWeightCombo;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.AbstractFontCombo;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.HyperlinkEventAction;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Placeholder;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.util.ui.JBUI;
import com.jetbrains.JBR;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u0017\u0018\u00002\u00020\u0001:\u0002FGB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001bH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020#H\u0014J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020#H\u0014J\u000e\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010(H\u0014J\u000e\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010(H\u0014J\b\u0010*\u001a\u00020 H\u0014J\u0006\u0010+\u001a\u00020 J\b\u0010,\u001a\u00020-H\u0014J\b\u0010.\u001a\u00020 H\u0016J\b\u0010/\u001a\u00020 H\u0002J\b\u00100\u001a\u00020 H\u0002J\n\u00101\u001a\u0004\u0018\u00010-H\u0014J\f\u00102\u001a\u00020 *\u000203H\u0002J\u001b\u00104\u001a\u0015\u0012\u000b\u0012\t\u0018\u00010\u0012\u00a2\u0006\u0002\b6\u0012\u0004\u0012\u00020705H\u0014J\b\u00108\u001a\u00020\u000bH\u0002J\b\u00109\u001a\u00020\u000bH\u0002J\u0016\u0010:\u001a\u00020 2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001e0<H\u0002J)\u0010>\u001a\u00020 *\u0002032\u0006\u0010?\u001a\u00020\u00122\u000b\u0010@\u001a\u00070\u0012\u00a2\u0006\u0002\b62\u0006\u0010A\u001a\u00020\u001bH\u0002J\u0010\u0010B\u001a\u00020\u00122\u0006\u0010?\u001a\u00020\u0012H\u0002J\u0019\u0010C\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b62\b\b\u0001\u0010D\u001a\u00020\u0012H\u0002J\b\u0010E\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/intellij/application/options/editor/fonts/AppFontOptionsPanel;", "Lcom/intellij/application/options/colors/AbstractFontOptionsPanel;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "defaultPreferences", "Lcom/intellij/openapi/editor/colors/impl/FontPreferencesImpl;", "getDefaultPreferences", "()Lcom/intellij/openapi/editor/colors/impl/FontPreferencesImpl;", "regularWeightCombo", "Lcom/intellij/application/options/editor/fonts/FontWeightCombo;", "boldWeightCombo", "variantsGroup", "Lcom/intellij/ui/dsl/builder/ButtonsGroup;", "variantsPlaceholder", "Lcom/intellij/ui/dsl/builder/Placeholder;", "currentFont", "", "currentFeatures", "", "Lcom/intellij/ui/components/JBCheckBox;", "recentFeatures", "", "fontGlyphCache", "Lcom/intellij/application/options/colors/FontGlyphHashCache;", "isReadOnly", "", "isDelegating", "getFontPreferences", "Lcom/intellij/openapi/editor/colors/FontPreferences;", "setFontSize", "", "fontSize", "", "", "getLineSpacing", "setCurrentLineSpacing", "lineSpacing", "createPrimaryFontCombo", "Lcom/intellij/ui/AbstractFontCombo;", "createSecondaryFontCombo", "addControls", "updateOnChangedFont", "createControls", "Ljavax/swing/JComponent;", "updateFontPreferences", "refreshVariantsPanel", "restoreSelectedVariants", "createCustomComponent", "createTypographySettings", "Lcom/intellij/ui/dsl/builder/Panel;", "createBoldFontHint", "Lkotlin/Pair;", "Lorg/jetbrains/annotations/Nls;", "Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;", "createRegularWeightCombo", "createBoldWeightCombo", "changeFontPreferences", "consumer", "Ljava/util/function/Consumer;", "previewChars", "addFeatureCheckbox", "feature", "label", "selected", "getFeatureSortingKey", "getFeatureLabel", "tag", "updateOptionsList", "RegularFontWeightCombo", "BoldFontWeightCombo", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAppFontOptionsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppFontOptionsPanel.kt\ncom/intellij/application/options/editor/fonts/AppFontOptionsPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,361:1\n1#2:362\n1#2:374\n1642#3,10:363\n1915#3:373\n1916#3:375\n1652#3:376\n1068#3:386\n1915#3,2:387\n221#4,2:377\n540#5:379\n525#5,6:380\n*S KotlinDebug\n*F\n+ 1 AppFontOptionsPanel.kt\ncom/intellij/application/options/editor/fonts/AppFontOptionsPanel\n*L\n157#1:374\n157#1:363,10\n157#1:373\n157#1:375\n157#1:376\n175#1:386\n176#1:387,2\n182#1:377,2\n188#1:379\n188#1:380,6\n*E\n"})
public class AppFontOptionsPanel
extends AbstractFontOptionsPanel {
    @NotNull
    private final EditorColorsScheme scheme;
    @NotNull
    private final FontPreferencesImpl defaultPreferences;
    @Nullable
    private FontWeightCombo regularWeightCombo;
    @Nullable
    private FontWeightCombo boldWeightCombo;
    @Nullable
    private ButtonsGroup variantsGroup;
    @Nullable
    private Placeholder variantsPlaceholder;
    @Nullable
    private String currentFont;
    @NotNull
    private final Map<String, JBCheckBox> currentFeatures;
    @NotNull
    private final Map<String, Set<String>> recentFeatures;
    @NotNull
    private final FontGlyphHashCache fontGlyphCache;
    @NotNull
    private final String previewChars;

    public AppFontOptionsPanel(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        this.scheme = scheme;
        this.defaultPreferences = new FontPreferencesImpl();
        this.currentFeatures = new LinkedHashMap();
        this.recentFeatures = new LinkedHashMap();
        this.fontGlyphCache = new FontGlyphHashCache();
        this.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void fontChanged() {
                this.restoreSelectedVariants();
                this.updateFontPreferences();
            }

            @Override
            public void schemeReset(FontPreferences fontPreferences) {
                Intrinsics.checkNotNullParameter((Object)fontPreferences, (String)"fontPreferences");
                recentFeatures.put(fontPreferences.getFontFamily(), fontPreferences.getCharacterVariants());
                if (Intrinsics.areEqual((Object)currentFont, (Object)fontPreferences.getFontFamily())) {
                    Map $this$forEach$iv = currentFeatures;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry entry = element$iv = iterator.next();
                        boolean bl = false;
                        String string = (String)entry.getKey();
                        JBCheckBox box = (JBCheckBox)entry.getValue();
                        box.setSelected(fontPreferences.getCharacterVariants().contains(string));
                    }
                }
            }
        });
        AppEditorFontOptions.initDefaults((ModifiableFontPreferences)((ModifiableFontPreferences)this.defaultPreferences));
        this.updateOptionsList();
        this.previewChars = CollectionsKt.joinToString$default((Iterable)((Iterable)new CharRange('!', '~')), null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    protected final FontPreferencesImpl getDefaultPreferences() {
        return this.defaultPreferences;
    }

    @Override
    protected boolean isReadOnly() {
        return false;
    }

    @Override
    protected boolean isDelegating() {
        return false;
    }

    @Override
    @NotNull
    protected FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.scheme.getFontPreferences();
        Intrinsics.checkNotNullExpressionValue((Object)fontPreferences, (String)"getFontPreferences(...)");
        return fontPreferences;
    }

    @Override
    protected void setFontSize(int fontSize) {
        this.setFontSize((float)fontSize);
    }

    @Override
    protected void setFontSize(float fontSize) {
        this.scheme.setEditorFontSize(fontSize);
    }

    @Override
    protected float getLineSpacing() {
        return this.scheme.getLineSpacing();
    }

    @Override
    protected void setCurrentLineSpacing(float lineSpacing) {
        this.scheme.setLineSpacing(lineSpacing);
    }

    @Override
    @Nullable
    protected AbstractFontCombo<?> createPrimaryFontCombo() {
        return new FontFamilyCombo(true);
    }

    @Override
    @Nullable
    protected AbstractFontCombo<?> createSecondaryFontCombo() {
        return new FontFamilyCombo(false);
    }

    @Override
    protected void addControls() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createControls(), "Center");
    }

    public final void updateOnChangedFont() {
        this.updateOptionsList();
        this.fireFontChanged();
    }

    @Override
    @NotNull
    protected JComponent createControls() {
        DialogPanel panel2 = (DialogPanel)BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> AppFontOptionsPanel.createControls$lambda$0(this, arg_0))).withBorder(JBUI.Borders.empty((int)5));
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)panel2), (int)22, (int)31, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        JScrollPane scrollPane = jScrollPane;
        scrollPane.setMinimumSize(new Dimension(panel2.getMinimumSize().width, 100));
        return scrollPane;
    }

    public void updateFontPreferences() {
        FontWeightCombo fontWeightCombo;
        FontWeightCombo fontWeightCombo2 = this.regularWeightCombo;
        if (fontWeightCombo2 != null) {
            FontWeightCombo $this$updateFontPreferences_u24lambda_u240 = fontWeightCombo = fontWeightCombo2;
            boolean bl = false;
            $this$updateFontPreferences_u24lambda_u240.update(this.getFontPreferences());
        }
        FontWeightCombo fontWeightCombo3 = this.boldWeightCombo;
        if (fontWeightCombo3 != null) {
            FontWeightCombo $this$updateFontPreferences_u24lambda_u241 = fontWeightCombo = fontWeightCombo3;
            boolean bl = false;
            $this$updateFontPreferences_u24lambda_u241.update(this.getFontPreferences());
        }
        this.refreshVariantsPanel();
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshVariantsPanel() {
        void $this$mapNotNullTo$iv$iv;
        if (this.variantsGroup == null) {
            return;
        }
        Font font = FontFamilyService.getFont((String)this.getFontPreferences().getFontFamily(), (String)this.getFontPreferences().getRegularSubFamily(), (String)this.getFontPreferences().getBoldSubFamily(), (int)12);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font font2 = font;
        Set set = JBR.getFontExtensions().getAvailableFeatures(font2);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAvailableFeatures(...)");
        Iterable $this$mapNotNull$iv = set;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            String displayText;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String variant = (String)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)variant);
            String string = displayText = this.getFeatureLabel(variant);
            if ((string != null ? TuplesKt.to((Object)variant, (Object)string) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List availableFeatures = (List)destination$iv$iv;
        if (availableFeatures.isEmpty()) {
            ButtonsGroup buttonsGroup = this.variantsGroup;
            if (buttonsGroup != null) {
                buttonsGroup.visible(false);
            }
            return;
        }
        ButtonsGroup buttonsGroup = this.variantsGroup;
        if (buttonsGroup != null) {
            buttonsGroup.visible(true);
        }
        Set set2 = this.getFontPreferences().getCharacterVariants();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getCharacterVariants(...)");
        Set enabledFeatures = set2;
        if (!Intrinsics.areEqual((Object)this.getFontPreferences().getFontFamily(), (Object)this.currentFont)) {
            this.currentFeatures.clear();
            this.currentFont = this.getFontPreferences().getFontFamily();
            Placeholder placeholder = this.variantsPlaceholder;
            Intrinsics.checkNotNull((Object)placeholder);
            placeholder.setComponent((JComponent)BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> AppFontOptionsPanel.refreshVariantsPanel$lambda$1(availableFeatures, this, enabledFeatures, arg_0))));
        } else {
            Map<String, JBCheckBox> $this$forEach$iv = this.currentFeatures;
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, JBCheckBox>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, JBCheckBox> element$iv;
                Map.Entry<String, JBCheckBox> entry = element$iv = iterator2.next();
                boolean bl = false;
                String feature = entry.getKey();
                JBCheckBox cb = entry.getValue();
                cb.setSelected(enabledFeatures.contains(feature));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void restoreSelectedVariants() {
        String string = this.currentFont;
        if (string != null) {
            void $this$filterTo$iv$iv;
            String font = string;
            boolean bl = false;
            Map<String, Set<String>> map2 = this.recentFeatures;
            Map<String, JBCheckBox> $this$filter$iv = this.currentFeatures;
            boolean $i$f$filter = false;
            Map<String, JBCheckBox> map3 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator.next();
                boolean bl2 = false;
                JBCheckBox value = (JBCheckBox)entry.getValue();
                if (!value.isSelected()) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Set set = CollectionsKt.toSet((Iterable)destination$iv$iv.keySet());
            map2.put(font, set);
        }
        Set<String> previousFeatures = this.recentFeatures.get(this.getFontPreferences().getFontFamily());
        if (previousFeatures != null && !Intrinsics.areEqual((Object)this.getFontPreferences().getCharacterVariants(), previousFeatures)) {
            FontPreferences fontPreferences = this.getFontPreferences();
            Intrinsics.checkNotNull((Object)fontPreferences, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.colors.ModifiableFontPreferences");
            ((ModifiableFontPreferences)fontPreferences).setCharacterVariants(previousFeatures);
        }
    }

    @Nullable
    protected JComponent createCustomComponent() {
        return null;
    }

    private final void createTypographySettings(Panel $this$createTypographySettings) {
        String string = ApplicationBundle.message((String)"settings.editor.font.typography.settings", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Panel.collapsibleGroup$default($this$createTypographySettings, string, false, arg_0 -> AppFontOptionsPanel.createTypographySettings$lambda$0(this, arg_0), 2, null);
    }

    @NotNull
    protected Pair<String, HyperlinkEventAction> createBoldFontHint() {
        return new Pair(null, (Object)HyperlinkEventAction.HTML_HYPERLINK_INSTANCE);
    }

    private final FontWeightCombo createRegularWeightCombo() {
        RegularFontWeightCombo result2 = new RegularFontWeightCombo();
        result2.addActionListener(arg_0 -> AppFontOptionsPanel.createRegularWeightCombo$lambda$0(this, result2, arg_0));
        return result2;
    }

    private final FontWeightCombo createBoldWeightCombo() {
        BoldFontWeightCombo result2 = new BoldFontWeightCombo();
        result2.addActionListener(arg_0 -> AppFontOptionsPanel.createBoldWeightCombo$lambda$0(this, result2, arg_0));
        return result2;
    }

    private final void changeFontPreferences(Consumer<FontPreferences> consumer) {
        FontPreferences preferences = this.getFontPreferences();
        consumer.accept(preferences);
        this.fireFontChanged();
    }

    private final void addFeatureCheckbox(Panel $this$addFeatureCheckbox, String feature, String label2, boolean selected) {
        Panel.row$default($this$addFeatureCheckbox, null, arg_0 -> AppFontOptionsPanel.addFeatureCheckbox$lambda$0(label2, selected, this, feature, arg_0), 1, null);
    }

    private final String getFeatureSortingKey(String feature) {
        if (Intrinsics.areEqual((Object)StringsKt.take((String)feature, (int)2), (Object)"ss")) {
            String string = feature.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            if (StringsKt.toIntOrNull((String)string) != null) {
                return "0-" + feature;
            }
        }
        if (Intrinsics.areEqual((Object)StringsKt.take((String)feature, (int)2), (Object)"cv")) {
            String string = feature.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            if (StringsKt.toIntOrNull((String)string) != null) {
                return "Z-" + feature;
            }
        }
        switch (feature) {
            case "zero": {
                return "1";
            }
            case "hlig": 
            case "onum": 
            case "salt": 
            case "clig": 
            case "dlig": 
            case "case": {
                return "2-" + feature;
            }
        }
        return "X-" + feature;
    }

    /*
     * Unable to fully structure code
     */
    private final String getFeatureLabel(@NlsSafe String tag) {
        block23: {
            block18: {
                block21: {
                    block20: {
                        block19: {
                            block22: {
                                var2_2 = tag;
                                switch (var2_2.hashCode()) {
                                    case 3735208: {
                                        if (!var2_2.equals("zero")) {
                                            ** break;
                                        }
                                        break block18;
                                    }
                                    case 3205410: {
                                        if (!var2_2.equals("hlig")) {
                                            ** break;
                                        }
                                        break block19;
                                    }
                                    case 3416247: {
                                        if (!var2_2.equals("onum")) {
                                            ** break;
                                        }
                                        break block20;
                                    }
                                    case 3522646: {
                                        if (!var2_2.equals("salt")) {
                                            ** break;
                                        }
                                        break block21;
                                    }
                                    case 3056455: {
                                        if (var2_2.equals("clig")) break;
                                        ** break;
                                    }
                                    case 3086246: {
                                        if (!var2_2.equals("dlig")) {
                                            ** break;
                                        }
                                        break block22;
                                    }
                                    case 3046192: {
                                        if (!var2_2.equals("case")) ** break;
                                        v0 = ApplicationBundle.message((String)"settings.editor.font.feature.case", (Object[])new Object[0]);
                                        break block23;
                                    }
                                }
                                v0 = ApplicationBundle.message((String)"settings.editor.font.feature.clig", (Object[])new Object[0]);
                                break block23;
                            }
                            v0 = ApplicationBundle.message((String)"settings.editor.font.feature.dlig", (Object[])new Object[0]);
                            break block23;
                        }
                        v0 = ApplicationBundle.message((String)"settings.editor.font.feature.hlig", (Object[])new Object[0]);
                        break block23;
                    }
                    v0 = ApplicationBundle.message((String)"settings.editor.font.feature.onum", (Object[])new Object[0]);
                    break block23;
                }
                v0 = ApplicationBundle.message((String)"settings.editor.font.feature.salt", (Object[])new Object[0]);
                break block23;
            }
            v0 = ApplicationBundle.message((String)"settings.editor.font.feature.zero", (Object[])new Object[0]);
            break block23;
lbl47:
            // 8 sources

            if (tag.length() == 4 && StringsKt.startsWith$default((String)tag, (String)"ss", (boolean)false, (int)2, null)) {
                v1 = tag.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                num = StringsKt.toIntOrNull((String)v1);
                if (num != null) {
                    var4_4 = new Object[]{num};
                    return ApplicationBundle.message((String)"settings.editor.font.feature.ss", (Object[])var4_4);
                }
            }
            if (tag.length() == 4 && StringsKt.startsWith$default((String)tag, (String)"cv", (boolean)false, (int)2, null)) {
                v2 = tag.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                num = StringsKt.toIntOrNull((String)v2);
                if (num != null) {
                    var4_5 = new Object[]{num};
                    return ApplicationBundle.message((String)"settings.editor.font.feature.cv", (Object[])var4_5);
                }
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    public void updateOptionsList() {
        block1: {
            super.updateOptionsList();
            FontWeightCombo fontWeightCombo = this.regularWeightCombo;
            if (fontWeightCombo != null) {
                fontWeightCombo.setEnabled(!this.isReadOnly());
            }
            FontWeightCombo fontWeightCombo2 = this.boldWeightCombo;
            if (fontWeightCombo2 == null) break block1;
            fontWeightCombo2.setEnabled(!this.isReadOnly());
        }
    }

    private static final Unit createControls$lambda$0$0(AppFontOptionsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        AbstractFontCombo<?> abstractFontCombo = this$0.getPrimaryCombo();
        Intrinsics.checkNotNullExpressionValue(abstractFontCombo, (String)"getPrimaryCombo(...)");
        $this$row.cell((JComponent)((Object)abstractFontCombo));
        return Unit.INSTANCE;
    }

    private static final Unit createControls$lambda$0$1(AppFontOptionsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JTextField jTextField = this$0.getEditorFontSizeField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getEditorFontSizeField(...)");
        $this$row.cell((JComponent)jTextField);
        JTextField jTextField2 = this$0.getLineSpacingField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField2, (String)"getLineSpacingField(...)");
        Cell<JComponent> cell = $this$row.cell((JComponent)jTextField2);
        JLabel jLabel = this$0.getLineSpacingLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"getLineSpacingLabel(...)");
        Cell.label$default(cell, jLabel, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createControls$lambda$0$2(AppFontOptionsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JCheckBox jCheckBox = this$0.getEnableLigaturesCheckbox();
        Intrinsics.checkNotNullExpressionValue((Object)jCheckBox, (String)"getEnableLigaturesCheckbox(...)");
        $this$row.cell((JComponent)jCheckBox).gap(RightGap.SMALL);
        JLabel jLabel = this$0.getEnableLigaturesHintLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"getEnableLigaturesHintLabel(...)");
        $this$row.cell((JComponent)jLabel);
        return Unit.INSTANCE;
    }

    private static final Unit createControls$lambda$0$3(JComponent $customComponent, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell($customComponent);
        return Unit.INSTANCE;
    }

    private static final Unit createControls$lambda$0(AppFontOptionsPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(this$0.getPrimaryLabel(), (Function1<? super Row, Unit>)((Function1)arg_0 -> AppFontOptionsPanel.createControls$lambda$0$0(this$0, arg_0)));
        $this$panel.row(this$0.getSizeLabel(), (Function1<? super Row, Unit>)((Function1)arg_0 -> AppFontOptionsPanel.createControls$lambda$0$1(this$0, arg_0))).bottomGap(BottomGap.SMALL);
        Panel.row$default($this$panel, null, arg_0 -> AppFontOptionsPanel.createControls$lambda$0$2(this$0, arg_0), 1, null).layout(RowLayout.INDEPENDENT).bottomGap(BottomGap.SMALL);
        JComponent customComponent = this$0.createCustomComponent();
        if (customComponent != null) {
            Panel.row$default($this$panel, null, arg_0 -> AppFontOptionsPanel.createControls$lambda$0$3(customComponent, arg_0), 1, null);
        }
        if (FontFamilyService.isServiceSupported()) {
            this$0.createTypographySettings($this$panel);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit refreshVariantsPanel$lambda$1(List $availableFeatures, AppFontOptionsPanel this$0, Set $enabledFeatures, Panel $this$panel) {
        void $this$forEach$iv;
        Iterable $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Iterable iterable = $availableFeatures;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(this$0){
            final /* synthetic */ AppFontOptionsPanel this$0;
            {
                this.this$0 = appFontOptionsPanel;
            }

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Object object = it.getFirst();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-first>(...)");
                it = (Pair)b;
                Comparable comparable = (Comparable)((Object)AppFontOptionsPanel.access$getFeatureSortingKey(this.this$0, (String)object));
                bl = false;
                Object object2 = it.getFirst();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"<get-first>(...)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)AppFontOptionsPanel.access$getFeatureSortingKey(this.this$0, (String)object2))));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Object object = pair.component1();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
            String feature = (String)object;
            String displayText = (String)pair.component2();
            this$0.addFeatureCheckbox($this$panel, feature, displayText, $enabledFeatures.contains(feature));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createTypographySettings$lambda$0$3$0(AppFontOptionsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.variantsPlaceholder = $this$row.placeholder();
        return Unit.INSTANCE;
    }

    private static final Unit createTypographySettings$lambda$0$0(AppFontOptionsPanel this$0, Row $this$row) {
        FontWeightCombo component2;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.regularWeightCombo = component2 = this$0.createRegularWeightCombo();
        $this$row.cell((JComponent)((Object)component2)).widthGroup("TypographySettingsCombo");
        return Unit.INSTANCE;
    }

    private static final Unit createTypographySettings$lambda$0$1(AppFontOptionsPanel this$0, Row $this$row) {
        FontWeightCombo component2;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.boldWeightCombo = component2 = this$0.createBoldWeightCombo();
        Pair<String, HyperlinkEventAction> boldFontHint = this$0.createBoldFontHint();
        $this$row.cell((JComponent)((Object)component2)).widthGroup("TypographySettingsCombo").comment((String)boldFontHint.getFirst(), 70, (HyperlinkEventAction)boldFontHint.getSecond());
        return Unit.INSTANCE;
    }

    private static final Unit createTypographySettings$lambda$0$2(AppFontOptionsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        AbstractFontCombo<?> abstractFontCombo = this$0.getSecondaryCombo();
        Intrinsics.checkNotNullExpressionValue(abstractFontCombo, (String)"getSecondaryCombo(...)");
        Cell.comment$default($this$row.cell((JComponent)((Object)abstractFontCombo)).widthGroup("TypographySettingsCombo"), ApplicationBundle.message((String)"label.fallback.fonts.list.description", (Object[])new Object[0]), 0, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createTypographySettings$lambda$0$3(AppFontOptionsPanel this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default($this$buttonsGroup, null, arg_0 -> AppFontOptionsPanel.createTypographySettings$lambda$0$3$0(this$0, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createTypographySettings$lambda$0(AppFontOptionsPanel this$0, Panel $this$collapsibleGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$collapsibleGroup, (String)"$this$collapsibleGroup");
        String string = ApplicationBundle.message((String)"settings.editor.font.main.weight", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$collapsibleGroup.row(string, (Function1<? super Row, Unit>)((Function1)arg_0 -> AppFontOptionsPanel.createTypographySettings$lambda$0$0(this$0, arg_0)));
        String string2 = ApplicationBundle.message((String)"settings.editor.font.bold.weight", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$collapsibleGroup.row(string2, (Function1<? super Row, Unit>)((Function1)arg_0 -> AppFontOptionsPanel.createTypographySettings$lambda$0$1(this$0, arg_0))).bottomGap(BottomGap.SMALL);
        JLabel secondaryFont = new JLabel(ApplicationBundle.message((String)"secondary.font", (Object[])new Object[0]));
        this$0.setSecondaryFontLabel(secondaryFont);
        $this$collapsibleGroup.row(secondaryFont, (Function1<? super Row, Unit>)((Function1)arg_0 -> AppFontOptionsPanel.createTypographySettings$lambda$0$2(this$0, arg_0)));
        this$0.variantsGroup = $this$collapsibleGroup.buttonsGroup(ApplicationBundle.message((String)"settings.editor.font.character.variants", (Object[])new Object[0]), true, (Function1<? super Panel, Unit>)((Function1)arg_0 -> AppFontOptionsPanel.createTypographySettings$lambda$0$3(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final void createRegularWeightCombo$lambda$0$0(RegularFontWeightCombo $result, FontPreferences preferences) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        if (preferences instanceof ModifiableFontPreferences) {
            String newSubFamily = $result.getSelectedSubFamily();
            if (!Intrinsics.areEqual((Object)((ModifiableFontPreferences)preferences).getRegularSubFamily(), (Object)newSubFamily)) {
                ((ModifiableFontPreferences)preferences).setBoldSubFamily(null);
            }
            ((ModifiableFontPreferences)preferences).setRegularSubFamily(newSubFamily);
        }
    }

    private static final void createRegularWeightCombo$lambda$0(AppFontOptionsPanel this$0, RegularFontWeightCombo $result, ActionEvent it) {
        this$0.changeFontPreferences(arg_0 -> AppFontOptionsPanel.createRegularWeightCombo$lambda$0$0($result, arg_0));
    }

    private static final void createBoldWeightCombo$lambda$0$0(BoldFontWeightCombo $result, FontPreferences preferences) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        if (preferences instanceof ModifiableFontPreferences) {
            ((ModifiableFontPreferences)preferences).setBoldSubFamily($result.getSelectedSubFamily());
        }
    }

    private static final void createBoldWeightCombo$lambda$0(AppFontOptionsPanel this$0, BoldFontWeightCombo $result, ActionEvent it) {
        this$0.changeFontPreferences(arg_0 -> AppFontOptionsPanel.createBoldWeightCombo$lambda$0$0($result, arg_0));
    }

    private static final Unit addFeatureCheckbox$lambda$0$0(AppFontOptionsPanel this$0, String $feature, ActionEvent actionEvent, JBCheckBox cb) {
        ModifiableFontPreferences modifiableFontPreferences;
        Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
        FontPreferences fontPreferences = this$0.getFontPreferences();
        Intrinsics.checkNotNull((Object)fontPreferences, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.colors.ModifiableFontPreferences");
        ModifiableFontPreferences $this$addFeatureCheckbox_u24lambda_u240_u240_u240 = modifiableFontPreferences = (ModifiableFontPreferences)fontPreferences;
        boolean bl = false;
        $this$addFeatureCheckbox_u24lambda_u240_u240_u240.setCharacterVariant($feature, cb.isSelected());
        this$0.fireFontChanged();
        return Unit.INSTANCE;
    }

    private static final Unit addFeatureCheckbox$lambda$0(String $label, boolean $selected, AppFontOptionsPanel this$0, String $feature, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBCheckBox featureCb = ButtonKt.actionListener(ButtonKt.selected($this$row.checkBox($label), $selected), (arg_0, arg_1) -> AppFontOptionsPanel.addFeatureCheckbox$lambda$0$0(this$0, $feature, arg_0, arg_1)).getComponent();
        this$0.currentFeatures.put($feature, featureCb);
        String[] stringArray = new String[]{$feature};
        FontDiffPopup.Companion.diffForFeatures(this$0.fontGlyphCache, this$0.scheme, this$0.previewChars, stringArray).installOn((JComponent)featureCb);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$getFeatureSortingKey(AppFontOptionsPanel $this, String feature) {
        return $this.getFeatureSortingKey(feature);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/application/options/editor/fonts/AppFontOptionsPanel$BoldFontWeightCombo;", "Lcom/intellij/application/options/editor/fonts/FontWeightCombo;", "<init>", "(Lcom/intellij/application/options/editor/fonts/AppFontOptionsPanel;)V", "getSubFamily", "", "preferences", "Lcom/intellij/openapi/editor/colors/FontPreferences;", "getRecommendedSubFamily", "family", "intellij.platform.ide.impl"})
    private final class BoldFontWeightCombo
    extends FontWeightCombo {
        public BoldFontWeightCombo() {
            super(true);
        }

        @Override
        @Nullable
        protected String getSubFamily(@NotNull FontPreferences preferences) {
            Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
            return preferences.getBoldSubFamily();
        }

        @Override
        @NotNull
        protected String getRecommendedSubFamily(@NotNull String family) {
            Intrinsics.checkNotNullParameter((Object)family, (String)"family");
            Object object = AppFontOptionsPanel.this.regularWeightCombo;
            if (object == null || (object = object.getSelectedSubFamily()) == null) {
                String string = FontFamilyService.getRecommendedSubFamily((String)family);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRecommendedSubFamily(...)");
            }
            String string = FontFamilyService.getRecommendedBoldSubFamily((String)family, (String)object);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRecommendedBoldSubFamily(...)");
            return string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/application/options/editor/fonts/AppFontOptionsPanel$RegularFontWeightCombo;", "Lcom/intellij/application/options/editor/fonts/FontWeightCombo;", "<init>", "()V", "getSubFamily", "", "preferences", "Lcom/intellij/openapi/editor/colors/FontPreferences;", "getRecommendedSubFamily", "family", "intellij.platform.ide.impl"})
    private static final class RegularFontWeightCombo
    extends FontWeightCombo {
        public RegularFontWeightCombo() {
            super(false);
        }

        @Override
        @Nullable
        protected String getSubFamily(@NotNull FontPreferences preferences) {
            Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
            return preferences.getRegularSubFamily();
        }

        @Override
        @NotNull
        protected String getRecommendedSubFamily(@NotNull String family) {
            Intrinsics.checkNotNullParameter((Object)family, (String)"family");
            String string = FontFamilyService.getRecommendedSubFamily((String)family);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRecommendedSubFamily(...)");
            return string;
        }
    }
}

