/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.IdeaFreezeReporterKt;
import com.intellij.diagnostic.PerformanceWatcherImplKt;
import com.intellij.util.SmartList;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u000e\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0000J\n\u0010\u0011\u001a\u00020\u0012H\u0096\u0080\u0004J\u0012\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017J\u0006\u0010\u0018\u001a\u00020\u0012J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001c\u001a\u00020\u001dR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/diagnostic/CallTreeNode;", "", "stackTraceElement", "Ljava/lang/StackTraceElement;", "parent", "time", "", "threadInfo", "Ljava/lang/management/ThreadInfo;", "<init>", "(Ljava/lang/StackTraceElement;Lcom/intellij/diagnostic/CallTreeNode;ILjava/lang/management/ThreadInfo;)V", "children", "Lcom/intellij/util/SmartList;", "depth", "addCallee", "e", "getMostHitChild", "toString", "", "appendIndentedString", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "dump", "getStack", "", "findDominantCommonStack", "threshold", "", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIdeaFreezeReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaFreezeReporter.kt\ncom/intellij/diagnostic/CallTreeNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,545:1\n1#2:546\n*E\n"})
final class CallTreeNode {
    @Nullable
    private final StackTraceElement stackTraceElement;
    @Nullable
    private final CallTreeNode parent;
    @JvmField
    public int time;
    @JvmField
    @Nullable
    public final ThreadInfo threadInfo;
    @NotNull
    private final SmartList<CallTreeNode> children;
    private final int depth;

    public CallTreeNode(@Nullable StackTraceElement stackTraceElement, @Nullable CallTreeNode parent, int time, @Nullable ThreadInfo threadInfo) {
        this.stackTraceElement = stackTraceElement;
        this.parent = parent;
        this.time = time;
        this.threadInfo = threadInfo;
        this.children = new SmartList();
        this.depth = this.parent == null ? 0 : this.parent.depth + 1;
    }

    @NotNull
    public final CallTreeNode addCallee(@Nullable StackTraceElement e, int time, @Nullable ThreadInfo threadInfo) {
        Iterator iterator = this.children.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e2 = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
            CallTreeNode child = (CallTreeNode)e2;
            StackTraceElement stackTraceElement = child.stackTraceElement;
            Intrinsics.checkNotNull((Object)stackTraceElement);
            StackTraceElement stackTraceElement2 = e;
            Intrinsics.checkNotNull((Object)stackTraceElement2);
            if (!PerformanceWatcherImplKt.compareStackTraceElements(stackTraceElement, stackTraceElement2)) continue;
            child.time += time;
            return child;
        }
        CallTreeNode child = new CallTreeNode(e, this, time, threadInfo);
        this.children.add((Object)child);
        return child;
    }

    @Nullable
    public final CallTreeNode getMostHitChild() {
        CallTreeNode currentMax = null;
        Iterator iterator = this.children.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            CallTreeNode child = (CallTreeNode)e;
            if (currentMax != null && child.time <= currentMax.time) continue;
            currentMax = child;
        }
        return currentMax;
    }

    @NotNull
    public String toString() {
        return this.time + " " + this.stackTraceElement;
    }

    public final void appendIndentedString(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        int n = this.depth;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            builder.append(' ');
        }
        StackTraceElement stackTraceElement = this.stackTraceElement;
        Intrinsics.checkNotNull((Object)stackTraceElement);
        builder.append(stackTraceElement.getClassName()).append(".").append(this.stackTraceElement.getMethodName()).append(" ").append(this.time).append("ms").append('\n');
    }

    @NotNull
    public final String dump() {
        StringBuilder stringBuilder = new StringBuilder();
        LinkedList nodes = new LinkedList((Collection)this.children);
        while (!nodes.isEmpty()) {
            CallTreeNode node = (CallTreeNode)nodes.removeFirst();
            node.appendIndentedString(stringBuilder);
            nodes.addAll(0, CollectionsKt.sortedWith((Iterable)((Iterable)node.children), (Comparator)IdeaFreezeReporterKt.access$getTIME_COMPARATOR$p()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final List<StackTraceElement> getStack() {
        Object object;
        ArrayList<Object> result2 = new ArrayList<Object>();
        CallTreeNode node = this;
        while ((object = node) != null && (object = ((CallTreeNode)object).stackTraceElement) != null) {
            result2.add(object);
            node = node.parent;
        }
        return result2;
    }

    @Nullable
    public final CallTreeNode findDominantCommonStack(long threshold) {
        CallTreeNode mostHitChild;
        CallTreeNode callTreeNode = this.getMostHitChild();
        if (callTreeNode == null) {
            return null;
        }
        CallTreeNode node = callTreeNode;
        while (!node.children.isEmpty() && (mostHitChild = node.getMostHitChild()) != null && (long)mostHitChild.time > threshold) {
            node = mostHitChild;
        }
        return node;
    }
}

