/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bJ\u0006\u0010\f\u001a\u00020\u0003R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/diagnostic/HProfDatabase;", "", "tmpDirectory", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "hprofTempDirectory", "LOCK", "cleanupHProfFiles", "", "pathsToKeep", "", "createHprofTemporaryFilePath", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHProfDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HProfDatabase.kt\ncom/intellij/diagnostic/HProfDatabase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1586#2:78\n1661#2,3:79\n1915#2,2:82\n*S KotlinDebug\n*F\n+ 1 HProfDatabase.kt\ncom/intellij/diagnostic/HProfDatabase\n*L\n52#1:78\n52#1:79,3\n54#1:82,2\n*E\n"})
public final class HProfDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path hprofTempDirectory;
    @NotNull
    private final Object LOCK;
    @NotNull
    private static final Logger LOG;

    public HProfDatabase(@NotNull Path tmpDirectory) {
        Intrinsics.checkNotNullParameter((Object)tmpDirectory, (String)"tmpDirectory");
        Path path = tmpDirectory.resolve("hprof-temp").toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        this.hprofTempDirectory = path;
        this.LOCK = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void cleanupHProfFiles(@NotNull List<? extends Path> pathsToKeep) {
        Intrinsics.checkNotNullParameter(pathsToKeep, (String)"pathsToKeep");
        Object object = this.LOCK;
        synchronized (object) {
            block12: {
                boolean bl = false;
                try {
                    void $this$mapTo$iv$iv;
                    LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                    if (!Files.isDirectory(this.hprofTempDirectory, linkOptionArray)) break block12;
                    Iterable $this$map$iv = pathsToKeep;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        Path path = (Path)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(p0.toAbsolutePath());
                    }
                    Set pathsToKeepSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    Closeable closeable = Files.newDirectoryStream(this.hprofTempDirectory);
                    Throwable throwable = null;
                    try {
                        DirectoryStream stream = (DirectoryStream)closeable;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)stream);
                        Iterable $this$forEach$iv = stream;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Path path = (Path)element$iv;
                            boolean bl4 = false;
                            LinkOption[] linkOptionArray2 = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                            if (!Files.isRegularFile(path, linkOptionArray2) || pathsToKeepSet.contains(path.toAbsolutePath())) continue;
                            Files.delete(path);
                        }
                        iterable = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (IOException e) {
                    LOG.warn("Exception while cleaning hprof files", (Throwable)e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final Path createHprofTemporaryFilePath() {
        String string = ApplicationNamesInfo.getInstance().getProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductName(...)");
        String string2 = StringsKt.replace$default((String)string, (char)' ', (char)'-', (boolean)false, (int)4, null);
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String name2 = string3;
        PathKt.createDirectories((Path)this.hprofTempDirectory);
        Path path = this.hprofTempDirectory.resolve("heapDump-" + name2 + "-" + System.currentTimeMillis() + ".hprof");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    static {
        Logger logger = Logger.getInstance(HProfDatabase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diagnostic/HProfDatabase$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

