/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.visitors;

import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.histogram.Histogram;
import com.intellij.diagnostic.hprof.histogram.HistogramEntry;
import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u00011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J_\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001fH\u0016\u00a2\u0006\u0002\u0010%J(\u0010&\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)H\u0016J(\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\u0018H\u0016J\b\u0010.\u001a\u00020\u0010H\u0016J\u0006\u0010/\u001a\u000200R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/diagnostic/hprof/visitors/HistogramVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "classStore", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "<init>", "(Lcom/intellij/diagnostic/hprof/classstore/ClassStore;)V", "completed", "", "instanceCount", "", "classToHistogramEntryInternal", "Ljava/util/HashMap;", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "Lcom/intellij/diagnostic/hprof/visitors/HistogramVisitor$InternalHistogramEntry;", "Lkotlin/collections/HashMap;", "preVisit", "", "visitPrimitiveArrayDump", "arrayObjectId", "stackTraceSerialNumber", "numberOfElements", "elementType", "Lcom/intellij/diagnostic/hprof/parser/Type;", "primitiveArrayData", "Ljava/nio/ByteBuffer;", "visitClassDump", "classId", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;)V", "visitObjectArrayDump", "arrayClassObjectId", "objects", "", "visitInstanceDump", "objectId", "classObjectId", "bytes", "postVisit", "createHistogram", "Lcom/intellij/diagnostic/hprof/histogram/Histogram;", "InternalHistogramEntry", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nHistogramVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistogramVisitor.kt\ncom/intellij/diagnostic/hprof/visitors/HistogramVisitor\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n221#2,2:108\n1033#3,2:110\n*S KotlinDebug\n*F\n+ 1 HistogramVisitor.kt\ncom/intellij/diagnostic/hprof/visitors/HistogramVisitor\n*L\n86#1:108,2\n89#1:110,2\n*E\n"})
public final class HistogramVisitor
extends HProfVisitor {
    @NotNull
    private final ClassStore classStore;
    private boolean completed;
    private long instanceCount;
    @NotNull
    private HashMap<ClassDefinition, InternalHistogramEntry> classToHistogramEntryInternal;

    public HistogramVisitor(@NotNull ClassStore classStore) {
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
        this.classStore = classStore;
        this.classToHistogramEntryInternal = new HashMap();
    }

    @Override
    public void preVisit() {
        boolean bl;
        boolean bl2 = bl = !this.completed;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.disableAll();
        this.enable(HeapDumpRecordType.InstanceDump);
        this.enable(HeapDumpRecordType.ObjectArrayDump);
        this.enable(HeapDumpRecordType.PrimitiveArrayDump);
        this.enable(HeapDumpRecordType.ClassDump);
    }

    @Override
    public void visitPrimitiveArrayDump(long arrayObjectId, long stackTraceSerialNumber, long numberOfElements, @NotNull Type elementType, @NotNull ByteBuffer primitiveArrayData) {
        Intrinsics.checkNotNullParameter((Object)((Object)elementType), (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)primitiveArrayData, (String)"primitiveArrayData");
        long l = this.instanceCount;
        this.instanceCount = l + 1L;
        ClassDefinition classDefinition = this.classStore.getClassForPrimitiveArray(elementType);
        Intrinsics.checkNotNull((Object)classDefinition);
        ClassDefinition classDefinition2 = classDefinition;
        this.classToHistogramEntryInternal.computeIfAbsent(classDefinition2, arg_0 -> HistogramVisitor.visitPrimitiveArrayDump$lambda$1(arg_0 -> HistogramVisitor.visitPrimitiveArrayDump$lambda$0(classDefinition2, arg_0), arg_0)).addInstance(numberOfElements * (long)elementType.getSize() + (long)12);
    }

    @Override
    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        long l = this.instanceCount;
        this.instanceCount = l + 1L;
        ClassDefinition classDefinition = this.classStore.getClassClass();
        this.classToHistogramEntryInternal.computeIfAbsent(classDefinition, arg_0 -> HistogramVisitor.visitClassDump$lambda$1(arg_0 -> HistogramVisitor.visitClassDump$lambda$0(classDefinition, arg_0), arg_0)).addInstance((long)classDefinition.getInstanceSize() + (long)8);
    }

    @Override
    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        long l = this.instanceCount;
        this.instanceCount = l + 1L;
        ClassDefinition classDefinition = this.classStore.get(arrayClassObjectId);
        this.classToHistogramEntryInternal.computeIfAbsent(classDefinition, arg_0 -> HistogramVisitor.visitObjectArrayDump$lambda$1(arg_0 -> HistogramVisitor.visitObjectArrayDump$lambda$0(classDefinition, arg_0), arg_0)).addInstance((long)objects.length * (long)this.getVisitorContext().getIdSize() + (long)12);
    }

    @Override
    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        long l = this.instanceCount;
        this.instanceCount = l + 1L;
        ClassDefinition classDefinition = this.classStore.get(classObjectId);
        this.classToHistogramEntryInternal.computeIfAbsent(classDefinition, arg_0 -> HistogramVisitor.visitInstanceDump$lambda$1(arg_0 -> HistogramVisitor.visitInstanceDump$lambda$0(classDefinition, arg_0), arg_0)).addInstance((long)classDefinition.getInstanceSize() + (long)8);
    }

    @Override
    public void postVisit() {
        this.completed = true;
    }

    @NotNull
    public final Histogram createHistogram() {
        boolean bl = this.completed;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ArrayList<HistogramEntry> result2 = new ArrayList<HistogramEntry>(this.classToHistogramEntryInternal.size());
        Map $this$forEach$iv = this.classToHistogramEntryInternal;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl2 = false;
            InternalHistogramEntry internalEntry = (InternalHistogramEntry)entry.getValue();
            result2.add(internalEntry.asHistogramEntry());
        }
        List $this$sortByDescending$iv = result2;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    HistogramEntry e = (HistogramEntry)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(e.getTotalInstances());
                    e = (HistogramEntry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(e.getTotalInstances()));
                }
            });
        }
        return new Histogram((List<HistogramEntry>)result2, this.instanceCount);
    }

    private static final InternalHistogramEntry visitPrimitiveArrayDump$lambda$0(ClassDefinition $classDefinition, ClassDefinition it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new InternalHistogramEntry($classDefinition);
    }

    private static final InternalHistogramEntry visitPrimitiveArrayDump$lambda$1(Function1 $tmp0, Object p0) {
        return (InternalHistogramEntry)$tmp0.invoke(p0);
    }

    private static final InternalHistogramEntry visitClassDump$lambda$0(ClassDefinition $classDefinition, ClassDefinition it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new InternalHistogramEntry($classDefinition);
    }

    private static final InternalHistogramEntry visitClassDump$lambda$1(Function1 $tmp0, Object p0) {
        return (InternalHistogramEntry)$tmp0.invoke(p0);
    }

    private static final InternalHistogramEntry visitObjectArrayDump$lambda$0(ClassDefinition $classDefinition, ClassDefinition it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new InternalHistogramEntry($classDefinition);
    }

    private static final InternalHistogramEntry visitObjectArrayDump$lambda$1(Function1 $tmp0, Object p0) {
        return (InternalHistogramEntry)$tmp0.invoke(p0);
    }

    private static final InternalHistogramEntry visitInstanceDump$lambda$0(ClassDefinition $classDefinition, ClassDefinition it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new InternalHistogramEntry($classDefinition);
    }

    private static final InternalHistogramEntry visitInstanceDump$lambda$1(Function1 $tmp0, Object p0) {
        return (InternalHistogramEntry)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/diagnostic/hprof/visitors/HistogramVisitor$InternalHistogramEntry;", "", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "<init>", "(Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;)V", "totalInstances", "", "totalBytes", "addInstance", "", "sizeInBytes", "asHistogramEntry", "Lcom/intellij/diagnostic/hprof/histogram/HistogramEntry;", "intellij.platform.ide.impl"})
    public static final class InternalHistogramEntry {
        @NotNull
        private final ClassDefinition classDefinition;
        private long totalInstances;
        private long totalBytes;

        public InternalHistogramEntry(@NotNull ClassDefinition classDefinition) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            this.classDefinition = classDefinition;
        }

        public final void addInstance(long sizeInBytes) {
            long l = this.totalInstances;
            this.totalInstances = l + 1L;
            this.totalBytes += sizeInBytes;
        }

        @NotNull
        public final HistogramEntry asHistogramEntry() {
            return new HistogramEntry(this.classDefinition, this.totalInstances, this.totalBytes);
        }
    }
}

