/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBaseKt;
import com.intellij.execution.impl.AsyncFilterRunner;
import com.intellij.execution.impl.EditorHyperlinkEffectSupplier;
import com.intellij.execution.impl.EditorHyperlinkEffectSupport;
import com.intellij.execution.impl.EditorHyperlinkListener;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCoreUtil;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartList;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class EditorHyperlinkSupport {
    private static final Logger LOG = Logger.getInstance(EditorHyperlinkSupport.class);
    private static final Key<HyperlinkInfoTextAttributes> HYPERLINK = Key.create((String)"EDITOR_HYPERLINK_SUPPORT_HYPERLINK");
    private static final Key<Unit> HIGHLIGHTING = Key.create((String)"EDITOR_HYPERLINK_SUPPORT_HIGHLIGHTING");
    private static final Key<Unit> INLAY = Key.create((String)"EDITOR_HYPERLINK_SUPPORT_INLAY");
    private static final Key<EditorHyperlinkSupport> EDITOR_HYPERLINK_SUPPORT_KEY = Key.create((String)"EDITOR_HYPERLINK_SUPPORT_KEY");
    private static final Expirable ETERNAL_TOKEN = () -> false;
    private final EditorEx myEditor;
    @NotNull
    private final Project myProject;
    private final EditorHyperlinkEffectSupport myLinkEffectSupport;
    private final AsyncFilterRunner myFilterRunner;
    private final CopyOnWriteArrayList<EditorHyperlinkListener> myHyperlinkListeners;

    public EditorHyperlinkSupport(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(1);
        }
        this(editor2, project2, false);
    }

    private EditorHyperlinkSupport(@NotNull Editor editor2, @NotNull Project project2, boolean trackChangesManually) {
        if (editor2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(3);
        }
        this.myHyperlinkListeners = new CopyOnWriteArrayList();
        this.myEditor = (EditorEx)editor2;
        this.myProject = project2;
        this.myLinkEffectSupport = new EditorHyperlinkEffectSupport(this.myEditor, new MyEffectSupplier());
        this.myFilterRunner = new AsyncFilterRunner(this, this.myEditor, trackChangesManually);
        editor2.addEditorMouseListener(new EditorMouseListener(){
            private MouseEvent myInitialMouseEvent;

            public void mousePressed(@NotNull EditorMouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.myInitialMouseEvent = e.getMouseEvent();
            }

            public void mouseReleased(@NotNull EditorMouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                MouseEvent initialMouseEvent = this.myInitialMouseEvent;
                this.myInitialMouseEvent = null;
                MouseEvent mouseEvent = e.getMouseEvent();
                if (mouseEvent.getButton() == 1 && !mouseEvent.isPopupTrigger()) {
                    if (!(initialMouseEvent == null || mouseEvent.getComponent() == initialMouseEvent.getComponent() && mouseEvent.getPoint().equals(initialMouseEvent.getPoint()))) {
                        return;
                    }
                    Runnable runnable2 = EditorHyperlinkSupport.this.getLinkNavigationRunnable(e.getLogicalPosition());
                    if (runnable2 != null) {
                        try (AccessToken ignore = SlowOperations.startSection((String)"action.perform");){
                            runnable2.run();
                        }
                        e.consume();
                    }
                }
            }

            public void mouseExited(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                EditorHyperlinkSupport.this.myLinkEffectSupport.linkHovered(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/impl/EditorHyperlinkSupport$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mousePressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseReleased";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseExited";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        editor2.addEditorMouseMotionListener(new EditorMouseMotionListener(){

            public void mouseMoved(@NotNull EditorMouseEvent e) {
                RangeHighlighter range;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                HyperlinkInfo info = (range = EditorHyperlinkSupport.this.findLinkAt(e)) == null ? null : EditorHyperlinkSupport.getHyperlinkInfo(range);
                EditorHyperlinkSupport.this.myEditor.setCustomCursor(EditorHyperlinkSupport.class, info == null ? null : Cursor.getPredefinedCursor(12));
                EditorHyperlinkSupport.this.myLinkEffectSupport.linkHovered(range);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/impl/EditorHyperlinkSupport$2", "mouseMoved"));
            }
        });
    }

    @Nullable
    private RangeHighlighter findLinkAt(@NotNull EditorMouseEvent e) {
        if (e == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(4);
        }
        if (e.getArea() == EditorMouseEventArea.EDITING_AREA && e.isOverText()) {
            return this.findLinkRangeAt(e.getOffset());
        }
        return null;
    }

    @ApiStatus.Internal
    public void addEditorHyperlinkListener(@NotNull EditorHyperlinkListener listener2) {
        if (listener2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(5);
        }
        this.myHyperlinkListeners.add(listener2);
    }

    @ApiStatus.Internal
    public void removeEditorHyperlinkListener(@NotNull EditorHyperlinkListener listener2) {
        if (listener2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(6);
        }
        this.myHyperlinkListeners.remove(listener2);
    }

    @NotNull
    public static EditorHyperlinkSupport get(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(7);
        }
        return EditorHyperlinkSupport.get(editor2, false);
    }

    @ApiStatus.Internal
    @NotNull
    public static EditorHyperlinkSupport get(@NotNull Editor editor2, boolean trackDocumentChangesManually) {
        EditorHyperlinkSupport instance;
        if (editor2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(8);
        }
        if ((instance = (EditorHyperlinkSupport)editor2.getUserData(EDITOR_HYPERLINK_SUPPORT_KEY)) == null) {
            Project project2 = editor2.getProject();
            assert (project2 != null);
            instance = new EditorHyperlinkSupport(editor2, project2, trackDocumentChangesManually);
            editor2.putUserData(EDITOR_HYPERLINK_SUPPORT_KEY, (Object)instance);
        }
        EditorHyperlinkSupport editorHyperlinkSupport = instance;
        if (editorHyperlinkSupport == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(9);
        }
        return editorHyperlinkSupport;
    }

    public void clearHyperlinks() {
        for (RangeHighlighter highlighter : EditorHyperlinkSupport.getHyperlinks(0, this.myEditor.getDocument().getTextLength(), this.myEditor)) {
            this.removeHyperlink(highlighter);
        }
    }

    @ApiStatus.Internal
    public void clearHyperlinks(int startOffset, int endOffset) {
        for (RangeHighlighter rangeHighlighter : EditorHyperlinkSupport.getRangeHighlighters(startOffset, endOffset, true, true, this.myEditor)) {
            this.myEditor.getMarkupModel().removeHighlighter(rangeHighlighter);
        }
        for (Inlay inlay : this.getInlays(startOffset, endOffset)) {
            Disposer.dispose((Disposable)inlay);
        }
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public List<Inlay<?>> getInlays(int startOffset, int endOffset) {
        return this.myEditor.getInlayModel().getInlineElementsInRange(startOffset, endOffset).stream().filter(arg_0 -> INLAY.isIn(arg_0)).toList();
    }

    @ApiStatus.Internal
    @TestOnly
    public List<Inlay<?>> collectAllInlays() {
        return this.getInlays(0, this.myEditor.getDocument().getTextLength());
    }

    @TestOnly
    @ApiStatus.Internal
    public void waitForPendingFilters(long timeoutMs) {
        this.myFilterRunner.waitForPendingFilters(timeoutMs);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Map<RangeHighlighter, HyperlinkInfo> getHyperlinks() {
        LinkedHashMap<RangeHighlighter, HyperlinkInfo> result2 = new LinkedHashMap<RangeHighlighter, HyperlinkInfo>();
        for (RangeHighlighter highlighter : EditorHyperlinkSupport.getHyperlinks(0, this.myEditor.getDocument().getTextLength(), this.myEditor)) {
            HyperlinkInfo info = EditorHyperlinkSupport.getHyperlinkInfo(highlighter);
            if (info == null) continue;
            result2.put(highlighter, info);
        }
        LinkedHashMap<RangeHighlighter, HyperlinkInfo> linkedHashMap = result2;
        if (linkedHashMap == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(10);
        }
        return linkedHashMap;
    }

    @Nullable
    public Runnable getLinkNavigationRunnable(@NotNull LogicalPosition logical) {
        if (logical == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(11);
        }
        if (EditorCoreUtil.inVirtualSpace((Editor)this.myEditor, (LogicalPosition)logical)) {
            return null;
        }
        int positionOffset = this.myEditor.logicalPositionToOffset(logical);
        RangeHighlighter range = this.findLinkRangeAt(positionOffset);
        if (range != null) {
            if (range.getEndOffset() == positionOffset) {
                return null;
            }
            HyperlinkInfo hyperlinkInfo = EditorHyperlinkSupport.getHyperlinkInfo(range);
            if (hyperlinkInfo != null) {
                return () -> {
                    HyperlinkInfoBaseKt.navigate((HyperlinkInfo)hyperlinkInfo, (Project)this.myProject, (Editor)this.myEditor, (LogicalPosition)logical);
                    this.linkFollowed(range);
                    this.fireListeners(hyperlinkInfo);
                };
            }
        }
        return null;
    }

    private void fireListeners(@NotNull HyperlinkInfo info) {
        if (info == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(12);
        }
        for (EditorHyperlinkListener listener2 : this.myHyperlinkListeners) {
            try {
                listener2.hyperlinkActivated(info);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("The listener " + String.valueOf(listener2) + " threw an exception", (Throwable)e);
            }
        }
    }

    @Nullable
    public static HyperlinkInfo getHyperlinkInfo(@NotNull RangeHighlighter range) {
        HyperlinkInfoTextAttributes attributes;
        if (range == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(13);
        }
        return (attributes = (HyperlinkInfoTextAttributes)range.getUserData(HYPERLINK)) != null ? attributes.hyperlinkInfo() : null;
    }

    @Nullable
    private RangeHighlighter findLinkRangeAt(int offset) {
        Ref minHighlighter = new Ref();
        EditorHyperlinkSupport.processHyperlinksAndHighlightings(offset, offset, this.myEditor, true, false, (Processor<? super RangeHighlighter>)((Processor)highlighter -> {
            if (minHighlighter.isNull()) {
                minHighlighter.set(highlighter);
            } else {
                TextRange minRange = ((RangeHighlighter)minHighlighter.get()).getTextRange();
                TextRange newRange = highlighter.getTextRange();
                if (newRange.getLength() < minRange.getLength() || newRange.getLength() == minRange.getLength() && newRange.getStartOffset() < minRange.getStartOffset()) {
                    minHighlighter.set(highlighter);
                }
            }
            return true;
        }));
        return (RangeHighlighter)minHighlighter.get();
    }

    @Nullable
    public HyperlinkInfo getHyperlinkAt(int offset) {
        RangeHighlighter range = this.findLinkRangeAt(offset);
        return range == null ? null : EditorHyperlinkSupport.getHyperlinkInfo(range);
    }

    @NotNull
    public List<RangeHighlighter> findAllHyperlinksOnLine(int line) {
        int lineStart = this.myEditor.getDocument().getLineStartOffset(line);
        int lineEnd = this.myEditor.getDocument().getLineEndOffset(line);
        return EditorHyperlinkSupport.getHyperlinks(lineStart, lineEnd, this.myEditor);
    }

    @NotNull
    private static List<RangeHighlighter> getHyperlinks(int startOffset, int endOffset, @NotNull Editor editor2) {
        if (editor2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(14);
        }
        return EditorHyperlinkSupport.getRangeHighlighters(startOffset, endOffset, true, false, editor2);
    }

    @ApiStatus.Internal
    @TestOnly
    @NotNull
    public List<RangeHighlighter> getAllHyperlinks(int startOffset, int endOffset) {
        return EditorHyperlinkSupport.getHyperlinks(startOffset, endOffset, this.myEditor);
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public static List<RangeHighlighter> getRangeHighlighters(int startOffset, int endOffset, boolean hyperlinks, boolean highlightings, @NotNull Editor editor2) {
        if (editor2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(15);
        }
        ArrayList<RangeHighlighter> result2 = new ArrayList<RangeHighlighter>();
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor(result2);
        EditorHyperlinkSupport.processHyperlinksAndHighlightings(startOffset, endOffset, editor2, hyperlinks, highlightings, (Processor<? super RangeHighlighter>)processor2);
        ArrayList<RangeHighlighter> arrayList = result2;
        if (arrayList == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private static void processHyperlinksAndHighlightings(int startOffset, int endOffset, @NotNull Editor editor2, boolean hyperlinks, boolean highlightings, @NotNull Processor<? super RangeHighlighter> processor2) {
        if (editor2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(17);
        }
        if (processor2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(18);
        }
        MarkupModelEx markupModel = (MarkupModelEx)editor2.getMarkupModel();
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor)new FilteringProcessor(highlighter -> highlighter.isValid() && (hyperlinks && EditorHyperlinkSupport.getHyperlinkInfo((RangeHighlighter)highlighter) != null || highlightings && HIGHLIGHTING.isIn((UserDataHolder)highlighter)), processor2));
    }

    public void removeHyperlink(@NotNull RangeHighlighter hyperlink) {
        if (hyperlink == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(19);
        }
        this.myEditor.getMarkupModel().removeHighlighter(hyperlink);
    }

    @Nullable
    public HyperlinkInfo getHyperlinkInfoByLineAndCol(int line, int col) {
        return this.getHyperlinkAt(this.myEditor.logicalPositionToOffset(new LogicalPosition(line, col)));
    }

    public void createHyperlink(@NotNull RangeHighlighter highlighter, @NotNull HyperlinkInfo hyperlinkInfo) {
        if (highlighter == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(20);
        }
        if (hyperlinkInfo == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(21);
        }
        EditorHyperlinkSupport.associateHyperlink(highlighter, hyperlinkInfo, null, null, true);
    }

    @NotNull
    public RangeHighlighter createHyperlink(int highlightStartOffset, int highlightEndOffset, @Nullable TextAttributes highlightAttributes, @NotNull HyperlinkInfo hyperlinkInfo) {
        if (hyperlinkInfo == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(22);
        }
        return this.createHyperlink(highlightStartOffset, highlightEndOffset, highlightAttributes, hyperlinkInfo, null, null, 5900);
    }

    @NotNull
    private RangeHighlighter createHyperlink(int highlightStartOffset, int highlightEndOffset, @Nullable TextAttributes highlightAttributes, @NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes, @Nullable TextAttributes hoveredHyperlinkAttributes, int layer) {
        if (hyperlinkInfo == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(23);
        }
        RangeHighlighterEx rangeHighlighterEx = this.myEditor.getMarkupModel().addRangeHighlighterAndChangeAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES, highlightStartOffset, highlightEndOffset, layer, HighlighterTargetArea.EXACT_RANGE, false, ex -> {
            if (highlightAttributes != null) {
                ex.setTextAttributes(highlightAttributes);
            }
            EditorHyperlinkSupport.associateHyperlink((RangeHighlighter)ex, hyperlinkInfo, followedHyperlinkAttributes, hoveredHyperlinkAttributes, false);
        });
        if (rangeHighlighterEx == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(24);
        }
        return rangeHighlighterEx;
    }

    private static void associateHyperlink(@NotNull RangeHighlighter highlighter, @NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes, @Nullable TextAttributes hoveredHyperlinkAttributes, boolean fireChanged) {
        if (highlighter == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(25);
        }
        if (hyperlinkInfo == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(26);
        }
        HyperlinkInfoTextAttributes attributes = new HyperlinkInfoTextAttributes(hyperlinkInfo, followedHyperlinkAttributes, hoveredHyperlinkAttributes);
        highlighter.putUserData(HYPERLINK, (Object)attributes);
        if (fireChanged) {
            ((RangeHighlighterEx)highlighter).fireChanged(false, false, false);
        }
    }

    @Nullable
    public HyperlinkInfo getHyperlinkInfoByPoint(Point p) {
        LogicalPosition pos = this.myEditor.xyToLogicalPosition(new Point(p.x, p.y));
        if (EditorCoreUtil.inVirtualSpace((Editor)this.myEditor, (LogicalPosition)pos)) {
            return null;
        }
        return this.getHyperlinkInfoByLineAndCol(pos.line, pos.column);
    }

    @Nullable
    public HyperlinkInfo getHyperlinkInfoByEvent(@NotNull EditorMouseEvent event) {
        if (event == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(27);
        }
        return event.isOverText() ? this.getHyperlinkAt(event.getOffset()) : null;
    }

    public void highlightHyperlinksLater(@NotNull Filter customFilter, int startLine, int endLine, @NotNull Expirable expirableToken) {
        if (customFilter == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(28);
        }
        if (expirableToken == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(29);
        }
        this.myFilterRunner.highlightHyperlinks(this.myProject, customFilter, Math.max(0, startLine), endLine, expirableToken);
    }

    @Deprecated
    public void highlightHyperlinks(@NotNull Filter customFilter, int startLine, int endLine) {
        if (customFilter == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(30);
        }
        this.myFilterRunner.highlightHyperlinks(this.myProject, customFilter, Math.max(0, startLine), endLine, ETERNAL_TOKEN);
    }

    @ApiStatus.Internal
    public void highlightHyperlinks(@NotNull Filter.Result result2) {
        if (result2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(31);
        }
        this.highlightHyperlinks(result2, item -> TextRange.create((int)item.getHighlightStartOffset(), (int)item.getHighlightEndOffset()));
    }

    @ApiStatus.Internal
    public void highlightHyperlinks(@NotNull Filter.Result result2, @NotNull Function<// Could not load outer class - annotation placement on inner may be incorrect
    Filter.ResultItem, @Nullable TextRange> highlightingRangeAccessor) {
        if (result2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(32);
        }
        if (highlightingRangeAccessor == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(33);
        }
        int length = this.myEditor.getDocument().getTextLength();
        SmartList inlayProviderPairs = new SmartList();
        for (Filter.ResultItem resultItem : result2.getResultItems()) {
            TextRange textRange = highlightingRangeAccessor.apply(resultItem);
            if (textRange == null) continue;
            int start2 = textRange.getStartOffset();
            int end = textRange.getEndOffset();
            if (start2 < 0 || end < start2 || end > length) continue;
            TextAttributes attributes = resultItem.getHighlightAttributes();
            if (resultItem instanceof InlayProvider) {
                InlayProvider inlayProvider = (InlayProvider)resultItem;
                inlayProviderPairs.add(Pair.create((Object)inlayProvider, (Object)end));
                continue;
            }
            if (resultItem.getHyperlinkInfo() != null) {
                this.createHyperlink(start2, end, attributes, resultItem.getHyperlinkInfo(), resultItem.getFollowedHyperlinkAttributes(), resultItem.getHoveredHyperlinkAttributes(), resultItem.getHighlighterLayer());
                continue;
            }
            if (attributes == null) continue;
            this.addHighlighter(start2, end, attributes, resultItem.getHighlighterLayer());
        }
        if (!inlayProviderPairs.isEmpty()) {
            this.myEditor.getInlayModel().execute(inlayProviderPairs.size() > 100, () -> this.lambda$highlightHyperlinks$6((List)inlayProviderPairs));
        }
    }

    public void addHighlighter(int highlightStartOffset, int highlightEndOffset, TextAttributes highlightAttributes) {
        this.addHighlighter(highlightStartOffset, highlightEndOffset, highlightAttributes, 5800);
    }

    public void addHighlighter(int highlightStartOffset, int highlightEndOffset, TextAttributes highlightAttributes, int highlighterLayer) {
        RangeHighlighter h = this.myEditor.getMarkupModel().addRangeHighlighter(highlightStartOffset, highlightEndOffset, highlighterLayer, highlightAttributes, HighlighterTargetArea.EXACT_RANGE);
        HIGHLIGHTING.set((UserDataHolder)h, (Object)Unit.INSTANCE);
    }

    private void addInlay(int offset, @NotNull InlayProvider inlayProvider) {
        Inlay<?> inlay;
        if (inlayProvider == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(34);
        }
        if ((inlay = inlayProvider.createInlay(this.myEditor, offset)) != null) {
            INLAY.set(inlay, (Object)Unit.INSTANCE);
        }
    }

    @Deprecated
    @Nullable
    public static OccurenceNavigator.OccurenceInfo getNextOccurrence(@NotNull Editor editor2, int delta, @NotNull Consumer<? super RangeHighlighter> action2) {
        if (editor2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(35);
        }
        if (action2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(36);
        }
        return EditorHyperlinkSupport.get(editor2).getNextOccurrence(delta, (java.util.function.Consumer<? super RangeHighlighter>)action2);
    }

    @ApiStatus.Internal
    @Nullable
    public OccurenceNavigator.OccurenceInfo getNextOccurrence(int delta, final @NotNull java.util.function.Consumer<? super RangeHighlighter> action2) {
        List<RangeHighlighter> ranges;
        if (action2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(37);
        }
        if ((ranges = EditorHyperlinkSupport.getHyperlinks(0, this.myEditor.getDocument().getTextLength(), this.myEditor)).isEmpty()) {
            return null;
        }
        int i2 = ranges.indexOf(this.myLinkEffectSupport.getFollowedLink());
        if (i2 == -1) {
            i2 = 0;
        }
        int newIndex = i2;
        while (newIndex < ranges.size()) {
            newIndex = (newIndex + delta + ranges.size()) % ranges.size();
            final RangeHighlighter next = ranges.get(newIndex);
            HyperlinkInfo info = EditorHyperlinkSupport.getHyperlinkInfo(next);
            assert (info != null);
            if (info.includeInOccurenceNavigation()) {
                boolean inCollapsedRegion;
                boolean bl = inCollapsedRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(next.getStartOffset()) != null;
                if (!inCollapsedRegion) {
                    return new OccurenceNavigator.OccurenceInfo((Navigatable)new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            action2.accept(next);
                            EditorHyperlinkSupport.this.linkFollowed(next);
                        }
                    }, newIndex + 1, ranges.size());
                }
            }
            if (newIndex != i2) continue;
            break;
        }
        return null;
    }

    private void linkFollowed(@NotNull RangeHighlighter link) {
        if (link == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(38);
        }
        if (link.isValid()) {
            this.myLinkEffectSupport.linkFollowed(link);
        }
    }

    @NotNull
    public static String getLineText(@NotNull Document document2, int lineNumber, boolean includeEol) {
        if (document2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(39);
        }
        String string = EditorHyperlinkSupport.getLineSequence(document2, lineNumber, includeEol).toString();
        if (string == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    private static CharSequence getLineSequence(@NotNull Document document2, int lineNumber, boolean includeEol) {
        if (document2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(41);
        }
        int endOffset = document2.getLineEndOffset(lineNumber);
        if (includeEol && endOffset < document2.getTextLength()) {
            ++endOffset;
        }
        CharSequence charSequence = document2.getImmutableCharSequence().subSequence(document2.getLineStartOffset(lineNumber), endOffset);
        if (charSequence == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(42);
        }
        return charSequence;
    }

    private /* synthetic */ void lambda$highlightHyperlinks$6(List inlayProviderPairs) {
        for (Pair inlayProviderPair : inlayProviderPairs) {
            this.addInlay((Integer)inlayProviderPair.second, (InlayProvider)inlayProviderPair.first);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 16, 24, 40, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 24: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/EditorHyperlinkSupport";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logical";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlink";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkInfo";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customFilter";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expirableToken";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingRangeAccessor";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlayProvider";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/EditorHyperlinkSupport";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHyperlinks";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeHighlighters";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createHyperlink";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineText";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findLinkAt";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addEditorHyperlinkListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorHyperlinkListener";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 24: 
            case 40: 
            case 42: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLinkNavigationRunnable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fireListeners";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHyperlinkInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getHyperlinks";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRangeHighlighters";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processHyperlinksAndHighlightings";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeHyperlink";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createHyperlink";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "associateHyperlink";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getHyperlinkInfoByEvent";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "highlightHyperlinksLater";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "highlightHyperlinks";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addInlay";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getNextOccurrence";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "linkFollowed";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getLineText";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getLineSequence";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 16, 24, 40, 42 -> new IllegalStateException(string);
        };
    }

    private static class MyEffectSupplier
    implements EditorHyperlinkEffectSupplier {
        private MyEffectSupplier() {
        }

        @Override
        @Nullable
        public TextAttributes getFollowedHyperlinkAttributes(@NotNull RangeHighlighterEx highlighter) {
            HyperlinkInfoTextAttributes attrs;
            if (highlighter == null) {
                MyEffectSupplier.$$$reportNull$$$0(0);
            }
            return (attrs = (HyperlinkInfoTextAttributes)highlighter.getUserData(HYPERLINK)) == null ? null : attrs.followedHyperlinkAttributes();
        }

        @Override
        @Nullable
        public TextAttributes getHoveredHyperlinkAttributes(@NotNull RangeHighlighterEx highlighter) {
            HyperlinkInfoTextAttributes attrs;
            if (highlighter == null) {
                MyEffectSupplier.$$$reportNull$$$0(1);
            }
            return (attrs = (HyperlinkInfoTextAttributes)highlighter.getUserData(HYPERLINK)) == null ? null : attrs.hoveredHyperlinkAttributes();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "highlighter";
            objectArray2[1] = "com/intellij/execution/impl/EditorHyperlinkSupport$MyEffectSupplier";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFollowedHyperlinkAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHoveredHyperlinkAttributes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record HyperlinkInfoTextAttributes(@NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes, @Nullable TextAttributes hoveredHyperlinkAttributes) {
        @NotNull
        private final HyperlinkInfo hyperlinkInfo;

        private HyperlinkInfoTextAttributes(@NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes, @Nullable TextAttributes hoveredHyperlinkAttributes) {
            if (hyperlinkInfo == null) {
                HyperlinkInfoTextAttributes.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public HyperlinkInfo hyperlinkInfo() {
            HyperlinkInfo hyperlinkInfo = this.hyperlinkInfo;
            if (hyperlinkInfo == null) {
                HyperlinkInfoTextAttributes.$$$reportNull$$$0(1);
            }
            return hyperlinkInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hyperlinkInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/EditorHyperlinkSupport$HyperlinkInfoTextAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/EditorHyperlinkSupport$HyperlinkInfoTextAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "hyperlinkInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

