/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.EventWatcher;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.ActiveWindowsWatcher;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.ClientIdAwareEvent;
import com.intellij.ide.ComponentEventWithClientId;
import com.intellij.ide.EditingCanceller;
import com.intellij.ide.HoverService;
import com.intellij.ide.IdeEventQueueKt;
import com.intellij.ide.IdeKeyboardFocusManagerKt;
import com.intellij.ide.IdePopupManager;
import com.intellij.ide.IdleTracker;
import com.intellij.ide.Logs;
import com.intellij.ide.MnemonicUsageCollector;
import com.intellij.ide.NakedRunnable;
import com.intellij.ide.SequencedEventNestedFieldHolder;
import com.intellij.ide.WindowsAltSuppressor;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDManagerImpl;
import com.intellij.ide.ui.MaximizeDialogKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ThreadingRuntimeFlagsKt;
import com.intellij.openapi.application.ThreadingSupport;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.InternalThreading;
import com.intellij.openapi.application.impl.InvocationUtil;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.IdeMouseEventDispatcher;
import com.intellij.openapi.keymap.impl.KeyState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.platform.ide.bootstrap.StartupErrorReporter;
import com.intellij.platform.locking.impl.IntelliJLockingUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Propagation;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.JBR;
import com.jetbrains.TextInput;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import sun.awt.AppContext;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 \u00a4\u00012\u00020\u0001:\n\u00a4\u0001\u00a5\u0001\u00a6\u0001\u00a7\u0001\u00a8\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010S\u001a\u00020P2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020P0OH\u0001\u00a2\u0006\u0002\bTJ\u0018\u0010U\u001a\u00020P2\u0006\u0010V\u001a\u00020\b2\u0006\u0010W\u001a\u00020(H\u0007J\u0010\u0010X\u001a\u00020P2\u0006\u0010V\u001a\u00020\bH\u0007J\u0016\u0010Y\u001a\u00020P2\u0006\u0010V\u001a\u00020\b2\u0006\u0010Z\u001a\u00020[J\u0016\u0010Y\u001a\u00020P2\u0006\u0010V\u001a\u00020\b2\u0006\u0010\\\u001a\u00020]J\u001a\u0010^\u001a\u00020P2\u0006\u0010_\u001a\u00020:2\b\u0010`\u001a\u0004\u0018\u00010[H\u0007J\u0018\u0010^\u001a\u00020P2\u0006\u0010_\u001a\u00020<2\b\u0010`\u001a\u0004\u0018\u00010[J\u0018\u0010^\u001a\u00020P2\u0006\u0010_\u001a\u00020:2\u0006\u0010a\u001a\u00020]H\u0007J\u0016\u0010^\u001a\u00020P2\u0006\u0010_\u001a\u00020<2\u0006\u0010a\u001a\u00020]J\u0010\u0010b\u001a\u00020P2\u0006\u0010_\u001a\u00020:H\u0007J\u000e\u0010b\u001a\u00020P2\u0006\u0010_\u001a\u00020<J\u000e\u0010c\u001a\u00020\"2\u0006\u0010_\u001a\u00020:J\u0018\u0010d\u001a\u00020P2\u0006\u0010_\u001a\u00020:2\b\u0010`\u001a\u0004\u0018\u00010[J\u0016\u0010d\u001a\u00020P2\u0006\u0010_\u001a\u00020:2\u0006\u0010\\\u001a\u00020]J\u000e\u0010e\u001a\u00020P2\u0006\u0010_\u001a\u00020:J\u0018\u0010f\u001a\u00020P2\u0006\u0010_\u001a\u00020:2\b\u0010`\u001a\u0004\u0018\u00010[J\u0010\u0010g\u001a\u00020P2\u0006\u0010h\u001a\u000203H\u0016J\u001e\u0010i\u001a\u00020P2\u0006\u0010K\u001a\u0002032\f\u0010j\u001a\b\u0012\u0004\u0012\u00020:0\u000bH\u0002J\u0010\u0010k\u001a\u00020P2\u0006\u0010l\u001a\u00020\u001dH\u0002J\b\u0010m\u001a\u000203H\u0016J\u0010\u0010n\u001a\u00020P2\u0006\u0010o\u001a\u00020pH\u0002J\u0012\u0010q\u001a\u0004\u0018\u0001032\u0006\u0010h\u001a\u000203H\u0002J\u0010\u0010r\u001a\u00020P2\u0006\u0010h\u001a\u000203H\u0002J\u0010\u0010s\u001a\u00020\"2\u0006\u0010h\u001a\u000203H\u0002J\u0010\u0010t\u001a\u00020\"2\u0006\u0010h\u001a\u000203H\u0002J\u0010\u0010u\u001a\u00020P2\u0006\u0010h\u001a\u000203H\u0002J\u0010\u0010v\u001a\u00020P2\u0006\u0010h\u001a\u00020wH\u0002J\u0010\u0010x\u001a\u00020P2\u0006\u0010h\u001a\u00020yH\u0002J\u0010\u0010z\u001a\u00020P2\u0006\u0010{\u001a\u00020yH\u0002J\u0010\u0010|\u001a\u00020P2\u0006\u0010{\u001a\u00020yH\u0002J\u0010\u0010}\u001a\u00020\"2\u0006\u0010h\u001a\u000203H\u0002J\u0010\u0010~\u001a\u00020P2\u0006\u0010h\u001a\u000203H\u0007J\b\u0010\u007f\u001a\u00020PH\u0007J/\u0010\u0080\u0001\u001a\u00020P2\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\f\u0010\u0083\u0001\u001a\u0007\u0012\u0002\b\u00030\u0084\u00012\u000e\u0010\u0085\u0001\u001a\t\u0012\u0004\u0012\u0002030\u0086\u0001J\u001d\u0010\u0089\u0001\u001a\u00020P2\u0006\u0010h\u001a\u00020y2\n\b\u0002\u0010\u008a\u0001\u001a\u00030\u008b\u0001H\u0007J\u000f\u0010\u008d\u0001\u001a\u00020PH\u0000\u00a2\u0006\u0003\b\u008e\u0001J\t\u0010\u008f\u0001\u001a\u00020PH\u0002J\u000f\u0010\u0090\u0001\u001a\u00020P2\u0006\u0010V\u001a\u00020\bJ\u000f\u0010\u0093\u0001\u001a\u00020P2\u0006\u0010Z\u001a\u00020[J\u0011\u0010\u0094\u0001\u001a\u00020P2\u0006\u0010K\u001a\u000203H\u0016J\u001a\u0010\u0095\u0001\u001a\u00020\"2\u0006\u0010K\u001a\u0002032\u0007\u0010\u0096\u0001\u001a\u00020\"H\u0007J\u0013\u0010\u0097\u0001\u001a\u0004\u0018\u0001032\u0006\u0010K\u001a\u000203H\u0002J\u0012\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u0006\u0010K\u001a\u000203H\u0002J\t\u0010\u009a\u0001\u001a\u00020PH\u0007J\t\u0010\u009b\u0001\u001a\u00020\"H\u0002J\u0011\u0010\u009c\u0001\u001a\u00020P2\u0006\u0010V\u001a\u00020\bH\u0007J7\u0010\u009d\u0001\u001a\u00020P2&\u0010\u009e\u0001\u001a!\u0012\u0013\u0012\u001103\u00a2\u0006\f\bI\u0012\b\bJ\u0012\u0004\b\b(K\u0012\u0004\u0012\u00020\"0Hj\u0002`L2\u0006\u0010Z\u001a\u00020[J\u0007\u0010\u009f\u0001\u001a\u00020\u001dJ\u0007\u0010\u00a0\u0001\u001a\u00020\u001dJ\u0007\u0010\u00a1\u0001\u001a\u00020\u001dJ\u0007\u0010\u00a2\u0001\u001a\u00020PJ\t\u0010\u00a3\u0001\u001a\u00020PH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u0006\u001a.\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u000b\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR \u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u00020\"8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0010\u0010-\u001a\u00020.8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u00020.8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00104\u001a\u0002032\u0006\u0010\u001c\u001a\u000203@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R:\u00109\u001a.\u0012\f\u0012\n \t*\u0004\u0018\u00010:0: \t*\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010:0:0\u000b\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010;\u001a.\u0012\f\u0012\n \t*\u0004\u0018\u00010<0< \t*\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010<0<0\u000b\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010=\u001a.\u0012\f\u0012\n \t*\u0004\u0018\u00010:0: \t*\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010:0:0\u000b\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010>\u001a.\u0012\f\u0012\n \t*\u0004\u0018\u00010:0: \t*\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010:0:0\u000b\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010?\u001a\u0012\u0012\u0004\u0012\u00020\b0@j\b\u0012\u0004\u0012\u00020\b`AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u00bb\u0001\u0010G\u001a\u00ae\u0001\u0012L\u0012J\u0012\u0013\u0012\u001103\u00a2\u0006\f\bI\u0012\b\bJ\u0012\u0004\b\b(K\u0012\u0004\u0012\u00020\" \t*%\u0012\u0013\u0012\u001103\u00a2\u0006\f\bI\u0012\b\bJ\u0012\u0004\b\b(K\u0012\u0004\u0012\u00020\"\u0018\u00010Hj\u0004\u0018\u0001`L0Hj\u0002`L \t*U\u0012L\u0012J\u0012\u0013\u0012\u001103\u00a2\u0006\f\bI\u0012\b\bJ\u0012\u0004\b\b(K\u0012\u0004\u0012\u00020\" \t*%\u0012\u0013\u0012\u001103\u00a2\u0006\f\bI\u0012\b\bJ\u0012\u0004\b\b(K\u0012\u0004\u0012\u00020\"\u0018\u00010Hj\u0004\u0018\u0001`L0Hj\u0002`L0\u000b\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010M\u001a\u00020\"8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010N\u001a\b\u0012\u0004\u0012\u00020P0OX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010Q\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010RR\u0013\u0010\u0087\u0001\u001a\u00020\u001d8F\u00a2\u0006\u0007\u001a\u0005\b\u0088\u0001\u0010 R\u0016\u0010\u008c\u0001\u001a\u00020\"8BX\u0082\u0004\u00a2\u0006\u0007\u001a\u0005\b\u008c\u0001\u0010$R\u0013\u0010\u0091\u0001\u001a\u00020\"8F\u00a2\u0006\u0007\u001a\u0005\b\u0091\u0001\u0010$R\u0013\u0010\u0092\u0001\u001a\u00020\"8F\u00a2\u0006\u0007\u001a\u0005\b\u0092\u0001\u0010$\u00a8\u0006\u00a9\u0001"}, d2={"Lcom/intellij/ide/IdeEventQueue;", "Ljava/awt/EventQueue;", "<init>", "()V", "lock", "", "activityListeners", "", "Ljava/lang/Runnable;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "threadingSupport", "Lcom/intellij/openapi/application/ThreadingSupport;", "getThreadingSupport", "()Lcom/intellij/openapi/application/ThreadingSupport;", "keyEventDispatcher", "Lcom/intellij/openapi/keymap/impl/IdeKeyEventDispatcher;", "getKeyEventDispatcher", "()Lcom/intellij/openapi/keymap/impl/IdeKeyEventDispatcher;", "mouseEventDispatcher", "Lcom/intellij/openapi/keymap/impl/IdeMouseEventDispatcher;", "getMouseEventDispatcher", "()Lcom/intellij/openapi/keymap/impl/IdeMouseEventDispatcher;", "popupManager", "Lcom/intellij/ide/IdePopupManager;", "getPopupManager", "()Lcom/intellij/ide/IdePopupManager;", "value", "", "popupTriggerTime", "getPopupTriggerTime", "()J", "actuallyWrapInputEventsIntoWriteIntentLock", "", "getActuallyWrapInputEventsIntoWriteIntentLock", "()Z", "setActuallyWrapInputEventsIntoWriteIntentLock", "(Z)V", "eventCount", "", "getEventCount", "()I", "setEventCount", "(I)V", "keyboardEventPosted", "Ljava/util/concurrent/atomic/AtomicInteger;", "keyboardEventDispatched", "eventsPosted", "Ljava/util/concurrent/atomic/AtomicLong;", "eventsReturned", "Ljava/awt/AWTEvent;", "trueCurrentEvent", "getTrueCurrentEvent", "()Ljava/awt/AWTEvent;", "lastActiveTime", "lastEventTime", "dispatchers", "Lcom/intellij/ide/IdeEventQueue$EventDispatcher;", "nonLockingDispatchers", "Lcom/intellij/ide/IdeEventQueue$NonLockedEventDispatcher;", "postProcessors", "preProcessors", "ready", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "hoverService", "Lcom/intellij/ide/HoverService;", "keyboardBusy", "winMetaPressed", "inputMethodLock", "postEventListeners", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "event", "Lcom/intellij/ide/PostEventHook;", "isDispatchingOnMainThread", "idleTracker", "Lkotlin/Function0;", "", "testMode", "Ljava/lang/Boolean;", "setIdleTracker", "setIdleTracker$intellij_platform_ide_impl", "addIdleListener", "runnable", "timeoutMillis", "removeIdleListener", "addActivityListener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "addDispatcher", "dispatcher", "parent", "scope", "removeDispatcher", "containsDispatcher", "addPostprocessor", "removePostprocessor", "addPreprocessor", "dispatchEvent", "e", "runCustomProcessors", "processors", "checkForTimeJump", "now", "getNextEvent", "processException", "exception", "", "mapMetaState", "_dispatchEvent", "shouldSkipListeners", "isUserActivityEvent", "processIdleActivityListeners", "dispatchKeyEvent", "Ljava/awt/event/KeyEvent;", "dispatchMouseEvent", "Ljava/awt/event/MouseEvent;", "resetGlobalMouseEventTarget", "me", "redispatchLater", "dispatchByCustomDispatchers", "defaultDispatchEvent", "flushQueue", "pumpEventsForHierarchy", "modalComponent", "Ljava/awt/Component;", "exitCondition", "Ljava/util/concurrent/Future;", "eventConsumer", "Ljava/util/function/Consumer;", "idleTime", "getIdleTime", "blockNextEvents", "blockMode", "Lcom/intellij/ide/IdeEventQueue$BlockMode;", "isReady", "maybeReady", "maybeReady$intellij_platform_ide_impl", "invokeReadyHandlers", "doWhenReady", "isPopupActive", "isInputMethodEnabled", "disableInputMethods", "postEvent", "doPostEvent", "postDirectly", "attachClientIdIfNeeded", "withAttachedClientId", "Lcom/intellij/openapi/application/AccessToken;", "flushDelayedKeyEvents", "isTestMode", "executeInProductionModeEvenThoughWeAreInTests", "addPostEventListener", "listener", "getPostedEventCount", "getReturnedEventCount", "getPostedSystemEventCount", "flushNativeEventQueue", "addTextInputListener", "Companion", "EventDispatcher", "NonLockedEventDispatcher", "WindowsUpMaximizer", "BlockMode", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIdeEventQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeEventQueue.kt\ncom/intellij/ide/IdeEventQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1357:1\n1#2:1358\n58#3:1359\n37#4,2:1360\n60#5,5:1362\n60#5,5:1367\n*S KotlinDebug\n*F\n+ 1 IdeEventQueue.kt\ncom/intellij/ide/IdeEventQueue\n*L\n533#1:1359\n782#1:1360,2\n713#1:1362,5\n744#1:1367,5\n*E\n"})
public final class IdeEventQueue
extends EventQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private final List<Runnable> activityListeners;
    @ApiStatus.Internal
    @NotNull
    private final ThreadingSupport threadingSupport;
    @NotNull
    private final IdeKeyEventDispatcher keyEventDispatcher;
    @NotNull
    private final IdeMouseEventDispatcher mouseEventDispatcher;
    @NotNull
    private final IdePopupManager popupManager;
    private long popupTriggerTime;
    @ApiStatus.Internal
    private volatile boolean actuallyWrapInputEventsIntoWriteIntentLock;
    private int eventCount;
    @VisibleForTesting
    @JvmField
    @NotNull
    public final AtomicInteger keyboardEventPosted;
    @VisibleForTesting
    @JvmField
    @NotNull
    public final AtomicInteger keyboardEventDispatched;
    @NotNull
    private final AtomicLong eventsPosted;
    @NotNull
    private final AtomicLong eventsReturned;
    @NotNull
    private AWTEvent trueCurrentEvent;
    private volatile long lastActiveTime;
    private long lastEventTime;
    @NotNull
    private final List<EventDispatcher> dispatchers;
    @NotNull
    private final List<NonLockedEventDispatcher> nonLockingDispatchers;
    @NotNull
    private final List<EventDispatcher> postProcessors;
    @NotNull
    private final List<EventDispatcher> preProcessors;
    @NotNull
    private final HashSet<Runnable> ready;
    @NotNull
    private final HoverService hoverService;
    private boolean keyboardBusy;
    private boolean winMetaPressed;
    private int inputMethodLock;
    @NotNull
    private final List<Function1<AWTEvent, Boolean>> postEventListeners;
    @ApiStatus.Internal
    @JvmField
    public final boolean isDispatchingOnMainThread;
    @NotNull
    private Function0<Unit> idleTracker;
    @Nullable
    private Boolean testMode;
    @NotNull
    private static final Lazy<IdeEventQueue> _instance$delegate = LazyKt.lazy(IdeEventQueue::_instance_delegate$lambda$0);

    /*
     * WARNING - void declaration
     */
    private IdeEventQueue() {
        void it;
        boolean bl;
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList(...)");
        this.activityListeners = list2;
        this.threadingSupport = IntelliJLockingUtil.getGlobalThreadingSupport();
        this.keyEventDispatcher = new IdeKeyEventDispatcher(this);
        this.mouseEventDispatcher = new IdeMouseEventDispatcher();
        this.popupManager = new IdePopupManager();
        this.popupTriggerTime = -1L;
        this.actuallyWrapInputEventsIntoWriteIntentLock = ThreadingRuntimeFlagsKt.getWrapHighLevelInputEventsInWriteIntentLock();
        this.keyboardEventPosted = new AtomicInteger();
        this.keyboardEventDispatched = new AtomicInteger();
        this.eventsPosted = new AtomicLong();
        this.eventsReturned = new AtomicLong();
        this.trueCurrentEvent = new InvocationEvent((Object)this, EmptyRunnable.getInstance());
        this.lastActiveTime = System.nanoTime();
        this.lastEventTime = System.currentTimeMillis();
        List list3 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"createLockFreeCopyOnWriteList(...)");
        this.dispatchers = list3;
        List list4 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"createLockFreeCopyOnWriteList(...)");
        this.nonLockingDispatchers = list4;
        List list5 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"createLockFreeCopyOnWriteList(...)");
        this.postProcessors = list5;
        List list6 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"createLockFreeCopyOnWriteList(...)");
        this.preProcessors = list6;
        this.ready = new HashSet();
        this.hoverService = new HoverService();
        List list7 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list7, (String)"createLockFreeCopyOnWriteList(...)");
        this.postEventListeners = list7;
        String string = Thread.currentThread().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        boolean bl2 = bl = StringsKt.contains$default((CharSequence)string, (CharSequence)"AppKit", (boolean)false, (int)2, null);
        IdeEventQueue ideEventQueue = this;
        boolean bl3 = false;
        if (it != false) {
            System.setProperty("jb.dispatching.on.main.thread", "true");
        }
        ideEventQueue.isDispatchingOnMainThread = bl;
        this.idleTracker = IdeEventQueue::idleTracker$lambda$0;
        bl = EventQueue.isDispatchThread();
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            Thread thread = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread(...)");
            Thread thread2 = thread;
            throw new AssertionError(thread2);
        }
        EventQueue systemEventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        boolean bl5 = bl2 = !(systemEventQueue instanceof IdeEventQueue);
        if (_Assertions.ENABLED && !bl2) {
            boolean bl6 = false;
            Intrinsics.checkNotNull((Object)systemEventQueue);
            EventQueue eventQueue = systemEventQueue;
            throw new AssertionError(eventQueue);
        }
        LaterInvocator.initializeNonBlockingFlushQueue((ThreadingSupport)this.threadingSupport);
        systemEventQueue.push(this);
        EDT.updateEdt();
        IdeKeyboardFocusManagerKt.replaceDefaultKeyboardFocusManager();
        this.addDispatcher((NonLockedEventDispatcher)new WindowsAltSuppressor(), (Disposable)null);
        if (SystemInfoRt.isWindows && Boolean.parseBoolean(System.getProperty("keymap.windows.up.to.maximize.dialogs", "true"))) {
            this.addDispatcher((NonLockedEventDispatcher)new WindowsUpMaximizer(), (Disposable)null);
        }
        this.addDispatcher((NonLockedEventDispatcher)new EditingCanceller(), (Disposable)null);
        IdeEventQueueKt.access$abracadabraDaberBoreh(this);
        if (Boolean.parseBoolean(System.getProperty("skip.move.resize.events", "true"))) {
            this.postEventListeners.add((Function1<AWTEvent, Boolean>)((Function1)IdeEventQueue::_init_$lambda$2));
        }
        this.addTextInputListener();
    }

    @NotNull
    public final ThreadingSupport getThreadingSupport() {
        return this.threadingSupport;
    }

    @NotNull
    public final IdeKeyEventDispatcher getKeyEventDispatcher() {
        return this.keyEventDispatcher;
    }

    @NotNull
    public final IdeMouseEventDispatcher getMouseEventDispatcher() {
        return this.mouseEventDispatcher;
    }

    @NotNull
    public final IdePopupManager getPopupManager() {
        return this.popupManager;
    }

    @ApiStatus.Internal
    public final long getPopupTriggerTime() {
        return this.popupTriggerTime;
    }

    public final boolean getActuallyWrapInputEventsIntoWriteIntentLock() {
        return this.actuallyWrapInputEventsIntoWriteIntentLock;
    }

    public final void setActuallyWrapInputEventsIntoWriteIntentLock(boolean bl) {
        this.actuallyWrapInputEventsIntoWriteIntentLock = bl;
    }

    public final int getEventCount() {
        return this.eventCount;
    }

    public final void setEventCount(int n) {
        this.eventCount = n;
    }

    @NotNull
    public final AWTEvent getTrueCurrentEvent() {
        return this.trueCurrentEvent;
    }

    @RequiresEdt
    public final void setIdleTracker$intellij_platform_ide_impl(@NotNull Function0<Unit> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        EDT.assertIsEdt();
        this.idleTracker = value;
    }

    @Deprecated(message="Use IdleTracker and coroutines")
    public final void addIdleListener(@NotNull Runnable runnable2, int timeoutMillis) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        IdleTracker.Companion.getInstance().addIdleListener(runnable2, timeoutMillis);
    }

    @Deprecated(message="Use IdleTracker and coroutines")
    public final void removeIdleListener(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        IdleTracker.Companion.getInstance().removeIdleListener(runnable2);
    }

    public final void addActivityListener(@NotNull Runnable runnable2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.activityListeners.add(runnable2);
        Disposer.register((Disposable)parentDisposable, () -> IdeEventQueue.addActivityListener$lambda$0(this, runnable2));
    }

    public final void addActivityListener(@NotNull Runnable runnable2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.activityListeners.add(runnable2);
        JobKt.getJob((CoroutineContext)coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> IdeEventQueue.addActivityListener$lambda$1(this, runnable2, arg_0));
    }

    @Deprecated(message="Use version for NonLockedEventDispatcher")
    public final void addDispatcher(@NotNull EventDispatcher dispatcher, @Nullable Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        IdeEventQueueKt.access$addProcessor(dispatcher, parent, this.dispatchers);
    }

    public final void addDispatcher(@NotNull NonLockedEventDispatcher dispatcher, @Nullable Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        IdeEventQueueKt.access$addProcessor(dispatcher, parent, this.nonLockingDispatchers);
    }

    @Deprecated(message="Use version for NonLockedEventDispatcher")
    public final void addDispatcher(@NotNull EventDispatcher dispatcher, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.dispatchers.add(dispatcher);
        JobKt.getJob((CoroutineContext)scope.getCoroutineContext()).invokeOnCompletion(arg_0 -> IdeEventQueue.addDispatcher$lambda$0(this, dispatcher, arg_0));
    }

    public final void addDispatcher(@NotNull NonLockedEventDispatcher dispatcher, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.nonLockingDispatchers.add(dispatcher);
        JobKt.getJob((CoroutineContext)scope.getCoroutineContext()).invokeOnCompletion(arg_0 -> IdeEventQueue.addDispatcher$lambda$1(this, dispatcher, arg_0));
    }

    @Deprecated(message="Use version for NonLockedEventDispatcher")
    public final void removeDispatcher(@NotNull EventDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.dispatchers.remove(dispatcher);
    }

    public final void removeDispatcher(@NotNull NonLockedEventDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.nonLockingDispatchers.remove(dispatcher);
    }

    public final boolean containsDispatcher(@NotNull EventDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        return this.dispatchers.contains(dispatcher) || CollectionsKt.contains((Iterable)this.nonLockingDispatchers, (Object)dispatcher);
    }

    public final void addPostprocessor(@NotNull EventDispatcher dispatcher, @Nullable Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        IdeEventQueueKt.access$addProcessor(dispatcher, parent, this.postProcessors);
    }

    public final void addPostprocessor(@NotNull EventDispatcher dispatcher, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.postProcessors.add(dispatcher);
        JobKt.getJob((CoroutineContext)coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> IdeEventQueue.addPostprocessor$lambda$0(this, dispatcher, arg_0));
    }

    public final void removePostprocessor(@NotNull EventDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.postProcessors.remove(dispatcher);
    }

    public final void addPreprocessor(@NotNull EventDispatcher dispatcher, @Nullable Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        IdeEventQueueKt.access$addProcessor(dispatcher, parent, this.preProcessors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(@NotNull AWTEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        AWTEvent event = e;
        long startedAt = System.currentTimeMillis();
        PerformanceWatcher performanceWatcher = PerformanceWatcher.Companion.getInstanceIfCreated();
        EventWatcher eventWatcher = LoadingState.COMPONENTS_LOADED.isOccurred() ? EventWatcher.getInstanceOrNull() : null;
        try {
            PerformanceWatcher performanceWatcher2 = performanceWatcher;
            if (performanceWatcher2 != null) {
                performanceWatcher2.edtEventStarted();
            }
            EventWatcher eventWatcher2 = eventWatcher;
            if (eventWatcher2 != null) {
                eventWatcher2.edtEventStarted(event, startedAt);
            }
            SequencedEventNestedFieldHolder.INSTANCE.fixNestedSequenceEvent(event);
            EDT.updateEdt();
            if (event.getID() == 205 || event.getID() == 204 || event.getID() == 200) {
                Object object = event.getSource();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Window");
                ActiveWindowsWatcher.addActiveWindow((Window)object);
            } else if (event.getID() == 202) {
                ActiveWindowsWatcher.updateActivatedWindowSet();
            }
            if (IdeEventQueueKt.access$isMetaKeyPressedOnLinux(event)) {
                return;
            }
            if (event.getSource() instanceof TrayIcon) {
                IdeEventQueueKt.access$dispatchTrayIconEvent(event);
                return;
            }
            this.checkForTimeJump(startedAt);
            if (!IdeEventQueueKt.access$appIsLoaded()) {
                try {
                    super.dispatchEvent(event);
                }
                catch (Throwable t) {
                    this.processException(t);
                }
                return;
            }
            this.hoverService.process(event);
            event = IdeEventQueueKt.access$mapEvent(event);
            AWTEvent metaEvent = this.mapMetaState(event);
            if (metaEvent != null && Registry.Companion.is("keymap.windows.as.meta", false)) {
                event = metaEvent;
            }
            if (SystemInfoRt.isMac && event instanceof InputEvent) {
                IdeEventQueueKt.access$disableAltGrUnsupportedOnMac(event);
            }
            AWTEvent oldEvent = this.trueCurrentEvent;
            this.trueCurrentEvent = event;
            AWTEvent finalEvent = event;
            Runnable runnable2 = InvocationUtil.extractRunnable((AWTEvent)event);
            Runnable runnable3 = runnable2 != null ? Propagation.unwrapContextRunnable((Runnable)runnable2) : null;
            Object object = runnable3;
            if (object == null || (object = object.getClass()) == null) {
                object = Runnable.class;
            }
            Class<Runnable> runnableClass = object;
            boolean nakedRunnable = runnable3 instanceof NakedRunnable;
            Runnable processEventRunnable = () -> IdeEventQueue.dispatchEvent$lambda$0(this, finalEvent, oldEvent, eventWatcher, runnable3, runnableClass, startedAt);
            if (Intrinsics.areEqual(runnableClass, (Object)InvocationUtil.REPAINT_PROCESSING_CLASS)) {
                processEventRunnable.run();
                return;
            }
            processEventRunnable.run();
        }
        finally {
            Thread.interrupted();
            this.processIdleActivityListeners(e);
            PerformanceWatcher performanceWatcher3 = performanceWatcher;
            if (performanceWatcher3 != null) {
                performanceWatcher3.edtEventFinished();
            }
            EventWatcher eventWatcher3 = eventWatcher;
            if (eventWatcher3 != null) {
                eventWatcher3.edtEventFinished(event, System.currentTimeMillis());
            }
        }
    }

    private final void runCustomProcessors(AWTEvent event, List<? extends EventDispatcher> processors) {
        for (EventDispatcher eventDispatcher : processors) {
            try {
                eventDispatcher.dispatch(event);
            }
            catch (Throwable t) {
                this.processException(t);
            }
        }
    }

    private final void checkForTimeJump(long now) {
        if (this.lastEventTime > now + (long)1000) {
            Logs.LOG.warn("System clock's jumped back by ~" + (this.lastEventTime - now) / (long)1000 + " sec");
        }
        this.lastEventTime = now;
    }

    @Override
    @NotNull
    public AWTEvent getNextEvent() {
        AWTEvent event = super.getNextEvent();
        this.eventsReturned.incrementAndGet();
        Intrinsics.checkNotNull((Object)event);
        if (IdeEventQueueKt.access$isKeyboardEvent(event) && this.keyboardEventDispatched.incrementAndGet() > this.keyboardEventPosted.get()) {
            throw new RuntimeException(event + "; posted: " + this.keyboardEventPosted + "; dispatched: " + this.keyboardEventDispatched);
        }
        return event;
    }

    private final void processException(Throwable exception) {
        Throwable t = exception;
        if (this.isTestMode()) {
            throw t;
        }
        if (t instanceof ControlFlowException && Boolean.getBoolean("report.control.flow.exceptions.in.edt")) {
            t = new RuntimeException(t);
        }
        StartupErrorReporter.processException(t);
    }

    private final AWTEvent mapMetaState(AWTEvent e) {
        if (this.winMetaPressed) {
            Application app = ApplicationManager.getApplication();
            boolean weAreNotActive = app == null || !app.isActive();
            if (weAreNotActive |= e instanceof FocusEvent && ((FocusEvent)e).getOppositeComponent() == null) {
                this.winMetaPressed = false;
                return null;
            }
        }
        if (e instanceof KeyEvent) {
            if (((KeyEvent)e).getKeyCode() == 524) {
                if (((KeyEvent)e).getID() == 401) {
                    this.winMetaPressed = true;
                }
                if (((KeyEvent)e).getID() == 402) {
                    this.winMetaPressed = false;
                }
                return null;
            }
            if (this.winMetaPressed) {
                return new KeyEvent(((KeyEvent)e).getComponent(), ((KeyEvent)e).getID(), ((KeyEvent)e).getWhen(), UIUtil.getAllModifiers((InputEvent)((InputEvent)e)) | 4, ((KeyEvent)e).getKeyCode(), ((KeyEvent)e).getKeyChar(), ((KeyEvent)e).getKeyLocation());
            }
        }
        if (this.winMetaPressed && e instanceof MouseEvent && ((MouseEvent)e).getButton() != 0) {
            return new MouseEvent(((MouseEvent)e).getComponent(), ((MouseEvent)e).getID(), ((MouseEvent)e).getWhen(), UIUtil.getAllModifiers((InputEvent)((InputEvent)e)) | 4, ((MouseEvent)e).getX(), ((MouseEvent)e).getY(), ((MouseEvent)e).getClickCount(), ((MouseEvent)e).isPopupTrigger(), ((MouseEvent)e).getButton());
        }
        return null;
    }

    private final void _dispatchEvent(AWTEvent e) {
        if (e.getID() == 506 && IdeEventQueueKt.access$appIsLoaded()) {
            DnDManager dnDManager = DnDManager.getInstance();
            DnDManagerImpl dnDManagerImpl = dnDManager instanceof DnDManagerImpl ? (DnDManagerImpl)dnDManager : null;
            if (dnDManagerImpl != null) {
                dnDManagerImpl.setLastDropHandler(null);
            }
        }
        int n = this.eventCount;
        this.eventCount = n + 1;
        boolean bl = this.keyboardBusy = e instanceof KeyEvent || this.keyboardEventPosted.get() > this.keyboardEventDispatched.get();
        if (e instanceof KeyEvent && e.getID() == 402 && ((KeyEvent)e).getKeyCode() == 16) {
            this.mouseEventDispatcher.resetHorScrollingTracker();
        }
        if (e instanceof MouseWheelEvent && IdeEventQueueKt.access$processMouseWheelEvent((MouseWheelEvent)e)) {
            return;
        }
        if (this.isUserActivityEvent(e)) {
            ActivityTracker.getInstance().inc();
        }
        if (this.popupManager.isPopupActive() && !this.shouldSkipListeners(e) && this.popupManager.dispatch(e)) {
            if (this.keyEventDispatcher.isWaitingForSecondKeyStroke()) {
                this.keyEventDispatcher.setState(KeyState.STATE_INIT);
            }
            return;
        }
        if (e instanceof WindowEvent) {
            if (ThreadingRuntimeFlagsKt.getWrapHighLevelFunctionsInWriteIntent()) {
                this.threadingSupport.runWriteIntentReadAction(() -> IdeEventQueue._dispatchEvent$lambda$0(e));
            } else {
                IdeEventQueueKt.access$processAppActivationEvent((WindowEvent)e);
            }
        }
        if (!this.shouldSkipListeners(e) && this.dispatchByCustomDispatchers(e)) {
            return;
        }
        if (e instanceof InputMethodEvent && SystemInfoRt.isMac && this.keyEventDispatcher.isWaitingForSecondKeyStroke()) {
            return;
        }
        if (e instanceof MouseEvent) {
            if (this.actuallyWrapInputEventsIntoWriteIntentLock) {
                this.threadingSupport.runWriteIntentReadAction(() -> IdeEventQueue._dispatchEvent$lambda$1(this, e));
            } else {
                this.dispatchMouseEvent((MouseEvent)e);
            }
        } else if (e instanceof KeyEvent) {
            if (this.actuallyWrapInputEventsIntoWriteIntentLock) {
                this.threadingSupport.runWriteIntentReadAction(() -> IdeEventQueue._dispatchEvent$lambda$2(this, e));
            } else {
                this.dispatchKeyEvent((KeyEvent)e);
            }
        } else if (IdeEventQueueKt.access$appIsLoaded()) {
            ApplicationEx app = ApplicationManagerEx.getApplicationEx();
            if (e instanceof ComponentEvent && !app.isHeadlessEnvironment()) {
                Intrinsics.checkNotNull((Object)app);
                ComponentManager $this$serviceIfCreated$iv = (ComponentManager)app;
                boolean $i$f$serviceIfCreated = false;
                Object object = $this$serviceIfCreated$iv.getServiceIfCreated(WindowManager.class);
                WindowManagerEx windowManagerEx = object instanceof WindowManagerEx ? (WindowManagerEx)((Object)object) : null;
                if (windowManagerEx != null) {
                    windowManagerEx.dispatchComponentEvent((ComponentEvent)e);
                }
            }
            this.defaultDispatchEvent(e);
        } else {
            this.defaultDispatchEvent(e);
        }
    }

    private final boolean shouldSkipListeners(AWTEvent e) {
        return e instanceof InternalThreading.TransferredWriteActionEvent;
    }

    private final boolean isUserActivityEvent(AWTEvent e) {
        return 401 == e.getID() || 400 == e.getID() || 501 == e.getID() || 502 == e.getID() || 500 == e.getID() || 506 == e.getID() || e instanceof FocusEvent || e instanceof WindowEvent && ((WindowEvent)e).getID() != 202;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processIdleActivityListeners(AWTEvent e) {
        if (!this.isUserActivityEvent(e)) {
            return;
        }
        ActivityTracker.getInstance().inc();
        this.idleTracker.invoke();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.lastActiveTime = System.nanoTime();
            ThreadContext.resetThreadContext(() -> IdeEventQueue.processIdleActivityListeners$lambda$0$0(this));
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void dispatchKeyEvent(KeyEvent e) {
        if (this.keyEventDispatcher.dispatchKeyEvent(e)) {
            e.consume();
        }
        this.defaultDispatchEvent(e);
    }

    private final void dispatchMouseEvent(MouseEvent e) {
        if (e.getID() == 501 && e.getModifiers() > 0 && e.getModifiersEx() == 0) {
            this.resetGlobalMouseEventTarget(e);
        }
        if (IdeMouseEventDispatcher.patchClickCount(e) && e.getID() == 500) {
            this.redispatchLater(e);
        }
        if (!this.mouseEventDispatcher.dispatchMouseEvent(e)) {
            this.defaultDispatchEvent(e);
        }
    }

    private final void resetGlobalMouseEventTarget(MouseEvent me) {
        super.dispatchEvent(new MouseEvent(me.getComponent(), 503, me.getWhen(), 0, me.getX(), me.getY(), 0, false, 0));
    }

    private final void redispatchLater(MouseEvent me) {
        MouseEvent toDispatch = new MouseEvent(me.getComponent(), me.getID(), System.currentTimeMillis(), me.getModifiers(), me.getX(), me.getY(), 1, me.isPopupTrigger(), me.getButton());
        EventQueue.invokeLater(() -> IdeEventQueue.redispatchLater$lambda$0(this, toDispatch));
    }

    private final boolean dispatchByCustomDispatchers(AWTEvent e) {
        Boolean result2;
        for (NonLockedEventDispatcher eachDispatcher : this.nonLockingDispatchers) {
            try {
                if (!eachDispatcher.dispatch(e)) continue;
                return true;
            }
            catch (Throwable t) {
                this.processException(t);
            }
        }
        List extensions = CollectionsKt.plus((Collection)IdeEventQueueKt.access$getDISPATCHER_EP$p().getExtensionsIfPointIsRegistered(), (Iterable)IdeEventQueueKt.access$getNON_LOCKED_DISPATCHER_EP$p().getExtensionsIfPointIsRegistered());
        boolean hasOldDispatchers = false;
        for (EventDispatcher eachDispatcher : extensions) {
            try {
                if (eachDispatcher instanceof NonLockedEventDispatcher) {
                    if (!eachDispatcher.dispatch(e)) continue;
                    return true;
                }
                hasOldDispatchers = true;
            }
            catch (Throwable t) {
                this.processException(t);
            }
        }
        return (!((Collection)this.dispatchers).isEmpty() || hasOldDispatchers) && (result2 = (Boolean)WriteIntentReadAction.computeThrowable(() -> IdeEventQueue.dispatchByCustomDispatchers$lambda$0(this, e))) != false;
    }

    @ApiStatus.Internal
    public final void defaultDispatchEvent(@NotNull AWTEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        try {
            boolean consumed;
            this.maybeReady$intellij_platform_ide_impl();
            MouseEvent me = e instanceof MouseEvent ? (MouseEvent)e : null;
            KeyEvent keyEvent = e instanceof KeyEvent ? (KeyEvent)e : null;
            boolean bl = consumed = keyEvent == null || keyEvent.isConsumed();
            if (me != null && (me.isPopupTrigger() || ((MouseEvent)e).getID() == 501) || keyEvent != null) {
                this.popupTriggerTime = System.nanoTime();
            }
            super.dispatchEvent(e);
            if (!consumed && keyEvent.isConsumed() && 401 == keyEvent.getID()) {
                MnemonicUsageCollector.logMnemonicUsed(keyEvent);
            }
        }
        catch (Throwable t) {
            this.processException(t);
        }
    }

    @ApiStatus.Internal
    public final void flushQueue() {
        EDT.assertIsEdt();
        ThreadContext.resetThreadContext(() -> IdeEventQueue.flushQueue$lambda$0(this));
    }

    public final void pumpEventsForHierarchy(@NotNull Component modalComponent, @NotNull Future<?> exitCondition, @NotNull Consumer<AWTEvent> eventConsumer) {
        Intrinsics.checkNotNullParameter((Object)modalComponent, (String)"modalComponent");
        Intrinsics.checkNotNullParameter(exitCondition, (String)"exitCondition");
        Intrinsics.checkNotNullParameter(eventConsumer, (String)"eventConsumer");
        ThreadContext.resetThreadContext(() -> IdeEventQueue.pumpEventsForHierarchy$lambda$0(exitCondition, this, modalComponent, eventConsumer));
    }

    public final long getIdleTime() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.lastActiveTime);
    }

    @JvmOverloads
    public final void blockNextEvents(@NotNull MouseEvent e, @NotNull BlockMode blockMode) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)((Object)blockMode), (String)"blockMode");
        this.mouseEventDispatcher.blockNextEvents(e, blockMode);
    }

    public static /* synthetic */ void blockNextEvents$default(IdeEventQueue ideEventQueue, MouseEvent mouseEvent, BlockMode blockMode, int n, Object object) {
        if ((n & 2) != 0) {
            blockMode = BlockMode.COMPLETE;
        }
        ideEventQueue.blockNextEvents(mouseEvent, blockMode);
    }

    private final boolean isReady() {
        return !this.keyboardBusy && this.keyEventDispatcher.isReady();
    }

    public final void maybeReady$intellij_platform_ide_impl() {
        if (!((Collection)this.ready).isEmpty() && this.isReady()) {
            this.invokeReadyHandlers();
        }
    }

    private final void invokeReadyHandlers() {
        Collection $this$toTypedArray$iv = this.ready;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Runnable[] ready = thisCollection$iv.toArray(new Runnable[0]);
        this.ready.clear();
        for (Runnable each : ready) {
            each.run();
        }
    }

    public final void doWhenReady(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        if (EventQueue.isDispatchThread()) {
            this.ready.add(runnable2);
            this.maybeReady$intellij_platform_ide_impl();
        } else {
            EventQueue.invokeLater(() -> IdeEventQueue.doWhenReady$lambda$0(this, runnable2));
        }
    }

    public final boolean isPopupActive() {
        return this.popupManager.isPopupActive();
    }

    public final boolean isInputMethodEnabled() {
        return !SystemInfoRt.isMac || this.inputMethodLock == 0;
    }

    public final void disableInputMethods(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        int n = this.inputMethodLock;
        this.inputMethodLock = n + 1;
        Disposer.register((Disposable)parentDisposable, () -> IdeEventQueue.disableInputMethods$lambda$0(this));
    }

    @Override
    public void postEvent(@NotNull AWTEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.doPostEvent(event, false);
    }

    @ApiStatus.Internal
    public final boolean doPostEvent(@NotNull AWTEvent event, boolean postDirectly) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (Function1<AWTEvent, Boolean> listener2 : this.postEventListeners) {
            if (!((Boolean)listener2.invoke((Object)event)).booleanValue()) continue;
            return false;
        }
        this.eventsPosted.incrementAndGet();
        if (event instanceof KeyEvent) {
            this.keyboardEventPosted.incrementAndGet();
        }
        if (postDirectly) {
            super.postEvent(event);
            return true;
        }
        AWTEvent aWTEvent = this.attachClientIdIfNeeded(event);
        if (aWTEvent != null) {
            Object it = aWTEvent;
            boolean bl = false;
            super.postEvent((AWTEvent)it);
            return true;
        }
        super.postEvent(event);
        return true;
    }

    private final AWTEvent attachClientIdIfNeeded(AWTEvent event) {
        if (event instanceof InvocationEvent && !(event instanceof PeerEvent)) {
            Runnable runnable2 = InvocationUtil.extractRunnable((AWTEvent)event);
            if (runnable2 == null || runnable2 instanceof ContextAwareRunnable) {
                return null;
            }
            if (InvocationUtil.replaceRunnable((InvocationEvent)((InvocationEvent)event), (Runnable)ThreadContext.captureThreadContext((Runnable)runnable2))) {
                return event;
            }
            CoroutineContext captured = ThreadContext.currentThreadContext();
            return new InvocationEvent(((InvocationEvent)event).getSource(), (Runnable)((ContextAwareRunnable)() -> IdeEventQueue.attachClientIdIfNeeded$lambda$0(captured, event)));
        }
        int n = event.getID();
        boolean bl = 100 <= n ? n < 104 : false;
        if (bl) {
            Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type java.awt.event.ComponentEvent");
            Component component2 = ((ComponentEvent)event).getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getComponent(...)");
            return new ComponentEventWithClientId(component2, ((ComponentEvent)event).getID(), ClientId.Companion.getCurrentOrNull());
        }
        return null;
    }

    private final AccessToken withAttachedClientId(AWTEvent event) {
        AccessToken accessToken;
        if (event instanceof ClientIdAwareEvent) {
            accessToken = ClientId.Companion.withExplicitClientId(((ClientIdAwareEvent)((Object)event)).getClientId());
        } else {
            AccessToken accessToken2 = AccessToken.EMPTY_ACCESS_TOKEN;
            accessToken = accessToken2;
            Intrinsics.checkNotNullExpressionValue((Object)accessToken2, (String)"EMPTY_ACCESS_TOKEN");
        }
        return accessToken;
    }

    @Deprecated(message="Does nothing currently")
    public final void flushDelayedKeyEvents() {
    }

    private final boolean isTestMode() {
        Boolean testMode = this.testMode;
        if (testMode != null) {
            return testMode;
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return false;
        }
        Application application2 = application;
        this.testMode = testMode = Boolean.valueOf(application2.isUnitTestMode());
        return testMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void executeInProductionModeEvenThoughWeAreInTests(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        boolean bl = ApplicationManager.getApplication().isUnitTestMode();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.testMode = false;
        try {
            runnable2.run();
        }
        finally {
            this.testMode = true;
        }
    }

    public final void addPostEventListener(@NotNull Function1<? super AWTEvent, Boolean> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.postEventListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> IdeEventQueue.addPostEventListener$lambda$0(this, listener2));
    }

    public final long getPostedEventCount() {
        return this.eventsPosted.get();
    }

    public final long getReturnedEventCount() {
        return this.eventsReturned.get();
    }

    public final long getPostedSystemEventCount() {
        AppContext appContext = AppContext.getAppContext();
        Object object = appContext != null ? appContext.get("jb.postedSystemEventCount") : null;
        AtomicLong atomicLong = object instanceof AtomicLong ? (AtomicLong)object : null;
        return atomicLong != null ? atomicLong.get() : -1L;
    }

    public final void flushNativeEventQueue() {
        SunToolkit.flushPendingEvents();
    }

    private final void addTextInputListener() {
        block1: {
            if (!StartupUiUtil.isLWCToolkit()) break block1;
            TextInput textInput = JBR.getTextInput();
            if (textInput != null) {
                textInput.setGlobalEventListener(new TextInput.EventListener(){

                    public void handleSelectTextRangeEvent(TextInput.SelectTextRangeEvent event) {
                        block1: {
                            SpeedSearchSupply supply;
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            Object source = event.getSource();
                            if (!(source instanceof JComponent)) break block1;
                            SpeedSearchSupply speedSearchSupply = supply = SpeedSearchSupply.getSupply((JComponent)((JComponent)source), (boolean)true);
                            if (speedSearchSupply != null) {
                                speedSearchSupply.selectTextRange(event.getBegin(), event.getLength());
                            }
                        }
                    }
                });
            }
        }
    }

    @JvmOverloads
    public final void blockNextEvents(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        IdeEventQueue.blockNextEvents$default(this, e, null, 2, null);
    }

    private static final Unit idleTracker$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$2(AWTEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return IdeEventQueueKt.access$skipMoveResizeEvents(it);
    }

    private static final void addActivityListener$lambda$0(IdeEventQueue this$0, Runnable $runnable) {
        this$0.activityListeners.remove($runnable);
    }

    private static final Unit addActivityListener$lambda$1(IdeEventQueue this$0, Runnable $runnable, Throwable it) {
        this$0.activityListeners.remove($runnable);
        return Unit.INSTANCE;
    }

    private static final Unit addDispatcher$lambda$0(IdeEventQueue this$0, EventDispatcher $dispatcher, Throwable it) {
        this$0.dispatchers.remove($dispatcher);
        return Unit.INSTANCE;
    }

    private static final Unit addDispatcher$lambda$1(IdeEventQueue this$0, NonLockedEventDispatcher $dispatcher, Throwable it) {
        this$0.nonLockingDispatchers.remove($dispatcher);
        return Unit.INSTANCE;
    }

    private static final Unit addPostprocessor$lambda$0(IdeEventQueue this$0, EventDispatcher $dispatcher, Throwable it) {
        this$0.postProcessors.remove($dispatcher);
        return Unit.INSTANCE;
    }

    private static final Unit dispatchEvent$lambda$0$0$0$0(IdeEventQueue this$0, AWTEvent $finalEvent) {
        this$0._dispatchEvent($finalEvent);
        return Unit.INSTANCE;
    }

    private static final Unit dispatchEvent$lambda$0$0$0(ProgressManager $progressManager, Runnable $runnable, IdeEventQueue this$0, AWTEvent $finalEvent) {
        if ($progressManager == null || $runnable != null && InvocationUtil.isFlushNow((Runnable)$runnable)) {
            this$0._dispatchEvent($finalEvent);
        } else {
            $progressManager.computePrioritized(() -> IdeEventQueue.dispatchEvent$lambda$0$0$0$0(this$0, $finalEvent));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final void dispatchEvent$lambda$0(IdeEventQueue this$0, AWTEvent $finalEvent, AWTEvent $oldEvent, EventWatcher $eventWatcher, Runnable $runnable, Class $runnableClass, long $startedAt) {
        var8_7 = (AutoCloseable)this$0.withAttachedClientId($finalEvent);
        var9_8 = null;
        try {
            it = (AccessToken)var8_7;
            $i$a$-use-IdeEventQueue$dispatchEvent$processEventRunnable$1$1 = false;
            progressManager = ProgressManager.getInstanceOrNull();
            try {
                this$0.runCustomProcessors($finalEvent, this$0.preProcessors);
                IdeEventQueueKt.performActivity($finalEvent, (Function0<Unit>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, dispatchEvent$lambda$0$0$0(com.intellij.openapi.progress.ProgressManager java.lang.Runnable com.intellij.ide.IdeEventQueue java.awt.AWTEvent ), ()Lkotlin/Unit;)((ProgressManager)progressManager, (Runnable)$runnable, (IdeEventQueue)this$0, (AWTEvent)$finalEvent));
                this$0.trueCurrentEvent = $oldEvent;
                SequencedEventNestedFieldHolder.INSTANCE.eventDispatched($finalEvent);
                this$0.runCustomProcessors($finalEvent, this$0.postProcessors);
            }
            catch (Throwable t) {
                try {
                    this$0.processException(t);
                    this$0.trueCurrentEvent = $oldEvent;
                    SequencedEventNestedFieldHolder.INSTANCE.eventDispatched($finalEvent);
                    this$0.runCustomProcessors($finalEvent, this$0.postProcessors);
                }
                catch (Throwable var13_15) {
                    this$0.trueCurrentEvent = $oldEvent;
                    SequencedEventNestedFieldHolder.INSTANCE.eventDispatched($finalEvent);
                    this$0.runCustomProcessors($finalEvent, this$0.postProcessors);
                    if ($finalEvent instanceof KeyEvent) {
                        this$0.maybeReady$intellij_platform_ide_impl();
                    }
                    if ($eventWatcher != null && $runnable != null && !InvocationUtil.isFlushNow((Runnable)$runnable)) {
                        $eventWatcher.logTimeMillis(Intrinsics.areEqual((Object)$runnableClass, Runnable.class) != false ? $finalEvent.toString() : $runnableClass.getName(), $startedAt, $runnableClass);
                    }
                    throw var13_15;
                }
                if ($finalEvent instanceof KeyEvent) {
                    this$0.maybeReady$intellij_platform_ide_impl();
                }
                if ($eventWatcher != null && $runnable != null && !InvocationUtil.isFlushNow((Runnable)$runnable)) {
                    $eventWatcher.logTimeMillis(Intrinsics.areEqual((Object)$runnableClass, Runnable.class) != false ? $finalEvent.toString() : $runnableClass.getName(), $startedAt, $runnableClass);
                } else {
                    ** GOTO lbl40
                }
            }
            if ($finalEvent instanceof KeyEvent) {
                this$0.maybeReady$intellij_platform_ide_impl();
            }
            if ($eventWatcher != null && $runnable != null && !InvocationUtil.isFlushNow((Runnable)$runnable)) {
                $eventWatcher.logTimeMillis(Intrinsics.areEqual((Object)$runnableClass, Runnable.class) != false ? $finalEvent.toString() : $runnableClass.getName(), $startedAt, $runnableClass);
            }
            var10_9 = Unit.INSTANCE;
        }
        catch (Throwable var11_11) {
            var9_8 = var11_11;
            throw var11_11;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)var8_7, (Throwable)var9_8);
        }
    }

    private static final Unit _dispatchEvent$lambda$0(AWTEvent $e) {
        IdeEventQueueKt.access$processAppActivationEvent((WindowEvent)$e);
        return Unit.INSTANCE;
    }

    private static final Unit _dispatchEvent$lambda$1(IdeEventQueue this$0, AWTEvent $e) {
        this$0.dispatchMouseEvent((MouseEvent)$e);
        return Unit.INSTANCE;
    }

    private static final Unit _dispatchEvent$lambda$2(IdeEventQueue this$0, AWTEvent $e) {
        this$0.dispatchKeyEvent((KeyEvent)$e);
        return Unit.INSTANCE;
    }

    private static final Unit processIdleActivityListeners$lambda$0$0(IdeEventQueue this$0) {
        for (Runnable activityListener : this$0.activityListeners) {
            activityListener.run();
        }
        return Unit.INSTANCE;
    }

    private static final void redispatchLater$lambda$0(IdeEventQueue this$0, MouseEvent $toDispatch) {
        this$0.dispatchEvent($toDispatch);
    }

    private static final Boolean dispatchByCustomDispatchers$lambda$0(IdeEventQueue this$0, AWTEvent $e) {
        for (EventDispatcher eachDispatcher : this$0.dispatchers) {
            try {
                if (!eachDispatcher.dispatch($e)) continue;
                return true;
            }
            catch (Throwable t) {
                this$0.processException(t);
            }
        }
        for (EventDispatcher eachDispatcher : IdeEventQueueKt.access$getDISPATCHER_EP$p().getExtensionsIfPointIsRegistered()) {
            try {
                if (eachDispatcher instanceof NonLockedEventDispatcher || !eachDispatcher.dispatch($e)) continue;
                return true;
            }
            catch (Throwable t) {
                this$0.processException(t);
            }
        }
        return false;
    }

    private static final Unit flushQueue$lambda$0(IdeEventQueue this$0) {
        while (this$0.peekEvent() != null) {
            try {
                this$0.dispatchEvent(this$0.getNextEvent());
                continue;
            }
            catch (Exception e) {
                Logs.LOG.error((Throwable)e);
                continue;
            }
            break;
        }
        return Unit.INSTANCE;
    }

    private static final Unit pumpEventsForHierarchy$lambda$0(Future $exitCondition, IdeEventQueue this$0, Component $modalComponent, Consumer $eventConsumer) {
        Logger logger;
        EDT.assertIsEdt();
        Logger $this$debug_u24default$iv = Logs.LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("pumpEventsForHierarchy(" + $modalComponent + ", " + $exitCondition + ")", t$iv);
        }
        SmartList exceptions = new SmartList();
        while (!$exitCondition.isDone()) {
            try {
                AWTEvent event = this$0.getNextEvent();
                boolean consumed = IdeEventQueueKt.consumeUnrelatedEvent($modalComponent, event);
                if (!consumed) {
                    this$0.dispatchEvent(event);
                }
                $eventConsumer.accept(event);
            }
            catch (Throwable e) {
                try {
                    Logs.LOG.error(e);
                    Unit bl = Unit.INSTANCE;
                }
                catch (Throwable e2) {
                    Boolean bl = exceptions.add((Object)e2);
                }
            }
        }
        switch (exceptions.size()) {
            case 0: {
                break;
            }
            case 1: {
                Logs.LOG.error((Throwable)exceptions.get(0));
                break;
            }
            default: {
                Logs.LOG.error((Throwable)new CompoundRuntimeException((List)exceptions));
            }
        }
        Logger $this$debug_u24default$iv2 = Logs.LOG;
        Throwable t$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("pumpEventsForHierarchy.exit(" + $modalComponent + ", " + $exitCondition + ")", t$iv2);
        }
        return Unit.INSTANCE;
    }

    private static final void doWhenReady$lambda$0(IdeEventQueue this$0, Runnable $runnable) {
        this$0.ready.add($runnable);
        this$0.maybeReady$intellij_platform_ide_impl();
    }

    private static final void disableInputMethods$lambda$0(IdeEventQueue this$0) {
        int n = this$0.inputMethodLock;
        this$0.inputMethodLock = n + -1;
    }

    private static final Unit attachClientIdIfNeeded$lambda$0$0(AWTEvent $event) {
        ((InvocationEvent)$event).dispatch();
        return Unit.INSTANCE;
    }

    private static final void attachClientIdIfNeeded$lambda$0(CoroutineContext $captured, AWTEvent $event) {
        ThreadContext.installThreadContext$default((CoroutineContext)$captured, (boolean)false, () -> IdeEventQueue.attachClientIdIfNeeded$lambda$0$0($event), (int)2, null);
    }

    private static final void addPostEventListener$lambda$0(IdeEventQueue this$0, Function1 $listener) {
        this$0.postEventListeners.remove($listener);
    }

    private static final IdeEventQueue _instance_delegate$lambda$0() {
        return new IdeEventQueue();
    }

    @JvmStatic
    @NotNull
    public static final IdeEventQueue getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final void applicationClose() {
        Companion.applicationClose();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/IdeEventQueue$BlockMode;", "", "<init>", "(Ljava/lang/String;I)V", "COMPLETE", "ACTIONS", "intellij.platform.ide.impl"})
    public static final class BlockMode
    extends Enum<BlockMode> {
        public static final /* enum */ BlockMode COMPLETE = new BlockMode();
        public static final /* enum */ BlockMode ACTIONS = new BlockMode();
        private static final /* synthetic */ BlockMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BlockMode[] values() {
            return (BlockMode[])$VALUES.clone();
        }

        public static BlockMode valueOf(String value) {
            return Enum.valueOf(BlockMode.class, value);
        }

        @NotNull
        public static EnumEntries<BlockMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = blockModeArray = new BlockMode[]{BlockMode.COMPLETE, BlockMode.ACTIONS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0007J\b\u0010\u000b\u001a\u00020\fH\u0007R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/IdeEventQueue$Companion;", "", "<init>", "()V", "_instance", "Lcom/intellij/ide/IdeEventQueue;", "get_instance", "()Lcom/intellij/ide/IdeEventQueue;", "_instance$delegate", "Lkotlin/Lazy;", "getInstance", "applicationClose", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final IdeEventQueue get_instance() {
            Lazy lazy = _instance$delegate;
            return (IdeEventQueue)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final IdeEventQueue getInstance() {
            return this.get_instance();
        }

        @JvmStatic
        @ApiStatus.Internal
        public final void applicationClose() {
            IdeEventQueueKt.access$setAppIsLoaded$p(false);
            IdeEventQueueKt.access$setTransactionGuard$p(null);
            IdeKeyboardFocusManagerKt.restoreDefaultKeyboardFocusManager();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ide/IdeEventQueue$EventDispatcher;", "", "dispatch", "", "e", "Ljava/awt/AWTEvent;", "intellij.platform.ide.impl"})
    public static interface EventDispatcher {
        public boolean dispatch(@NotNull AWTEvent var1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0002\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ide/IdeEventQueue$NonLockedEventDispatcher;", "Lcom/intellij/ide/IdeEventQueue$EventDispatcher;", "intellij.platform.ide.impl"})
    public static interface NonLockedEventDispatcher
    extends EventDispatcher {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/IdeEventQueue$WindowsUpMaximizer;", "Lcom/intellij/ide/IdeEventQueue$NonLockedEventDispatcher;", "<init>", "(Lcom/intellij/ide/IdeEventQueue;)V", "dispatch", "", "e", "Ljava/awt/AWTEvent;", "intellij.platform.ide.impl"})
    private final class WindowsUpMaximizer
    implements NonLockedEventDispatcher {
        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            Component parent;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (IdeEventQueue.this.winMetaPressed && e instanceof KeyEvent && e.getID() == 402 && (((KeyEvent)e).getKeyCode() == 38 || ((KeyEvent)e).getKeyCode() == 40) && (parent = (Component)ComponentUtil.getWindow((Component)((KeyEvent)e).getComponent())) instanceof JDialog) {
                EventQueue.invokeLater(() -> WindowsUpMaximizer.dispatch$lambda$0(e, parent));
                return true;
            }
            return false;
        }

        private static final void dispatch$lambda$0(AWTEvent $e, Component $parent) {
            if (((KeyEvent)$e).getKeyCode() == 38) {
                MaximizeDialogKt.maximize((JDialog)$parent);
            } else {
                MaximizeDialogKt.normalize((JDialog)$parent);
            }
        }
    }
}

