/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ProjectColorStorage;
import com.intellij.ide.ProjectColors;
import com.intellij.ide.ProjectGradients;
import com.intellij.ide.ProjectIconPalette;
import com.intellij.ide.ProjectWidgetGradientLocationService;
import com.intellij.ide.ProjectWindowCustomizerIconCache;
import com.intellij.ide.ProjectWindowCustomizerServiceKt;
import com.intellij.ide.RecentProjectColorStorage;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.WorkspaceProjectColorStorage;
import com.intellij.ide.actions.DistractionFreeModeController;
import com.intellij.ide.ui.GradientTextureCache;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomWindowHeaderUtil;
import com.intellij.openapi.wm.impl.headertoolbar.MainToolbar;
import com.intellij.ui.ColorHexUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.AvatarIcon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Window;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \\2\u00020\u0001:\u0001\\B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b!J\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180#H\u0000\u00a2\u0006\u0002\b$J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0007J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0007J\u001c\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120,2\u0006\u0010-\u001a\u00020\tH\u0007J\u0012\u0010.\u001a\u0004\u0018\u00010\u00122\u0006\u0010'\u001a\u00020(H\u0002J\u0017\u0010/\u001a\u0004\u0018\u00010\u001b2\u0006\u0010'\u001a\u00020(H\u0007\u00a2\u0006\u0002\u00100J\u0015\u00101\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0000\u00a2\u0006\u0002\b2J\u0010\u00103\u001a\u00020\n2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\u001b2\u0006\u00104\u001a\u000205H\u0002J\u0017\u00107\u001a\u0004\u0018\u00010\u001b2\u0006\u00104\u001a\u000205H\u0002\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(H\u0007J\u0010\u0010:\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0007J\u0018\u0010;\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(2\u0006\u0010<\u001a\u00020\u001bH\u0007J\u0018\u0010;\u001a\u00020\u000e2\u0006\u00104\u001a\u0002052\u0006\u0010<\u001a\u00020\u001bH\u0002J\u001a\u0010=\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(2\b\u0010>\u001a\u0004\u0018\u00010\u0012H\u0007J\u001a\u0010=\u001a\u00020\u000e2\u0006\u00104\u001a\u0002052\b\u0010>\u001a\u0004\u0018\u00010\u0012H\u0002J\u0015\u0010?\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(H\u0001\u00a2\u0006\u0002\b@J\u0010\u0010A\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(H\u0007J\u0010\u0010A\u001a\u00020\u000e2\u0006\u00104\u001a\u000205H\u0002J\u0014\u0010B\u001a\u00020\u001b*\u00020C2\u0006\u0010D\u001a\u00020\u001bH\u0002J\u0010\u0010E\u001a\u00020F2\u0006\u0010-\u001a\u00020\tH\u0002J\u0012\u0010E\u001a\u0004\u0018\u00010G2\u0006\u0010'\u001a\u00020(H\u0002J\u0015\u0010H\u001a\u00020\u000e2\u0006\u0010I\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bJJ\u0006\u0010K\u001a\u00020\u0005J\u0006\u0010L\u001a\u00020\u0005J\u0006\u0010M\u001a\u00020\u000eJ*\u0010N\u001a\u00020\u000e2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020\u00052\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rJ\b\u0010S\u001a\u00020\u000eH\u0002J\b\u0010T\u001a\u00020\u0005H\u0002J\u001e\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020\u00182\u0006\u0010Y\u001a\u00020ZJ\b\u0010[\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lcom/intellij/ide/ProjectWindowCustomizerService;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "wasGradientPainted", "", "ourSettingsValue", "colorCache", "Ljava/util/HashMap;", "Ljava/nio/file/Path;", "Lcom/intellij/ide/ProjectColors;", "listeners", "", "Lkotlin/Function1;", "", "defaultColors", "gradientColors", "", "Ljava/awt/Color;", "getGradientColors$annotations", "getGradientColors", "()[Ljava/awt/Color;", "gradientRepaintRoots", "Ljava/util/HashSet;", "Ljavax/swing/JComponent;", "allGradients", "", "", "Lcom/intellij/ide/ProjectGradients;", "addGradientRepaintRoot", "component", "addGradientRepaintRoot$intellij_platform_ide_impl", "removeGradientRepaintRoot", "removeGradientRepaintRoot$intellij_platform_ide_impl", "getGradientRepaintRoots", "", "getGradientRepaintRoots$intellij_platform_ide_impl", "getProjectIcon", "Ljavax/swing/Icon;", "project", "Lcom/intellij/openapi/project/Project;", "getGradientProjectColor", "getProjectColorToCustomize", "getRecentProjectIconColor", "Lkotlin/Pair;", "projectPath", "getDeprecatedCustomToolbarColor", "getCurrentProjectColorIndex", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/Integer;", "getProjectGradients", "getProjectGradients$intellij_platform_ide_impl", "getProjectColor", "colorStorage", "Lcom/intellij/ide/ProjectColorStorage;", "getOrGenerateAssociatedColorIndex", "getAssociatedColorIndex", "(Lcom/intellij/ide/ProjectColorStorage;)Ljava/lang/Integer;", "dropProjectIconCache", "setIconMainColorAsProjectColor", "setAssociatedColorsIndex", "index", "setCustomProjectColor", "color", "setupWorkspaceStorage", "setupWorkspaceStorage$intellij_platform_ide_impl", "clearToolbarColorsAndInMemoryCache", "nextColorIndex", "Lcom/intellij/ide/util/PropertiesComponent;", "colorsCount", "storageFor", "Lcom/intellij/ide/RecentProjectColorStorage;", "Lcom/intellij/ide/WorkspaceProjectColorStorage;", "update", "newValue", "update$intellij_platform_ide_impl", "isAvailable", "isActive", "enableIfNeeded", "addListener", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "fireFirstTime", "listener", "fireUpdate", "doPaint", "paint", "window", "Ljava/awt/Window;", "parent", "g", "Ljava/awt/Graphics2D;", "dispose", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nProjectWindowCustomizerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectWindowCustomizerService.kt\ncom/intellij/ide/ProjectWindowCustomizerService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,638:1\n30#2,2:639\n58#2:642\n30#2,2:650\n30#2,2:652\n30#2,2:656\n1#3:641\n383#4,7:643\n1915#5,2:654\n13#6:658\n*S KotlinDebug\n*F\n+ 1 ProjectWindowCustomizerService.kt\ncom/intellij/ide/ProjectWindowCustomizerService\n*L\n194#1:639,2\n218#1:642\n283#1:650,2\n290#1:652,2\n439#1:656,2\n228#1:643,7\n414#1:654,2\n136#1:658\n*E\n"})
public final class ProjectWindowCustomizerService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean wasGradientPainted = ProjectWindowCustomizerServiceKt.access$isForceColorfulToolbar();
    private boolean ourSettingsValue = UISettings.Companion.getInstance().getDifferentiateProjects();
    @NotNull
    private final HashMap<Path, ProjectColors> colorCache = new HashMap();
    @NotNull
    private final List<Function1<Boolean, Unit>> listeners = new ArrayList();
    @NotNull
    private final ProjectColors defaultColors = new ProjectColors(this.getGradientColors()[0], (Color)ProjectIconPalette.INSTANCE.getGradients()[0].getFirst(), (Color)ProjectIconPalette.INSTANCE.getGradients()[0].getSecond(), 0);
    @NotNull
    private final HashSet<JComponent> gradientRepaintRoots = new HashSet();
    @NotNull
    private final Map<Integer, ProjectGradients> allGradients = new LinkedHashMap();
    @Nullable
    private static ProjectWindowCustomizerService instance;
    @NotNull
    private static GradientTextureCache leftGradientCache;
    @NotNull
    private static GradientTextureCache rightGradientCache;
    @NotNull
    private static final Logger LOG;

    private final Color[] getGradientColors() {
        Color[] colorArray = new Color[9];
        Intrinsics.checkNotNullExpressionValue((Object)JBColor.namedColor((String)"RecentProject.Color1.MainToolbarGradientStart", (Color)((Color)new JBColor(14368060, 13517884))), (String)"namedColor(...)");
        Intrinsics.checkNotNullExpressionValue((Object)JBColor.namedColor((String)"RecentProject.Color2.MainToolbarGradientStart", (Color)((Color)new JBColor(16085558, 14840375))), (String)"namedColor(...)");
        Intrinsics.checkNotNullExpressionValue((Object)JBColor.namedColor((String)"RecentProject.Color3.MainToolbarGradientStart", (Color)((Color)new JBColor(2869435, 2997421))), (String)"namedColor(...)");
        Intrinsics.checkNotNullExpressionValue((Object)JBColor.namedColor((String)"RecentProject.Color4.MainToolbarGradientStart", (Color)((Color)new JBColor(3513074, 3708385))), (String)"namedColor(...)");
        Intrinsics.checkNotNullExpressionValue((Object)JBColor.namedColor((String)"RecentProject.Color5.MainToolbarGradientStart", (Color)((Color)new JBColor(8616443, 8091112))), (String)"namedColor(...)");
        Intrinsics.checkNotNullExpressionValue((Object)JBColor.namedColor((String)"RecentProject.Color6.MainToolbarGradientStart", (Color)((Color)new JBColor(8279221, 7885997))), (String)"namedColor(...)");
        Intrinsics.checkNotNullExpressionValue((Object)JBColor.namedColor((String)"RecentProject.Color7.MainToolbarGradientStart", (Color)((Color)new JBColor(14040264, 9389459))), (String)"namedColor(...)");
        Intrinsics.checkNotNullExpressionValue((Object)JBColor.namedColor((String)"RecentProject.Color8.MainToolbarGradientStart", (Color)((Color)new JBColor(9781908, 13123769))), (String)"namedColor(...)");
        Intrinsics.checkNotNullExpressionValue((Object)JBColor.namedColor((String)"RecentProject.Color9.MainToolbarGradientStart", (Color)((Color)new JBColor(15160177, 14111600))), (String)"namedColor(...)");
        return colorArray;
    }

    private static /* synthetic */ void getGradientColors$annotations() {
    }

    public final void addGradientRepaintRoot$intellij_platform_ide_impl(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.gradientRepaintRoots.add(component2);
    }

    public final void removeGradientRepaintRoot$intellij_platform_ide_impl(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.gradientRepaintRoots.remove(component2);
    }

    @NotNull
    public final Set<JComponent> getGradientRepaintRoots$intellij_platform_ide_impl() {
        return this.gradientRepaintRoots;
    }

    @NotNull
    public final Icon getProjectIcon(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ProjectWindowCustomizerIconCache> serviceClass$iv = ProjectWindowCustomizerIconCache.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (Icon)((ProjectWindowCustomizerIconCache)object).cachedIcon.get();
    }

    @ApiStatus.Internal
    @NotNull
    public final Color getGradientProjectColor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Color color = this.getDeprecatedCustomToolbarColor(project2);
        if (color == null) {
            Color color2;
            WorkspaceProjectColorStorage workspaceProjectColorStorage = this.storageFor(project2);
            if (workspaceProjectColorStorage != null) {
                WorkspaceProjectColorStorage it = workspaceProjectColorStorage;
                boolean bl = false;
                color2 = this.getProjectColor(it).getGradient();
            } else {
                color2 = color = null;
            }
            if (color2 == null) {
                color = this.defaultColors.getGradient();
            }
        }
        return color;
    }

    @ApiStatus.Internal
    @NotNull
    public final Color getProjectColorToCustomize(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Color color = this.getDeprecatedCustomToolbarColor(project2);
        if (color == null) {
            Color color2;
            WorkspaceProjectColorStorage workspaceProjectColorStorage = this.storageFor(project2);
            if (workspaceProjectColorStorage != null) {
                WorkspaceProjectColorStorage it = workspaceProjectColorStorage;
                boolean bl = false;
                color2 = this.getProjectColor(it).getIconColorStart();
            } else {
                color2 = color = null;
            }
            if (color2 == null) {
                color = this.defaultColors.getIconColorStart();
            }
        }
        return color;
    }

    @ApiStatus.Internal
    @NotNull
    public final Pair<Color, Color> getRecentProjectIconColor(@NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        ProjectColors projectColors = this.getProjectColor(this.storageFor(projectPath));
        return new Pair((Object)projectColors.getIconColorStart(), (Object)projectColors.getIconColorEnd());
    }

    private final Color getDeprecatedCustomToolbarColor(Project project2) {
        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project2;
        boolean $i$f$serviceIfCreated = false;
        PropertiesComponent propertiesComponent = (PropertiesComponent)$this$serviceIfCreated$iv.getServiceIfCreated(PropertiesComponent.class);
        String colorStr = propertiesComponent != null ? propertiesComponent.getValue("PROJECT_TOOLBAR_COLOR") : null;
        return ColorHexUtil.fromHex((String)colorStr, null);
    }

    @ApiStatus.Internal
    @Nullable
    public final Integer getCurrentProjectColorIndex(@NotNull Project project2) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        WorkspaceProjectColorStorage workspaceProjectColorStorage = this.storageFor(project2);
        if (workspaceProjectColorStorage != null) {
            WorkspaceProjectColorStorage it = workspaceProjectColorStorage;
            boolean bl = false;
            n = this.getProjectColor(it).getIndex();
        } else {
            n = null;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProjectGradients getProjectGradients$intellij_platform_ide_impl(@NotNull Project project2) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Integer n = this.getCurrentProjectColorIndex(project2);
        int index = n != null ? n : 0;
        Map<Integer, ProjectGradients> map2 = this.allGradients;
        Integer key$iv = index;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ProjectGradients answer$iv = new ProjectGradients(index + 1);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (ProjectGradients)object;
    }

    private final ProjectColors getProjectColor(ProjectColorStorage colorStorage) {
        ThreadingAssertions.assertEventDispatchThread();
        Path path = colorStorage.getProjectPath();
        if (path == null) {
            return this.defaultColors;
        }
        Path projectPath = path;
        ProjectColors projectColors = this.colorCache.computeIfAbsent(projectPath, arg_0 -> ProjectWindowCustomizerService.getProjectColor$lambda$1(arg_0 -> ProjectWindowCustomizerService.getProjectColor$lambda$0(colorStorage, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)projectColors, (String)"computeIfAbsent(...)");
        return projectColors;
    }

    private final int getOrGenerateAssociatedColorIndex(ProjectColorStorage colorStorage) {
        Integer n = this.getAssociatedColorIndex(colorStorage);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            return it;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance(...)");
        int index = this.nextColorIndex(propertiesComponent, this.getGradientColors().length);
        this.setAssociatedColorsIndex(colorStorage, index);
        return index;
    }

    private final Integer getAssociatedColorIndex(ProjectColorStorage colorStorage) {
        Integer n = colorStorage.getAssociatedIndex();
        if (n == null) {
            return null;
        }
        int index = n;
        if (index >= 0 && index < this.getGradientColors().length) {
            return index;
        }
        return null;
    }

    @ApiStatus.Internal
    public final void dropProjectIconCache(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ProjectWindowCustomizerIconCache> serviceClass$iv = ProjectWindowCustomizerIconCache.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((ProjectWindowCustomizerIconCache)object).cachedIcon.drop();
    }

    @ApiStatus.Internal
    public final boolean setIconMainColorAsProjectColor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!RecentProjectsManagerBase.Companion.getInstanceEx().hasCustomIcon(project2)) {
            return false;
        }
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ProjectWindowCustomizerIconCache> serviceClass$iv = ProjectWindowCustomizerIconCache.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Icon icon2 = (Icon)((ProjectWindowCustomizerIconCache)object).cachedIcon.get();
        if (icon2 instanceof AvatarIcon) {
            LOG.warn("Unexpected cached AvatarIcon as a custom icon during the project color setup");
            return false;
        }
        Color iconMainColor = IconUtil.INSTANCE.mainColor(icon2);
        this.setCustomProjectColor(project2, iconMainColor);
        return true;
    }

    @ApiStatus.Internal
    public final void setAssociatedColorsIndex(@NotNull Project project2, int index) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        WorkspaceProjectColorStorage workspaceProjectColorStorage = this.storageFor(project2);
        if (workspaceProjectColorStorage == null) {
            return;
        }
        WorkspaceProjectColorStorage storage = workspaceProjectColorStorage;
        this.setAssociatedColorsIndex(storage, index);
    }

    private final void setAssociatedColorsIndex(ProjectColorStorage colorStorage, int index) {
        colorStorage.setAssociatedIndex(index);
        if (index >= 0) {
            colorStorage.setCustomColor(null);
        }
    }

    @ApiStatus.Internal
    public final void setCustomProjectColor(@NotNull Project project2, @Nullable Color color) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        WorkspaceProjectColorStorage workspaceProjectColorStorage = this.storageFor(project2);
        if (workspaceProjectColorStorage == null) {
            return;
        }
        WorkspaceProjectColorStorage storage = workspaceProjectColorStorage;
        this.setCustomProjectColor(storage, color);
    }

    private final void setCustomProjectColor(ProjectColorStorage colorStorage, Color color) {
        String string;
        this.clearToolbarColorsAndInMemoryCache(colorStorage);
        ProjectColorStorage projectColorStorage = colorStorage;
        Color color2 = color;
        if (color2 != null) {
            Color color3 = color2;
            ProjectColorStorage projectColorStorage2 = projectColorStorage;
            boolean bl = false;
            string = ColorUtil.toHex((Color)color, (boolean)true);
            projectColorStorage = projectColorStorage2;
        } else {
            string = null;
        }
        projectColorStorage.setCustomColor(string);
    }

    @ApiStatus.Internal
    public final void setupWorkspaceStorage$intellij_platform_ide_impl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.clearToolbarColorsAndInMemoryCache(project2);
        WorkspaceProjectColorStorage workspaceStorage = new WorkspaceProjectColorStorage(project2);
        if (!workspaceStorage.isEmpty()) {
            return;
        }
        if (RecentProjectsManagerBase.Companion.getInstanceEx().hasCustomIcon(project2)) {
            this.setIconMainColorAsProjectColor(project2);
            return;
        }
        Path path = Companion.projectPath(project2);
        if (path == null) {
            return;
        }
        Path path2 = path;
        RecentProjectColorStorage recentProjectsStorage = new RecentProjectColorStorage(path2);
        if (recentProjectsStorage.isEmpty()) {
            this.getOrGenerateAssociatedColorIndex(workspaceStorage);
        } else {
            workspaceStorage.getDataFrom(recentProjectsStorage);
        }
    }

    @ApiStatus.Internal
    public final void clearToolbarColorsAndInMemoryCache(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        WorkspaceProjectColorStorage workspaceProjectColorStorage = this.storageFor(project2);
        if (workspaceProjectColorStorage == null) {
            return;
        }
        WorkspaceProjectColorStorage storage = workspaceProjectColorStorage;
        this.clearToolbarColorsAndInMemoryCache(storage);
    }

    private final void clearToolbarColorsAndInMemoryCache(ProjectColorStorage colorStorage) {
        ThreadingAssertions.assertEventDispatchThread();
        Path path = colorStorage.getProjectPath();
        if (path != null) {
            Path it = path;
            boolean bl = false;
            this.colorCache.remove(it);
        }
        if (colorStorage instanceof WorkspaceProjectColorStorage) {
            PropertiesComponent.getInstance((Project)((WorkspaceProjectColorStorage)colorStorage).getProject()).unsetValue("PROJECT_TOOLBAR_COLOR");
        }
    }

    private final int nextColorIndex(PropertiesComponent $this$nextColorIndex, int colorsCount) {
        int randomDefault = new Random().nextInt(colorsCount);
        int result2 = ($this$nextColorIndex.getInt("LAST_CALCULATED_COLOR_INDEX_KEY", randomDefault) + 1) % colorsCount;
        $this$nextColorIndex.setValue("LAST_CALCULATED_COLOR_INDEX_KEY", result2, -1);
        return result2;
    }

    private final RecentProjectColorStorage storageFor(Path projectPath) {
        return new RecentProjectColorStorage(projectPath);
    }

    private final WorkspaceProjectColorStorage storageFor(Project project2) {
        return project2.isDisposed() ? null : new WorkspaceProjectColorStorage(project2);
    }

    public final void update$intellij_platform_ide_impl(boolean newValue) {
        if (newValue != this.ourSettingsValue) {
            this.ourSettingsValue = newValue;
            this.wasGradientPainted = newValue && ProjectWindowCustomizerServiceKt.access$conditionToEnable();
            this.fireUpdate();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAvailable() {
        boolean bl;
        if (DistractionFreeModeController.shouldMinimizeCustomHeader()) return false;
        InternalUICustomization internalUICustomization = InternalUICustomization.Companion.getInstance();
        if (internalUICustomization != null) {
            if (!internalUICustomization.isProjectCustomDecorationActive()) {
                return false;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return false;
        if (PlatformUtils.isRider()) return true;
        if (!Registry.Companion.is("ide.colorful.toolbar", true)) return false;
        return true;
    }

    public final boolean isActive() {
        return this.wasGradientPainted && this.ourSettingsValue && this.isAvailable();
    }

    public final void enableIfNeeded() {
        if (!this.wasGradientPainted && ProjectWindowCustomizerServiceKt.access$conditionToEnable()) {
            this.wasGradientPainted = true;
            this.fireUpdate();
        }
    }

    public final void addListener(@NotNull CoroutineScope coroutineScope, boolean fireFirstTime, @NotNull Function1<? super Boolean, Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        if (fireFirstTime) {
            listener2.invoke((Object)this.isActive());
        }
        this.listeners.add(listener2);
        JobKt.getJob((CoroutineContext)coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> ProjectWindowCustomizerService.addListener$lambda$0(this, listener2, arg_0));
    }

    private final void fireUpdate() {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)this.isActive());
        }
    }

    private final boolean doPaint() {
        InternalUICustomization customization = InternalUICustomization.Companion.getInstance();
        return customization == null || customization.isProjectCustomDecorationGradientPaint();
    }

    public final boolean paint(@NotNull Window window, @NotNull JComponent parent, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!this.isActive() || !this.doPaint()) {
            return false;
        }
        ProjectFrameHelper projectFrameHelper = ProjectFrameHelper.Companion.getFrameHelper(window);
        if (projectFrameHelper == null) {
            return false;
        }
        ProjectFrameHelper frameHelper = projectFrameHelper;
        Project project2 = frameHelper.getProject();
        if (project2 == null) {
            return false;
        }
        Project project3 = project2;
        g.setColor(parent.getBackground());
        int height = parent.getHeight();
        g.fillRect(0, 0, parent.getWidth(), height);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Color color = this.getGradientProjectColor(project3);
        int length = Registry.Companion.intValue("ide.colorful.toolbar.gradient.radius", 300);
        ComponentManager $this$service$iv = (ComponentManager)project3;
        boolean $i$f$service = false;
        Class<ProjectWidgetGradientLocationService> serviceClass$iv = ProjectWidgetGradientLocationService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        float offset = ((ProjectWidgetGradientLocationService)object).getGradientOffsetRelativeToRootPane();
        List list2 = ComponentUtil.findComponentsOfType((JComponent)parent, MainToolbar.class);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"findComponentsOfType(...)");
        if (CollectionsKt.firstOrNull((List)list2) == null && !CustomWindowHeaderUtil.INSTANCE.isToolbarInHeader$intellij_platform_ide_impl(UISettings.Companion.getInstance(), frameHelper.isInFullScreen())) {
            return true;
        }
        double saturation = RangesKt.coerceIn((double)Registry.Companion.doubleValue("ide.colorful.toolbar.gradient.saturation", 0.85), (double)0.0, (double)1.0) * ((double)color.getAlpha() / (double)255);
        Color color2 = ColorUtil.blendColorsInRgb((Color)parent.getBackground(), (Color)color, (double)saturation);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"blendColorsInRgb(...)");
        Color blendedColor = color2;
        PaintUtil.alignTxToInt((Graphics2D)g, null, (boolean)true, (boolean)false, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
        ScaleContext ctx = ScaleContext.Companion.create(g);
        int leftX = PaintUtil.alignIntToInt((int)((int)RangesKt.coerceAtLeast((float)(offset - (float)length), (float)0.0f)), (ScaleContext)ctx, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, null);
        int leftWidth = PaintUtil.alignIntToInt((int)((int)(offset - (float)leftX)), (ScaleContext)ctx, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL, null);
        int rightX = leftX + leftWidth;
        int rightWidth = PaintUtil.alignIntToInt((int)length, (ScaleContext)ctx, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL, null);
        Color color3 = parent.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getBackground(...)");
        TexturePaint leftGradientTexture = GradientTextureCache.getHorizontalTexture$default(leftGradientCache, g, leftWidth, color3, blendedColor, leftX, 0, 32, null);
        Color color4 = parent.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"getBackground(...)");
        TexturePaint rightGradientTexture = GradientTextureCache.getHorizontalTexture$default(rightGradientCache, g, rightWidth, blendedColor, color4, rightX, 0, 32, null);
        g.setPaint(leftGradientTexture);
        g.fillRect(leftX, 0, leftWidth, height);
        g.setPaint(rightGradientTexture);
        g.fillRect(rightX, 0, rightWidth, height);
        return true;
    }

    public void dispose() {
    }

    /*
     * Unable to fully structure code
     */
    private static final ProjectColors getProjectColor$lambda$0(ProjectColorStorage $colorStorage, ProjectWindowCustomizerService this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($colorStorage instanceof WorkspaceProjectColorStorage && $colorStorage.isEmpty()) {
            this$0.setupWorkspaceStorage$intellij_platform_ide_impl(((WorkspaceProjectColorStorage)$colorStorage).getProject());
        }
        if ((v0 = $colorStorage.getCustomColor()) == null) ** GOTO lbl-1000
        it = var5_3 = v0;
        $i$a$-takeIf-ProjectWindowCustomizerService$getProjectColor$1$customColors$1 = false;
        v0 = ((CharSequence)it).length() > 0 != false ? var5_3 : null;
        if (v0 != null) {
            it = v0;
            $i$a$-let-ProjectWindowCustomizerService$getProjectColor$1$customColors$2 = false;
            v1 = ColorHexUtil.fromHex((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"fromHex(...)");
            color = v1;
            v2 = ColorUtil.toAlpha((Color)color, (int)90);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toAlpha(...)");
            toolbarColor = v2;
            v3 = new ProjectColors(toolbarColor, color, color, null, 8, null);
        } else lbl-1000:
        // 2 sources

        {
            v3 = customColors = null;
        }
        if (customColors != null) {
            v4 = customColors;
        } else {
            associatedIndex = this$0.getOrGenerateAssociatedColorIndex($colorStorage);
            v4 = new ProjectColors(this$0.getGradientColors()[associatedIndex], (Color)ProjectIconPalette.INSTANCE.getGradients()[associatedIndex].getFirst(), (Color)ProjectIconPalette.INSTANCE.getGradients()[associatedIndex].getSecond(), associatedIndex);
        }
        return v4;
    }

    private static final ProjectColors getProjectColor$lambda$1(Function1 $tmp0, Object p0) {
        return (ProjectColors)$tmp0.invoke(p0);
    }

    private static final Unit addListener$lambda$0(ProjectWindowCustomizerService this$0, Function1 $listener, Throwable it) {
        this$0.listeners.remove($listener);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$0() {
        instance = null;
    }

    static {
        leftGradientCache = new GradientTextureCache();
        rightGradientCache = new GradientTextureCache();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProjectWindowCustomizerService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        ApplicationManager.registerCleaner(ProjectWindowCustomizerService::_init_$lambda$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/ProjectWindowCustomizerService$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/ide/ProjectWindowCustomizerService;", "leftGradientCache", "Lcom/intellij/ide/ui/GradientTextureCache;", "rightGradientCache", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "projectPath", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nProjectWindowCustomizerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectWindowCustomizerService.kt\ncom/intellij/ide/ProjectWindowCustomizerService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,638:1\n42#2,3:639\n*S KotlinDebug\n*F\n+ 1 ProjectWindowCustomizerService.kt\ncom/intellij/ide/ProjectWindowCustomizerService$Companion\n*L\n145#1:639,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProjectWindowCustomizerService getInstance() {
            ProjectWindowCustomizerService result2 = instance;
            if (result2 == null) {
                boolean $i$f$service = false;
                Class<ProjectWindowCustomizerService> serviceClass$iv = ProjectWindowCustomizerService.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                result2 = (ProjectWindowCustomizerService)object;
                instance = result2;
            }
            return result2;
        }

        @ApiStatus.Internal
        @Nullable
        public final Path projectPath(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return RecentProjectsManagerBase.Companion.getInstanceEx().getProjectPath(project2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

