/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.SwitcherToolWindow;
import com.intellij.ide.actions.SwitcherVirtualFile;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a.\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\nH\u0002\u001a$\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a0\u0010\u0015\u001a\u00020\n2\u0016\u0010\u0016\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u001a(\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00182\u0016\u0010\u0016\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0002\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001d\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"ACTION_PLACE", "", "SWITCHER_ELEMENTS_LIMIT", "", "getFilesToShow", "", "Lcom/intellij/ide/actions/SwitcherVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "onlyEdited", "", "toolWindowsCount", "pinned", "isTheSameTab", "currentWindow", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "element", "", "getRecentFiles", "addShortcut", "keymap", "", "Lcom/intellij/ide/actions/SwitcherToolWindow;", "window", "shortcut", "addSmartShortcut", "getIndexShortcut", "index", "findAppropriateWindow", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nSwitcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Switcher.kt\ncom/intellij/ide/actions/SwitcherKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,962:1\n3938#2:963\n4474#2,2:964\n*S KotlinDebug\n*F\n+ 1 Switcher.kt\ncom/intellij/ide/actions/SwitcherKt\n*L\n904#1:963\n904#1:964,2\n*E\n"})
public final class SwitcherKt {
    @NotNull
    private static final String ACTION_PLACE = "Switcher";
    private static final int SWITCHER_ELEMENTS_LIMIT = 30;

    private static final List<SwitcherVirtualFile> getFilesToShow(Project project2, boolean onlyEdited, int toolWindowsCount, boolean pinned) {
        List<VirtualFile> filesForInit;
        ArrayList<SwitcherVirtualFile> filesData = new ArrayList<SwitcherVirtualFile>();
        ArrayList<SwitcherVirtualFile> editors = new ArrayList<SwitcherVirtualFile>();
        LinkedHashSet<VirtualFile> addedFiles = new LinkedHashSet<VirtualFile>();
        if (!pinned) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
            Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
            for (Pair<VirtualFile, EditorWindow> pair : ((FileEditorManagerImpl)fileEditorManager).getSelectionHistoryList()) {
                editors.add(new SwitcherVirtualFile(project2, (VirtualFile)pair.getFirst(), (EditorWindow)pair.getSecond()));
            }
            Iterator iterator = editors.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<Object> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object object = iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
                SwitcherVirtualFile editor2 = (SwitcherVirtualFile)object;
                addedFiles.add(editor2.getFile());
                filesData.add(editor2);
                if (filesData.size() < 30) continue;
            }
        }
        if (filesData.size() > 1) {
            return filesData;
        }
        if (onlyEdited) {
            List<VirtualFile> list2 = IdeDocumentHistory.getInstance(project2).getChangedFiles();
            v4 = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getChangedFiles(...)");
        } else {
            v4 = filesForInit = SwitcherKt.getRecentFiles(project2);
        }
        if (!filesForInit.isEmpty()) {
            int i2;
            int editorFileCount = SequencesKt.count((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)editors), SwitcherKt::getFilesToShow$lambda$0)));
            int maxFiles = Math.max(editorFileCount, filesForInit.size());
            int minIndex = pinned ? 0 : filesForInit.size() - RangesKt.coerceAtMost((int)toolWindowsCount, (int)maxFiles);
            if (minIndex <= (i2 = filesForInit.size() - 1)) {
                while (true) {
                    VirtualFile virtualFile = filesForInit.get(i2);
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"get(...)");
                    SwitcherVirtualFile info = new SwitcherVirtualFile(project2, virtualFile, null);
                    boolean add2 = true;
                    if (pinned) {
                        Iterator iterator;
                        Intrinsics.checkNotNullExpressionValue(filesData.iterator(), (String)"iterator(...)");
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                            SwitcherVirtualFile fileInfo = (SwitcherVirtualFile)e;
                            if (!Intrinsics.areEqual((Object)fileInfo.getFile(), (Object)info.getFile())) continue;
                            add2 = false;
                            break;
                        }
                    }
                    if (add2 && addedFiles.add(info.getFile())) {
                        filesData.add(info);
                    }
                    if (i2 == minIndex) break;
                    --i2;
                }
            }
        }
        if (editors.size() == 1 && (filesData.isEmpty() || !Intrinsics.areEqual((Object)((SwitcherVirtualFile)editors.get(0)).getFile(), (Object)((SwitcherVirtualFile)filesData.get(0)).getFile())) && addedFiles.add(((SwitcherVirtualFile)editors.get(0)).getFile())) {
            filesData.add(0, (SwitcherVirtualFile)editors.get(0));
        }
        return filesData;
    }

    private static final boolean isTheSameTab(EditorWindow currentWindow, VirtualFile currentFile, Object element) {
        SwitcherVirtualFile svf = element instanceof SwitcherVirtualFile ? (SwitcherVirtualFile)element : null;
        return svf != null && Intrinsics.areEqual((Object)svf.getFile(), (Object)currentFile) && (svf.getWindow() == null || Intrinsics.areEqual((Object)svf.getWindow(), (Object)currentWindow));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<VirtualFile> getRecentFiles(Project project2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List<VirtualFile> recentFiles = EditorHistoryManager.Companion.getInstance(project2).getFileList();
        Object[] objectArray = FileEditorManager.getInstance((Project)project2).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getOpenFiles(...)");
        Object[] openFiles2 = objectArray;
        HashSet recentFilesSet = new HashSet(recentFiles);
        HashSet openFilesSet = ArraysKt.toHashSet((Object[])openFiles2);
        int index = 0;
        int n = ((Collection)recentFiles).size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (!openFilesSet.contains(recentFiles.get(i2))) continue;
            index = i2;
            break;
        }
        ArrayList result2 = new ArrayList(recentFiles);
        Object[] objectArray2 = openFiles2;
        int n2 = index;
        ArrayList arrayList = result2;
        boolean $i$f$filter = false;
        void var9_13 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n3 = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n3; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            if (!(!recentFilesSet.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        arrayList.addAll(n2, list2);
        return result2;
    }

    private static final boolean addShortcut(Map<String, SwitcherToolWindow> keymap2, SwitcherToolWindow window, String shortcut) {
        if (keymap2.containsKey(shortcut)) {
            return false;
        }
        keymap2.put(shortcut, window);
        window.setMnemonic(shortcut);
        return true;
    }

    private static final boolean addSmartShortcut(SwitcherToolWindow window, Map<String, SwitcherToolWindow> keymap2) {
        String title2 = window.getMainText();
        if (StringUtil.isEmpty((String)title2)) {
            return false;
        }
        int n = title2.length();
        for (int j = 0; j < n; ++j) {
            char c = title2.charAt(j);
            if (!Character.isUpperCase(c) || !SwitcherKt.addShortcut(keymap2, window, String.valueOf(c))) continue;
            return true;
        }
        return false;
    }

    private static final String getIndexShortcut(int index) {
        if (!(0 <= index ? index < 36 : false)) {
            return null;
        }
        String string = Integer.toString(index, CharsKt.checkRadix((int)RangesKt.coerceIn((int)(index + 1), (ClosedRange)((ClosedRange)new IntRange(2, 36)))));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return Strings.toUpperCase((String)string);
    }

    private static final EditorWindow findAppropriateWindow(EditorWindow window) {
        if (window == null) {
            return null;
        }
        if (UISettings.Companion.getInstance().getEditorTabPlacement() == 0) {
            return window.getOwner().getCurrentWindow();
        }
        List windows = SequencesKt.toList(window.getOwner().windows());
        return windows.contains(window) ? window : (EditorWindow)CollectionsKt.firstOrNull((List)windows);
    }

    private static final VirtualFile getFilesToShow$lambda$0(SwitcherVirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFile();
    }

    public static final /* synthetic */ List access$getFilesToShow(Project project2, boolean onlyEdited, int toolWindowsCount, boolean pinned) {
        return SwitcherKt.getFilesToShow(project2, onlyEdited, toolWindowsCount, pinned);
    }

    public static final /* synthetic */ String access$getIndexShortcut(int index) {
        return SwitcherKt.getIndexShortcut(index);
    }

    public static final /* synthetic */ boolean access$addShortcut(Map keymap2, SwitcherToolWindow window, String shortcut) {
        return SwitcherKt.addShortcut(keymap2, window, shortcut);
    }

    public static final /* synthetic */ boolean access$addSmartShortcut(SwitcherToolWindow window, Map keymap2) {
        return SwitcherKt.addSmartShortcut(window, keymap2);
    }

    public static final /* synthetic */ EditorWindow access$findAppropriateWindow(EditorWindow window) {
        return SwitcherKt.findAppropriateWindow(window);
    }

    public static final /* synthetic */ boolean access$isTheSameTab(EditorWindow currentWindow, VirtualFile currentFile, Object element) {
        return SwitcherKt.isTheSameTab(currentWindow, currentFile, element);
    }
}

