/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.ExportToTextFileToolbarAction;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.ide.errorTreeView.MyOccurrenceNavigatorSupport;
import com.intellij.ide.errorTreeView.NavigatableErrorTreeElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeRenderer;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.SimpleErrorData;
import com.intellij.ide.errorTreeView.impl.ErrorTreeViewConfiguration;
import com.intellij.ide.errorTreeView.impl.ErrorViewTextExporter;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.MessageView;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ui.ErrorTreeView;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MutableErrorTreeView;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c9\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t*\u0001%\b\u0016\u0018\u0000 \u00af\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u000e\u00ad\u0001\u00ae\u0001\u00af\u0001\u00b0\u0001\u00b1\u0001\u00b2\u0001\u00b3\u0001BW\b\u0007\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\u0010\b\u0002\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u00107\u001a\u00020\u00142\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u00108\u001a\u00020\fH\u0014J\b\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\f2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010A\u001a\u00020\f2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010F\u001a\u00020:2\u0006\u0010G\u001a\u00020HH\u0016J\b\u0010I\u001a\u00020:H\u0016J \u0010J\u001a\u00020:2\u0006\u0010K\u001a\u00020L2\u000e\u0010M\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010H\u0002J\b\u0010N\u001a\u00020\fH\u0014J\b\u0010O\u001a\u00020:H\u0016JG\u0010P\u001a\u00020:2\u0006\u0010Q\u001a\u00020R2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\n0T2\b\u0010U\u001a\u0004\u0018\u00010V2\u0006\u0010W\u001a\u00020R2\u0006\u0010X\u001a\u00020R2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0016\u00a2\u0006\u0002\u0010[JQ\u0010P\u001a\u00020:2\u0006\u0010Q\u001a\u00020R2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\n0T2\b\u0010\\\u001a\u0004\u0018\u00010V2\b\u0010U\u001a\u0004\u0018\u00010V2\u0006\u0010W\u001a\u00020R2\u0006\u0010X\u001a\u00020R2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0016\u00a2\u0006\u0002\u0010]J\u000e\u0010^\u001a\u00020:2\u0006\u0010K\u001a\u00020LJ\u0010\u0010_\u001a\u00020:2\u0006\u0010K\u001a\u00020LH\u0004JS\u0010P\u001a\u00020:2\u0006\u0010Q\u001a\u00020R2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\n0T2\b\u0010`\u001a\u0004\u0018\u00010\n2\u0006\u0010a\u001a\u00020b2\b\u0010c\u001a\u0004\u0018\u00010\n2\b\u0010d\u001a\u0004\u0018\u00010\n2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0016\u00a2\u0006\u0002\u0010eJ\u001e\u0010f\u001a\u00020\f2\u0006\u0010Q\u001a\u00020R2\u0006\u0010`\u001a\u00020\n2\u0006\u0010a\u001a\u00020bJ\u000e\u0010g\u001a\u00020:2\u0006\u0010h\u001a\u00020\nJ\b\u0010i\u001a\u00020jH\u0016J\b\u0010}\u001a\u00020:H\u0002J#\u0010~\u001a\u00020:2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\u0007\u0010\u0081\u0001\u001a\u00020R2\u0007\u0010\u0082\u0001\u001a\u00020RH\u0002J\u0013\u0010\u0083\u0001\u001a\u00020:2\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0014J\u0012\u0010\u0086\u0001\u001a\u00020:2\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010-J\u0007\u0010\u0088\u0001\u001a\u00020:J\u0007\u0010\u0089\u0001\u001a\u00020\fJ\t\u0010\u008c\u0001\u001a\u00020:H\u0016J!\u0010\u008d\u0001\u001a\u00020:2\u000e\u0010\u008e\u0001\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u001d2\b\u0010\u008f\u0001\u001a\u00030\u0090\u0001J\u0017\u0010\u0091\u0001\u001a\u00020:2\u000e\u0010\u008e\u0001\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u001dJ\u0011\u0010\u0092\u0001\u001a\u00020:2\b\u0010\u008f\u0001\u001a\u00030\u0090\u0001J\u0007\u0010\u0093\u0001\u001a\u00020:J\t\u0010\u0094\u0001\u001a\u00020:H\u0007J\t\u0010\u0095\u0001\u001a\u00020:H\u0002J\u0007\u0010\u0096\u0001\u001a\u00020:J\u0007\u0010\u0097\u0001\u001a\u00020:J\u0019\u0010\u0098\u0001\u001a\u00020\u00012\u000e\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010H\u0002J\u0013\u0010\u0099\u0001\u001a\u00020:2\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0014J\n\u0010\u009a\u0001\u001a\u00030\u009b\u0001H\u0016J\n\u0010\u009c\u0001\u001a\u00030\u009b\u0001H\u0016J\t\u0010\u009d\u0001\u001a\u00020\fH\u0016J\t\u0010\u009e\u0001\u001a\u00020\fH\u0016J\u000f\u0010\u009f\u0001\u001a\b0\n\u00a2\u0006\u0003\b\u00a0\u0001H\u0016J\u000f\u0010\u00a1\u0001\u001a\b0\n\u00a2\u0006\u0003\b\u00a0\u0001H\u0016J\b\u00108\u001a\u00020\fH\u0014J\u0017\u0010\u00a4\u0001\u001a\b\u0012\u0004\u0012\u00020Z0z2\u0006\u0010`\u001a\u00020\nH\u0016J\u0011\u0010\u00a5\u0001\u001a\u00020:2\u0006\u0010h\u001a\u00020\nH\u0016J#\u0010\u00a6\u0001\u001a\u00020:2\u0006\u0010S\u001a\u00020\n2\u0010\u0010\u00a7\u0001\u001a\u000b\u0012\u0007\u0012\u0005\u0018\u00010\u00a8\u00010zH\u0016J%\u0010\u00a9\u0001\u001a\u00020:2\b\u0010\u00aa\u0001\u001a\u00030\u00ab\u00012\u0010\u0010\u00a7\u0001\u001a\u000b\u0012\u0007\u0012\u0005\u0018\u00010\u00a8\u00010zH\u0016J\t\u0010\u00ac\u0001\u001a\u00020:H\u0016R\u0012\u0010\u0007\u001a\u00020\b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\n\u00a2\u0006\u0002\b\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010)\u001a\u00020*8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010B\u001a\u00020C8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0016\u0010k\u001a\u0004\u0018\u00010l8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bm\u0010nR\u0013\u0010o\u001a\u0004\u0018\u00010L8F\u00a2\u0006\u0006\u001a\u0004\bp\u0010qR\u0016\u0010r\u001a\u0004\u0018\u00010s8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bt\u0010uR\u0013\u0010v\u001a\u0004\u0018\u00010V8F\u00a2\u0006\u0006\u001a\u0004\bw\u0010xR\u001a\u0010y\u001a\b\u0012\u0004\u0012\u00020s0z8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b{\u0010|R\u0014\u0010\u008a\u0001\u001a\u00020\f8F\u00a2\u0006\b\u001a\u0006\b\u008a\u0001\u0010\u008b\u0001R\u0014\u0010\u00a2\u0001\u001a\u00020\f8F\u00a2\u0006\b\u001a\u0006\b\u00a2\u0001\u0010\u008b\u0001R\u0014\u0010\u00a3\u0001\u001a\u00020\f8F\u00a2\u0006\b\u001a\u0006\b\u00a3\u0001\u0010\u008b\u0001\u00a8\u0006\u00b4\u0001"}, d2={"Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/UiCompatibleDataProvider;", "Lcom/intellij/ide/OccurenceNavigator;", "Lcom/intellij/util/ui/MutableErrorTreeView;", "Lcom/intellij/ide/CopyProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "helpId", "", "createExitAction", "", "createToolbar", "rerunAction", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "state", "Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel$MessageViewState;", "errorViewStructure", "Lcom/intellij/ide/errorTreeView/ErrorViewStructure;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;ZZLjava/lang/Runnable;Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel$MessageViewState;Lcom/intellij/ide/errorTreeView/ErrorViewStructure;)V", "getErrorViewStructure", "()Lcom/intellij/ide/errorTreeView/ErrorViewStructure;", "structureModel", "Lcom/intellij/ui/tree/StructureTreeModel;", "progressFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "isDisposed", "configuration", "Lcom/intellij/ide/errorTreeView/impl/ErrorTreeViewConfiguration;", "kotlin.jvm.PlatformType", "leftToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "treeExpander", "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel$treeExpander$1", "Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel$treeExpander$1;", "exporterToTextFile", "Lcom/intellij/ide/ExporterToTextFile;", "myTree", "Lcom/intellij/ui/treeStructure/Tree;", "messagePanel", "processController", "Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel$ProcessController;", "progressLabel", "Ljavax/swing/JLabel;", "progressPanel", "autoScrollToSourceHandler", "Lcom/intellij/ui/AutoScrollToSourceHandler;", "occurrenceNavigatorSupport", "Lcom/intellij/ide/errorTreeView/MyOccurrenceNavigatorSupport;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "createErrorViewStructure", "canHideWarnings", "dispose", "", "performCopy", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isCopyEnabled", "isCopyVisible", "emptyText", "Lcom/intellij/util/ui/StatusText;", "getEmptyText", "()Lcom/intellij/util/ui/StatusText;", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "selectFirstMessage", "selectElement", "element", "Lcom/intellij/ide/errorTreeView/ErrorTreeElement;", "onDone", "shouldShowFirstErrorInEditor", "updateTree", "addMessage", "type", "", "text", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "column", "data", "", "(I[Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;IILjava/lang/Object;)V", "underFileGroup", "(I[Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;IILjava/lang/Object;)V", "updateAddedElement", "makeVisible", "groupName", "navigatable", "Lcom/intellij/pom/Navigatable;", "exportTextPrefix", "rendererTextPrefix", "(I[Ljava/lang/String;Ljava/lang/String;Lcom/intellij/pom/Navigatable;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "removeMessage", "removeAllInGroup", "name", "getComponent", "Ljavax/swing/JComponent;", "selectedNavigatableElement", "Lcom/intellij/ide/errorTreeView/NavigatableErrorTreeElement;", "getSelectedNavigatableElement", "()Lcom/intellij/ide/errorTreeView/NavigatableErrorTreeElement;", "selectedErrorTreeElement", "getSelectedErrorTreeElement", "()Lcom/intellij/ide/errorTreeView/ErrorTreeElement;", "selectedNodeDescriptor", "Lcom/intellij/ide/errorTreeView/ErrorTreeNodeDescriptor;", "getSelectedNodeDescriptor", "()Lcom/intellij/ide/errorTreeView/ErrorTreeNodeDescriptor;", "selectedFile", "getSelectedFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "selectedNodeDescriptors", "", "getSelectedNodeDescriptors", "()Ljava/util/List;", "navigateToSource", "popupInvoked", "component", "Ljava/awt/Component;", "x", "y", "addExtraPopupMenuActions", "group", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "setProcessController", "controller", "stopProcess", "canControlProcess", "isProcessStopped", "()Z", "close", "setProgress", "s", "fraction", "", "setProgressText", "setFraction", "clearProgressData", "updateProgress", "initProgressPanel", "collapseAll", "expandAll", "createToolbarPanel", "fillRightToolbarGroup", "goNextOccurence", "Lcom/intellij/ide/OccurenceNavigator$OccurenceInfo;", "goPreviousOccurence", "hasNextOccurence", "hasPreviousOccurence", "getNextOccurenceActionName", "Lorg/jetbrains/annotations/Nls;", "getPreviousOccurenceActionName", "isHideWarnings", "isHideInfos", "getGroupChildrenData", "removeGroup", "addFixedHotfixGroup", "children", "Lcom/intellij/ide/errorTreeView/SimpleErrorData;", "addHotfixGroup", "hotfixData", "Lcom/intellij/ide/errorTreeView/HotfixData;", "reload", "MessageViewState", "ProcessController", "Companion", "RerunAction", "StopAction", "ShowWarningsAction", "ShowInfosAction", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nNewErrorTreeViewPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewErrorTreeViewPanel.kt\ncom/intellij/ide/errorTreeView/NewErrorTreeViewPanel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,690:1\n13#2:691\n*S KotlinDebug\n*F\n+ 1 NewErrorTreeViewPanel.kt\ncom/intellij/ide/errorTreeView/NewErrorTreeViewPanel\n*L\n193#1:691\n*E\n"})
public class NewErrorTreeViewPanel
extends JPanel
implements UiCompatibleDataProvider,
OccurenceNavigator,
MutableErrorTreeView,
CopyProvider,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected Project project;
    @Nullable
    private final String helpId;
    @NotNull
    private final MessageViewState state;
    @NotNull
    private final ErrorViewStructure errorViewStructure;
    @NotNull
    private final StructureTreeModel<ErrorViewStructure> structureModel;
    @NotNull
    private final MutableStateFlow<String> progressFlow;
    private volatile boolean isDisposed;
    private final ErrorTreeViewConfiguration configuration;
    @Nullable
    private ActionToolbar leftToolbar;
    @NotNull
    private final treeExpander.1 treeExpander;
    @NotNull
    private final ExporterToTextFile exporterToTextFile;
    @JvmField
    @NotNull
    protected Tree myTree;
    @NotNull
    private final JPanel messagePanel;
    @Nullable
    private ProcessController processController;
    @Nullable
    private JLabel progressLabel;
    @Nullable
    private JPanel progressPanel;
    @NotNull
    private final AutoScrollToSourceHandler autoScrollToSourceHandler;
    @NotNull
    private final MyOccurrenceNavigatorSupport occurrenceNavigatorSupport;
    @NotNull
    private final CoroutineScope scope;
    @JvmField
    @NotNull
    protected static final Logger LOG;

    @JvmOverloads
    public NewErrorTreeViewPanel(@NotNull Project project2, @Nullable String helpId, boolean createExitAction, boolean createToolbar2, @Nullable Runnable rerunAction, @NotNull MessageViewState state2, @Nullable ErrorViewStructure errorViewStructure) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.project = project2;
        this.helpId = helpId;
        this.state = state2;
        this.progressFlow = StateFlowKt.MutableStateFlow(null);
        this.configuration = ErrorTreeViewConfiguration.getInstance(this.project);
        this.treeExpander = new TreeExpander(this){
            final /* synthetic */ NewErrorTreeViewPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void expandAll() {
                this.this$0.expandAll();
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                this.this$0.collapseAll();
            }

            public boolean canCollapse() {
                return true;
            }
        };
        Project project3 = this.project;
        Intrinsics.checkNotNull((Object)project3, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
        this.scope = CoroutineScopeKt.childScope$default((CoroutineScope)((ComponentManagerEx)project3).getCoroutineScope(), null, (boolean)false, (int)3, null);
        this.setLayout(new BorderLayout());
        this.autoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return configuration.isAutoscrollToSource();
            }

            protected void setAutoScrollMode(boolean state2) {
                configuration.setAutoscrollToSource(state2);
            }
        };
        this.messagePanel = new JPanel(new BorderLayout());
        ErrorViewStructure errorViewStructure2 = errorViewStructure;
        if (errorViewStructure2 == null) {
            errorViewStructure2 = this.createErrorViewStructure(this.project, this.canHideWarnings());
        }
        this.errorViewStructure = errorViewStructure2;
        this.structureModel = new StructureTreeModel<AbstractTreeStructure>(this.errorViewStructure, this);
        this.myTree = new Tree((TreeModel)((Object)new AsyncTreeModel((TreeModel)((Object)this.structureModel), this)));
        this.myTree.setRowHeight(0);
        this.myTree.getEmptyText().setText(IdeBundle.message((String)"errortree.noMessages", (Object[])new Object[0]));
        this.exporterToTextFile = new ErrorViewTextExporter(errorViewStructure);
        this.occurrenceNavigatorSupport = new MyOccurrenceNavigatorSupport(this.myTree);
        this.autoScrollToSourceHandler.install((JTree)this.myTree);
        TreeUtil.installActions((JTree)((JTree)this.myTree));
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setLargeModel(true);
        JScrollPane scrollPane = NewErrorTreeRenderer.install((JTree)this.myTree);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)1));
        this.messagePanel.add((Component)scrollPane, "Center");
        if (createToolbar2) {
            this.add((Component)this.createToolbarPanel(rerunAction), "West");
        }
        this.add((Component)this.messagePanel, "Center");
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                this.popupInvoked(comp, x, y);
            }
        });
        EditSourceOnDoubleClickHandler.install$default((JTree)((JTree)this.myTree), null, (int)2, null);
        EditSourceOnEnterKeyHandler.install((JTree)((JTree)this.myTree));
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NewErrorTreeViewPanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)this.this$0.progressFlow), (long)DurationKt.toDuration((int)100, (DurationUnit)DurationUnit.MILLISECONDS)), (Function2)((Function2)new Function2<String, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ NewErrorTreeViewPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                String string = (String)this.L$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void text2;
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)text2);
                                        this.label = 1;
                                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, (String)text2, null){
                                            int label;
                                            final /* synthetic */ NewErrorTreeViewPanel this$0;
                                            final /* synthetic */ String $text;
                                            {
                                                this.this$0 = $receiver;
                                                this.$text = $text;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.this$0.initProgressPanel();
                                                        if (this.$text == null) {
                                                            JLabel jLabel = this.this$0.progressLabel;
                                                            Intrinsics.checkNotNull((Object)jLabel);
                                                            jLabel.setText("");
                                                        } else {
                                                            float fraction = ((NewErrorTreeViewPanel)this.this$0).state.fraction;
                                                            JLabel jLabel = this.this$0.progressLabel;
                                                            Intrinsics.checkNotNull((Object)jLabel);
                                                            jLabel.setText((String)(fraction > 0.0f ? (int)((double)(fraction * (float)100) + 0.5) + "%  " + this.$text : this.$text));
                                                        }
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(String p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public /* synthetic */ NewErrorTreeViewPanel(Project project2, String string, boolean bl, boolean bl2, Runnable runnable2, MessageViewState messageViewState, ErrorViewStructure errorViewStructure, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            runnable2 = null;
        }
        if ((n & 0x20) != 0) {
            messageViewState = new MessageViewState();
        }
        if ((n & 0x40) != 0) {
            errorViewStructure = null;
        }
        this(project2, string, bl, bl2, runnable2, messageViewState, errorViewStructure);
    }

    @NotNull
    public final ErrorViewStructure getErrorViewStructure() {
        return this.errorViewStructure;
    }

    @NotNull
    protected ErrorViewStructure createErrorViewStructure(@Nullable Project project2, boolean canHideWarnings) {
        return new ErrorViewStructure(project2, canHideWarnings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
        }
        finally {
            this.isDisposed = true;
            this.errorViewStructure.clear();
        }
    }

    public void performCopy(@NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        List<ErrorTreeNodeDescriptor> descriptors2 = this.getSelectedNodeDescriptors();
        if (!descriptors2.isEmpty()) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(CollectionsKt.joinToString$default((Iterable)descriptors2, (CharSequence)"\n", null, null, (int)0, null, NewErrorTreeViewPanel::performCopy$lambda$0, (int)30, null)));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        return !this.getSelectedNodeDescriptors().isEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        return true;
    }

    @NotNull
    public final StatusText getEmptyText() {
        StatusText statusText = this.myTree.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"getEmptyText(...)");
        return statusText;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = PlatformDataKeys.COPY_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"COPY_PROVIDER");
        sink.set(dataKey, (Object)this);
        DataKey dataKey2 = CommonDataKeys.NAVIGATABLE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"NAVIGATABLE");
        NavigatableErrorTreeElement navigatableErrorTreeElement = this.getSelectedNavigatableElement();
        sink.set(dataKey2, navigatableErrorTreeElement != null ? navigatableErrorTreeElement.getNavigatable() : null);
        DataKey dataKey3 = PlatformCoreDataKeys.HELP_ID;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"HELP_ID");
        sink.set(dataKey3, (Object)this.helpId);
        DataKey dataKey4 = PlatformDataKeys.TREE_EXPANDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey4, (String)"TREE_EXPANDER");
        sink.set(dataKey4, (Object)this.treeExpander);
        DataKey dataKey5 = PlatformDataKeys.EXPORTER_TO_TEXT_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey5, (String)"EXPORTER_TO_TEXT_FILE");
        sink.set(dataKey5, (Object)this.exporterToTextFile);
        DataKey dataKey6 = ErrorTreeView.CURRENT_EXCEPTION_DATA_KEY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey6, (String)"CURRENT_EXCEPTION_DATA_KEY");
        ErrorTreeElement errorTreeElement = this.getSelectedErrorTreeElement();
        sink.set(dataKey6, errorTreeElement != null ? errorTreeElement.getData() : null);
    }

    public void selectFirstMessage() {
        ErrorTreeElement firstError = this.errorViewStructure.getFirstMessage(ErrorTreeElementKind.ERROR);
        if (firstError != null) {
            this.selectElement(firstError, () -> NewErrorTreeViewPanel.selectFirstMessage$lambda$0(this));
        } else {
            ErrorTreeElement firstWarning;
            ErrorTreeElement errorTreeElement = this.errorViewStructure.getFirstMessage(ErrorTreeElementKind.WARNING);
            if (errorTreeElement == null) {
                errorTreeElement = this.errorViewStructure.getFirstMessage(ErrorTreeElementKind.NOTE);
            }
            if ((firstWarning = errorTreeElement) == null) {
                Promise promise = TreeUtil.promiseSelectFirst((JTree)((JTree)this.myTree));
                Intrinsics.checkNotNull((Object)promise);
            } else {
                this.selectElement(firstWarning, null);
            }
        }
    }

    private final void selectElement(ErrorTreeElement element, Runnable onDone) {
        this.structureModel.select(element, (JTree)this.myTree, arg_0 -> NewErrorTreeViewPanel.selectElement$lambda$0(onDone, arg_0));
    }

    protected boolean shouldShowFirstErrorInEditor() {
        return false;
    }

    public void updateTree() {
        if (!this.isDisposed) {
            this.structureModel.invalidateAsync();
        }
    }

    public void addMessage(int type, @NotNull String[] text2, @Nullable VirtualFile file2, int line, int column, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.addMessage(type, text2, null, file2, line, column, data2);
    }

    public void addMessage(int type, @NotNull String[] text2, @Nullable VirtualFile underFileGroup, @Nullable VirtualFile file2, int line, int column, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (this.isDisposed) {
            return;
        }
        ErrorTreeElement errorTreeElement = this.errorViewStructure.addMessage(ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)type), text2, underFileGroup, file2, line, column, data2);
        Intrinsics.checkNotNullExpressionValue((Object)errorTreeElement, (String)"addMessage(...)");
        this.updateAddedElement(errorTreeElement);
    }

    public final void updateAddedElement(@NotNull ErrorTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        CompletionStage<Object> future = null;
        Object parent = this.errorViewStructure.getParentElement(element);
        if (parent == null) {
            future = this.structureModel.invalidateAsync();
        } else {
            Object parent2;
            CompletionStage<TreePath> completionStage = parent instanceof GroupingElement ? ((parent2 = this.errorViewStructure.getParentElement(parent)) != null ? this.structureModel.invalidateAsync(parent2, true) : null) : (future = null);
            if (future == null) {
                future = this.structureModel.invalidateAsync(parent, true);
            } else {
                Function2 function2 = updateAddedElement.1.INSTANCE;
                future = ((CompletableFuture)future.handle(new BiFunction(function2){
                    private final /* synthetic */ Function2 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ Object apply(Object p0, Object p1) {
                        return this.function.invoke(p0, p1);
                    }
                })).thenCompose(arg_0 -> NewErrorTreeViewPanel.updateAddedElement$lambda$0(new Function1(this, parent){
                    final /* synthetic */ NewErrorTreeViewPanel this$0;
                    final /* synthetic */ Object $parent;
                    {
                        this.this$0 = $receiver;
                        this.$parent = $parent;
                    }

                    public final CompletionStage<TreePath> invoke(Void it) {
                        return NewErrorTreeViewPanel.access$getStructureModel$p(this.this$0).invalidateAsync(this.$parent, true);
                    }
                }, arg_0));
            }
        }
        if (element.getKind() == ErrorTreeElementKind.ERROR) {
            CompletableFuture<?> completableFuture = future;
            Intrinsics.checkNotNull(completableFuture);
            completableFuture.thenRun(() -> NewErrorTreeViewPanel.updateAddedElement$lambda$1(this, element));
        }
    }

    protected final void makeVisible(@NotNull ErrorTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.structureModel.makeVisible(element, (JTree)this.myTree, arg_0 -> NewErrorTreeViewPanel.makeVisible$lambda$1(NewErrorTreeViewPanel::makeVisible$lambda$0, arg_0));
    }

    public void addMessage(int type, @NotNull String[] text2, @Nullable String groupName, @NotNull Navigatable navigatable, @Nullable String exportTextPrefix, @Nullable String rendererTextPrefix, @Nullable Object data2) {
        String string;
        String exportPrefix;
        String string2;
        VirtualFile file2;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        if (this.isDisposed) {
            return;
        }
        VirtualFile virtualFile = file2 = data2 instanceof VirtualFile ? (VirtualFile)data2 : null;
        if (file2 == null && navigatable instanceof OpenFileDescriptor) {
            file2 = ((OpenFileDescriptor)navigatable).getFile();
        }
        if ((string2 = exportTextPrefix) == null) {
            string2 = exportPrefix = "";
        }
        if ((string = rendererTextPrefix) == null) {
            string = "";
        }
        String renderPrefix = string;
        ErrorTreeElementKind errorTreeElementKind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)type);
        Intrinsics.checkNotNullExpressionValue((Object)errorTreeElementKind, (String)"convertMessageFromCompilerErrorType(...)");
        ErrorTreeElementKind kind = errorTreeElementKind;
        ErrorTreeElement errorTreeElement = this.errorViewStructure.addNavigatableMessage(groupName, navigatable, kind, text2, data2, exportPrefix, renderPrefix, file2);
        Intrinsics.checkNotNullExpressionValue((Object)errorTreeElement, (String)"addNavigatableMessage(...)");
        this.updateAddedElement(errorTreeElement);
    }

    public final boolean removeMessage(int type, @NotNull String groupName, @NotNull Navigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        ErrorTreeElementKind errorTreeElementKind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)type);
        Intrinsics.checkNotNullExpressionValue((Object)errorTreeElementKind, (String)"convertMessageFromCompilerErrorType(...)");
        ErrorTreeElementKind kind = errorTreeElementKind;
        List<NavigatableMessageElement> list2 = this.errorViewStructure.removeNavigatableMessage(groupName, kind, navigatable);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"removeNavigatableMessage(...)");
        List<NavigatableMessageElement> removed = list2;
        if (removed.isEmpty()) {
            return false;
        }
        for (NavigatableMessageElement descriptor2 : removed) {
            Intrinsics.checkNotNull((Object)descriptor2);
            this.updateAddedElement(descriptor2);
        }
        return true;
    }

    public final void removeAllInGroup(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        for (NavigatableMessageElement it : this.errorViewStructure.removeAllNavigatableMessagesInGroup(name2)) {
            Intrinsics.checkNotNull((Object)it);
            this.updateAddedElement(it);
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    private final NavigatableErrorTreeElement getSelectedNavigatableElement() {
        ErrorTreeElement errorTreeElement = this.getSelectedErrorTreeElement();
        return errorTreeElement instanceof NavigatableErrorTreeElement ? (NavigatableErrorTreeElement)((Object)errorTreeElement) : null;
    }

    @Nullable
    public final ErrorTreeElement getSelectedErrorTreeElement() {
        ErrorTreeNodeDescriptor errorTreeNodeDescriptor = this.getSelectedNodeDescriptor();
        return errorTreeNodeDescriptor != null ? errorTreeNodeDescriptor.getElement() : null;
    }

    private final ErrorTreeNodeDescriptor getSelectedNodeDescriptor() {
        return (ErrorTreeNodeDescriptor)((Object)CollectionsKt.singleOrNull(this.getSelectedNodeDescriptors()));
    }

    @Nullable
    public final VirtualFile getSelectedFile() {
        ErrorTreeElement element;
        ErrorTreeNodeDescriptor descriptor2;
        ErrorTreeNodeDescriptor errorTreeNodeDescriptor = descriptor2 = this.getSelectedNodeDescriptor();
        ErrorTreeElement errorTreeElement = element = errorTreeNodeDescriptor != null ? errorTreeNodeDescriptor.getElement() : null;
        if (element != null && !(element instanceof GroupingElement)) {
            ErrorTreeNodeDescriptor errorTreeNodeDescriptor2 = descriptor2;
            Intrinsics.checkNotNull((Object)((Object)errorTreeNodeDescriptor2));
            NodeDescriptor parent = errorTreeNodeDescriptor2.getParentDescriptor();
            if (parent instanceof ErrorTreeNodeDescriptor) {
                element = ((ErrorTreeNodeDescriptor)parent).getElement();
            }
        }
        return element instanceof GroupingElement ? ((GroupingElement)element).getFile() : null;
    }

    private final List<ErrorTreeNodeDescriptor> getSelectedNodeDescriptors() {
        TreePath[] treePathArray = this.isDisposed ? null : this.myTree.getSelectionPaths();
        if (treePathArray == null) {
            return CollectionsKt.emptyList();
        }
        TreePath[] paths = treePathArray;
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (TreePath path : paths) {
            Object object = path.getLastPathComponent();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode lastPathNode = (DefaultMutableTreeNode)object;
            Object userObject = lastPathNode.getUserObject();
            if (!(userObject instanceof ErrorTreeNodeDescriptor)) continue;
            result2.add(userObject);
        }
        return result2;
    }

    private final void navigateToSource() {
        NavigatableErrorTreeElement navigatableErrorTreeElement = this.getSelectedNavigatableElement();
        if (navigatableErrorTreeElement == null) {
            return;
        }
        NavigatableErrorTreeElement element = navigatableErrorTreeElement;
        Navigatable navigatable = element.getNavigatable();
        Intrinsics.checkNotNullExpressionValue((Object)navigatable, (String)"getNavigatable(...)");
        Navigatable navigatable2 = navigatable;
        if (navigatable2.canNavigate()) {
            navigatable2.navigate(false);
        }
    }

    private final void popupInvoked(Component component2, int x, int y) {
        if (this.myTree.getLeadSelectionPath() == null) {
            return;
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        if (this.getData(CommonDataKeys.NAVIGATABLE.getName()) != null) {
            group2.add(ActionManager.getInstance().getAction("EditSource"));
        }
        group2.add(ActionManager.getInstance().getAction("$Copy"));
        group2.add((AnAction)this.autoScrollToSourceHandler.createToggleAction());
        this.addExtraPopupMenuActions(group2);
        group2.addSeparator();
        group2.add(CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)this.treeExpander, (JComponent)this));
        group2.add(CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)this.treeExpander, (JComponent)this));
        group2.addSeparator();
        group2.add((AnAction)new ExportToTextFileToolbarAction(this.exporterToTextFile));
        ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("CompilerMessagesPopup", (ActionGroup)group2);
        Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"createActionPopupMenu(...)");
        ActionPopupMenu menu = actionPopupMenu;
        menu.getComponent().show(component2, x, y);
    }

    protected void addExtraPopupMenuActions(@NotNull DefaultActionGroup group2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
    }

    public final void setProcessController(@Nullable ProcessController controller) {
        this.processController = controller;
    }

    public final void stopProcess() {
        ProcessController processController = this.processController;
        Intrinsics.checkNotNull((Object)processController);
        processController.stopProcess();
    }

    public final boolean canControlProcess() {
        return this.processController != null;
    }

    public final boolean isProcessStopped() {
        ProcessController processController = this.processController;
        Intrinsics.checkNotNull((Object)processController);
        return processController.isProcessStopped();
    }

    public void close() {
        block0: {
            MessageView messageView = MessageView.Companion.getInstance(this.project);
            Content content2 = messageView.getContentManager().getContent((JComponent)this);
            if (content2 == null) break block0;
            Content it = content2;
            boolean bl = false;
            messageView.getContentManager().removeContent(it, true);
            Disposer.dispose((Disposable)this);
        }
    }

    public final void setProgress(@Nullable String s, float fraction) {
        this.state.progressText = s;
        this.state.fraction = fraction;
        this.updateProgress();
    }

    public final void setProgressText(@Nullable String s) {
        this.state.progressText = s;
        this.updateProgress();
    }

    public final void setFraction(float fraction) {
        this.state.fraction = fraction;
        this.updateProgress();
    }

    public final void clearProgressData() {
        this.state.clearProgress();
        this.progressFlow.setValue(null);
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public final void updateProgress() {
        this.progressFlow.setValue((Object)this.state.progressText);
    }

    private final void initProgressPanel() {
        JPanel progressPanel;
        if (this.progressPanel != null) {
            return;
        }
        this.progressPanel = progressPanel = new JPanel(new GridLayout(1, 2));
        this.progressLabel = new JLabel();
        progressPanel.add(this.progressLabel);
        this.messagePanel.add((Component)progressPanel, "South");
        this.messagePanel.validate();
    }

    public final void collapseAll() {
        TreeUtil.collapseAll((JTree)((JTree)this.myTree), (int)2);
    }

    public final void expandAll() {
        block2: {
            Object it;
            TreePath[] selectionPaths = this.myTree.getSelectionPaths();
            TreePath leadSelectionPath = this.myTree.getLeadSelectionPath();
            for (int row2 = 0; row2 < this.myTree.getRowCount(); ++row2) {
                this.myTree.expandRow(row2);
            }
            if (selectionPaths != null) {
                it = selectionPaths;
                boolean bl = false;
                this.myTree.setSelectionPaths(it);
            }
            TreePath treePath = leadSelectionPath;
            if (treePath == null) break block2;
            it = treePath;
            boolean bl = false;
            this.myTree.scrollPathToVisible((TreePath)it);
        }
    }

    private final JPanel createToolbarPanel(Runnable rerunAction) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        AnAction closeMessageViewAction2 = (AnAction)new CloseTabToolbarAction(this){
            final /* synthetic */ NewErrorTreeViewPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.close();
            }
        };
        if (rerunAction != null) {
            group2.add((AnAction)new RerunAction(rerunAction, closeMessageViewAction2));
        }
        group2.add((AnAction)new StopAction());
        if (this.canHideWarnings()) {
            group2.addSeparator();
            group2.add((AnAction)new ShowInfosAction());
            group2.add((AnAction)new ShowWarningsAction());
        }
        this.fillRightToolbarGroup(group2);
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar2 = this.leftToolbar = actionManager.createActionToolbar("CompilerMessagesToolbar", (ActionGroup)group2, false);
        Intrinsics.checkNotNull((Object)actionToolbar2);
        actionToolbar2.setTargetComponent((JComponent)this.messagePanel);
        ActionToolbar actionToolbar3 = this.leftToolbar;
        Intrinsics.checkNotNull((Object)actionToolbar3);
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)actionToolbar3.getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"simplePanel(...)");
        return (JPanel)borderLayoutPanel;
    }

    protected void fillRightToolbarGroup(@NotNull DefaultActionGroup group2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
    }

    @NotNull
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        OccurenceNavigator.OccurenceInfo occurenceInfo = this.occurrenceNavigatorSupport.goNextOccurence();
        Intrinsics.checkNotNullExpressionValue((Object)occurenceInfo, (String)"goNextOccurence(...)");
        return occurenceInfo;
    }

    @NotNull
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        OccurenceNavigator.OccurenceInfo occurenceInfo = this.occurrenceNavigatorSupport.goPreviousOccurence();
        Intrinsics.checkNotNullExpressionValue((Object)occurenceInfo, (String)"goPreviousOccurence(...)");
        return occurenceInfo;
    }

    public boolean hasNextOccurence() {
        return this.occurrenceNavigatorSupport.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.occurrenceNavigatorSupport.hasPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        return this.occurrenceNavigatorSupport.getNextOccurenceActionName();
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        return this.occurrenceNavigatorSupport.getPreviousOccurenceActionName();
    }

    protected boolean canHideWarnings() {
        return true;
    }

    public final boolean isHideWarnings() {
        return this.configuration.isHideWarnings();
    }

    public final boolean isHideInfos() {
        return this.configuration.isHideInfoMessages();
    }

    @NotNull
    public List<Object> getGroupChildrenData(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        List<Object> list2 = this.errorViewStructure.getGroupChildrenData(groupName);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getGroupChildrenData(...)");
        return list2;
    }

    public void removeGroup(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.errorViewStructure.removeGroup(name2);
    }

    public void addFixedHotfixGroup(@NotNull String text2, @NotNull List<? extends SimpleErrorData> children2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(children2, (String)"children");
        this.errorViewStructure.addFixedHotfixGroup(text2, children2);
    }

    public void addHotfixGroup(@NotNull HotfixData hotfixData, @NotNull List<? extends SimpleErrorData> children2) {
        Intrinsics.checkNotNullParameter((Object)hotfixData, (String)"hotfixData");
        Intrinsics.checkNotNullParameter(children2, (String)"children");
        this.errorViewStructure.addHotfixGroup(hotfixData, children2, this);
    }

    public void reload() {
        this.structureModel.invalidateAsync();
    }

    @JvmOverloads
    public NewErrorTreeViewPanel(@NotNull Project project2, @Nullable String helpId, boolean createExitAction, boolean createToolbar2, @Nullable Runnable rerunAction, @NotNull MessageViewState state2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this(project2, helpId, createExitAction, createToolbar2, rerunAction, state2, null, 64, null);
    }

    @JvmOverloads
    public NewErrorTreeViewPanel(@NotNull Project project2, @Nullable String helpId, boolean createExitAction, boolean createToolbar2, @Nullable Runnable rerunAction) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this(project2, helpId, createExitAction, createToolbar2, rerunAction, null, null, 96, null);
    }

    @JvmOverloads
    public NewErrorTreeViewPanel(@NotNull Project project2, @Nullable String helpId, boolean createExitAction, boolean createToolbar2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this(project2, helpId, createExitAction, createToolbar2, null, null, null, 112, null);
    }

    @JvmOverloads
    public NewErrorTreeViewPanel(@NotNull Project project2, @Nullable String helpId, boolean createExitAction) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this(project2, helpId, createExitAction, false, null, null, null, 120, null);
    }

    @JvmOverloads
    public NewErrorTreeViewPanel(@NotNull Project project2, @Nullable String helpId) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this(project2, helpId, false, false, null, null, null, 124, null);
    }

    private static final CharSequence performCopy$lambda$0(ErrorTreeNodeDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        ErrorTreeElement element = it.getElement();
        String string = NewErrorTreeRenderer.calcPrefix(element);
        String[] stringArray = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getText(...)");
        return string + ArraysKt.joinToString$default((Object[])stringArray, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private static final void selectFirstMessage$lambda$0(NewErrorTreeViewPanel this$0) {
        if (this$0.shouldShowFirstErrorInEditor()) {
            ApplicationManager.getApplication().invokeLater(this$0::navigateToSource, this$0.project.getDisposed());
        }
    }

    private static final void selectElement$lambda$0(Runnable $onDone, TreePath it) {
        block0: {
            Runnable runnable2 = $onDone;
            if (runnable2 == null) break block0;
            runnable2.run();
        }
    }

    private static final CompletionStage updateAddedElement$lambda$0(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final void updateAddedElement$lambda$1(NewErrorTreeViewPanel this$0, ErrorTreeElement $element) {
        this$0.makeVisible($element);
    }

    private static final Unit makeVisible$lambda$0(TreePath it) {
        return Unit.INSTANCE;
    }

    private static final void makeVisible$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final String createExportPrefix(int line) {
        return Companion.createExportPrefix(line);
    }

    @JvmStatic
    @NotNull
    public static final String createRendererPrefix(int line, int column) {
        return Companion.createRendererPrefix(line, column);
    }

    @JvmStatic
    @NotNull
    public static final String getQualifiedName(@NotNull VirtualFile file2) {
        return Companion.getQualifiedName(file2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NewErrorTreeViewPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createExportPrefix", "", "line", "", "createRendererPrefix", "column", "getQualifiedName", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String createExportPrefix(int line) {
            String string;
            if (line < 0) {
                string = "";
            } else {
                Object[] objectArray = new Object[]{line};
                String string2 = IdeBundle.message((String)"errortree.prefix.line", (Object[])objectArray);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final String createRendererPrefix(int line, int column) {
            if (line < 0) {
                return "";
            }
            return column < 0 ? "(" + line + ")" : "(" + line + ", " + column + ")";
        }

        @JvmStatic
        @NotNull
        public final String getQualifiedName(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            String string = file2.getPresentableUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableUrl(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nR\u0019\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel$MessageViewState;", "", "<init>", "()V", "progressText", "", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "fraction", "", "clearProgress", "", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static final class MessageViewState {
        @JvmField
        @Nullable
        public volatile String progressText;
        @JvmField
        public volatile float fraction;

        public final void clearProgress() {
            this.progressText = null;
            this.fraction = 0.0f;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel$ProcessController;", "", "stopProcess", "", "isProcessStopped", "", "()Z", "intellij.platform.ide.impl"})
    public static interface ProcessController {
        public void stopProcess();

        public boolean isProcessStopped();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel$RerunAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "rerunAction", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "closeAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel;Ljava/lang/Runnable;Lcom/intellij/openapi/actionSystem/AnAction;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "event", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.ide.impl"})
    private final class RerunAction
    extends DumbAwareAction {
        @NotNull
        private final Runnable rerunAction;
        @NotNull
        private final AnAction closeAction;

        public RerunAction(@NotNull Runnable rerunAction, AnAction closeAction) {
            Intrinsics.checkNotNullParameter((Object)rerunAction, (String)"rerunAction");
            Intrinsics.checkNotNullParameter((Object)closeAction, (String)"closeAction");
            super(IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), null, AllIcons.Actions.Rerun);
            this.rerunAction = rerunAction;
            this.closeAction = closeAction;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.closeAction.actionPerformed(e);
            this.rerunAction.run();
        }

        public void update(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Presentation presentation2 = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
            Presentation presentation3 = presentation2;
            presentation3.setEnabled(NewErrorTreeViewPanel.this.canControlProcess() && NewErrorTreeViewPanel.this.isProcessStopped());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel$ShowInfosAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "(Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel;)V", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "showInfos", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.ide.impl"})
    private final class ShowInfosAction
    extends ToggleAction
    implements DumbAware {
        public ShowInfosAction() {
            super(IdeBundle.messagePointer((String)"action.show.infos", (Object[])new Object[0]), AllIcons.General.ShowInfos);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return !NewErrorTreeViewPanel.this.isHideInfos();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean showInfos) {
            boolean hideInfos;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            boolean bl = hideInfos = !showInfos;
            if (NewErrorTreeViewPanel.this.configuration.isHideInfoMessages() != hideInfos) {
                NewErrorTreeViewPanel.this.configuration.setHideInfoMessages(hideInfos);
                NewErrorTreeViewPanel.this.structureModel.invalidateAsync();
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel$ShowWarningsAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "(Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel;)V", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "showWarnings", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.ide.impl"})
    private final class ShowWarningsAction
    extends ToggleAction
    implements DumbAware {
        public ShowWarningsAction() {
            super(IdeBundle.messagePointer((String)"action.show.warnings", (Object[])new Object[0]), AllIcons.General.ShowWarning);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return !NewErrorTreeViewPanel.this.isHideWarnings();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean showWarnings) {
            boolean hideWarnings;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            boolean bl = hideWarnings = !showWarnings;
            if (NewErrorTreeViewPanel.this.configuration.isHideWarnings() != hideWarnings) {
                NewErrorTreeViewPanel.this.configuration.setHideWarnings(hideWarnings);
                NewErrorTreeViewPanel.this.structureModel.invalidateAsync();
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel$StopAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "event", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.ide.impl"})
    private final class StopAction
    extends DumbAwareAction {
        public StopAction() {
            super(IdeBundle.messagePointer((String)"action.stop", (Object[])new Object[0]), AllIcons.Actions.Suspend);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (NewErrorTreeViewPanel.this.canControlProcess()) {
                NewErrorTreeViewPanel.this.stopProcess();
            }
            ActionToolbar actionToolbar2 = NewErrorTreeViewPanel.this.leftToolbar;
            Intrinsics.checkNotNull((Object)actionToolbar2);
            actionToolbar2.updateActionsImmediately();
        }

        public void update(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Presentation presentation2 = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
            Presentation presentation3 = presentation2;
            presentation3.setEnabled(NewErrorTreeViewPanel.this.canControlProcess() && !NewErrorTreeViewPanel.this.isProcessStopped());
            presentation3.setVisible(NewErrorTreeViewPanel.this.canControlProcess());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }
}

