/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.lightEdit.LightEditConfiguration;
import com.intellij.ide.lightEdit.LightEditConfirmationDialog;
import com.intellij.ide.lightEdit.LightEditFrameWrapper;
import com.intellij.ide.lightEdit.LightEditFrameWrapperKt;
import com.intellij.ide.lightEdit.LightEditPanel;
import com.intellij.ide.lightEdit.LightEditSaveConfirmationHandler;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditServiceImplKt;
import com.intellij.ide.lightEdit.LightEditServiceListener;
import com.intellij.ide.lightEdit.LightEditTabs;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.ide.lightEdit.LightEditorManagerImpl;
import com.intellij.ide.lightEdit.intentions.openInProject.LightEditOpenInProjectIntention;
import com.intellij.ide.lightEdit.project.LightEditProjectImpl;
import com.intellij.ide.lightEdit.project.LightEditProjectManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutineSupport;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="LightEdit", storages={@Storage(value="lightEdit.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u00020\u00050\u0004B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u0006\u0010\"\u001a\u00020\u001fJ\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u0018\u0010'\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010)\u001a\u00020\u0018H\u0002J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020,H\u0002J\u000e\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020,J\u0012\u00101\u001a\u00020,2\b\u00102\u001a\u0004\u0018\u000103H\u0016J\b\u00104\u001a\u00020\u0014H\u0016J\b\u00105\u001a\u00020\u0014H\u0002J\b\u00106\u001a\u00020\u0014H\u0002J\n\u0010=\u001a\u0004\u0018\u00010%H\u0016J\n\u0010>\u001a\u0004\u0018\u00010?H\u0016J\u0016\u0010@\u001a\u00020\u00182\f\u0010A\u001a\b\u0012\u0004\u0012\u00020%0BH\u0016J\b\u0010C\u001a\u00020\u0018H\u0016J\b\u0010D\u001a\u00020\u0018H\u0002J\u0006\u0010E\u001a\u00020\u0018J\u0012\u0010F\u001a\u00020\u00182\b\u00100\u001a\u0004\u0018\u00010,H\u0016J\u0010\u0010G\u001a\u00020\u00182\u0006\u00100\u001a\u00020,H\u0016J\u0018\u0010H\u001a\u00020\u00182\u0006\u00100\u001a\u00020,2\u0006\u0010I\u001a\u00020%H\u0002J\u0010\u0010J\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010P\u001a\u00020\u0018H\u0007J\b\u0010\u0015\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\u000e\u0010Q\u001a\u00020\u00182\u0006\u0010R\u001a\u00020SJ\b\u0010T\u001a\u00020\u0018H\u0016J\u0010\u0010U\u001a\u00020\u00142\u0006\u0010V\u001a\u00020WH\u0016J\u0010\u0010X\u001a\u00020\u00182\u0006\u0010V\u001a\u00020WH\u0016J\b\u0010Z\u001a\u00020\u0014H\u0016J\u0010\u0010[\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\\\u001a\u0002032\u0006\u0010'\u001a\u00020\u0014H\u0016J\b\u0010]\u001a\u00020\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0017\u00107\u001a\u0002088F\u00a2\u0006\f\u0012\u0004\b9\u0010:\u001a\u0004\b;\u0010<R$\u0010L\u001a\u00020\u00142\u0006\u0010K\u001a\u00020\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u0014\u0010Y\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bY\u0010M\u00a8\u0006^"}, d2={"Lcom/intellij/ide/lightEdit/LightEditServiceImpl;", "Lcom/intellij/ide/lightEdit/LightEditService;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/ide/lightEdit/LightEditorListener;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ide/lightEdit/LightEditConfiguration;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "frameWrapper", "Lcom/intellij/ide/lightEdit/LightEditFrameWrapper;", "editorManager", "Lcom/intellij/ide/lightEdit/LightEditorManagerImpl;", "getEditorManager", "()Lcom/intellij/ide/lightEdit/LightEditorManagerImpl;", "configuration", "lightEditProjectManager", "Lcom/intellij/ide/lightEdit/project/LightEditProjectManager;", "editorWindowClosing", "", "saveSession", "getState", "loadState", "", "state", "init", "restoreSession", "showEditorWindow", "doShowEditorWindow", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getOrCreateProject", "openFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "doOpenFile", "suggestSwitchToProject", "processNotOpenedFile", "logStartupTime", "selectEditorTab", "openEditorInfo", "Lcom/intellij/ide/lightEdit/LightEditorInfo;", "addEditorTab", "newEditorInfo", "closeEditor", "editorInfo", "createNewDocument", "preferredSavePath", "Ljava/nio/file/Path;", "closeEditorWindow", "canClose", "autoSaveDocuments", "editPanel", "Lcom/intellij/ide/lightEdit/LightEditPanel;", "getEditPanel$annotations", "()V", "getEditPanel", "()Lcom/intellij/ide/lightEdit/LightEditPanel;", "getSelectedFile", "getSelectedFileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "updateFileStatus", "files", "", "dispose", "closeAndDisposeFrame", "frameDisposed", "afterSelect", "afterClose", "saveEditorAs", "targetFile", "saveToAnotherFile", "value", "isAutosaveMode", "()Z", "setAutosaveMode", "(Z)V", "disposeCurrentSession", "setFrameInfo", "frameInfo", "Lcom/intellij/openapi/wm/impl/FrameInfo;", "saveNewDocuments", "isTabNavigationAvailable", "navigationAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "navigateToTab", "isPreferProjectMode", "isLightEditEnabled", "isLightEditProject", "path", "isForceOpenInLightEditMode", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLightEditServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LightEditServiceImpl.kt\ncom/intellij/ide/lightEdit/LightEditServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,513:1\n1642#2,10:514\n1915#2:524\n1916#2:526\n1652#2:527\n1586#2:528\n1661#2,3:529\n1#3:525\n*S KotlinDebug\n*F\n+ 1 LightEditServiceImpl.kt\ncom/intellij/ide/lightEdit/LightEditServiceImpl\n*L\n316#1:514,10\n316#1:524\n316#1:526\n316#1:527\n382#1:528\n382#1:529,3\n316#1:525\n*E\n"})
public final class LightEditServiceImpl
implements LightEditService,
Disposable,
LightEditorListener,
PersistentStateComponent<LightEditConfiguration> {
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private LightEditFrameWrapper frameWrapper;
    @NotNull
    private final LightEditorManagerImpl editorManager;
    @NotNull
    private LightEditConfiguration configuration;
    @NotNull
    private final LightEditProjectManager lightEditProjectManager;
    private boolean editorWindowClosing;
    private boolean saveSession;

    public LightEditServiceImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.editorManager = new LightEditorManagerImpl(this);
        this.configuration = new LightEditConfiguration();
        this.lightEditProjectManager = new LightEditProjectManager();
        this.getEditorManager().addListener(this);
        SimpleMessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(this.coroutineScope);
        Topic topic = AppLifecycleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new AppLifecycleListener(){

            public void appClosing() {
                boolean $i$f$serviceIfCreated = false;
                Application application = ApplicationManager.getApplication();
                Object object = application != null ? application.getServiceIfCreated(EncodingManager.class) : null;
                EncodingManagerImpl encodingManagerImpl = object instanceof EncodingManagerImpl ? (EncodingManagerImpl)((Object)object) : null;
                if (encodingManagerImpl != null) {
                    encodingManagerImpl.clearDocumentQueue();
                }
                if (frameWrapper != null) {
                    this.closeAndDisposeFrame();
                }
                Disposer.dispose((Disposable)this.getEditorManager());
            }
        });
        CoroutineScopeKt.disposeOnCompletion((Disposable)this.getEditorManager(), (CoroutineScope)this.coroutineScope);
    }

    @NotNull
    public LightEditorManagerImpl getEditorManager() {
        return this.editorManager;
    }

    @NotNull
    public LightEditConfiguration getState() {
        return this.configuration;
    }

    public void loadState(@NotNull LightEditConfiguration state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.configuration = state2;
    }

    private final void init(boolean restoreSession) {
        Project project2 = this.getOrCreateProject();
        LightEditServiceImplKt.access$invokeOnEdt(() -> LightEditServiceImpl.init$lambda$0(this, restoreSession, project2));
    }

    public void showEditorWindow() {
        this.doShowEditorWindow(true);
    }

    private final void doShowEditorWindow(boolean restoreSession) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.init(restoreSession);
        }
    }

    @Nullable
    public Project getProject() {
        return this.lightEditProjectManager.getProject();
    }

    @NotNull
    public final Project getOrCreateProject() {
        return this.lightEditProjectManager.getOrCreateProject();
    }

    @NotNull
    public Project openFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Project project2 = this.lightEditProjectManager.getOrCreateProject();
        LightEditUtil.LightEditCommandLineOptions commandLineOptions = LightEditUtil.getCommandLineOptions();
        LightEditServiceImplKt.access$doWhenActionManagerInitialized(() -> LightEditServiceImpl.openFile$lambda$0(this, file2, commandLineOptions));
        return project2;
    }

    private final void doOpenFile(VirtualFile file2, boolean restoreSession) {
        this.doShowEditorWindow(restoreSession);
        LightEditorInfo openEditorInfo = this.getEditorManager().findOpen(file2);
        if (openEditorInfo == null) {
            LightEditorInfo newEditorInfo = this.getEditorManager().createEditor(file2);
            if (newEditorInfo != null) {
                this.addEditorTab(newEditorInfo);
                LightEditServiceImplKt.access$getLOG$p().info("Opened new tab for " + file2.getPresentableUrl());
                if (Intrinsics.areEqual((Object)file2.getUserData(LightEditUtil.SUGGEST_SWITCH_TO_PROJECT), (Object)true)) {
                    file2.putUserData(LightEditUtil.SUGGEST_SWITCH_TO_PROJECT, null);
                    if (LightEditConfiguration.PreferredMode.LightEdit != this.configuration.getPreferredMode()) {
                        this.suggestSwitchToProject(this.getOrCreateProject(), file2);
                    }
                }
            } else {
                this.processNotOpenedFile(file2);
            }
        } else {
            this.selectEditorTab(openEditorInfo);
            LightEditServiceImplKt.access$getLOG$p().info("Selected tab for " + file2.getPresentableUrl());
        }
        this.logStartupTime();
    }

    private final void suggestSwitchToProject(Project project2, VirtualFile file2) {
        LightEditConfirmationDialog dialog2 = new LightEditConfirmationDialog(project2);
        dialog2.show();
        if (dialog2.isDontAsk()) {
            switch (dialog2.getExitCode()) {
                case 100: {
                    this.configuration.setPreferredMode(LightEditConfiguration.PreferredMode.LightEdit);
                    break;
                }
                case 101: {
                    this.configuration.setPreferredMode(LightEditConfiguration.PreferredMode.Project);
                }
            }
        }
        if (dialog2.getExitCode() == 101) {
            LightEditOpenInProjectIntention.performOn(this.getOrCreateProject(), file2);
        }
    }

    private final void processNotOpenedFile(VirtualFile file2) {
        FileType fileType2 = file2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
        FileType fileType3 = fileType2;
        Project project2 = this.lightEditProjectManager.getProject();
        Intrinsics.checkNotNull((Object)project2);
        Project project3 = project2;
        Object[] objectArray = new Object[]{file2.getPresentableName()};
        Messages.showWarningDialog((Project)project3, (String)ApplicationBundle.message((String)"light.edit.unableToOpenFile.text", (Object[])objectArray), (String)ApplicationBundle.message((String)"light.edit.unableToOpenFile.title", (Object[])new Object[0]));
        LightEditServiceImplKt.access$getLOG$p().info("Failed to open " + file2.getPresentableUrl() + ", binary: " + fileType3.isBinary());
    }

    private final void logStartupTime() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.frameWrapper != null) {
            TabInfo tabInfo = this.getEditPanel().getTabs().getSelectedInfo();
            if (tabInfo == null) {
                return;
            }
            TabInfo info = tabInfo;
            UiNotifyConnector.Companion.doWhenFirstShown$default((UiNotifyConnector.Companion)UiNotifyConnector.Companion, (Component)info.getComponent(), (boolean)false, () -> LightEditServiceImpl.logStartupTime$lambda$0(this), (int)2, null);
        }
    }

    private final void selectEditorTab(LightEditorInfo openEditorInfo) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getEditPanel().getTabs().selectTab(openEditorInfo);
        }
    }

    private final void addEditorTab(LightEditorInfo newEditorInfo) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getEditPanel().getTabs().addEditorTab(newEditorInfo);
        }
    }

    public final void closeEditor(@NotNull LightEditorInfo editorInfo) {
        Intrinsics.checkNotNullParameter((Object)editorInfo, (String)"editorInfo");
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getEditPanel().getTabs().closeTab(editorInfo);
        }
    }

    @NotNull
    public LightEditorInfo createNewDocument(@Nullable Path preferredSavePath) {
        this.showEditorWindow();
        Path path = preferredSavePath;
        String preferredName = path != null && (path = path.getFileName()) != null ? ((Object)path).toString() : null;
        LightEditorInfo lightEditorInfo = this.getEditorManager().createEmptyEditor(preferredName);
        Intrinsics.checkNotNullExpressionValue((Object)lightEditorInfo, (String)"createEmptyEditor(...)");
        LightEditorInfo newEditorInfo = lightEditorInfo;
        newEditorInfo.setPreferredSavePath(preferredSavePath);
        this.addEditorTab(newEditorInfo);
        return newEditorInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeEditorWindow() {
        if (!this.canClose()) {
            LightEditServiceImplKt.access$getLOG$p().info("Close canceled");
            return false;
        }
        LightEditFrameWrapper lightEditFrameWrapper = this.frameWrapper;
        Intrinsics.checkNotNull((Object)lightEditFrameWrapper);
        Project project2 = lightEditFrameWrapper.getProject();
        LightEditFrameWrapper lightEditFrameWrapper2 = this.frameWrapper;
        Intrinsics.checkNotNull((Object)lightEditFrameWrapper2);
        lightEditFrameWrapper2.getFrame().setVisible(false);
        this.saveSession();
        this.editorWindowClosing = true;
        try {
            this.getEditorManager().closeAllEditors();
        }
        finally {
            this.editorWindowClosing = false;
        }
        LightEditServiceImplKt.access$getLOG$p().info("Window closed");
        ((LightEditServiceListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(LightEditServiceListener.Companion.getTOPIC())).lightEditWindowClosed(project2);
        if (ProjectManager.getInstance().getOpenProjects().length == 0 && WelcomeFrame.Companion.getInstance() == null) {
            this.closeAndDisposeFrame();
            LightEditServiceImplKt.access$getLOG$p().info("No open projects or welcome frame, exiting");
            try {
                Disposer.dispose((Disposable)this.getEditorManager());
                ApplicationManager.getApplication().exit();
            }
            catch (Throwable e) {
                LightEditServiceImplKt.access$getLOG$p().error(e);
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        } else {
            WindowManagerEx windowManagerEx = WindowManagerEx.getInstanceEx();
            LightEditFrameWrapper lightEditFrameWrapper3 = this.frameWrapper;
            Intrinsics.checkNotNull((Object)lightEditFrameWrapper3);
            windowManagerEx.releaseFrame(lightEditFrameWrapper3);
            this.frameWrapper = null;
        }
        return false;
    }

    private final boolean canClose() {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager documentManager = fileDocumentManager;
        return !this.getEditorManager().containsUnsavedDocuments() || this.autoSaveDocuments() || LightEditUtil.confirmClose(ApplicationBundle.message((String)"light.edit.exit.message", (Object[])new Object[0]), ApplicationBundle.message((String)"light.edit.exit.title", (Object[])new Object[0]), new LightEditSaveConfirmationHandler(documentManager, this){
            final /* synthetic */ FileDocumentManager $documentManager;
            final /* synthetic */ LightEditServiceImpl this$0;
            {
                this.$documentManager = $documentManager;
                this.this$0 = $receiver;
            }

            public void onSave() {
                this.$documentManager.saveAllDocuments();
            }

            public void onDiscard() {
                Iterator<LightEditorInfo> iterator = this.this$0.getEditorManager().getUnsavedEditors().iterator();
                while (iterator.hasNext()) {
                    VirtualFile file2;
                    LightEditorInfo editorInfo;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)editorInfo.getFile(), (String)"getFile(...)");
                    Document document2 = this.$documentManager.getDocument(file2);
                    if (document2 == null) continue;
                    this.$documentManager.reloadFromDisk(document2);
                }
            }
        });
    }

    private final boolean autoSaveDocuments() {
        if (this.isAutosaveMode()) {
            FileDocumentManager.getInstance().saveAllDocuments();
            return true;
        }
        return false;
    }

    @NotNull
    public final LightEditPanel getEditPanel() {
        boolean bl;
        LightEditFrameWrapper lightEditFrameWrapper = this.frameWrapper;
        Intrinsics.checkNotNull((Object)lightEditFrameWrapper);
        boolean bl2 = bl = !Disposer.isDisposed((Disposable)lightEditFrameWrapper.getLightEditPanel());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        LightEditFrameWrapper lightEditFrameWrapper2 = this.frameWrapper;
        Intrinsics.checkNotNull((Object)lightEditFrameWrapper2);
        return lightEditFrameWrapper2.getLightEditPanel();
    }

    public static /* synthetic */ void getEditPanel$annotations() {
    }

    @Nullable
    public VirtualFile getSelectedFile() {
        LightEditFrameWrapper lightEditFrameWrapper = this.frameWrapper;
        if (lightEditFrameWrapper == null) {
            return null;
        }
        LightEditFrameWrapper frameWrapper = lightEditFrameWrapper;
        LightEditPanel panel2 = frameWrapper.getLightEditPanel();
        if (!Disposer.isDisposed((Disposable)panel2)) {
            return panel2.getTabs().getSelectedFile();
        }
        return null;
    }

    @Nullable
    public FileEditor getSelectedFileEditor() {
        LightEditFrameWrapper lightEditFrameWrapper = this.frameWrapper;
        if (lightEditFrameWrapper == null) {
            return null;
        }
        LightEditFrameWrapper frameWrapper = lightEditFrameWrapper;
        LightEditPanel panel2 = frameWrapper.getLightEditPanel();
        if (!Disposer.isDisposed((Disposable)panel2)) {
            return panel2.getTabs().getSelectedFileEditor();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void updateFileStatus(@NotNull Collection<? extends VirtualFile> files2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Iterable $this$mapNotNull$iv = files2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LightEditorInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (this.getEditorManager().findOpen(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List editors = (List)destination$iv$iv;
        if (!editors.isEmpty()) {
            this.getEditorManager().fireFileStatusChanged(editors);
        }
    }

    public void dispose() {
        if (this.frameWrapper != null) {
            this.closeAndDisposeFrame();
        }
    }

    private final void closeAndDisposeFrame() {
        if (this.frameWrapper != null) {
            LightEditFrameWrapper lightEditFrameWrapper = this.frameWrapper;
            Intrinsics.checkNotNull((Object)lightEditFrameWrapper);
            Disposer.dispose((Disposable)lightEditFrameWrapper);
            LightEditServiceImplKt.access$getLOG$p().info("Frame disposed");
        }
    }

    public final void frameDisposed() {
        this.frameWrapper = null;
    }

    public void afterSelect(@Nullable LightEditorInfo editorInfo) {
        block0: {
            LightEditFrameWrapper lightEditFrameWrapper = this.frameWrapper;
            if (lightEditFrameWrapper == null) break block0;
            LightEditorInfo lightEditorInfo = editorInfo;
            lightEditFrameWrapper.setFrameTitle(lightEditorInfo == null ? LightEditServiceImplKt.access$getAppName() : LightEditServiceImplKt.access$getFileTitle(lightEditorInfo));
        }
    }

    public void afterClose(@NotNull LightEditorInfo editorInfo) {
        Intrinsics.checkNotNullParameter((Object)editorInfo, (String)"editorInfo");
        if (this.getEditorManager().getEditorCount() == 0 && !this.editorWindowClosing) {
            this.closeEditorWindow();
        }
    }

    private final void saveEditorAs(LightEditorInfo editorInfo, VirtualFile targetFile) {
        LightEditorInfo lightEditorInfo = this.getEditorManager().saveAs(editorInfo, targetFile);
        Intrinsics.checkNotNullExpressionValue((Object)lightEditorInfo, (String)"saveAs(...)");
        LightEditorInfo newInfo = lightEditorInfo;
        this.getEditPanel().getTabs().replaceTab(editorInfo, newInfo);
    }

    public void saveToAnotherFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        LightEditorInfo lightEditorInfo = this.getEditorManager().getEditorInfo(file2);
        if (lightEditorInfo == null) {
            return;
        }
        LightEditorInfo editorInfo = lightEditorInfo;
        LightEditFrameWrapper lightEditFrameWrapper = this.frameWrapper;
        Intrinsics.checkNotNull((Object)lightEditFrameWrapper);
        VirtualFile targetFile = LightEditUtil.chooseTargetFile(lightEditFrameWrapper.getLightEditPanel(), editorInfo);
        if (targetFile != null) {
            this.saveEditorAs(editorInfo, targetFile);
        }
    }

    public boolean isAutosaveMode() {
        return this.configuration.getAutosaveMode();
    }

    public void setAutosaveMode(boolean value) {
        this.configuration.setAutosaveMode(value);
        this.getEditorManager().fireAutosaveModeChanged(value);
    }

    @TestOnly
    public final void disposeCurrentSession() {
        this.getEditorManager().releaseEditors();
        Project project2 = this.lightEditProjectManager.getProject();
        if (project2 != null) {
            ProjectManagerEx.Companion.getInstanceEx().forceCloseProject(project2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void saveSession() {
        if (this.saveSession) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            LightEditFrameWrapper lightEditFrameWrapper = this.frameWrapper;
            Intrinsics.checkNotNull((Object)lightEditFrameWrapper);
            LightEditTabs tabs = lightEditFrameWrapper.getLightEditPanel().getTabs();
            List<VirtualFile> openFiles2 = tabs.getOpenFiles();
            Intrinsics.checkNotNull(openFiles2);
            Iterable iterable = openFiles2;
            LightEditConfiguration lightEditConfiguration = this.configuration;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(VfsUtilCore.pathToUrl((String)it.getPath()));
            }
            lightEditConfiguration.setSessionFiles((List)destination$iv$iv);
        }
    }

    private final void restoreSession() {
        LightEditServiceImplKt.access$doWhenActionManagerInitialized(() -> LightEditServiceImpl.restoreSession$lambda$0(this));
    }

    public final void setFrameInfo(@NotNull FrameInfo frameInfo) {
        Intrinsics.checkNotNullParameter((Object)((Object)frameInfo), (String)"frameInfo");
        this.configuration.setFrameInfo(frameInfo);
    }

    public void saveNewDocuments() {
        for (VirtualFile virtualFile : this.getEditorManager().getOpenFiles()) {
            LightEditorInfo editorInfo;
            Intrinsics.checkNotNull((Object)this.getEditorManager().getEditorInfo(virtualFile));
            if (!editorInfo.isNew()) continue;
            VirtualFile preferredTarget = LightEditUtil.getPreferredSaveTarget(editorInfo);
            if (preferredTarget == null) {
                Intrinsics.checkNotNull((Object)virtualFile);
                this.saveToAnotherFile(virtualFile);
                continue;
            }
            this.saveEditorAs(editorInfo, preferredTarget);
        }
    }

    public boolean isTabNavigationAvailable(@NotNull AnAction navigationAction) {
        Intrinsics.checkNotNullParameter((Object)navigationAction, (String)"navigationAction");
        return this.getEditPanel().getTabs().isTabNavigationAvailable(navigationAction);
    }

    public void navigateToTab(@NotNull AnAction navigationAction) {
        Intrinsics.checkNotNullParameter((Object)navigationAction, (String)"navigationAction");
        this.getEditPanel().getTabs().navigateToTab(navigationAction);
    }

    public boolean isPreferProjectMode() {
        return this.configuration.getPreferredMode() != null && LightEditConfiguration.PreferredMode.Project == this.configuration.getPreferredMode();
    }

    public boolean isLightEditEnabled() {
        return LightEditUtil.isLightEditEnabled();
    }

    public boolean isLightEditProject(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return project2 instanceof LightEditProjectImpl;
    }

    @Nullable
    public Project openFile(@NotNull Path path, boolean suggestSwitchToProject) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return LightEditUtil.openFile(path, suggestSwitchToProject);
    }

    public boolean isForceOpenInLightEditMode() {
        return LightEditUtil.isForceOpenInLightEditMode();
    }

    private static final void init$lambda$0(LightEditServiceImpl this$0, boolean $restoreSession, Project $project) {
        boolean notify2 = false;
        if (this$0.frameWrapper == null) {
            this$0.saveSession = $restoreSession;
            this$0.frameWrapper = LightEditFrameWrapperKt.allocateLightEditFrame($project, this$0.configuration.getFrameInfo());
            LightEditServiceImplKt.access$getLOG$p().info("Frame created");
            if ($restoreSession) {
                this$0.restoreSession();
            }
            notify2 = true;
        }
        LightEditFrameWrapper lightEditFrameWrapper = this$0.frameWrapper;
        Intrinsics.checkNotNull((Object)lightEditFrameWrapper);
        IdeFrameImpl frame = lightEditFrameWrapper.getFrame();
        if (!frame.isVisible()) {
            frame.setVisible(true);
            LightEditServiceImplKt.access$getLOG$p().info("Window opened");
            notify2 = true;
        }
        LightEditFrameWrapper lightEditFrameWrapper2 = this$0.frameWrapper;
        Intrinsics.checkNotNull((Object)lightEditFrameWrapper2);
        lightEditFrameWrapper2.setFrameTitle(LightEditServiceImplKt.access$getAppName());
        if (notify2) {
            ((LightEditServiceListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(LightEditServiceListener.Companion.getTOPIC())).lightEditWindowOpened($project);
        }
    }

    private static final Unit openFile$lambda$0(LightEditServiceImpl this$0, VirtualFile $file, LightEditUtil.LightEditCommandLineOptions $commandLineOptions) {
        this$0.doOpenFile($file, $commandLineOptions == null || !$commandLineOptions.shouldWait());
        return Unit.INSTANCE;
    }

    private static final Unit logStartupTime$lambda$0(LightEditServiceImpl this$0) {
        BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, (CoroutineContext)CoroutinesKt.ui$default((Dispatchers)Dispatchers.INSTANCE, (CoroutineSupport.UiDispatcherKind)CoroutineSupport.UiDispatcherKind.STRICT, (boolean)false, (int)2, null), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        LightEditServiceImplKt.access$getLOG$p().info("Startup took: " + ManagementFactory.getRuntimeMXBean().getUptime() + " ms");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit restoreSession$lambda$0(LightEditServiceImpl this$0) {
        LightEditFrameWrapper lightEditFrameWrapper = this$0.frameWrapper;
        Intrinsics.checkNotNull((Object)lightEditFrameWrapper);
        lightEditFrameWrapper.setFrameTitleUpdateEnabled(false);
        for (String path : this$0.configuration.getSessionFiles()) {
            VirtualFile it;
            if (VirtualFileManager.getInstance().findFileByUrl(path) == null) continue;
            boolean bl = false;
            this$0.doOpenFile(it, false);
        }
        LightEditFrameWrapper lightEditFrameWrapper2 = this$0.frameWrapper;
        Intrinsics.checkNotNull((Object)lightEditFrameWrapper2);
        lightEditFrameWrapper2.setFrameTitleUpdateEnabled(true);
        return Unit.INSTANCE;
    }
}

