/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupWrapper;
import com.intellij.openapi.actionSystem.ActionUpdaterInterceptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.DynamicActionGroup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.util.ArrayUtil;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomisedActionGroup
extends ActionGroupWrapper {
    private AnAction[] myChildren;
    private final CustomActionsSchema mySchema;
    private final String myDefaultGroupName;
    private final String myRootGroupName;
    private int mySchemeModificationStamp;
    private int myGroupModificationStamp;

    public CustomisedActionGroup(@NlsActions.ActionText String shortName, @NotNull ActionGroup group2, CustomActionsSchema schema, String defaultGroupName, String name2) {
        if (group2 == null) {
            CustomisedActionGroup.$$$reportNull$$$0(0);
        }
        super(group2);
        this.mySchemeModificationStamp = -1;
        this.myGroupModificationStamp = -1;
        this.getTemplatePresentation().setText(shortName);
        this.mySchema = schema;
        this.myDefaultGroupName = defaultGroupName;
        this.myRootGroupName = name2;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        int currentGroupStamp;
        ActionGroup delegate = this.getDelegate();
        int currentSchemaStamp = CustomActionsSchema.getInstance().getModificationStamp();
        if (!ActionUpdaterInterceptor.Companion.treatDefaultActionGroupAsDynamic() && delegate instanceof DefaultActionGroup) {
            DefaultActionGroup group2 = (DefaultActionGroup)delegate;
            v0 = group2.getModificationStamp();
        } else {
            v0 = currentGroupStamp = -1;
        }
        if (this.mySchemeModificationStamp < currentSchemaStamp || this.myGroupModificationStamp < currentGroupStamp || currentGroupStamp < 0 || ArrayUtil.isEmpty((Object[])this.myChildren) || delegate instanceof DynamicActionGroup) {
            AnAction[] originalChildren = super.getChildren(e);
            this.myChildren = CustomizationUtil.getReordableChildren(delegate, originalChildren, this.mySchema, this.myDefaultGroupName, this.myRootGroupName);
            this.mySchemeModificationStamp = currentSchemaStamp;
            this.myGroupModificationStamp = currentGroupStamp;
        }
        if (this.myChildren == null) {
            CustomisedActionGroup.$$$reportNull$$$0(1);
        }
        return this.myChildren;
    }

    @ApiStatus.Internal
    public AnAction @NotNull [] getDefaultChildrenOrStubs() {
        ActionGroup delegate = this.getDelegate();
        if (!(delegate instanceof DefaultActionGroup)) {
            if (EMPTY_ARRAY == null) {
                CustomisedActionGroup.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        DefaultActionGroup g = (DefaultActionGroup)delegate;
        AnAction[] anActionArray = CustomizationUtil.getReordableChildren(delegate, g.getChildActionsOrStubs(), this.mySchema, this.myDefaultGroupName, this.myRootGroupName);
        if (anActionArray == null) {
            CustomisedActionGroup.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    public void resetChildren() {
        this.myChildren = null;
    }

    public boolean equals(Object obj) {
        return obj instanceof CustomisedActionGroup && Objects.equals(((CustomisedActionGroup)((Object)obj)).getDelegate(), this.getDelegate());
    }

    public int hashCode() {
        return Objects.hash(this.getDelegate());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/customization/CustomisedActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/customization/CustomisedActionGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultChildrenOrStubs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

