/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.newItemPopup;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.SlowOperations;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.AccessibleAnnouncerUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class NewItemSimplePopupPanel
extends JBPanel
implements Disposable {
    protected final ExtendableTextField myTextField;
    protected JBPopup myErrorPopup;
    protected RelativePoint myErrorShowPoint;
    protected Consumer<? super InputEvent> myApplyAction;

    public NewItemSimplePopupPanel() {
        this(false);
    }

    public NewItemSimplePopupPanel(boolean liveValidation) {
        super((LayoutManager)new BorderLayout());
        this.myTextField = this.createTextField(liveValidation);
        this.add((Component)this.myTextField, "North");
        this.setBottomSpace(true);
        if (ExperimentalUI.isNewUI()) {
            this.setBackground(JBUI.CurrentTheme.NewClassDialog.panelBackground());
        }
        this.myErrorShowPoint = new RelativePoint((Component)this.myTextField, new Point(0, this.myTextField.getHeight()));
    }

    public void setApplyAction(@NotNull Consumer<? super InputEvent> applyAction) {
        if (applyAction == null) {
            NewItemSimplePopupPanel.$$$reportNull$$$0(0);
        }
        this.myApplyAction = e -> {
            try (AccessToken ignore = SlowOperations.startSection((String)"action.perform");){
                WriteIntentReadAction.run(() -> applyAction.consume(e));
            }
        };
    }

    @NotNull
    public Consumer<? super InputEvent> getApplyAction() {
        Consumer<? super InputEvent> consumer = this.myApplyAction;
        if (consumer == null) {
            NewItemSimplePopupPanel.$$$reportNull$$$0(1);
        }
        return consumer;
    }

    public void setError(@NlsContexts.DialogMessage String error) {
        this.setMessage(error, false);
    }

    public void setWarning(@NlsContexts.DialogMessage String warning) {
        this.setMessage(warning, true);
    }

    @ApiStatus.Internal
    protected void setBottomSpace(boolean spaceNeeded) {
        if (ExperimentalUI.isNewUI()) {
            this.setBorder((Border)(spaceNeeded ? JBUI.Borders.emptyBottom((int)JBUI.CurrentTheme.Popup.bodyBottomInsetNoAd()) : null));
        }
    }

    private void setMessage(@NlsContexts.DialogMessage String message, boolean isWarning) {
        this.myTextField.putClientProperty((Object)"JComponent.outline", message != null ? (isWarning ? "warning" : "error") : null);
        if (this.myErrorPopup != null && !this.myErrorPopup.isDisposed()) {
            Disposer.dispose((Disposable)this.myErrorPopup);
        }
        if (message == null) {
            return;
        }
        ValidationInfo validationInfo = new ValidationInfo(message, (JComponent)this.myTextField);
        if (isWarning) {
            validationInfo.asWarning();
        }
        ComponentPopupBuilder popupBuilder = ComponentValidator.createPopupBuilder((ValidationInfo)validationInfo, errorHint -> {
            Insets insets = this.myTextField.getInsets();
            Dimension hintSize = errorHint.getPreferredSize();
            Point point = new Point(0, insets.top - JBUIScale.scale((int)6) - hintSize.height);
            this.myErrorShowPoint = new RelativePoint((Component)this.myTextField, point);
        }).setCancelOnWindowDeactivation(false).setCancelOnClickOutside(true);
        if (AccessibleAnnouncerUtil.isAnnouncingAvailable()) {
            AccessibleAnnouncerUtil.announce((Accessible)this.myTextField, (String)UIBundle.message((String)(isWarning ? "validation.info.warning.with.prefix" : "validation.info.error.with.prefix"), (Object[])new Object[]{message}), (boolean)true);
        }
        this.myErrorPopup = popupBuilder.createPopup();
        this.myErrorPopup.show(this.myErrorShowPoint);
    }

    public void dispose() {
        if (this.myErrorPopup != null && !this.myErrorPopup.isDisposed()) {
            Disposer.dispose((Disposable)this.myErrorPopup);
        }
    }

    public JTextField getTextField() {
        return this.myTextField;
    }

    @NotNull
    private ExtendableTextField createTextField(final boolean liveErrorValidation) {
        ExtendableTextField res = new ExtendableTextField();
        int textFieldHeight = ExperimentalUI.isNewUI() ? 32 : 28;
        Dimension minSize = res.getMinimumSize();
        Dimension prefSize = res.getPreferredSize();
        minSize.height = JBUIScale.scale((int)textFieldHeight);
        prefSize.height = JBUIScale.scale((int)textFieldHeight);
        res.setMinimumSize(minSize);
        res.setPreferredSize(prefSize);
        res.setColumns(30);
        ErrorBorder errorBorder = new ErrorBorder(res.getBorder());
        if (ExperimentalUI.isNewUI()) {
            res.setBorder(JBUI.Borders.compound((Border)errorBorder, (Border)JBUI.Borders.emptyLeft((int)13)));
        } else {
            Border border = JBUI.Borders.customLine((Color)JBUI.CurrentTheme.NewClassDialog.bordersColor(), (int)1, (int)0, (int)0, (int)0);
            res.setBorder(JBUI.Borders.compound((Border)border, (Border)errorBorder));
        }
        res.setBackground(JBUI.CurrentTheme.NewClassDialog.searchFieldBackground());
        res.putClientProperty((Object)"StatusVisibleFunction", field -> field.getText().isEmpty());
        res.getEmptyText().setText(IdeBundle.message((String)"action.create.new.class.name.field", (Object[])new Object[0]));
        res.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"action.create.new.class.name.field", (Object[])new Object[0]));
        res.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                NewItemSimplePopupPanel.this.performApplyActionOnEnter(e);
            }
        });
        res.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!liveErrorValidation) {
                    NewItemSimplePopupPanel.this.setError(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/newItemPopup/NewItemSimplePopupPanel$2", "textChanged"));
            }
        });
        ExtendableTextField extendableTextField = res;
        if (extendableTextField == null) {
            NewItemSimplePopupPanel.$$$reportNull$$$0(2);
        }
        return extendableTextField;
    }

    protected void performApplyActionOnEnter(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            if (this.myApplyAction == null) {
                return;
            }
            this.myApplyAction.consume((Object)e);
        }
    }

    public boolean hasError() {
        return this.myErrorPopup != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/newItemPopup/NewItemSimplePopupPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/newItemPopup/NewItemSimplePopupPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplyAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setApplyAction";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static final class ErrorBorder
    implements Border {
        private final Border errorDelegateBorder;

        private ErrorBorder(Border delegate) {
            this.errorDelegateBorder = delegate;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (ErrorBorder.checkError(c)) {
                this.errorDelegateBorder.paintBorder(c, g, x, y, width, height);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return ErrorBorder.checkError(c) ? this.errorDelegateBorder.getBorderInsets(c) : JBInsets.emptyInsets();
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        private static boolean checkError(Component c) {
            DarculaUIUtil.Outline outline = DarculaUIUtil.getOutline((JComponent)c);
            return DarculaUIUtil.isWarningOrError(outline);
        }
    }
}

