/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.CommonBundle;
import com.intellij.ide.ui.search.ConfigurableHit;
import com.intellij.ide.ui.search.IndexedCharsInterner;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchableOptionContributor;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.util.ResourceUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a \u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e2\u0006\u0010\u0016\u001a\u00020\fH\u0002\u001a\u0018\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\fH\u0002\u001a$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u0019\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002\u001a\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0000\u001a,\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0000\u001a,\u0010#\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0000\u001a6\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\f2\b\u0010(\u001a\u0004\u0018\u00010\f2\u0006\u0010)\u001a\u00020*H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006+"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/ide/ui/search/SearchableOptionContributor;", "WORD_SEPARATOR_CHARS", "Ljava/util/regex/Pattern;", "Lorg/jetbrains/annotations/NonNls;", "getWORD_SEPARATOR_CHARS", "()Ljava/util/regex/Pattern;", "loadStopWords", "", "", "filterById", "", "Lcom/intellij/openapi/options/Configurable;", "configurables", "configurableIds", "findGroupsByPath", "Lcom/intellij/ide/ui/search/ConfigurableHit;", "groups", "Lcom/intellij/openapi/options/ConfigurableGroup;", "path", "parseSettingsPath", "skipPrefixIfNeeded", "prefix", "split", "splitToWordsWithoutStemmingAndStopWords", "Ljava/util/stream/Stream;", "text", "collectProcessedWordsWithoutStemming", "", "result", "", "stopWords", "collectProcessedWords", "packSearchableOptions", "", "id", "hit", "groupName", "identifierTable", "Lcom/intellij/ide/ui/search/IndexedCharsInterner;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nSearchableOptionsRegistrarImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchableOptionsRegistrarImpl.kt\ncom/intellij/ide/ui/search/SearchableOptionsRegistrarImplKt\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,594:1\n66#2:595\n1#3:596\n1#3:612\n777#4:597\n873#4,2:598\n812#4,12:600\n13#5:613\n*S KotlinDebug\n*F\n+ 1 SearchableOptionsRegistrarImpl.kt\ncom/intellij/ide/ui/search/SearchableOptionsRegistrarImplKt\n*L\n432#1:595\n432#1:596\n443#1:597\n443#1:598,2\n471#1:600,12\n42#1:613\n*E\n"})
public final class SearchableOptionsRegistrarImplKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ExtensionPointName<SearchableOptionContributor> EP_NAME;
    @NotNull
    private static final Pattern WORD_SEPARATOR_CHARS;

    @NotNull
    public static final Pattern getWORD_SEPARATOR_CHARS() {
        return WORD_SEPARATOR_CHARS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Set<String> loadStopWords() {
        try {
            HashSet hashSet;
            InputStream stream;
            InputStream inputStream = ResourceUtil.getResourceAsStream((ClassLoader)SearchableOptionsRegistrarImpl.class.getClassLoader(), (String)"search", (String)"ignore.txt");
            if (inputStream == null) {
                throw new IOException("Broken installation: IDE does not provide /search/ignore.txt");
            }
            InputStream inputStream2 = stream = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader $this$useLines$iv = new InputStreamReader(inputStream2, charset);
            boolean $i$f$useLines = false;
            Closeable closeable = $this$useLines$iv;
            int n = 8192;
            closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)closeable;
                boolean bl = false;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl2 = false;
                hashSet = SequencesKt.toHashSet((Sequence)SequencesKt.filter((Sequence)lines, SearchableOptionsRegistrarImplKt::loadStopWords$lambda$0$0));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return hashSet;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return SetsKt.emptySet();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Configurable> filterById(Set<? extends Configurable> configurables2, Set<String> configurableIds) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = configurables2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            Configurable configurable = (Configurable)element$iv$iv;
            boolean bl2 = false;
            if (configurable instanceof SearchableConfigurable && configurableIds.contains(((SearchableConfigurable)configurable).getId())) {
                bl = true;
            } else if (configurable instanceof SearchableConfigurable.Merged) {
                for (Configurable mergedConfigurable : ((SearchableConfigurable.Merged)configurable).getMergedConfigurables()) {
                    if (!(mergedConfigurable instanceof SearchableConfigurable) || !configurableIds.contains(((SearchableConfigurable)mergedConfigurable).getId())) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConfigurableHit findGroupsByPath(List<? extends ConfigurableGroup> groups, String path) {
        int $i$f$filterIsInstanceTo;
        List<String> split = SearchableOptionsRegistrarImplKt.parseSettingsPath(path);
        Collection collection = split;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ConfigurableGroup root = (ConfigurableGroup)CollectionsKt.singleOrNull(groups);
        List topLevel = null;
        if (root instanceof SearchableConfigurable && Intrinsics.areEqual((Object)((SearchableConfigurable)root).getId(), (Object)"configurable.group.root")) {
            Configurable[] configurableArray = ((Configurable.Composite)root).getConfigurables();
            Intrinsics.checkNotNullExpressionValue((Object)configurableArray, (String)"getConfigurables(...)");
            topLevel = ArraysKt.toList((Object[])configurableArray);
        } else {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = groups;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = 0;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Configurable)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            topLevel = (List)destination$iv$iv;
        }
        List current = topLevel;
        Configurable lastMatched = null;
        int lastMatchedIndex = -1;
        int i2 = 0;
        $i$f$filterIsInstanceTo = ((Collection)split).size();
        while (i2 < $i$f$filterIsInstanceTo) {
            Configurable matched;
            Object v1;
            block7: {
                String option2 = split.get(i2);
                Iterable iterable = current;
                for (Object t : iterable) {
                    Configurable it = (Configurable)t;
                    boolean bl = false;
                    if (!StringsKt.equals((String)it.getDisplayName(), (String)option2, (boolean)true)) continue;
                    v1 = t;
                    break block7;
                }
                v1 = null;
            }
            if ((Configurable)v1 == null) break;
            lastMatched = matched;
            lastMatchedIndex = i2++;
            if (!(matched instanceof Configurable.Composite)) break;
            Configurable[] configurableArray = ((Configurable.Composite)matched).getConfigurables();
            Intrinsics.checkNotNullExpressionValue((Object)configurableArray, (String)"getConfigurables(...)");
            current = ArraysKt.asList((Object[])configurableArray);
        }
        if (lastMatched == null) {
            return null;
        }
        String spotlightFilter = lastMatchedIndex + 1 < split.size() ? CollectionsKt.joinToString$default((Iterable)split.subList(lastMatchedIndex + 1, split.size()), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) : "";
        List hits = CollectionsKt.listOf(lastMatched);
        return new ConfigurableHit((Collection)hits, (Collection)hits, hits, spotlightFilter);
    }

    private static final List<String> parseSettingsPath(String path) {
        if (!StringsKt.contains$default((CharSequence)path, (CharSequence)" | ", (boolean)false, (int)2, null)) {
            return null;
        }
        String[] stringArray = new String[]{" | "};
        List<String> split = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null), SearchableOptionsRegistrarImplKt::parseSettingsPath$lambda$0));
        String[] stringArray2 = new String[8];
        stringArray2[0] = "IntelliJ IDEA";
        Intrinsics.checkNotNullExpressionValue((Object)ApplicationNamesInfo.getInstance().getFullProductName(), (String)"getFullProductName(...)");
        stringArray2[2] = "Settings";
        stringArray2[3] = "Preferences";
        stringArray2[4] = "File | Settings";
        Intrinsics.checkNotNullExpressionValue((Object)CommonBundle.message((String)"action.settings.path", (Object[])new Object[0]), (String)"message(...)");
        Intrinsics.checkNotNullExpressionValue((Object)CommonBundle.message((String)"action.settings.path.mac", (Object[])new Object[0]), (String)"message(...)");
        Intrinsics.checkNotNullExpressionValue((Object)CommonBundle.message((String)"action.settings.path.macOS.ventura", (Object[])new Object[0]), (String)"message(...)");
        List prefixes = CollectionsKt.listOf((Object[])stringArray2);
        for (String prefix : prefixes) {
            split = SearchableOptionsRegistrarImplKt.skipPrefixIfNeeded(prefix, split);
        }
        return split;
    }

    private static final List<String> skipPrefixIfNeeded(String prefix, List<String> split) {
        if (split.isEmpty()) {
            return split;
        }
        String[] stringArray = new String[]{" | "};
        List prefixSplit = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)prefix, (String[])stringArray, (boolean)false, (int)0, (int)6, null), SearchableOptionsRegistrarImplKt::skipPrefixIfNeeded$lambda$0));
        if (split.size() < prefixSplit.size()) {
            return split;
        }
        int n = ((Collection)prefixSplit).size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (StringsKt.equals((String)split.get(i2), (String)((String)prefixSplit.get(i2)), (boolean)true)) continue;
            return split;
        }
        return split.subList(prefixSplit.size(), split.size());
    }

    @NotNull
    public static final Stream<String> splitToWordsWithoutStemmingAndStopWords(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Stream<String> stream = WORD_SEPARATOR_CHARS.splitAsStream(text2);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"splitAsStream(...)");
        return stream;
    }

    public static final void collectProcessedWordsWithoutStemming(@NotNull String text2, @NotNull Set<String> result2, @NotNull Set<String> stopWords) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Intrinsics.checkNotNullParameter(stopWords, (String)"stopWords");
        String string = text2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String[] stringArray = WORD_SEPARATOR_CHARS.split(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"split(...)");
        for (String opt : stringArray) {
            if (stopWords.contains(opt) || CollectionsKt.contains((Iterable)stopWords, (Object)PorterStemmerUtil.stem(opt))) continue;
            Intrinsics.checkNotNull((Object)opt);
            result2.add(opt);
        }
    }

    public static final void collectProcessedWords(@NotNull String text2, @NotNull Set<String> result2, @NotNull Set<String> stopWords) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Intrinsics.checkNotNullParameter(stopWords, (String)"stopWords");
        String string = text2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String[] stringArray = WORD_SEPARATOR_CHARS.split(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"split(...)");
        for (String opt : stringArray) {
            if (stopWords.contains(opt)) continue;
            String string2 = PorterStemmerUtil.stem(opt);
            if (string2 == null) continue;
            result2.add(string2);
        }
    }

    public static final long packSearchableOptions(@NotNull String id2, @Nullable String hit, @Nullable String path, @Nullable String groupName, @NotNull IndexedCharsInterner identifierTable) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)identifierTable, (String)"identifierTable");
        long _id = identifierTable.toId(((Object)StringsKt.trim((CharSequence)id2)).toString());
        String string = hit;
        long _hit = string == null ? 32767L : (long)identifierTable.toId(((Object)StringsKt.trim((CharSequence)string)).toString());
        String string2 = path;
        long _path = string2 == null ? 32767L : (long)identifierTable.toId(((Object)StringsKt.trim((CharSequence)string2)).toString());
        String string3 = groupName;
        long _groupName = string3 == null ? 32767L : (long)identifierTable.toId(((Object)StringsKt.trim((CharSequence)string3)).toString());
        boolean bl2 = bl = _id >= 0L && _id < 32767L;
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        boolean bl3 = bl = _hit >= 0L && _hit <= 32767L;
        if (_Assertions.ENABLED && !bl) {
            String string5 = "Assertion failed";
            throw new AssertionError((Object)string5);
        }
        boolean bl4 = bl = _path >= 0L && _path <= 32767L;
        if (_Assertions.ENABLED && !bl) {
            String string6 = "Assertion failed";
            throw new AssertionError((Object)string6);
        }
        boolean bl5 = bl = _groupName >= 0L && _groupName <= 32767L;
        if (_Assertions.ENABLED && !bl) {
            String string7 = "Assertion failed";
            throw new AssertionError((Object)string7);
        }
        return _groupName << 48 | _id << 32 | _hit << 16 | _path;
    }

    private static final boolean loadStopWords$lambda$0$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() > 0;
    }

    private static final String parseSettingsPath$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final String skipPrefixIfNeeded$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    public static final /* synthetic */ Set access$loadStopWords() {
        return SearchableOptionsRegistrarImplKt.loadStopWords();
    }

    public static final /* synthetic */ ExtensionPointName access$getEP_NAME$p() {
        return EP_NAME;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ ConfigurableHit access$findGroupsByPath(List groups, String path) {
        return SearchableOptionsRegistrarImplKt.findGroupsByPath(groups, path);
    }

    public static final /* synthetic */ List access$filterById(Set configurables2, Set configurableIds) {
        return SearchableOptionsRegistrarImplKt.filterById(configurables2, configurableIds);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SearchableOptionsRegistrarImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        EP_NAME = new ExtensionPointName("com.intellij.search.optionContributor");
        Pattern pattern = Pattern.compile("[^-\\pL\\d#+]+");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        WORD_SEPARATOR_CHARS = pattern;
    }
}

